//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 22 textures and 96 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 04/05/1997    (05.04.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <21.484, 30.380, 8.860>
  direction <0.0,     0.0,  1.0052>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <5.477, -0.408, 11.983>

   aperture 2.25
      focal_point <0, 0, 0>
       blur_samples 37
   confidence 0.975           // default is 0.9
   variance 1/6000
}

// *******  L I G H T S *******
light_source {   // Light1
  <30.135, 25.624, 42.031>
  color rgb <1.000, 1.000, 1.000>
  //shadowless
}


light_source {   // Light2
  <-4500, 4500, 300>
  color rgb <1.0000, 1.0000, 0.25000>
  //shadowless
}


// ********  TEXTURES  *******
//

#include "skola.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



box { // wall
  <-1, -1, -1>, <1, 1, 1>
  texture {
    walltex1
  }
  hollow
  scale <0.329277, 200.0, 56.727268>
  translate  <202.69838, -109.598913, 35.408658>
}


union { // Window2
  box { // Blaeck2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 24.0, 1.0>
    translate  <-50.0, -210.0, -1.63671>
  }
  box { // Frame7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.405188, 37.0>
    translate  <-52.0, -230.0, 36.0>
  }
  box { // Frame8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.405188, 37.0>
    translate  <-52.0, -190.0, 36.0>
  }
  box { // Frame9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 22.0, 1.0>
    translate  <-52.0, -210.0, 72.0>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 1.2, 40.0>
    rotate -90.0*x
    translate  <-52.0, -230.0, 42.5>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 1.2, 74.0>
    rotate <0.0, 0.0, 0.0>
    translate  <-52.0, -210.0, -2.0>
  }
  box { // WinCut5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WinGlas
    }
    scale <0.25, 20.0, 36.0>
    translate  <-52.0, -211.0, 35.0>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  104.0*y
}


union { // Window1
  box { // Blaeck1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 24.0, 1.0>
    translate  <-50.0, -210.0, -1.63671>
  }
  box { // Frame4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.405188, 37.0>
    translate  <-52.0, -230.0, 36.0>
  }
  box { // Frame5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.405188, 37.0>
    translate  <-52.0, -190.0, 36.0>
  }
  box { // Frame6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 22.0, 1.0>
    translate  <-52.0, -210.0, 72.0>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 1.2, 40.0>
    rotate -90.0*x
    translate  <-52.0, -230.0, 42.5>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 1.2, 74.0>
    rotate <0.0, 0.0, 0.0>
    translate  <-52.0, -210.0, -2.0>
  }
  box { // WinCut3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WinGlas
    }
    scale <0.25, 20.0, 36.0>
    translate  <-52.0, -211.0, 35.0>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  198.0*y
}


union { // Window
  box { // Blaeck
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 24.0, 1.0>
    translate  <-50.0, -210.0, -1.63671>
  }
  box { // Frame1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.405188, 37.0>
    translate  <-52.0, -230.0, 36.0>
  }
  box { // Frame2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.405188, 37.0>
    translate  <-52.0, -190.0, 36.0>
  }
  box { // Frame3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 22.0, 1.0>
    translate  <-52.0, -210.0, 72.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 1.2, 40.0>
    rotate -90.0*x
    translate  <-52.0, -230.0, 42.5>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 1.2, 74.0>
    rotate <0.0, 0.0, 0.0>
    translate  <-52.0, -210.0, -2.0>
  }
  box { // WinCut4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WinGlas
    }
    scale <0.25, 20.0, 36.5>
    translate  <-52.0, -210.0, 35.0>
  }
  texture {
    DeskTxt
  }
  hollow
}


union { // BzPtch003
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>,
      <-3.256662, -2.401178, 0.396659>, <-2.683565, -2.401178, 1.327375>, <-1.683565, -2.401178, 1.327375>, <-0.330116, -2.200589, 0.920349>,
      <-3.000000, -1.000000, 0.000000>, <-2.426903, -1.000000, 0.930715>, <-1.426903, -1.000000, 1.157269>, <-0.213451, -1.000000, 0.578635>,
      <-2.992680, 0.000000, 0.139083>, <-2.206131, 0.000000, 0.604441>, <-1.419583, 0.000000, 1.183076>, <-0.355177, 0.000000, 0.754218>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.992680, 0.000000, 0.139083>, <-2.206131, 0.000000, 0.604441>, <-1.419583, 0.000000, 1.183076>, <-0.355177, 0.000000, 0.754218>,
      <-2.985360, 1.000000, 0.278167>, <-1.985360, 1.000000, 0.278167>, <-1.412263, 1.000000, 1.208882>, <-0.489581, 1.000000, 0.929801>,
      <-3.000000, 2.000000, 0.000000>, <-1.510009, 3.825136, 0.614895>, <-0.510009, 3.825136, 0.614895>, <0.244995, 2.912568, 0.307447>,
      <-3.000000, 3.000000, 0.000000>, <-1.510009, 4.825136, 0.614895>, <-0.510009, 4.825136, 0.614895>, <0.244995, 3.912568, 0.307447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>,
      <-0.330116, -2.200589, 0.920349>, <1.023333, -2.000000, 0.513324>, <2.023333, -2.000000, 0.513324>, <3.000000, -2.000000, 0.000000>,
      <-0.213451, -1.000000, 0.578635>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>,
      <-0.355177, 0.000000, 0.754218>, <0.716550, 0.000000, 0.325360>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.355177, 0.000000, 0.754218>, <0.716550, 0.000000, 0.325360>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>,
      <-0.489581, 1.000000, 0.929801>, <0.433100, 1.000000, 0.650720>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>,
      <0.244995, 2.912568, 0.307447>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>,
      <0.244995, 3.912568, 0.307447>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  texture {
    Leaves
  }
  hollow
  scale <300.0, 350.0, 400.0>
  translate  <-4168.140382, -3334.512306, -24.0>
}


union { // Hill
  sphere { // Hill3
    <0,0,0>,1
    scale <585.177307, 412.442352, 100.0>
    translate  <-2181.175162, -1093.752636, -22.0>
  }
  sphere { // Hill2
    <0,0,0>,1
    scale <134.276291, 292.202087, 30.0>
    translate  <-1459.733574, -743.051864, -22.0>
  }
  sphere { // Hill1
    <0,0,0>,1
    scale <204.416443, 192.001877, 65.0>
    translate  <-1579.973839, -963.492349, -22.0>
  }
  texture {
    Leaves
  }
  hollow
  translate  <108.734097, -4095.650984, 0.0>
}


difference { // Gavel
  box { // wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      walltex1
    }
    scale <0.329277, 200.0, 56.727268>
    translate  <-53.387953, -109.598913, 35.408658>
  }
  box { // WinCut
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TakTex
    }
    scale <8.5, 20.0, 36.0>
    translate  <-56.0, -13.0, 35.0>
  }
  box { // WinCut1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TakTex
    }
    scale <8.5, 20.0, 36.5>
    translate  <-56.0, -106.0, 35.0>
  }
  box { // WinCut2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TakTex
    }
    scale <8.5, 20.0, 36.5>
    translate  <-56.0, -210.0, 35.0>
  }
  hollow
}


box { // Tak
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TakTex
  }
  hollow
  scale <150.762344, 220.096771, 1.0>
  translate  <95.250156, -94.294811, 92.227202>
}


box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorTex
    scale <0.6, 0.4, 1.0>
  }
  hollow
  scale <150.762344, 220.096771, 1.0>
  translate  <93.603242, -94.294811, -21.409886>
}


box { // wall2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    walltex2
    scale <0.5, 25.0, 1.0>
    rotate -90.0*y
  translate <-0.948972, 19.604633, -0.245945>
  }
  hollow
  scale <192.363007, 1.0, 58.641998>
  translate  <132.819081, -310.618202, 37.055572>
}



cylinder { // Cylndr19
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <27.573657, -200.465558, -21.980528>
}


cylinder { // Cylndr18
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <27.573657, -178.041004, -21.980528>
}


cylinder { // Cylndr17
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <26.154381, -140.572129, -21.980528>
}


cylinder { // Cylndr16
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <26.438236, -118.431429, -21.980528>
}


cylinder { // Cylndr15
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <28.709077, -74.717741, -21.980528>
}


cylinder { // Cylndr14
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <28.425222, -52.577042, -21.980528>
}


cylinder { // Cylndr13
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <-9.611363, -117.863719, -21.980528>
}


cylinder { // Cylndr12
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <-10.179074, -140.288273, -21.980528>
}


cylinder { // Cylndr11
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <-9.043653, -178.892569, -21.980528>
}


cylinder { // Cylndr10
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <-9.043653, -199.613993, -21.980528>
}


cylinder { // Cylndr9
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <-8.475943, -259.791278, -21.980528>
}


cylinder { // Cylndr008
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  hollow
  scale <0.75, 0.75, 12.0>
  translate  <-9.043653, -238.218289, -21.980528>
}


difference { // Benk7
  box { // 15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTxt
    }
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTxt
    }
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  hollow
  translate  <19.269569, -183.791444, 0.0>
}


difference { // Benk6
  box { // 13
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 14
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <19.269569, -124.188036, 0.0>
}


difference { // Benk5
  box { // 11
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 12
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <18.198982, -64.235191, 0.0>
}


difference { // Benk4
  box { // 9
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 10
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <-48.176393, -183.791444, 0.0>
}


difference { // Benk3
  box { // 7
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 8
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <-48.176393, -124.188036, 0.0>
}


difference { // Benk2
  box { // 5
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 6
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <-49.24698, -64.235191, 0.0>
}


difference { // Benk1
  box { // 2
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 4
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <-50.317566, 1.070587, 0.0>
}


difference { // Benk
  box { // 1
    <-1, -1, -1>, <1, 1, 1>
    scale <17.133749, 12.535124, 3.0>
    translate  <23.893706, -64.960963, -7.411114>
  }
  box { // 3
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 12.535124, 1.779501>
    rotate <7.64103, 0.0, 0.0>
    translate  <23.893706, -69.232711, -4.054741>
  }
  texture {
    DeskTxt
  }
  hollow
  translate  <20.540116, 1.528274, 0.0>
}



box { // Cube003
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DeskTxt
  }
  hollow
  scale <31.963816, 21.594206, 1.0>
  translate  <20.12648, 1.032127, -1.0>
}


cylinder { // Cylndr007
  <0,0,1>, <0,0,0>, 1
  texture {
    ChalkTex
  }
  hollow
  scale <0.1, 0.1, 1.0>
  rotate <90.600792, -0.259522, 26.405861>
  translate  <18.307094, 3.706498, 0.503681>
}


#declare BzPtch002 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <1.000000, -1.000000, 2.000000>, <1.000000, 0.000000, 2.000000>,
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>,
      <-3.478087, 0.000000, 4.990281>, <-3.478087, -1.000000, 4.990281>, <-1.671613, -1.000000, 5.848565>, <-1.671613, 0.000000, 5.848565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>,
      <1.000000, 0.000000, 2.000000>, <1.000000, 1.000000, 2.000000>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>,
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>,
      <-1.671613, 0.000000, 5.848565>, <-1.671613, 1.000000, 5.848565>, <-3.478087, 1.000000, 4.990281>, <-3.478087, 0.000000, 4.990281>
    }
  }
  texture {
    Texture03
  }
  scale <0.05, 0.05, 0.15>
  translate  1.85*z
}
#declare BzPtch2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.571770, -2.697532, 1.248045>, <-1.749819, -4.977610, 0.776407>, <-0.186650, -5.621368, -0.036729>, <0.022456, -5.621368, -0.021343>,
      <-2.723004, -2.000000, 1.248045>, <-1.843147, -2.000000, 0.776407>, <-0.206747, -2.000000, -0.036729>, <0.002359, -2.000000, -0.021343>,
      <-2.723004, -1.000000, 1.248045>, <-1.843147, -1.000000, 0.776407>, <-0.206747, -1.000000, -0.036729>, <0.002359, -1.000000, -0.021343>,
      <-2.723004, 0.000000, 1.248045>, <-1.843147, 0.000000, 0.776407>, <-0.206747, 0.000000, -0.036729>, <0.002359, 0.000000, -0.021343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.723004, 0.000000, 1.248045>, <-1.843147, 0.000000, 0.776407>, <-0.206747, 0.000000, -0.036729>, <0.002359, 0.000000, -0.021343>,
      <-2.723004, 1.000000, 1.248045>, <-1.843147, 1.000000, 0.776407>, <-0.206747, 1.000000, -0.036729>, <0.002359, 1.000000, -0.021343>,
      <-2.723004, 2.000000, 1.248045>, <-1.843147, 5.605760, 0.817883>, <-0.206747, 6.611106, 0.012159>, <0.002359, 6.610993, 0.027545>,
      <-2.723004, 3.000000, 1.248045>, <-1.843147, 9.159584, 0.844163>, <-0.093322, 7.820428, -2.444184>, <0.115784, 7.821908, -2.428869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.022456, -5.621368, -0.021343>, <0.231562, -5.621368, -0.005957>, <2.048079, -4.750759, 0.780718>, <2.459520, -3.226851, 1.171077>,
      <0.002359, -2.000000, -0.021343>, <0.211465, -2.000000, -0.005957>, <1.841326, -2.000000, 0.780718>, <2.761988, -2.000000, 1.171077>,
      <0.002359, -1.000000, -0.021343>, <0.211465, -1.000000, -0.005957>, <1.841326, -1.000000, 0.780718>, <2.761988, -1.000000, 1.171077>,
      <0.002359, 0.000000, -0.021343>, <0.211465, 0.000000, -0.005957>, <1.841326, 0.000000, 0.780718>, <2.761988, 0.000000, 1.171077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.002359, 0.000000, -0.021343>, <0.211465, 0.000000, -0.005957>, <1.841326, 0.000000, 0.780718>, <2.761988, 0.000000, 1.171077>,
      <0.002359, 1.000000, -0.021343>, <0.211465, 1.000000, -0.005957>, <1.841326, 1.000000, 0.780718>, <2.761988, 1.000000, 1.171077>,
      <0.002359, 6.610993, 0.027545>, <0.211465, 6.610879, 0.042930>, <1.841326, 5.605729, 0.822194>, <2.761988, 2.000000, 1.171077>,
      <0.115784, 7.821908, -2.428869>, <0.324891, 7.823388, -2.413555>, <1.841326, 9.159552, 0.848474>, <2.761988, 3.000000, 1.171077>
    }
  }
  texture {
    Leaves
  }
  scale 0.1
  rotate <16.783033, 0.0, -77.590607>
  translate  <0.396805, 0.042352, 2.072202>
}
#declare BzPtch001 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.571770, -2.697532, 1.248045>, <-1.749819, -4.977610, 0.776407>, <-0.186650, -5.621368, -0.036729>, <0.022456, -5.621368, -0.021343>,
      <-2.723004, -2.000000, 1.248045>, <-1.843147, -2.000000, 0.776407>, <-0.206747, -2.000000, -0.036729>, <0.002359, -2.000000, -0.021343>,
      <-2.723004, -1.000000, 1.248045>, <-1.843147, -1.000000, 0.776407>, <-0.206747, -1.000000, -0.036729>, <0.002359, -1.000000, -0.021343>,
      <-2.723004, 0.000000, 1.248045>, <-1.843147, 0.000000, 0.776407>, <-0.206747, 0.000000, -0.036729>, <0.002359, 0.000000, -0.021343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.723004, 0.000000, 1.248045>, <-1.843147, 0.000000, 0.776407>, <-0.206747, 0.000000, -0.036729>, <0.002359, 0.000000, -0.021343>,
      <-2.723004, 1.000000, 1.248045>, <-1.843147, 1.000000, 0.776407>, <-0.206747, 1.000000, -0.036729>, <0.002359, 1.000000, -0.021343>,
      <-2.723004, 2.000000, 1.248045>, <-1.843147, 5.605760, 0.817883>, <-0.206747, 6.611106, 0.012159>, <0.002359, 6.610993, 0.027545>,
      <-2.723004, 3.000000, 1.248045>, <-1.843147, 9.159584, 0.844163>, <-0.093322, 7.820428, -2.444184>, <0.115784, 7.821908, -2.428869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.022456, -5.621368, -0.021343>, <0.231562, -5.621368, -0.005957>, <2.048079, -4.750759, 0.780718>, <2.459520, -3.226851, 1.171077>,
      <0.002359, -2.000000, -0.021343>, <0.211465, -2.000000, -0.005957>, <1.841326, -2.000000, 0.780718>, <2.761988, -2.000000, 1.171077>,
      <0.002359, -1.000000, -0.021343>, <0.211465, -1.000000, -0.005957>, <1.841326, -1.000000, 0.780718>, <2.761988, -1.000000, 1.171077>,
      <0.002359, 0.000000, -0.021343>, <0.211465, 0.000000, -0.005957>, <1.841326, 0.000000, 0.780718>, <2.761988, 0.000000, 1.171077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.002359, 0.000000, -0.021343>, <0.211465, 0.000000, -0.005957>, <1.841326, 0.000000, 0.780718>, <2.761988, 0.000000, 1.171077>,
      <0.002359, 1.000000, -0.021343>, <0.211465, 1.000000, -0.005957>, <1.841326, 1.000000, 0.780718>, <2.761988, 1.000000, 1.171077>,
      <0.002359, 6.610993, 0.027545>, <0.211465, 6.610879, 0.042930>, <1.841326, 5.605729, 0.822194>, <2.761988, 2.000000, 1.171077>,
      <0.115784, 7.821908, -2.428869>, <0.324891, 7.823388, -2.413555>, <1.841326, 9.159552, 0.848474>, <2.761988, 3.000000, 1.171077>
    }
  }
  texture {
    Leaves
  }
  scale 0.1
  rotate 16.783033*x
  translate  <0.0, 0.345367, 2.072202>
}
//
// Include file contains 'RotSwp001'
//
#include "p_schol1.in1"
#declare RotSwp001 = object {
  RotSwp001_Raw
  texture {
    AppleTex
  }
  translate  1.0*z
}
union { // Apple
  object { BzPtch002 }
  object { BzPtch2 }
  object { BzPtch001 }
  object { RotSwp001 }
  hollow
  scale 1.5
  rotate -47.227573*z
  translate  <2.315249, 9.416853, 0.0>
}


#declare Earth = union {
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      EarthTex
    }
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 3.0>
    translate  -1.5*z
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <1.3, 1.3, 0.05>
    rotate -90.0*y
    translate  0.05*x
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.1, 1.1, 0.4>
    rotate -90.0*y
    translate  0.2*x
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    scale <1.462263, 1.040788, 0.25>
    rotate -90.0*y
    translate  <0.125, -0.650485, 0.0>
  }
}
#declare Top = union {
  object { Earth }
  object { CSG001 }
  rotate -25.0*x
  translate  <0.0, -0.113302, 1.69515>
}
#declare TIP = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    scale <0.15, 0.15, 0.4>
  }
  torus { // Torus001
    0.2125, 0.1875  rotate -x*90
    scale <1.0, 1.0, 2.5>
    translate  0.4*z
  }
}
union { // Globe
  object { Top }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 0.05>
    translate  -0.05*z
  }
  object { TIP }
  texture {
    T_Silver_4D
  }
  hollow
  scale 10.0
  translate  0.5*z
}






#declare CSG2 = merge {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <4.0, 4.0, 3.0>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 3.0
    translate  6.0*z
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 6.0>
  }
}
#declare CSG002 = difference {
  object { CSG2 }
  torus { // Torus2
    4.5, 1.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
    translate  3.0*z
  }
}
#declare CSG3 = merge {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <4.0, 4.0, 3.0>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 3.0
    translate  6.0*z
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 6.0>
  }
}
#declare CSG4 = difference {
  object { CSG3 }
  torus { // Torus3
    4.5, 1.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
    translate  3.0*z
  }
  scale <0.96, 0.96, 1.0>
  translate  -0.2*z
}
#declare CSG004 = difference {
  object { CSG002 }
  object { CSG4 }
}
#declare CSG003 = union {
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.5, 0.5, 1.3>
    translate  17.0*z
  }
  cone { // Cone001
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale <1.0, 1.0, 8.0>
    translate  9.0*z
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.5, 0.5, 0.25>
    translate  9.0*z
  }
  texture {
    Dark_Wood3
  }
}
#declare CSG005 = union {
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.8
    translate  1.4*z
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 6.7>
    translate  2.0*z
  }
  texture {
    T_Chrome_5D
  }
  rotate -17.308941*x
  translate  <0.0, -2.529501, 0.407762>
}
union { // klocka
  object { CSG004 }
  object { CSG003 }
  object { CSG005 }
  texture {
    T_Gold_4D
  }
  hollow
  rotate <100.228935, 4.551273, -55.397694>
  translate  <10.188805, -8.405997, 4.006573>
}


#declare Frame = union {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood5
    }
    scale <1.75, 0.21, 0.05>
    rotate 90.0*z
    translate  <-2.715, 0.0, -0.02>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood5
    }
    scale <1.75, 0.2, 0.05>
    rotate 90.0*z
    translate  <2.7, 0.0, -0.02>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood5
    }
    scale <2.9, 0.2, 0.05>
    translate  -1.95*y
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood5
    }
    scale <2.9, 0.2, 0.05>
    translate  1.95*y
  }
}
union { // ChalkBrd
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture01
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <2.5, 1.75, 0.03>
  }
  object { Frame }
  hollow
  scale 3.0
  rotate <0.503619, -2.030611, 166.06781>
  translate  <11.056905, 0.713349, 0.576788>
}


