
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"


// ----------------------------------------


#declare BoyStarFish = union
{
sphere {
       0.0, 1
       texture { pigment { color rgbt <0.25,0.25,1.00,0.7> } }
       texture {
       pigment { gradient x
            color_map {
             [0.0 rgbt <0.25,0.25,1.00,1> ]
             [0.50 rgbt <0.25,1.00,0.25,0.5> ]
             [1.00 rgbt <0.25,0.25,1.00,1> ]
            }
            frequency 6
            turbulence 0.1
            }
       }
      halo {
      attenuating
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <0, 1, 0, 1> ]
        [ 0.5 color rgbt <0, 1, 0, 1> ]
        [ 1 color rgbt <0, 1, 0, 0.3> ]
      }
      turbulence 1.33
      samples 10
   }
       hollow
       finish { specular 1 }
}

sphere {
       0.0, 0.25
       pigment {  color rgb <2,0,0> }
       finish { specular 0.5 }
}

difference {
cone
{
  0.75*z, 0.5,
  1.5*z, 0.33
  pigment { gradient x
            color_map {
             [0.0 rgbt <0.25,0.25,1.00,0.6> ]
             [0.50 rgbt <0.25,1.00,0.25,0.5> ]
             [1.00 rgbt <0.25,0.25,1.00,0.6> ]
            }
            frequency 6
          }
  finish { specular 0.3 }
  hollow
}
cone
{
  0.75*z,  0.4,
  1.5*z, 0.23
  open
  pigment { color rgbt <0.25,0.25,1.00,0.6> }
  finish { specular 0.3 }
  hollow
}
}

cylinder
{
  -1*z,  1*z,  1
  pigment { color rgbft <1,1,1,0,1> }
  halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale 2
      translate <0,0,-1>
   }
   hollow
   scale <0.2,0.2,0.7>
   translate <0,0,1>

}
}

#declare GirlStarFish = union
{
sphere {
       0.0, 1
       texture { pigment { color rgbt <1.00,1.00,0.25,0.7> } }
       texture {
       pigment { gradient x
            color_map {
             [0.0 rgbt <1.00,1.00,0.25,1> ]
             [0.50 rgbt <1.00,0.25,1.00,0.5> ]
             [1.00 rgbt <1.00,1.00,0.25,1> ]
            }
            frequency 6
            turbulence 0.15
            }
       }
      halo {
      attenuating
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 0.5 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <1, 0, 1, 0.3> ]
      }
      turbulence 1.15
      samples 10
   }
       hollow
       finish { specular 1 }
}

sphere {
       0.0, 0.25
       pigment {  color rgb <2,0,0> }
       finish { specular 0.5 }
}

difference {
cone
{
  0.75*z, 0.5,
  1.5*z, 0.33
  pigment { gradient x
            color_map {
             [0.0 rgbt <0.25,0.25,1.00,0.6> ]
             [0.50 rgbt <0.25,1.00,0.25,0.5> ]
             [1.00 rgbt <0.25,0.25,1.00,0.6> ]
            }
            frequency 6
          }
  finish { specular 0.3 }
  hollow
}
cone
{
  0.75*z,  0.4,
  1.5*z, 0.23
  open
  pigment { color rgbt <0.25,0.25,1.00,0.6> }
  finish { specular 0.3 }
  hollow
}
}

cylinder
{
  -1*z,  1*z,  1
  pigment { color rgbft <1,1,1,0,1> }
  halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale 2
      translate <0,0,-1>
   }
   hollow
   scale <0.2,0.2,0.7>
   translate <0,0,1>

}
}

#declare Sun = sphere {
       0.0, 1
       pigment {  bumps
                  color_map {
                          [0.0  color Clear]
                          [0.5  color rgbft <1,0,0,0,0.3> ]
                          [1.0  color rgbft <1,1,0,0,0.3> ]
                  }
                  scale 1
                  turbulence 1
               }
   halo {
      emitting
      spherical_mapping
      poly
      exponent 0.5
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
    }
    hollow

}

#declare Starfield2 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.81 color Black  color Black  ] 
            [ 0.81  0.91 color Gray30 color Gray50 ] 
            [ 0.91  1.00 color Black  color Black  ] 
        }
    scale 0.015
    turbulence 1
    }
    finish { ambient 1 }
}

sphere {
       0, 10000
       texture { Starfield2 scale 10000 }
       hollow
}


// ----------------------------------------
camera
{
  location  <0.0, 0.0, -5.0>
  direction z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

light_source
{
  0*x // light's position (translated below)
  color red 2.0  green 2.0  blue 2.0  // light's color
  looks_like { Sun scale 4 }
  translate <0, 0, 10>
}

object { BoyStarFish rotate <0,90,0> translate <1,0,0>}
object { GirlStarFish rotate <0,-90,0> translate <-1,0,0>}

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 0, -5> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}

