
// Persistence of Vision Ray Tracer Scene Description File
// File: Star School.pov
// Vers: 3
// Desc:
// Date:
// Auth:


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare R1 = seed(1)
#declare R2 = seed(11)

#declare BoyStarFish = union
{
sphere {
       0.0, 1
       texture { pigment { color rgbt <0.25,0.25,1.00,0.7> } }
       texture {
       pigment { gradient x
            color_map {
             [0.0 rgbt <0.25,0.25,1.00,1> ]
             [0.50 rgbt <0.25,1.00,0.25,0.5> ]
             [1.00 rgbt <0.25,0.25,1.00,1> ]
            }
            frequency 6
            turbulence 0.1
            }
       }
      halo {
      attenuating
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <0, 1, 0, 1> ]
        [ 0.5 color rgbt <0, 1, 0, 1> ]
        [ 1 color rgbt <0, 1, 0, 0.3> ]
      }
      turbulence 1.33
      samples 10
   }
       hollow
       finish { specular 0.5 }
}

sphere {
       0.0, 0.25
       pigment {  color rgb <2,0,0> }
       finish { specular 0.5 }
}

difference {
cone
{
  0.75*z, 0.5,
  1.5*z, 0.33
  pigment { gradient x
            color_map {
             [0.0 rgbt <0.25,0.25,1.00,0.6> ]
             [0.50 rgbt <0.25,1.00,0.25,0.5> ]
             [1.00 rgbt <0.25,0.25,1.00,0.6> ]
            }
            frequency 6
          }
  finish { specular 0.3 }
  hollow
}
cone
{
  0.75*z,  0.4,
  1.5*z, 0.23
  open
  pigment { color rgbt <0.25,0.25,1.00,0.6> }
  finish { specular 0.3 }
  hollow
}
}

cylinder
{
  -1*z,  1*z,  1
  pigment { color rgbft <1,1,1,0,1> }
  halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale 2
      translate <0,0,-1>
   }
   hollow
   scale <0.2,0.2,0.7>
   translate <0,0,1>

}
}

#declare GirlStarFish = union
{
sphere {
       0.0, 1
       texture { pigment { color rgbt <1.00,1.00,0.25,0.7> } }
       texture {
       pigment { gradient x
            color_map {
             [0.0 rgbt <1.00,1.00,0.25,1> ]
             [0.50 rgbt <1.00,0.25,1.00,0.5> ]
             [1.00 rgbt <1.00,1.00,0.25,1> ]
            }
            frequency 6
            turbulence 0.15
            }
       }
      halo {
      attenuating
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 0.5 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <1, 0, 1, 0.3> ]
      }
      turbulence 1.15
      samples 10
   }
       hollow
       finish { specular 0.5 }
}

sphere {
       0.0, 0.25
       pigment {  color rgb <2,0,0> }
       finish { specular 0.5 }
}

difference {
cone
{
  0.75*z, 0.5,
  1.5*z, 0.33
  pigment { gradient x
            color_map {
             [0.0 rgbt <0.25,0.25,1.00,0.6> ]
             [0.50 rgbt <0.25,1.00,0.25,0.5> ]
             [1.00 rgbt <0.25,0.25,1.00,0.6> ]
            }
            frequency 6
          }
  finish { specular 0.3 }
  hollow
}
cone
{
  0.75*z,  0.4,
  1.5*z, 0.23
  open
  pigment { color rgbt <0.25,0.25,1.00,0.6> }
  finish { specular 0.3 }
  hollow
}
}

cylinder
{
  -1*z,  1*z,  1
  pigment { color rgbft <1,1,1,0,1> }
  halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale 2
      translate <0,0,-1>
   }
   hollow
   scale <0.2,0.2,0.7>
   translate <0,0,1>

}
}

#declare Starfield2 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.81 color Black  color Black  ] 
            [ 0.81  0.91 color Gray30 color Gray50 ] 
            [ 0.91  1.00 color Black  color Black  ] 
        }
    scale 0.015
    turbulence 1
    }
    finish { ambient 1 }
}



// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 2.0  green 2.0  blue 2.0  // light's color
  translate <0, 0, 50>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-10, 10, -20>
}
// set viewer's position in the scene
camera
{
  location  <-10.0, 10.0, -20.0> // position of camera <X Y Z>
  direction 1.5*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  -6.0> // point center of view at this point <X Y Z>
}

#declare Countx = 0
#declare County = 0

#while ( County < 10 )

#while ( Countx < 10 )
    #if (rand(R1) > 0.74)   
    object { GirlStarFish scale <0.4,0.4,0.4> translate <Countx-5+rand(R2)/8,County-5+rand(R2)/8,-2+rand(R2)/4>
           }
    #else
    object { BoyStarFish scale <0.4,0.4,0.4> translate <Countx-5+rand(R2)/8,County-5+rand(R2)/8,-2+rand(R2)/4>
           }
    #end
#declare Countx = Countx + 1
#end

#declare County = County + 1
#declare Countx = 0
#end

object { GirlStarFish rotate <180,0,0> scale 1.5 translate <0,0,-12> }

plane {
      z, -12
         bounded_by { box { <-3,2,-11.9>, <3,8,-12.1> } }
         clipped_by { bounded_by }
      pigment { image_map { tga "board.tga" } scale 5}
      finish { ambient 0.5 }
      hollow
}

box { <-3,2,-11.9> <3,8,-12.1>
      pigment { bumps
                color_map {
                 [0.0 color rgbt <0.25,0.25,1.0,0.6> ]
                 [1.0 color rgbt <0.25,0.25,1.0,0.3> ]
                }
                scale 0.5
              }
      finish { specular 1 }
      hollow
}

sphere {
       0, 10000
       texture { Starfield2 scale 10000 }
       hollow
}
