//Phillip A. Conophy
//"Among the Crystal Reefs"
//4-21-97

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "sph4.inc"

background { color Black }

camera {
	location <0, 0, -500>
	look_at <0, 0, 1>
}

light_source { <0, 0, -500> color White }

plane {
    -z,
    -5000
    texture {
        pigment {
            image_map {
                tga "backdrop.tga"
            }
        }
        finish {
			ambient 1
        }
        translate<-0.5, -0.5, 0>
        scale<7333, 5500, 1>
    }
}

#declare RedGlass =
texture {
    pigment { color rgbf <0.9, 0.1, 0.2, 0.8> }
    finish {
        ambient 0.5
        diffuse 0.1
        reflection .25
        refraction 1
        ior 1.5
        specular 1
        roughness 0.001
    }
}

#declare BlueGlass =
texture {
    pigment { color rgbf <0.2, 0.1, 0.9, 0.8> }
    finish {
        ambient 0.5
        diffuse 0.1
        reflection .25
        refraction 1
        ior 1.5
        specular 1
        roughness 0.001
    }
}

object {
    sph4
    texture { RedGlass }

    scale < 120, 120, 120 >
    translate < 1500, 1500, 2500 >
}

object {
    sph4
    texture { BlueGlass }

    rotate <90, 0, 0>
    scale < 30, 15, 15 >
    translate < -300, -530, 1000 >
}

#declare BodyTex =
    texture {
        T_Chrome_2A
    }
#declare FinTex =
    texture {
        pigment {
            color rgb <0.30, 0.30, 0.45>
        }
        finish  {
            ambient 0.25
            brilliance 4
            diffuse 0.5
            metallic
            specular 0.80
            roughness 1/80
            reflection 0.5
        }
        normal {
            ripples 0.4
            scale 0.1
        }
        scale 100
    }
#declare EyeTex =
    texture {
		pigment { color rgbt <0, 0, 1, 1> }
		halo {
			emitting
			spherical_mapping
			linear
			color_map {
				[ 0 color rgbt <0, 0, 1, 1> ]
				[ 0.8 color rgbt <0.35, 0.35, 1, -1> ]
				[ 1 color rgbt <0.5, 0.5, 1, -2> ]
			}
			samples 20
		}
    }
#declare EngineTex =
    texture {
		pigment { color rgbt <0, 0, 1, 1> }
		halo {
			emitting
			spherical_mapping
			linear
			color_map {
				[ 0 color rgbt <0, 0, 1, 1> ]
				[ 0.8 color rgbt <0.35, 0.35, 1, -1> ]
				[ 1 color rgbt <0.5, 0.5, 1, -2> ]
			}
			samples 20
		}
    }

//foreground fish
#declare LeftEye = <0, 20, 0>
#declare RightEye = <0, -20, 0>
#declare LeftFin = <20, 25, -20>
#declare RightFin = <-20, -25, -20>
#declare Link = <0, 25, 0>
#declare Tail = <0, 35, 0>
#include "fish.inc"

object {
    Fish
    rotate<0, -35, 15>
    translate <50, -40, -100>
}

//background fish
#declare LeftEye = <0, 0, 0>
#declare RightEye = <0, 0, 0>
#declare LeftFin = <0, 45, 0>
#declare RightFin = <0, -40, 0>
#declare Link = <0, -15, 0>
#declare Tail = <0, -30, 0>
#include "fish.inc"

object {
    Fish
    rotate<0, 90, 0>
    translate <-530, -386, 499>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, 20, 0>
#declare Tail = <0, 20, 0>
#include "fish.inc"

object {
    Fish
    rotate<0, 90, 0>
    translate <-1059, -136, 1362>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, -5, 0>
#declare Tail = <0, -5, 0>
#include "fish.inc"

object {
    Fish
    rotate<0, 90, 0>
    translate <-1488, 113, 1929>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, 5, 0>
#declare Tail = <0, 5, 0>
#include "fish.inc"

object {
    Fish
    rotate<0, 95, 0>
    translate <-1662, 288, 2519>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, -5, 0>
#declare Tail = <0, -5, 0>
#include "fish.inc"

object {
    Fish
    rotate<0, 100, 0>
    translate <-1740, 840, 2870>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, 5, 0>
#declare Tail = <0, 5, 0>
#include "fish.inc"

object {
    Fish
    scale 0.75
    rotate<0, 180, -10>
    translate <40, 1500, 3300>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, -5, 0>
#declare Tail = <0, -5, 0>
#include "fish.inc"

object {
    Fish
    scale 0.6
    rotate<0, 180, 0>
    translate <720, 1610, 3530>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, 5, 0>
#declare Tail = <0, 5, 0>
#include "fish.inc"

object {
    Fish
    scale 0.5
    rotate<0, 180, 10>
    translate <570, 1410, 3530>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, -5, 0>
#declare Tail = <0, -5, 0>
#include "fish.inc"

object {
    Fish
    scale 0.8
    rotate<0, 130, 15>
    translate <-1340, 1330, 3590>
}

#declare LeftEye = <0, 12, 0>
#declare RightEye = <0, -12, 0>
#declare LeftFin = <0, 20, -20>
#declare RightFin = <0, -20, -20>
#declare Link = <0, 5, 0>
#declare Tail = <0, 5, 0>
#include "fish.inc"

object {
    Fish
    scale 0.85
    rotate<0, 0, -20>
    rotate<0, 130, 0>
    translate <-800, 1230, 3990>
}
