// Persistence of Vision Ray Tracer Scene Description File
// File: SWSchool.pov
// Vers: 3
// Desc: Entry for IRTC: Subject School
// Date: 01-04-97
// Auth: Samuel Ward
#version 3

//***Declares***\\
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "Textur-F.inc"

#declare Fog_On = 0 //Fog on or off: 1=on 0=off: Not Working so leave off
#declare Vortex_On = 1 //Vortex on or off
#declare Globs_On = 1 //Energy Globs on or off
#declare Rays_on = 1 //Tenticals from Vortex
#declare Building_on = 1 //School House on or off
#declare Some_Vector = <0,75,-285>
#declare Some_Vector2 = <0,0,-265>
//#declare Direction = 1

 // FOG TYPE CONSTANTS
#declare Constant_Fog = 1
#declare Ground_Fog   = 2
#declare My_Gray = color red 0.752941 green 0.752941 blue 0.752941 transmit 0.9

//***End Declares***\\

//***Camera***\\
#debug "Seting up Enviroment...\n"
#debug "    Camera\n"
camera{ //Front on
  location Some_Vector
  direction <0,0,1>
  look_at <0,0,0>
}

/*camera{ //Side on
  location <-265,75,0>
  direction <0,0,Direction>
  look_at <0,0,0>
}*/
//***End Camera***\\

//***Lights***\\
#debug "    Lights\n"
light_source{ (Some_Vector + <0,0,0>) color Gray25 }
light_source{ <0,0,0> color Green }

//light_source{ (Vector + <0,0,0>) color Gray25 }
//light_source{ <0,0,0> color Gray95 }
global_settings{ max_trace_level 10 }
//***End Lights***\\

//***Ground Fog***\\
#if (Fog_On=1)
#debug "    Ground Fog is on\n"
fog
{
  fog_type   2
  distance   10 //10
  color      My_Gray
  fog_offset 0.1 //0.1
  fog_alt    0.2 //0.2
  turbulence 0.8 //0.8
}
#else
#debug "    Ground Fog is off\n"
#end
//***End Ground Fog***\\

//***Enviroment***\\
#debug "    Sky and ground\n"
// Sky
sphere {
   <0.0, 0.0, 0.0>, 2000.0
   inverse

   texture {
      pigment {
         Sunset_Sky
         translate 200.0*y
         scale 1.2
         quick_color Green
      }
      finish {
         ambient 0.6
         diffuse 0.0
      }
   }
hollow
}
// Clouds
sphere {
   <0.0, 0.0, 0.0>, 1997.0
   texture {
      pigment {
         Yellow_Clouds
         scale <1000.0 30.0 100.0>
         quick_color Green
      }
      finish {
         ambient 0.7
         diffuse 0.0
      }
   }
hollow
}
//The Ground
plane
{
  y, -40
   texture {
      pigment { color red 0.5 green 0.6 blue 0.2 }
      normal {
         bumps 0.8
         scale 5.0
      }
      finish {
         ambient 0.1
         diffuse 0.7
      }
   }
}
#debug "Done\n"
//***End Enviroment***\\

// ----------------------------------------
//***Vortex***\\
#if (Vortex_On=1)
#debug "Vortex Forming..."
union{
  torus{ 75,50 scale <1,5,1> clipped_by{ plane{ y, 0 } } rotate x*-90 }
  torus{ 75,50 clipped_by{ plane{ -y, -0 } } rotate x*-90 }
#debug ".."
  texture{
    pigment{ color SlateBlue  } //SlateBlue
    finish{ Metal }
    normal{ Vortex_Surface scale <35,35,100> } //<10,100,10>
#debug ".."
   }
  hollow
}
#debug ".."
sphere{ <0,0,0>, 10000
  texture{
    pigment{ color SlateBlue } //SlateBlue
  }
#debug ".."

  hollow
}
#debug "Done\n"
#else
#debug "The vortex is off\n"
#end
//***Energy Globs***\\
#if (Globs_On=1)
#debug "Energy Globs Appearing..."
#declare Ball =
sphere{ 0, 0.95
  texture{
    pigment{ rgbt 1 }
    halo{
      emitting
      linear
      samples 25
      turbulence 0.15
      lambda 2.5
      omega 0.6
      scale 0.85
      frequency 1
#debug ".."
      color_map{
        [0.0 SlateBlue transmit 1]
        [0.5 color (White*2+SlateBlue)/3 transmit 0.5]
        [0.7 color (White*2+SlateBlue)/3 transmit 0]
        [0.8 color (White*2+SlateBlue)/3 transmit -0.5]
        [1.0 color (White*2+SlateBlue)/3 transmit -2.35]
      }
    }
  }
 #debug ".."
 hollow
  scale 10
  translate <0,0,0>
}
//+++\\
#debug ".."
#declare S = seed(0) //Random Seed
#declare Con = 0 //Constant
#declare Number = 6*4 //Number of Globs
#while (Con < Number)
#debug ".."
  object{ Ball
    rotate <rand(S)*360,rand(S)*360,rand(S)*360>
    translate <4*Con*cos(Con),4*Con*sin(Con),-30-(8*Con)>

  }
  #declare Con = Con + 1
#end
#debug "Done\n"

#else
#debug "The globs are off\n"
#end
//---\\
//***Tenticals***\\
#if (Rays_on = 1)
#debug "Tenticals Emerging...."
difference {
    union {
torus{ 200,4
    pigment {color LightSteelBlue}
    rotate z*90.1
    translate y*210
    no_shadow
}
#debug ".."
torus{ 200,4
    pigment {color LightSteelBlue}
    translate x*210
    no_shadow
}
#debug ".."
torus{ 200,4
    pigment {color LightSteelBlue}
    rotate z*-90.1
    translate y*-210
    no_shadow
}
#debug ".."
torus{ 200,4
    pigment {color LightSteelBlue}
    translate x*-210
    no_shadow
}
#debug ".."
torus{ 200,4
    pigment {color LightSteelBlue}
    rotate z*45
    translate <150,150,0>
    no_shadow
}
#debug ".."
torus{ 200,4
    pigment {color LightSteelBlue}
    rotate z*-45
    translate <-150,150,0>
    no_shadow
}
}//end union
cylinder { <0,0,0>, <0,0,1000>, 1000 pigment {color LightSteelBlue} }
} //end differance

#debug "Done\n"
#else
#debug "Tenticals off\n"
#end

//***Building***\\
#if (Building_on = 1)
#declare Window = union {
difference {
box { <-150, 50, -4> < -85, 105, 1> pigment {color Magenta} } //Windows

box { <-145, 52, -5> < -140, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <-135, 52, -5> < -130, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <-125, 52, -5> < -120, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <-115, 52, -5> < -110, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <-105, 52, -5> < -100, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <-95, 52, -5> < -90, 103, 2> pigment {color Magenta}  } //Slat cut-outs
translate z*-30
}

difference {
box { <85, 50, -4> < 150,  105,  1> pigment {color Magenta} }

box { <90, 52, -5> < 95, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <100, 52, -5> < 105, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <110, 52, -5> < 115, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <120, 52, -5> < 125, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <130, 52, -5> < 135, 103, 2> pigment {color Magenta}  } //Slat cut-outs
box { <140, 52, -5> < 145, 103, 2> pigment {color Magenta}  } //Slat cut-outs
translate z*-30
}

}
#declare Building = difference {
    difference {
        box { <-200, -40, 0> < 200,  125,  50> texture {SchoolStone} } //Building
        cylinder { <0, 0, -30> <0, 0, 60>, 51 texture {SchoolStone} } //Hole fo Vortex
    }
    box { <-190, -35, 1> < 190,  120,  49> pigment {color Clear} } //Building Cut-out

box { <-150, 50, -0.01> <-96, 105, 2> pigment {color Black}}
box { <96, 50, -0.01> <150, 105, 2> pigment {color Black}}
}

object {Building}
object {Window}
light_source{ <-120, 51, 1> color Red }
light_source{ <115, 51, 1> color Red }
#end
