/*
global_settings { ambient_light 1 }

#include "colors.inc"
#include "textures.inc"

#declare cam = 0 // TOP = 1 PERSPECTIVE = 0

#if ( cam = 0 )
  camera {
    location <0,1,-5>
    look_at <0,1,0>
  }
#else
  camera {
    location <0,10,0>
    look_at <0,0,0>
  }
#end

light_source { <10,14,-10> color White }

light_source { <-10,14,-10> color White }

// plane { y,0 pigment { color White } }
*/
union {
// ********* BODY OF MAGICAL SPHERE *********
   difference {
      union {
         sphere { <0,0,0>,1 scale <1,1,0.2> translate y*1 }
         sphere { <0,0,0>,1 scale <0.2,1,1> translate y*1 }
         sphere { <0,0,0>,1 scale <1,1,0.2> translate y*1 rotate y*45 }
         sphere { <0,0,0>,1 scale <0.2,1,1> translate y*1 rotate <0,-135,0> }
      }
      sphere { <0,0,0>,1 scale <0.9,0.9,0.9> translate y*1.2 }
      cylinder { <0,1.4,0> <0,2,0>,2 }
   texture { pigment { color rgbf <0.8,0.8,0.825> } finish { Shiny ambient 0.3 diffuse 0.7 }}
   }
   cone { <0,0,0>,1 <0,0.5,0>,0.7
     texture {
       pigment { color rgbf <0.8,0.8,0.825> }
       finish { Shiny ambient 0.3 diffuse 0.7 }
     }
   }
   sphere { <0,0,0>,1
     scale <0.9,0.9,0.9>
     translate y*1.2
     texture { pigment { color rgbf <0,0.8,1,0.5> } finish { ambient 1 diffuse 0.5 }}
   }
   difference {
      cone { <0,0,0>,1 <0,0.5,0>,0.7 }
      union {
            sphere { <0,0.2,-0.85>,0.15 rotate y*0 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*45 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*90 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*135 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*180 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*225 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*270 }
            sphere { <0,0.2,-0.85>,0.15 rotate y*315 }

      }
      pigment { color White }
   }
   torus { 0.8, 0.05 translate y*0.8 pigment { color White } }

   #declare rot01= 0
   #while ( rot01 <360 )
          torus { 0.15,0.05
                  rotate z*(-53.3) /* atan2(0.5/0.15,1) */
                  translate <0.825,0.22,0>
                  rotate y*rot01
                  pigment { color White }
                  }
          sphere { <0,0.2,-0.85>,0.125 rotate y*rot01
                 pigment { color rgb <0,1,1> }
          }
   #declare rot01 = rot01 + 45
   #end
}
