// Name of picture: The school of magic
// Creator: Toni Bratincevic (Alpha Crew)
// E-Mail: toni.bratincevic@altbbs.fido.hr
// Country: CROATIA

// This is my submission for IRTC (Internet Raytracing Competittion)
// Theme: School

// Hardware used: P120 / 32 MB RAM
// Software: POVRay 3.0e for Windows, sPatch

// Rendering time:

#declare cam = 1

global_settings {
   ambient_light 0.5
   assumed_gamma 1.5
   max_trace_level 40
}

// ********** TEXTURE - INCLUDE DATOTEKE **********

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "tonitex1.inc"
#include "glass.inc"
#include "enviro.inc"

#declare wood01 =
    texture { pigment { P_WoodGrain5A color_map { M_Wood16A }}}
    texture { pigment { P_WoodGrain5B color_map { M_Wood16B }}}

// ********** OBJEKTI - INCLUDE DATOTEKE **********

#include "zeko02.inc"
#include "msphere1.inc"
#include "umetak.inc"
#include "table01.inc"
#include "bottle01.inc"
#include "door01.inc"
#include "table02.inc"
#include "ormar.inc"
#include "stjena01.inc"
#include "prostor.inc"
#include "stolica.inc"
#include "slika.inc"
#include "book02.inc"
#include "caro.inc"
#include "tabla.inc"

// ********** CAMERA **********

#if ( cam = 1 )
camera {
       location <-5,15,-14>
       look_at <-10,5,20>
       angle 60
}
#else
camera {                        // TEST CAMERA
       location <0,5,-10>
       look_at <0,5,10>
       angle 60
}
#end

// ********** LIGHTS **********

light_source {
   <0,19,0>
   color White
   area_light <-4,0,4> <4,0,-4> ,20 ,20
   adaptive 1
   jitter

}

light_source {
   <-30,30,20>
   color rgb <0.5,0.5,0.5>
   shadowless
}

// ********** OBJECTS **********

// SOBA

union {
      // POD
      plane { y,0.01
            texture { M_Floor04 scale 1.5 }
      }
      // STROP
      box { <-20,20,20>, <20,22,-20>
            texture { M_Floor04 scale 1.5 }
      }
      // LIJEVI ZID
      difference {
            box { <-20,0,-20>, <-22,20,20> }
            box { <-19,0,2.9>, <-23,15.1,11.1> }
            texture { M_Brick3 scale 3.5 }
      }
      // DESNI ZID
      box { <20,0,-20> , <22,20,20>
            texture { M_Brick3 scale 3.5 }
      }
      // PREDNJI ZID
      difference {
            box { <-20,0,20>, <20,20,24>  }
            box { <-18,7.5,19>, <-12,15,22>  }
            box { <-9.5,6.5,19>, <0,3.5,23>  }
            texture { M_Brick3 scale 3.5 }
       }
       // ZADNJI ZID
       box { <-10,-1,-20>, <10,1,-22>
            texture { M_Brick3 scale 3.5 }
      }
      // ZID IZVAN RAZREDA
      box { <-30,0,-30>, <-32,30,30>
            texture { M_Brick3 scale 3.5 }
      }
}

// ########## TABLA ##########

 object { TABLEALL translate <-16,0,16> }

// ########## VRATA ##########

object { DOOR rotate x*(-90) rotate y*(-90) translate <-21.5,7.5,7> }
union  { box { <-19.9,0,2.95>, <-22.1,15.05,2.45> }
         box { <-19.9,0,11.05>, <-22.1,15.05,11.55> }
         box { <-19.9,15.05,2.45>, <-22.1,15.55,11.55> }
         texture { wood01 }
}

// ########## STOLOVI ##########

union {
       object { TABLE02ALL }
       object { MSTICK01
          rotate y*340
          translate <5,7.5,-5>
       }
       scale 0.8
       rotate y*5
       translate <-7,0,6>
}
union {
       object { TABLE02ALL }
       object { msphere02 translate <-6.25,4.8,-1> }
       object { MSTICK01
          rotate x*277.5
          translate <5.355,0,1>
       }
       scale 0.8
       rotate y*-5
       translate <6,0,6>

}
union {
       object { TABLE02ALL }
       object { MSTICK01
          rotate x*277.5
          translate <5.355,0,1>
       }
       scale 0.8
       rotate y*(-4)
       translate <-7.5,0,-5>
}

// ########## KNJIGA ##########

object {
         book01
         scale 0.75
         rotate y*5
         translate <-10,6,-5>
}

// ########## ORMARIC U ZIDU ##########

object { ormar rotate x*-90 translate <-15,7.5+3.75,21>}

// ########## BOCE ##########

union {
       union {
       object { BOTTLE  }
       object { voda01 }
         scale 0.5
         translate <-8.5,3.7,21.5>
       }
       union {
       object { BOTTLE  }
       object { voda02 }
         scale 0.5
         translate <-3.5,3.7,21.6>
       }
       union {
       object { BOTTLE  }
       object { voda03 }
         scale 0.5
         translate <-1,3.7,21.2>
       }
}

// ########## SEKUNDARNA MAGICNA KUGLA ##########

object { msphere02 translate <-6,3.7,21.5> }

// ########## CAROBNJAKOV MAGICNI MAC ##########

object { msword translate <-17,0,11.5> }

// ########## STOLICA ##########

object { stolica scale 0.8 translate <-8,0,1> }

// ########## SLIKA NA ZIDU ##########

object {
   SLIKA
   rotate <-90,-90,0>
   translate <-20,12,15>
   rotate <1.5,0,0>
}

// ########## OTVORENA KNJIGA ##########

object {
   book02
   scale <0.7,0.5,0.7>
   rotate y*(-3)
   translate <-8,6,6>
}

// ########## ZEKO ##########

object { zeko scale 0.6 translate <-7.65,6.10,1> }

// ########## MAGIJA - OMOTAC ##########

sphere {
   <0,0,0>,1
   texture {
       pigment { color rgbt <1, 1, 1, 1> }
   }
   halo {
      emitting
      spherical_mapping
      linear
      color_map {
         [ 0 color rgbt <0,0,0,1> ]
         [ 0.20 color rgbt <0,0,0,1> ]
         [ 0.25 color rgbt <0.2,0.7,0.3,-0.5> ]
         [ 1 color rgbt <0.2,0.9,0.6,-1> ]
      }
      frequency 1.5
      turbulence 1
      samples 10
      scale 0.75
   }
   hollow
   scale <1,2.5,1> translate y*2
   scale 2
   translate <-8,3,1>
   no_shadow
}

// ########## MAGIJA - SNOP ##########

cylinder { <-7,0,0> <5,0,1> , 2
  texture {
      pigment { color rgbt <0,0,0,1> }
   }
   halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
         [ 0 color rgbt <0,0,0,1> ]
         [ 0.20 color rgbt <0,0,0,1> ]
         [ 0.25 color rgbt <0.2,0.7,0.3,-0.25> ]
         [ 1 color rgbt <0.2,0.9,0.6,-0.5> ]
      }
      frequency 1.5
      turbulence 1
      samples 10
      rotate z*90
      scale <7,0.4,0.4>
   }
   hollow
   translate y*7.5
}

// ########## CAROBNJAK ##########

object {
   wizard
   scale 0.65
   rotate y*170
   translate <10,8,16.5>
}
