// Textures for POVRay
// Seria: My Textures 01

// Created by Toni Bratincevic from Alpha Crew
// E-Mail: Toni.Bratincevic@fesb-bbs.fido.hr

// Tekstures:
//       M_Floor01
//       M_Floor02
//       M_Floor03
//       M_Floor04
//       M_Crackle01
//       M_PlastOker
//       M_PlastGray
//       Comp_Plast
//       M_PlastGreen
//       M_PlastBlue
//       M_PlastBBlue
//       M_Brick1
//       M_Brick2
//       M_Brick3
//       M_Metal01
//       M_Metal02
//       landtex01
//       School_table
//       TStone01
//       TStone02
//       TStone03
//       TStone04
//       TStone05
//       TStone06
//       TStone07
//       Book_tex01
//       Paper_Tex01
//       Hander_Tex
//       Hander_Tex1

#declare M_Floor01 =
texture { pigment {
            agate
              color_map {
                [ 0 color rgb <0.2,0.2,0.2> ]
                [ 1 color rgb <0.8,0.7,0.6> ]
              }
       }
}
texture { pigment {
            checker
              color rgbt <0.3,0,0,0.5>,
              color rgbt <1,.7,.7,0.5>
            }
          finish { ambient 0.2
                   diffuse 0.4
                   reflection 0.2
                   phong 0.7
                   phong_size 20
          }
          normal {
            bumps 0.2
          }
          scale 0.4
}

#declare M_Floor02 =
texture { pigment {
            agate
              color_map {
                [ 0 color rgb <0.2,0.2,0.2> ]
                [ 1 color rgb <0.8,0.7,0.6> ]
              }
              scale 0.5
       }
}
texture { pigment {
            hexagon
              color rgbt <0.2,0.2,0.2,0.3>,
              color rgbt <0.5,0.5,0.5,0.3>,
              color rgbt <0.8,0.8,0.8,0.3>
            }
          finish { ambient 0.2
                   diffuse 0.4
                   reflection 0.1
                   phong 0.7
                   phong_size 20
          }
          normal {
            bumps 0.2
          }
          scale 0.2

}


#declare M_Crackle01 =
texture { pigment { crackle
                           color_map {
                                    [ 0 color Red ]
                                    [ 0.5 color Green ]
                                    [ 1 color Blue ]
                           }
                           scale 0.5
                  }
          finish { ambient 0.2 diffuse 0.4 specular 0.4 }
          normal { crackle 0.8 scale 0.5 }
}

#declare M_PlastOker =
texture { pigment { color rgb <0.8,0.7,0.3> }
    finish  { ambient 0.35 diffuse 0.7 phong 0.3 phong_size 20 }
    normal  { bumps 0.05 scale 0.01 bump_size 0.05 }
}

#declare M_PlastGray =
texture { pigment { color rgb <0.7,0.7,0.7> }
    finish  { ambient 0.35 diffuse 0.7 phong 0.3 phong_size 20 }
    normal  { bumps 0.05 scale 0.01 bump_size 0.05 }
}
#declare Comp_Plast =
texture {
    pigment { color rgb <0.2,0.2,0.2> }
    finish  { ambient 0.35 diffuse 0.7 phong 0.3 phong_size 20 }
    normal  { bumps 0.05 scale 0.01 bump_size 0.05 }
}

#declare M_PlastGreen =
texture { pigment { color rgb <0.1,0.8,0.1> }
    finish  { ambient 0.35 diffuse 0.7 phong 0.3 phong_size 20 }
    normal  { bumps 0.05 scale 0.01 bump_size 0.05 }
}

#declare M_PlastBlue =
texture { pigment { color rgb <0.1,0.1,0.8> }
    finish  { ambient 0.35 diffuse 0.7 phong 0.3 phong_size 20 }
    normal  { bumps 0.05 scale 0.01 bump_size 0.05 }
}

#declare M_PlastBBlue =
texture { pigment { color rgb <0.65,0.65,0.9> }
    finish  { ambient 0.35 diffuse 0.7 phong 0.3 phong_size 20 }
    normal  { bumps 0.05 scale 0.01 bump_size 0.05 }
}

#declare M_Brick1 =
texture { pigment { brick
                         color rgb <0.8,0.8,0.8>
                         color rgb <0.8,0.3,0.1>
                         turbulence 0.2
                  }
          finish  { ambient 0.3 diffuse 0.7 phong 0.2 phong_size 10 }
          normal  { brick 0.2 }
          scale 0.1
}
texture { pigment { agate
                    color_map {
                         [ 0.0 color rgbt <0.3,0.1,0.2,0.7> ]
                         [ 0.5 color rgbt <0.5,0.3,0.1,0.8> ]
                         [ 0.7 color rgbt <0.4,0.2,0.2,0.9> ]
                         [ 1.0 color rgbt <0.4,0.4,0.4,0.8> ]
                    }
                   }
          finish  { ambient 0.3 diffuse 0.7 phong 0.2 phong_size 10 }
          normal  { agate 0.4 }
          scale 0.1
}
texture { pigment { color rgbt <1,1,1,1> } normal  { bumps 0.4 scale 0.2 } }

#declare M_Brick2 =
texture { pigment { brick
                         color rgb <0.7,0.7,0.7>
                         color rgb <0.3,0.3,0.3>
                         turbulence 0.2
                  }
          finish  { ambient 0.3 diffuse 0.7 phong 0.2 phong_size 10 }
          normal  { brick 0.2 }
          scale 0.1
}
texture { pigment { agate
                    color_map {
                         [ 0.0 color rgbt <0.3,0.3,0.3,0.7> ]
                         [ 0.5 color rgbt <0.5,0.5,0.5,0.8> ]
                         [ 0.7 color rgbt <0.4,0.4,0.4,0.9> ]
                         [ 1.0 color rgbt <0.2,0.2,0.2,0.8> ]
                    }
                   }
          finish  { ambient 0.3 diffuse 0.7 phong 0.2 phong_size 10 }
          normal  { agate 0.4 }
          scale 0.1
}
texture { pigment { color rgbt <1,1,1,1> } normal  { bumps 0.4 scale 0.2 } }

#declare M_Metal01 =
texture {
      pigment { dents
        color_map {
          [0 color rgb <0.35,0.35,0.4>  ]
          [0.4 color rgb <0.4,0.4,0.4>]
          [1 color rgb <0.4,0.4,0.45>]
        }
      }
      finish {
        diffuse 0.6
        ambient 0.3
        specular 0.6
        reflection 0.15
        // metallic
      }
      normal {
        ripples
          normal_map {
            [ 0 hexagon 0.5]
            [ 0.5 bumps 0.2 scale 4]
            [ 1 checker 0.3 turbulence 0.05 scale 0.5]
          }
      }
      rotate x*90
      scale 2
}

#declare landtex01 =
texture { pigment {
            granite
              color_map {
                [ 0 color rgb <0.8,0.6,0.2> ]
                [ 1 color rgb <0.8,0.8,0.3> ]
              }

       }
       normal { granite 0.2 /* scale 0.4 */ }
       finish { diffuse 0.7 ambient 0.2 }
       scale 0.2
}
texture {
  pigment {
    wrinkles
      color_map {
        [ 0   color rgbt <1,1,1,1> ]
        [ 0.5 color rgbt <1,0.5,0,0.8> ]
        [ 0.7 color rgbt <0.6,0.2,0.1,0.6> ]
        [ 1   color rgbt <0.9,0.3,0,0.4> ]
        }
        scale 0.5
     }
  finish {
    ambient 0.2
    diffuse 0.8
  }
  normal {
     wrinkles 0.6
     scale 0.5
 }
scale 0.4
}

#declare M_Floor03 =
texture { pigment {
            granite
              color_map {
                [ 0 color rgb <0.35,0.35,0.35> ]
                [ 1 color rgb <0.65,0.55,0.45> ]
              }
              turbulence 2

       }
       normal { granite 0.2 }
       finish { reflection 0.3 }
       scale 0.3
}
texture { pigment {
            checker
              color rgbt <0,0,0,0.4>,
              color rgbt <1,1,1,0.6>
          }
          finish { ambient 0.2
                   diffuse 0.6
                   reflection 0.3
                   phong 0.7
                   phong_size 10
          }
          normal {
                   bumps
                     normal_map {
                             [ 0 bumps 0.025 scale 2]
                             [ 0.6 granite 0.05 scale 2]
                             [ 1 granite 0.1 scale 4 ]
                     }
                     scale 0.3

               }

scale 0.4
}
texture {
  pigment {
    agate
      color_map {
        [0    color rgbt <1,1,1,1>]
        [0.80 color rgbt <1,1,1,1>]
        [0.85 color rgbt <0.7,0.7,0.7,0.8>]
        [1    color rgbt <0.8,0.8,0.8,0.6>]
      }
      turbulence .8
      scale 0.25
  }
  finish { reflection 0.3 }
}

#declare TStone01 =
  texture {
    pigment{
      wrinkles
        colour_map {
                   [0 color rgb<0.5,.5,0.4>]
                   // [0.25 color rgb<0,1,0>]
                   // [0.75 color rgb<0,0,1>]
                   [1 color rgb<0.8,0.8,0.9>]
                   }
        frequency 1
        turbulence 3
         }
    finish { ambient 0.3 diffuse 0.7 specular 0.3  roughness 0.01 }
    normal { wrinkles 0.5 }
    scale 2.5
  }
  texture {
 pigment{
      granite
        colour_map {
                   [0 color rgbt<0.7,.7,0.6,0.4>]
                   // [0.25 color rgbt<0,1,0,0.1>]
                   // [0.75 color rgbt<0,0,1,0.6>]
                   [1 color rgbt<0.5,0.5,0.4,0.6>]
                   }
        frequency 1
         }
    finish { ambient 0.3 diffuse 0.7 specular 0.3  roughness 0.01 }

  }
  texture {
 pigment{
      agate
        colour_map {
                   [0 color rgbt<1,1,1,1>]
                   [0.75 color rgbt<1,1,1,1>]
                   [0.8 color rgbt<0.6,0.6,.5,0.7>]
                   [1 color rgbt<0.7,0.7,0.6,0.5>]
                   }
        frequency 1
         }
    finish { ambient 0.3 diffuse 0.7 specular 0.3  roughness 0.01 }
}

#declare TStone02 =
  texture {
    pigment{
      wrinkles
        colour_map {
                   [0 color rgb<0.5,.5,0.4>]
                   // [0.25 color rgb<0,1,0>]
                   // [0.75 color rgb<0,0,1>]
                   [1 color rgb<0.8,0.8,0.9>]
                   }
        frequency 1
        turbulence 3
         }
    finish { ambient 0.3 diffuse 0.7 specular 0.3  roughness 0.01 }
    scale 2.5
  }

#declare TStone03 =
texture {
    pigment{
      crackle
        colour_map {
                   [0 color rgb<0.6,0.6,0.65>]
                   [0.60 color rgb<0.45,0.4,0.5>]
                   [0.75 color rgb<0.4,0.4,.45>]
                   [1 color rgb<0.8,0.8,0.9>]
                   }
        frequency 1
        turbulence 3
        scale 2
         }
    finish { ambient 0.3 diffuse 0.7 specular 0.3  roughness 0.01 }
    scale 2.5
}
texture {
    pigment{
      spiral2 5
        colour_map {
                   [0 color rgbf<0.7,0.7,0.6,1>]
                   [0.40 color rgbf<0.4,0.4,0.5,.9>]
                   [0.55 color rgbf<0.5,0.5,0.55,0.8>]
                   [1 color rgbf<0.85,0.85,0.9,0.5>]
                   }
        frequency 1
        turbulence 2
        scale 6
         }
    finish { ambient 0.3 diffuse 0.7 specular 0.3  roughness 0.01 }
    scale 3
}

#declare M_Floor04 =
texture {
    pigment {
              crackle
              color_map {
                        [ 0   color rgb <0.6,0.6,0.55> ]
                        [ 0.02 color rgb <0.55,0.55,0.55> ]
                        [ 0.06 color rgb <0.55,0.45,0.4> ]
                        [ 1   color rgb <0.55,0.45,0.4> ]
              }
    }
    finish  { ambient 0.4 diffuse 0.7 }
    normal {
       crackle
       slope_map {
          [0    <0, 0>]
          [0.06   <0.25, 0.25>]
          [1    <0.7, 0.7>]
       }
    }
}
texture {
    pigment {
              granite
              color_map {
                        [ 0   color rgbt <0.6,0.6,0.6,0.8> ]
                        [ 0.5 color rgbt <0.5,0.45,0.45,0.8> ]
                        [ 0.5 color rgbt <0.5,0.45,0.4,0.8> ]
                        [ 1   color rgbt <0.5,0.45,0.4,0.8> ]
              }
    }
    normal { granite 0.1 scale 0.2 }
}

#declare M_Brick3 =
texture { pigment { brick
                         color rgb <0.75,0.7,0.7>
                         color rgb <0.35,0.3,0.3>
                         turbulence 0.2
                  }
          finish  { ambient 0.3 diffuse 0.7 phong 0.2 phong_size 10 }
          normal  { brick 0.6 }
          scale 0.1
}
texture { pigment { agate
                    color_map {
                         [ 0.0 color rgbt <0.35,0.3,0.3,0.7> ]
                         [ 0.5 color rgbt <0.525,0.5,0.5,0.8> ]
                         [ 0.7 color rgbt <0.4,0.4,0.4,0.9> ]
                         [ 1.0 color rgbt <0.225,0.2,0.2,0.8> ]
                    }
                   }
          finish  { ambient 0.3 diffuse 0.7 phong 0.2 phong_size 10 }
          normal  { agate 0.4 }
          scale 0.1
}
texture {
        pigment { color rgbt <1,1,1,1> }
        normal  { bumps 0.4 scale 0.2 }
}

#declare School_table =
texture { pigment { color rgb <0,0.175,0> }
          finish  { ambient 0.35 diffuse 0.7 phong 0.1 phong_size 2 }
          normal  { bumps 0.075 scale 0.01}
}

#declare M_Metal02 =
texture {
          pigment { color rgb <0.7,0.7,0.7> }
          finish { phong 0.5 phong_size 10 reflection 0.1 ambient 0.2 diffuse 0.6 }
          normal { bumps 0.05 scale <0.05,0.6,0.05> }
}

#declare TStone04 =
texture {
   pigment {
      agate
      color_map {
         [ 0   color rgb <0.35,0.3,0.3> ]
         [ 0.2 color rgb <0.4,0.35,0.35> ]
         [ 1   color rgb <0.475,0.425,0.425> ]
      }
   }
   finish { ambient 0.3 diffuse 0.7 phong 0.4 phong_size 10 crand 0.025 reflection 0.05}
   normal { agate 0.025 }
}

#declare TStone05 =
texture {
   pigment {
           wrinkles
           color_map {
             [ 0    color rgb <0.5,0.4,0.4> ]
             [ 0.25 color rgb <0.4,0.4,0.4> ]
             [ 1    color rgb <0.5,0.45,0.375>  ]
           }
   }
   normal { wrinkles 0.5 }
   finish { diffuse 0.6 ambient 0.3 }
   scale 0.5
}
texture {
   pigment {
           granite
           color_map {
             [ 0    color rgbt <0.45,0.4,0.4,0.6> ]
             [ 0.5 color rgbt <0.325,0.35,0.35,0.8> ]
             [ 1    color rgbt <0.4,0.35,0.375,0.7>  ]
           }
   }
   normal { granite 0.75 }
   scale 0.5
   finish { diffuse 0.6 ambient 0.3  phong 0.15 phong_size 0.5  crand 0.05 }
}

#declare Book_tex01 =
texture {
   pigment {
      bumps
      color_map {
         [ 0   color rgbf <0.46,0.11,0,0.5> ]
         [ 1   color rgbf <0.45,0.1,0,0.5> ]
      }
   }
   finish { ambient 0.4 diffuse 0.7 phong 0.2 phong_size 1 crand 0.01 }
   normal { bumps 0.1 }
   scale <0.5,0.1,0.1>
   scale 0.2
}
texture {
   pigment {
      bumps
      color_map {
         [ 0   color rgbf <0.46,0.11,0,0.5> ]
         [ 1   color rgbf <0.45,0.1,0,0.5> ]
      }
   }
   finish { ambient 0.4 diffuse 0.8 phong 0.1 phong_size 0.5 crand 0.01 }
   normal { bumps 0.1 }
   scale <0.5,0.1,0.1>
   scale 0.2
   rotate y*90
}

#declare Paper_Tex01 =      // Paper texture on y layer
texture {
  pigment {
    gradient y
      color_map {
         [ 0 color <0.5,0.475,0.475> ]
         [ 0.2 color <0.5,0.475,0.475> ]
         [ 0.25 color <0.6,0.55,0.55> ]
         [ 1 color <0.6,0.55,0.55> ]
      }
   }
finish { ambient 0.4 diffuse 0.7 phong 0.05 phong_size 0.5 crand 0.025 }
normal { gradient y 0.25 }
scale 0.025
}

#declare TStone06 = texture {
   pigment {
      crackle
      color_map {
            [ 0   color rgb <0.25,0.35,0.5> ]
            [ 0.2 color rgb <0.25,0.35,0.5> ]
            [ 1   color rgb <0.15,0.15,0.3> ]
      }
      turbulence 0.8
   }
   normal {
      crackle
      slope_map { [ 0,0 ] [ 0.2,0.05 ] [ 1. 0.05 ]}
      turbulence 0.8
   }
   finish { diffuse 0.7 ambient 0.3 phong 1 phong_size 40 reflection 0.01 crand 0.005 }
   scale 0.2
}


#declare TStone07 = texture {
   pigment {
      crackle
      color_map {
            [ 0   color rgb <0.4,0.3,0> ]
            [ 0.2 color rgb <0.4,0.3,0> ]
            [ 1   color rgb <0.3,0.05,0.05> ]
      }
      turbulence 0.8
   }
   normal {
      crackle
      slope_map { [ 0,0 ] [ 0.2,0.05 ] [ 1. 0.05 ]}
      turbulence 0.8
   }
   finish { diffuse 0.7 ambient 0.3 phong 1 phong_size 40 reflection 0.01 }
   scale 0.2
}

#declare Hander_Tex = texture {
   pigment { gradient z
      color_map {
         [ 0 color Black ]
         [ 0.05 color Black ]
         [ 0.1 color Brown ]
         [ 1 color Brown ]
   } turbulence 0.2 }
   normal { gradient z
      slope_map {
        [ 0   ,0 ]
        [ 0.1 ,0 ]
        [ 0.15,1 ]
        [ 1   ,1 ]
      }
   }
   scale 0.1 rotate y*10
}

#declare Hander_Tex1 = texture {
   pigment { gradient z
      color_map {
         [ 0 color Black ]
         [ 0.05 color Black ]
         [ 0.1 color rgb <0.6,0.5,0.5> ]
         [ 1 color rgb <0.6,0.5,0.5> ]
   } turbulence 0.2 }
   normal { gradient z
      slope_map {
        [ 0   ,0 ]
        [ 0.1 ,0 ]
        [ 0.15,1 ]
        [ 1   ,1 ]
      }
   }
   scale 0.1 rotate y*10
}
