// Persistence of Vision Ray Tracer Scene Description File
// File: furnish.pov
// Vers: 3.01 Watcom Win32
// Desc: Furnishing for the room
// Date: March 12, 1997
// Auth: Sonya Roberts
// Note:

#if (I_Desks=True)
	#debug "     Making desks...\n"

	#declare DeskLeg=
	object {
		union {
			cylinder {
				<0,0,0>,<0,2.5,0>,.12
				texture {T_Silver_4C}
			}
			cylinder {
				<0,0,0>,<0,.075,0>,.125
				texture {BlackPlastic}
			}
		}
	}

	#declare Desk=
	object {
		union {
			union {
				superellipsoid {				// DESK SURFACE
					<.2,.2>					// Box with rounded edges
					scale <2.5,.07,1.25>			// Scale to approx. <5,.14,2.5> units
					texture {BlackPlastic}
				}
				superellipsoid {
					<.2,.2>					// Box with rounded edges
					scale <2.475,.075,1.225>		// Scale to approx. <5,.15,2.5> units
					texture {GrayMelamine	scale <.5,.5,.5>}
				}
				translate <0,2.5,0>
			}
			object {DeskLeg	translate <-2,0,-.75>}
			object {DeskLeg	translate <2,0,-.75>}
			object {DeskLeg	translate <-2,0,.75>}
			object {DeskLeg	translate <2,0,.75>}
		}
	}
#end

#if (I_Chairs=True)
	#debug "     Creating chair pieces...\n"

	#debug "      - Chair Base\n"
	#declare ChairBase=
	object {
		union {
			#declare RotY=1
			#while (RotY<=5)
				union {
					cylinder {				// Metal leg
						<0,0,0>,<0,0,1.2>,.15
						scale <.5,1,1>
						texture {T_Silver_4C}
					}
					cylinder {				// With plastic end-cap
						<0,0,1.15>,<0,0,1.25>,.15
						scale <.5,1,1>
						texture {BlackPlastic}
					}
					cylinder {				// Peg for wheel
						<0,0,1.2>,<0,-.15,1.2>,.025
						texture {BlackPlastic}
					}
					sphere {				// Wheel
						<0,-.2,1.2>,.175
						texture {BlackPlastic}
					}
					rotate y*((360/5)*RotY)
				}
				#declare RotY=RotY+1
			#end
			union {
				cylinder {<0,-.18,0>,<0,.18,0>,.3}			// Center Hub
				sphere {
					<0,0,0>,.3
					scale <1,.25,1>
					translate <0,.18,0>
				}
				texture {BlackPlastic}
			}
			translate <0,.375,0>					// Translate so wheels are on floor
		}
	}

	#debug "      - Chair Seat\n"
	#declare ChairSeat=
	object {
		union {
			superellipsoid {
				<.6,.6>						// Squarish sphere-like shape
				scale <.85,.15,.7>				// Scale to approx. <1.7,.3,1.4>
				texture {
					BlueFabric
					translate <-1,-1,-.5>
					scale <.75,.75,.75>
				}
			}
			superellipsoid {
				<.6,.6>						// Squarish sphere-like shape
				scale <.875,.15,.725>				// Scale to just over <1.7,.3,1.4>
				translate <0,-.025,0>				// Translate down
				texture {BlackPlastic}
			}
			difference {						// Make a bracket to hold seat backs
				superellipsoid {
					<.1,.1>
					translate <0,1,0>
					scale <.175,.5,.5>
				}
				superellipsoid {
					<.1,.1>
					translate <0,1,0>
					scale <.2,.5,.5>
				}
				box {<-.3,.2,-.3>,<.3,1.1,1.1>}
				translate <0,-.1,-.5>
				texture {T_Silver_4C}
			}

		}
	}

	#debug "      - Chair Back\n"
	#declare ChairBack=
	object {
		union {
			superellipsoid {
				<.35,.35>					// Cube with rounded corners
				scale <.75,.5,.1>				// Scale to approx. <1.5,1,.2>
				translate <0,0,.075>
			}
			superellipsoid {
				<.3,.3>						// Cube with rounded corners
				scale <.35,.3,.05>				// Scale to approx. <.7,.6,.1>
				translate <0,0,-.075>
				texture {BlackPlastic}
			}
		}
		texture {
			BlueFabric
			translate <-1,-1,-.5>
			scale <.75,.75,.75>
		}
	}

	#debug "     Creating Plain Chair too...\n"
	#declare OtherChair=
	object {
		union {
			union {
				cylinder {<0,-.5,1.25>,<0,1,1.25>,.05}			// Left Chair Legs
				cylinder {
					<0,-.5,1.25>,<0,-.4,1.25>,.065
					texture {BlackPlastic}
				}
				cylinder {<0,-.5,0>,<0,1.25,0>,.05}
				cylinder {
					<0,-.5,0>,<0,-.4,0>,.065
					texture {BlackPlastic}
				}
				intersection {						// 1/4 circle curve
					torus {
						.25,.05
						rotate z*90
						translate <0,0,-.25>
					}
					box {<-.1,0,-.25>,<.1,.26,.1>}			// Curve up & back
					translate <0,1,1.25>				// Move into position
				}
				cylinder {<0,1.25,1>,<0,1.25,0>,.05}			// Side rail
				intersection {						// 1/4 circle curve
					torus {
						.25,.05
						rotate z*90
						translate <0,.25,0>
					}
					box {<-.1,0,-.26>,<.1,.25,.1>}			// Curve back & up
					translate <0,1.25,0>				// Move into position
				}
				cylinder {<0,1.5,-.25>,<0,2.75,-.25>,.05}		// Back side rail
				translate <-.75,0,0>
			}
			union {
				cylinder {<0,-.5,1.25>,<0,1,1.25>,.05}			// Right Chair Legs
				cylinder {
					<0,-.5,1.25>,<0,-.4,1.25>,.065
					texture {BlackPlastic}
				}
				cylinder {<0,-.5,0>,<0,1.25,0>,.05}
				cylinder {
					<0,-.5,0>,<0,-.4,0>,.065
					texture {BlackPlastic}
				}
				intersection {						// 1/4 circle curve
					torus {
						.25,.05
						rotate z*90
						translate <0,0,-.25>
					}
					box {<-.1,0,-.25>,<.1,.3,.1>}			// Curve up & back
					translate <0,1,1.25>				// Move into position
				}
				cylinder {<0,1.25,1>,<0,1.25,0>,.05}			// Side rail
				intersection {						// 1/4 circle curve
					torus {
						.25,.05
						rotate z*90
						translate <0,.25,0>
					}
					box {<-.1,0,-.3>,<.1,.25,.1>}			// Curve back & up
					translate <0,1.25,0>				// Move into position
				}
				cylinder {<0,1.5,-.25>,<0,2.75,-.25>,.05}		// Back side rail
				translate <.75,0,0>
			}
			union {
				intersection {						// 1/4 circle curve
					torus {
						.25,.05
						rotate x*90
						translate <.25,0,0>
					}
					box {<-.1,0,-.1>,<.25,.3,.1>}			// Curve up & right
					translate <-.75,2,-.25>				// Move into position
				}
				intersection {						// 1/4 circle curve
					torus {
						.25,.05
						rotate x*90
						translate <-.25,0,0>
					}
					box {<-.25,0,-.1>,<.1,.3,.1>}			// Curve up & left
					translate <.75,2,-.25>				// Move into position
				}
				cylinder {<-.5,2.25,-.25>,<.5,2.25,-.25>,.05}		// Crossbar
				translate <0,.75,0>
			}
			superellipsoid {						// Seat Cushion
				<.4,.4>							// Rounded Square
				scale <.75,.1,.5125>					// Scale to approx. <1.5,.2,1.25>
				translate <0,1.25,.5>					// Move into position
				texture {BlueVinyl}
			}
			superellipsoid {						// Chair Back
				<.4,.4>							// Rounded Square
				scale <.75,.5,.1>					// Scale to approx. <1.5,1,.2>
				translate <0,2.25,-.25>					// Move into position
				texture {BlueVinyl}
			}
			texture {T_Silver_3D}
			translate <0,.5,-.75>						// Translate so is centered around origin
		}
	}
#end

#if (I_PCCase=True)
	#debug "     Making PCs...\n"

	#declare PCCase=
	object {
		union {
			difference {
				union {							// Box with slightly curved front
					box {<-.35,0,0>,<.35,2,1.5>}
					cylinder {
						<0,0,0>,<0,2,0>,.3525
						scale <1,1,.15>
					}
				}
				#declare YCount=1
				#while (YCount<=7)					// Ventilation grooves
					box {
						<-.36,0,-.3>,<.36,.025,0>
						translate <0,.2+(YCount*.05),0>
					}
					#declare YCount=YCount+1
				#end
				box {<-.36,1,-.3>,<.36,1.75,.00001>}			// Place for Drives
				box {<-.34,1.01,-.1>,<.34,1.74,.1>}			// Hollow out for height field
				box {<-.3,.05,1.45>,<.3,1.95,1.51>}			// Place on Back for Cables
			}
			height_field {
				gif "drives.gif"					// Height field of drive area
				smooth
				translate <0,-.5,0>
				scale <.7,.015,.75>
				rotate x*-90
				translate <-.35,1,0>
			}
			box {
				<0,0,0>,<1,1,-.001>					// Image Map of Computer Logo
				pigment {
					image_map {
						gif "logo.gif"
					}
				}
				scale <.15,.15,1>
				translate <-.325,1.025,0>
			}
			box {
				<-.31,.04,1.4>,<.31,1.96,1.46>				// Back of Computer - Dark Plastic
				pigment {color Gray30}
			}
		}
		translate <0,2.55,-.75>
		pigment {color Wheat*1.5}
	}
#end

#if (I_Monitor=True)
	#debug "     Making computer monitor...\n"

	#declare Monitor=
	object {
		union {
			superellipsoid {
				<.15,.15>						// Box with rounded corners (Base)
				scale <.65,.05,.65>					// Scale to approx. <1,.1,1>
			}
			union {
				cylinder {<0,0,0>,<0,.1,0>,.3}					// Neck
				sphere {<0,.4,0>,.4}						// Ball Joint
				box {<-.25,.2,-.75>,<.25,.3,0>}					// Controls Area
				union {
					cylinder {<-.15,.25,-.725>,<-.15,.25,-.7>,.05}
					cylinder {<0,.25,-.725>,<0,.25,-.7>,.05}
					cylinder {<.15,.25,-.725>,<.15,.25,-.7>,.05}
					pigment {color Wheat*1.25}
				}
			}
			difference {
				superellipsoid {					// Screen Front
					<.2,.2>						// Box with rounded corners
					scale <1,.75,.25>				// Scale to approx. <2,1.5,.5>
				}
				superellipsoid {
					<.05,.95>					// "Pointed cube" octahedron
					scale <.85,.6,.25>				// Scale to approx. <1.7,1.2,.5>
					translate <0,0,-.3>
				}
				translate <0,.95,-.5>
			}
			difference {
				box {<-.8,.3,-.5>,<.8,1.5,.75>}				// Main body of Monitor
				box {							// Slant sides towards back
					<-1,0,0>,<0,2.1,2>
					rotate y*9
					translate <-.8,0,-.5>
				}
				box {
					<1,0,0>,<0,2.1,2>
					rotate y*-9
					translate <.8,0,-.5>
				}
				box {							// Slant top towards back
					<-1,0,0>,<1,1,2>
					rotate x*9
					translate <0,1.5,-.5>
				}
				#declare XCount=-.6					// Ventilation Grooves on top
				union {
					#while (XCount<=.6)
						box {<XCount-.025,1.25,-.5>,<XCount+.025,1.6,.8>}
						#declare XCount=XCount+.1
					#end
				}
			}
		}
		translate <0,2.55,0>
		pigment {color Wheat*1.5}
	}

	#declare MonitorScreen=
	object {
		union {
			box {<-.95,.35,-.7>,<.95,1.5,-.6>	pigment {color Black}}	// Screen
			box {<-.7,.425,-.71>,<.7,1.475,-.69>}				// Area for Image on Screen
		}
	}
#end

#if (I_Keyboard=True)
	#debug "     Creating keyboards...\n"

	#declare Keyboard=
	object {
		union {
			union {
				difference {
					box {<-.75,0,-.25>,<.75,.1,.25>}	// Basic form of keyboard
					box {<-.74,.01,-.24>,<.74,.11,.24>}	// Hollow it out
				}
				cylinder {					// Round off front edge of keyboard
					<-.75,.05,0>,<.75,.05,0>,.05
					scale <1,1,.75>
					translate <0,0,-.25>
				}
				cylinder {					// Round off back edge of keyboard
					<-.75,.05,0>,<.75,.05,0>,.05
					scale <1,1,.5>
					translate <0,0,.25>
				}
				height_field {
					tga "keyboard.tga"			// Height field of top of keyboard
					smooth
					texture {
						material_map {
							gif "keycolor.gif"
							texture {
								pigment {color Wheat*1.25}
							}
							texture {
								pigment {color Wheat*1.5}
							}
						}
						rotate x*90
					}
					translate <-.5,-.5,-.5>			// translate and scale it to match top of box
					scale <1.5,.1,.5>
					translate <0,.1,0>
				}
				translate <0,0,.25>				// Position so origin along front edge
				rotate x*-15					// Tip slightly towards user
			}
			cone {
				<0,0,0>,.05,<0,.1,0>,.1				// Leg for Keyboard
				scale <1,1,.25>					// Flatten it front-to-back
				translate <-.6,0,.2>				// Move to back left of keyboard
			}
			cone {
				<0,0,0>,.05,<0,.1,0>,.1				// Leg for Keyboard
				scale <1,1,.25>					// Flatten it front-to-back
				translate <.6,0,.2>				// Move to back right of keyboard
			}
		pigment {color Wheat*1.5}
		}
	}
#end

#if (I_Mouse=True)
	#debug "     Creating mice...\n"

	#include "tail.inc"							// define MouseTail

	#declare Mouse=
	object {
		intersection {
			superellipsoid {
				<.85,.2>					// cylinder with curved edges
				scale <.2,.1,.125>				// scale to approx. <.4,.2,.25>
			}
			box {<-.25,0,-.15>,<.25,.15,.15>}			// cut off top half for mouse
		}
		rotate y*90
		pigment {color White}
		finish {
			ambient .15
			phong .2
		}
	}
#end

#if (I_Mousepad=True)
	#debug "     Making Mousepads...\n"

	#declare Mousepad=
	object {
		intersection {
			superellipsoid {
				<.15,.15>					// Box with rounded corners
				scale <.5,.1,.4>				// Scale to approx. <1,.2,.8>
			}
			box {<-1.1,0,-1.1>,<1.1,.025,1.1>}			// Cut a slice out of the rounded box
		}
	}
#end

#if (I_ZipDrives=True)
	#debug "     Assembling Zip Drives...\n"

	#declare ZipDrive=
	object {
		union {
			difference {
				superellipsoid {
					<.4,.05>					// Box with rounded edges
					scale <.25,.1,.4>				// Scale to approx. <.5,.2,.8>
				}
				superellipsoid {					// Hollow out above form
					<.4,.05>					// Box with rounded edges
					scale <.2,.075,.3>				// Scale to approx. <.4,.15,.6>
					pigment {color White}
				}
				superellipsoid {					// Cut place for view window
					<.3,.3>						// Box with rounded edges
					scale <.1,.05,.075>				// Scale to approx. <.2,.1,.15>
					translate <-.05,.075,-.25>
				}
				box {<.15,.085,-.41>,<.3,.1,.41>}			// Cut bit off top
				box {<-.3,-.05,-.41>,<.15,.11,-.38>}			// Cut bit off front
				box {<.195,.075,-.41>,<.2,.09,-.37>}			// Place for power light
				box {<-.225,0,-.4>,<.125,.025,-.35>}			// Cut slot for disks
				sphere {
					<0,0,0,>,.075					// Cut rounded bit for fingers
					scale <.75,2,.25>
					translate <-.075,.1,-.38>
				}
				pigment {color CornflowerBlue*1.75}
			}
			box {
				<.195,.075,-.4>,<.2,.085,-.37>				// Power Light
				pigment {color Green}
				finish {ambient .8}
			}
			intersection {							// View Window
				difference {
					superellipsoid {
						<.4,.05>				// Box with rounded edges
						scale <.25,.1,.4>			// Scale to approx. <.5,.2,.8>
					}
					superellipsoid {				// Hollow out above form
						<.4,.05>				// Box with rounded edges
						scale <.2,.075,.3>			// Scale to approx. <.4,.15,.6>
					}
				}
				superellipsoid {
					<.3,.3>						// Box with rounded edges
					scale <.1,.05,.075>				// Scale to approx. <.2,.1,.15>
					translate <-.05,.075,-.25>
				}
				texture {T_Glass1}
			}
			intersection {							// Sideways Leg - Front
				union {
					sphere {<0,0,0>,.01}
					cylinder {<0,0,0>,<.05,0,0>,.01}
				}
				box {<-.011,-.0095,-.0095>,<.061,.0075,.0095>}
				translate <.16,.1,-.3>
				pigment {color Gray55}
			}
			intersection {
				union {							// Sideways Leg - Back
					sphere {<0,0,0>,.01}
					cylinder {<0,0,0>,<.05,0,0>,.01}
				}
				box {<-.011,-.0095,-.0095>,<.061,.0075,.0095>}
				translate <.16,.1,.3>
				pigment {color Gray55}
			}
			superellipsoid {						// Eject Button
				<.95,.15>						// Cylinder w/rounded edges
				scale <.005,.005,.025>					// Scale to approx. <.01,.01,.05>
				translate <.2,0,-.385>
				pigment {color Gray55}
			}
		}
		translate <0,.075,0>
	}
#end


// ---- ASSEMBLE PIECES OF FURNISHING -------------------------------------------------------------------------------

#declare Furnishings=
union {
	#debug "Assembling furnishings...\n"

	#declare RowC=0
	#declare SD1=seed(2)	// Desks
	#declare SD2=seed(14)	// Chairs
	#declare SD3=seed(4)	// PC Cases
	#declare SD4=seed(47)	// Monitors
	#declare SD5=seed(10)	// Keyboards
	#declare SD6=seed(8)	// Mice
	#declare SD7=seed(6)	// Mousepads
	#declare SD8=seed(9)	// Zip Drives
	#declare ZCount=38.7
	#while (ZCount>1.5)
		union {
			#declare XCount=12.45
			#declare RowD=0
			#while (XCount>=-9)
				union {
					#if (I_Desks=True)
						object {
							Desk
							rotate y*((rand(SD1)*8)-4)
						}
					#end

					#if (I_Chairs=True)
						#if ((rand(SD2)*5)<=3)
							#declare SeatHeight=1.75+(rand(SD2)*.4)
							union {
								object {ChairBase rotate y*(360*rand(SD2))}
								union {
									cylinder {<0,.4,0>,<0,1.25,0>,.12}
									cylinder {<0,1.2,0>,<0,SeatHeight,0>,.1}
									texture {T_Silver_4C}
								}
								union {
									object {ChairSeat}
									object {
										ChairBack
										rotate x*-((rand(SD2)*20)-5)
										translate <0,.9,-.75>
									}
									rotate y*((rand(SD2)*40)-15)
									translate <0,SeatHeight,0>
								}
								translate <0,0,-2>
								#if (RowC=1)
									rotate y*180
								#end
								translate <(rand(SD)*2.5)-1.25,0,(rand(SD)*.6)-.3>
							}
						    #else
						    	object {
								OtherChair
								rotate y*((rand(SD2)*10)-5)
								translate <0,0,-2>
								#if (RowC=1)
									rotate y*180
								#end
								translate <(rand(SD)*2)-1,0,(rand(SD)*.4)-.2>
							}
						#end
					#end

					#if (I_PCCase=True)
						#if ((I_ZipDrives=False) | ((I_ZipDrives=True) & (rand(SD8)<.7)))
							object {
								PCCase
								rotate y*((rand(SD3)*4)-2)
								#if (RowC=1)
									rotate y*180
								#end
								#if (RowD=0)
									translate <2,0,0>
								    #else
									translate <-2,0,0>
								#end
							}
						    #else
							union {
								object {
									PCCase
									rotate y*((rand(SD3)*4)-2)
								}
								object {
									ZipDrive
									rotate y*((rand(SD8)*5)-2.5)
									translate <0,4.55,.25>
								}
								#if (RowC=1)
									rotate y*180
								#end
								#if (RowD=0)
									translate <2,0,0>
								    #else
									translate <-2,0,0>
								#end
							}
						#end
					#end

					#if (I_Monitor=True)
						#declare Show=int(rand(SD4)*15)
						union {
							object {Monitor}
							object {
								MonitorScreen
								#switch (Show)
									#case(1)		// IRTC Web Site
										texture {
											pigment {
												image_map {
													gif "screen01.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(2)		// Adobe Premiere
										texture {
											pigment {
												image_map {
													gif "screen02.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(3)		// 3D Studio Max - Seated Figure
										texture {
											pigment {
												image_map {
													gif "screen03.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(4)		// 3D Studio Max - Three Expressive Poses
										texture {
											pigment {
												image_map {
													gif "screen04.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(5)		// 3D Studio Max - Imploding Clock
										texture {
											pigment {
												image_map {
													gif "screen05.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(6)		// POV-Ray for Windows
										texture {
											pigment {
												image_map {
													gif "screen06.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(7)		// "Design Links" Homework Web Page
										texture {
											pigment {
												image_map {
													gif "screen07.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break			// Mess'o'windows With Sheep Screen Mate
									#case(8)
										texture {
											pigment {
												image_map {
													gif "screen08.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(9)		// Heretic Screen Grab
										texture {
											pigment {
												image_map {
													gif "screen09.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
									#case(14)		// My Resume ;)
										texture {
											pigment {
												image_map {
													gif "screen10.gif"
												}
												scale <1.4,1.05,1>
												translate <-.7,.425,0>
											}
											finish {ambient .4}
										}
									#break
								    #else
									pigment {color Black}
								#end
								translate <0,2.55,0>
							}
							#if ((MonitorGlow=True) & (Show<=9 | Show=14))
								light_source {
									<0,3.7,-.9>
									color Gray25
									area_light <2,0,0>,<0,2,0>,2,2
									adaptive 1
									jitter
									fade_distance 1.5
									fade_power .75
									atmosphere off
								}
							#end
							#if ((I_Mousepad=True) & (Show<=9 | Show=14))
								#if ((rand(SD7)*10)<=7)
									object {
										Mousepad
										pigment {color rgb <.25+(rand(SD7)*.75),.25+(rand(SD7)*.75),.25+(rand(SD7)*.75)>}
										rotate y*((rand(SD7)*14)-7)
										#if (RowC=0)
											translate <0,0,-.75>
										    #else
											translate <0,0,.75>
										#end
										#if (RowD=0)
											translate <-1.5,2.57,0>
										    #else
											translate <1.5,2.57,0>
										#end
									}
								#end
							#end

							translate <0,0,.25>
							rotate y*((rand(SD4)*4)-2)
							#if (RowC=1)
								rotate y*180
							#end
						}
					#end

					#if (I_Keyboard=True)
						object {
							Keyboard
							rotate y*((rand(SD5)*6)-3)
							translate <0,0,-1.15>
							#if (RowC=1)
								rotate y*180
							#end
							translate <(rand(SD5)*.2)-.1,2.55,(rand(SD5)*.05)-.025>
						}
					#end

					#if (I_Mouse=True)
						union {
							object {Mouse}
							object {
								MouseTail
								#if ((RowD=1 & RowC=0) | (RowD=0 & RowC=1))
									rotate z*180
								#end
								rotate x*1
								translate <0,.025,.0>
							}
							rotate y*((rand(SD6)*14)-7)
							#if (RowC=0)
								#if (RowD=0)
									translate <-1.5,0,0>
								    #else
								    	translate <1.5,0,0>
								#end
								translate <0,2.6,-.7>
							    #else
								#if (RowD=0)
									translate <1.5,0,0>
								    #else
								    	translate <-1.5,0,0>
								#end
							    	rotate y*180
								translate <0,2.575,.7>
							#end
						}
					#end

					translate <XCount,0,ZCount>
				}
				#if (RowD=0)
					#declare RowD=1
				    #else
					#declare RowD=0
				#end

				#declare XCount=XCount-5.05
			#end
		}
		#if (RowC=0)
			#declare ZCount=ZCount-7.5
			#declare RowC=1
		     #else
			#declare ZCount=ZCount-2.55
			#declare RowC=0
		#end
	#end
}
