// Persistence of Vision Ray Tracer Scene Description File
// File: room.pov
// Vers: 3.01 Watcom Win32
// Desc: Code for creation of basic room
// Date: March 12, 1997
// Auth: Sonya Roberts
// Note:

#if (DetailedCeiling=True)
	#debug "     Making Potlights...\n"
	#declare PotLight=
	object {
		union {
			difference {
				superellipsoid {
					<.95,.05>				// Cylinder with Rounded Edges
					rotate x*90				// Rotate so axis is vertical
					translate <0,.95,0>			// Move so origin near bottom
					scale <.3,.5,.3>			// Scale to .3 units in radius, 1 unit high
					texture {T_Silver_4A}			// Dull Silver
				}
				union {
					cylinder {<0,-.1,0>,<0,.7,0>,.25}	// Hollow out inside
					sphere {<0,.7,0>,.25}
					texture {T_Silver_4E}			// Polished Silver
				}
			}
			#if (UseLights=True)
				light_source {					// Light from Pot Lights
					<0,0,0>
					color Gray30
					spotlight
					point_at <0,-11,0>
					radius 20
					falloff 55
					tightness 60
				}
			#end
		}
	}

	#debug "     Making suspended ceiling...\n"
	#declare SuspendedCeiling=
	object {
		union {
			difference {
				#debug "      - Placing Ceiling Tiles\n"
				box {
					<-21,11,-1>,<16,11.1,40.1>		// Ceiling Tiles
					texture {CeilingTile}
				}
				#debug "      - Cutting holes for Panel Lights\n"
				#declare XCount=-13				// Cut Florescent Light Holes
				#while (XCount<15)
					#declare ZCount=3
					#while (ZCount<=40)
						box {<XCount,10.5,ZCount>,<XCount+2,11.5,ZCount+3>	pigment {color Clear}}
						#declare ZCount=ZCount+6
					#end
					#declare XCount=XCount+6
				#end
				#debug "      - Cutting holes for Potlights\n"
				#declare XCount=-12				// Holes for Pot Lights
				#while (XCount<=15)
					cylinder {<XCount,10.5,31>,<XCount,11.5,31>,.275	pigment {color Clear}}
					cylinder {<XCount,10.5,7.5>,<XCount,11.5,7.5>,.275	pigment {color Clear}}
					#declare XCount=XCount+6
				#end
			}
			#debug "      - Placing Panel Lights\n"
			#declare XCount=-13				// Glass Panels over Florescents
			#while (XCount<15)
				union {
					#declare ZCount=3
					#while (ZCount<=40)
						union {
							box {
								<XCount,11,ZCount>,<XCount+2,11.075,ZCount+3>
								texture {EtchedGlass}
							}
							cylinder {<XCount+.5,11.25,ZCount>,<XCount+.5,11.25,ZCount+3>,.075}
							cylinder {<XCount+.75,11.25,ZCount>,<XCount+.75,11.25,ZCount+3>,.075}
							cylinder {<XCount+1.25,11.25,ZCount>,<XCount+1.25,11.25,ZCount+3>,.075}
							cylinder {<XCount+1.5,11.25,ZCount>,<XCount+1.5,11.25,ZCount+3>,.075}
							pigment {color White}
							finish {ambient .4}
						}
						#declare ZCount=ZCount+6
					#end
				}
				#declare XCount=XCount+6
			#end
			union {
				#debug "      - Placing pot lights\n"
				#declare XCount=-12				// Pot Lights near windows
				#while (XCount<=15)
					object {
						PotLight
						translate <XCount,10.95,31>
					}
					#declare XCount=XCount+6
				#end
			}
			union {
				#declare XCount=-12				// Pot Lights near Whiteboard
				#while (XCount<=15)
					object {
						PotLight
						translate <XCount,10.95,7.5>
					}
					#declare XCount=XCount+6
				#end
			}
			#debug "      - Placing Metal Suspension Strips\n"
			#declare ZCount=0
			#while (ZCount<=40)
				superellipsoid {
					<.25,.25>			// Created Rounded-Corner Box
					scale <26,.025,.075>		// Scale to create metal strip
					translate <0,11,ZCount>		// Translate into position
					pigment {color Wheat}
					finish {
						reflection .1
						phong .3
					}
				}
				#declare ZCount=ZCount+3
			#end
			#declare XCount=-21
			#while (XCount<=15)
				superellipsoid {
					<.25,.25>			// Created Rounded-Corner Box
					scale <.075,.025,21>		// Scale to create metal strip
					translate <XCount,11,20>	// Translate into position
					pigment {color Wheat}
					finish {
						reflection .1
						phong .3
					}
				}
				#declare XCount=XCount+2
			#end
		}
	}
   #else
	#declare SuspendedCeiling=
	object {
		#debug "Using simplified ceiling...\n"
		box {
			<-21,11,-1>,<16,11.1,40.1>		// Ceiling Tiles
			texture {CeilingTile}
		}
	}
#end

#if (I_Posters=True)
	#debug "Creating Framed Posters...\n"

	#declare Poster1=
	object {
		union {
			difference {
				box {<-1.3,-1.95,-.05>,<1.3,1.9,0>}		// Thin frame
				box {<-1.19,-1.84,-.051>,<1.19,1.79,.011>}
				texture {T_Brass_1C}
			}
			difference {
				box {<-1.2,-1.85,-.025>,<1.2,1.8,0>}		// Create matting for image
				box {<-1,-1.5,-.03>,<1,1.5,.01>}
				pigment {color White}
				finish {ambient .3}
			}
			box {<-1,-1.5,0>,<1,1.5,-.001>}				// Graphics Goes Here
		}
	}

	#declare Poster2=
	object {
		union {
			difference {
				box {<-1.8,-1.35,-.05>,<1.8,1.3,0>}		// Thin frame
				box {<-1.69,-1.34,-.051>,<1.69,1.29,.011>}
				texture {T_Brass_1C}
			}
			difference {
				box {<-1.7,-1.35,-.025>,<1.7,1.2,0>}		// Create matting for image
				box {<-1.5,-1,-.03>,<1.5,1,.01>}
				pigment {color White}
				finish {ambient .3}
			}
			box {<-1.5,-1,0>,<1.5,1,-.001>}				// Graphics Goes Here
		}
	}
#end

#if (I_Warnings=True)
	#debug "Creating Warning Poster...\n"

	#declare WarnPoster=
	object {
		box {<0,0,0>,<1,1,-.01>}
		pigment {
			image_map {
				gif "warning.gif"
			}
		}
		translate <-.5,0,0>
		scale <3,4,1>
	}
#end

#if (I_TrackLights=True)
	#debug "Creating Track Lighting...\n"

	#declare LightShade=
	object {
		union {
			superellipsoid {
				<.4,.4>							// Roundish Square
				scale <.075,.0335,.075>					// Scale to approx. <.15,.075,.15>
				translate <0,-.05,0>					// Move downwards
			}
			cylinder {<0,0,0>,<0,-.5,0>,.025}				// Stem
			sphere {<0,-.5,0>,.1}						// Ball Joint
			union {
				difference {
					cylinder {<0,.2,0>,<0,-.75,0>,.25}		// Basic shape of shade
					cylinder {<0,.19,0>,<0,-.76,0>,.225}		// Hollow it out
				}
				cone {<0,.195,0>,.15,<0,.3,0>,.1}			// Lump on end
				#if (UseLights=True)
					light_source {					// Put a light in it
						<0,-.4,0>
						color Gray40
						spotlight
						point_at <0,-11,0>
						radius 30
						falloff 50
						tightness 70
					}
				#end
				translate <-.25,0,0>
				rotate z*50
				translate <0,-.5,0>
			}
		}
	}

	#declare TrackLights=
	object {
		union {
			difference {
				box {<-.1,0,-7.5>,<.1,-.05,7.5>}			// Basic Track
				box {<-.05,-.02,-7.6>,<.05,-.06,7.6>}			// Groove
			}
			union {
				cylinder {<-.05,-.035,-7.5>,<-.05,-.035,7.5>,.01}	// Electrified Wires
				cylinder {<-.05,-.035,-7.5>,<-.05,-.035,7.5>,.01}	// Electrified Wires
				texture {T_Copper_4C}
			}
			object {LightShade	rotate y*1	translate <0,0,7.5>}
			object {LightShade	rotate y*-3	translate <0,0,2.5>}
			object {LightShade	rotate y*-1	translate <0,0,-2.5>}
			object {LightShade	rotate y*2	translate <0,0,-7.5>}
		}
		texture {WhiteEnamel}
	}
#end

#if (I_TV=True)
	#debug "Creating Television Monitor...\n"

	#declare TVMonitor=
	object {
		union {
			difference {
				superellipsoid {			// TV Monitor Case
					<.45,.15>			// Rounded Box
					scale <2,1.5,1>			// Scale to approx. <4,3,2>
				}
				superellipsoid {
					<.45,.95>			// Cut out screen on front
					scale <2,1.5,1>			// Scale to roughly same as above
					scale <.9,.9,.9>		// Then make it a touch smaller
					translate <0,0,-1.25>		// Move to front
				}
				texture {BlackPlastic}
			}
			intersection {
				box {<-1.9,-1.4,-.9>,<1.9,1.4,-.8>}	// Screen
				superellipsoid {
					<.45,.95>
					scale <2,1.5,1>
					scale <.9,.9,.9>
					translate <0,0,-1.25>
				}
				texture {pigment {color Black}}
			}
			box  {
				<-1.75,-1.3125,-.91>,<1.75,1.3125,-.85>	// Image on screen
				texture {
					pigment {
						image_map {
							gif "norwegia.gif"
						}
						scale <3.5,2.625,1>
						translate <-1.75,-1.3125,0>
					}
					finish {
						ambient .4
					}
				}
				scale <.85,.85,1>
			}
			#if (MonitorGlow=True)
				light_source {
					<0,0,-1>
					color Gray25
					area_light <3,0,0>,<0,3,0>,3,3
					adaptive 1
					jitter
					fade_distance 1.5
					fade_power .5
					atmosphere off
				}
			#end
		}
	}

	#declare TV=
	object {
		union {
			cylinder {
				<-2.55,0,0>,<2.55,0,0>,.2		// Axle for TV Monitor
				texture {T_Silver_4C}
			}
			cylinder {
				<-2.05,0,0>,<2.05,0,0>,.3		// Reinforcement around axle
				texture {BlackPlastic}
			}
			difference {
				superellipsoid {
					<.4,.05>			// Box rounded a lot one way, a little the other
					scale <2.5,1.9,.4>		// Scale to approx. <5,3.8,.8>
				}
				superellipsoid {
					<.4,.05>			// Hollow out above box, removing front & back too
					scale <2.5,1.9,.4>		// Scale to same as above
					scale <.9,.9,2>			// Then change it
				}
				box {
					<-2.6,-2,-.5>,<2.6,-.2,.5>	// Remove bottom half so only bracket is left
				}
				texture {BlackEnamel}
			}
			cylinder {
				<0,1.8,0>,<0,2.5,0>,.15			// Suspension pole
				texture {T_Silver_4C}
			}
			object {
				TVMonitor
				rotate x*-20
			}
		}
		translate <0,-2.5,0>					// Translate so origin is at top of suspension pole
	}
#end

#if (I_Camera=True)
	#debug "Making security camera...\n"

	#declare SecurityCam=
	object {
		union {
			union {
				box {<-.2,0,-.5>,<.2,.5,.5>}				// Body of Camera
				union {
					difference {
						cylinder {<0,0,-.49>,<0,0,-.7>,.15}	// Barrel
						cylinder {<0,0,-.51>,<0,0,-.7>,.125}
						texture {BlackPlastic}
					}
					sphere {					// Lens
						<0,0,0>,.126
						scale <1,1,.2>
						translate <0,0,-.65>
						texture {T_Glass4}
					}
					translate <0,.25,0>
				}
				translate <0,-.5,0>
				rotate x*-20
			}
			cylinder {<0,-.1,0>,<0,.5,0>,.05}				// Hanging Rod
			translate <0,-.5,0>						// Translate so top of rod at origin
		}
		texture {T_Chrome_4A}
	}
#end

#if (I_WhiteBoard=True)
	#declare WhiteBoard=
	union {
		object {
			difference {
				box {<.1,.1,-.01>,<15.1,3.75,.05>}				// Basic Shape
				box {<5.08,0,-.011>,<5.12,3.76,.04>}				// Seams every 5 feet
				box {<10.08,0,-.011>,<10.12,3.76,.04>}
			}
			pigment {color White}
			finish {
				ambient .4
				reflection .2
			}
		}
		object {
			box{<.1,3.8,-.01>,<15.1,4,.05>}						// Cork Strip
			texture {Cork}
		}
		object {
			union {									// Framing
				box{<0,0,0>,<15.2,4.2,.1>}
				difference {
					box{<0,0,0>,<15.2,.1,.35>}				// Pen Tray
					cylinder {<.1,.1,.051>,<15.1,.1,.051>,.05}
					cylinder {<.1,.1,.152>,<15.1,.1,.152>,.05}
					cylinder {<.1,.1,.253>,<15.1,.1,.253>,.05}
					translate <0,0,-.349>
				}
			}
			texture {T_Chrome_4C}
		}
		rotate y*180
		translate <7.5,3.5,.05>
	}
#end


// ---- ASSEMBLING ROOM OUT OF CREATED OBJECTS ----------------------------------------------------------------------

#debug "Creating room with suspended ceiling...\n"
difference {
	box {<-21,-1,-1>,<16,14,40.5>}			// Overall Box
	box {<-15,-.1,0>,<15,13.5,40>}			// Main Room
	box {<-20,-.1,.5>,<-14,12,4.5>}			// Alcove for Main Doorway
	box {<-20,-.1,28>,<-14,12,32>}			// Alcove For Other Doorway
	box {<-14.5,1,39>,<14.5,8,41>}			// Windows to Outside
	pigment {color LightBlue}
}
union {
	difference {					// Window Frame
		box {<-14.75,.75,39.95>,<14.75,8.25,41>}
		box {<-14.45,1.05,39.9>,<14.45,7.95,41.1>}
		box {<-5.25,1.05,39.9>,<-4.75,7.95,41.1>}
		box {<-.25,1.05,39.9>,<.25,7.95,41.1>}
		box {<4.75,1.05,39.9>,<5.25,7.95,41.1>}
	}
	difference {
		box {<-14.65,.85,39.85>,<14.65,8.15,40>}
		box {<-14.5,1,39.8>,<14.5,8,40.1>}
	}
	texture {T_Silver_4A}
}
box {
	<-15,.5,40.1>,<15,8.1,40.15>			// Window Glass
	texture {T_Glass4}
}
union {
	difference {
		box {<-15,8.5,39.25>,<15,9,40>}		// Valance Box
		box {<-14.9,8.4,39.35>,<14.9,8.95,40.1>}
		pigment {color LightBlue*.75}
	}
	union {
		#declare XCount=-14.75			// Vertical Blinds
		#declare SD=seed(1)
		#while (XCount<=14.75)
			box {
				<-.2,.6,-.01>,<.2,8.8,.01>
				rotate y*((rand(SD)*8)-4)
				translate <XCount,0,39.75>
			}
			#declare XCount=XCount+.5
		#end
		pigment {color SummerSky}
		normal {
			bumps .4
			scale <.05,.05,.05>
		}
	}
}
union {
	box {<-15.5,0,39.5>,<15.5,.25,40>}		// Electric Radiator
	#declare bflc=<-15.5,.25,39.5>
	#declare bbrc=<15.5,.25,40>
	#declare tflc=<-15.5,.45,39.75>
	#declare tbrc=<15.5,.45,40>
	#include "pyr_cube.inc"
	box {<-10.5,.5,39.6>,<10.5,.525,40>}
	pigment {color Wheat}
	finish {
		reflection .1
		phong .3
	}
}
box {
	<-16,-.2,-1>,<11,0,40.5>			// Carpeting
	pigment {color Gray65}
	normal {
		bumps	.5
		scale <.05,.2,.05>
	}
}
object {SuspendedCeiling}				// Suspended Ceiling
#if (I_TrackLights=True)				// Track Lights
	#debug "Placing Track Lights...\n"
		object {
		TrackLights
		translate <10,11,22.5>
	}
#end
#if (I_TV=True)						// TV Monitor
	#debug "Suspending TV from ceiling...\n"
		object {
		TV
		translate <0,11,38>
	}
#end
#if (I_Warnings=True)					// Warning Posters
	#debug "Hanging Warning Posters...\n"
		object {
		WarnPoster
		rotate y*90
		translate <15,5,35>
	}
	object {
		WarnPoster
		rotate y*90
		translate <15,5,10>
	}
	object {
		WarnPoster
		rotate y*-90
		translate <-15,5,24>
	}
#end
#if (I_Posters=True)					// Artwork
	#debug "Hanging Framed Posters...\n"
	object {
		Poster2
		pigment {
			image_map {
				tga "drill.tga"
			}
			scale <3,2,1>
			translate <-1.5,-1,0>
		}
		finish {ambient .2}
		rotate y*90
		translate <15,6,15>
	}
	object {
		Poster1
		pigment {
			image_map {
				tga "tree.tga"
			}
			scale <2,3,1>
			translate <-1,-1.5,0>
		}
		finish {ambient .2}
		rotate y*90
		translate <15,6.5,20>
	}
	object {
		Poster2
		pigment {
			image_map {
				tga "bait.tga"
			}
			scale <3,2,1>
			translate <-1.5,-1,0>
		}
		finish {ambient .2}
		rotate y*90
		translate <15,6,25>
	}
	object {
		Poster1
		pigment {
			image_map {
				tga "xmas.tga"
			}
			scale <2,3,1>
			translate <-1,-1.5,0>
		}
		finish {ambient .2}
		rotate y*90
		translate <15,6.5,30>
	}
#end
#if (I_Camera=True)
	#debug "Placing Security Cameras...\n"
	object {
		SecurityCam
		rotate y*40
		translate <13,11,38>
	}
	object {
		SecurityCam
		rotate y*-60
		translate <-14,11,27>
	}
#end
#if (I_WhiteBoard=True)
	#debug "Hanging Whiteboard on Wall...\n"
	object {WhiteBoard}
#end
