// Persistence of Vision Ray Tracer Scene Description File
// File: STUFF.pov
// Vers: 3.01 Watcom Win32
// Desc: Miscellaneous items the students have at their desks
// Date: March 17, 1997
// Auth: Sonya Roberts
// Note:

#if (I_Popcans=True)
	#debug "     Producing popcans...\n"

	#declare Popcan1=
	object {
		union {
			difference {
				cylinder {<0,.025,0>,<0,.6,0>,.125}		// Basic can
				torus {.1,.025}					// Rounded Base
				torus {						// Scooped Top
					.125,.0125
					scale <1,2,1>
					translate <0,.6,0>
				}
				cylinder {<0,.575,0>,<0,.61,0>,.09}		// Lower Inside Top
				cylinder {<0,.4,0>,<0,.565,0>,.12}		// Hollow out can
				sphere {<0,.575,-.07>,.02}			// Cut hole to inside
				texture {T_Silver_5B}
			}
			difference {
				cylinder {<0,.03,0>,<0,.55,0>,.1251}		// Popcan Label
				cylinder {<0,.02,0>,<0,.56,0>,.125}		// Hollow it out
				pigment {
					image_map {
						gif "popcan.gif"
						map_type 2
					}
					scale <1,.52,1>
					translate <0,.03,0>
				}
				finish {
					ambient .35
				}
			}
		}
		scale <1,.8,1>
	}

	#declare Popcan2=
	object {
		union {
			difference {
				cylinder {<0,.025,0>,<0,.6,0>,.125}		// Basic can
				torus {.1,.025}					// Rounded Base
				torus {						// Scooped Top
					.125,.0125
					scale <1,2,1>
					translate <0,.6,0>
				}
				cylinder {<0,.575,0>,<0,.61,0>,.09}		// Lower Inside Top
				cylinder {<0,.4,0>,<0,.565,0>,.12}		// Hollow out can
				sphere {<0,.575,-.07>,.02}			// Cut hole to inside
				texture {T_Silver_5B}
			}
			difference {
				cylinder {<0,.03,0>,<0,.55,0>,.1251}		// Popcan Label
				cylinder {<0,.02,0>,<0,.56,0>,.125}		// Hollow it out
				pigment {
					image_map {
						gif "popcan2.gif"
						map_type 2
					}
					scale <1,.52,1>
					translate <0,.03,0>
				}
				finish {
					ambient .35
				}
			}
		}
		scale <1,.8,1>
	}
#end

#if (I_Cookies=True)
	#debug "     Making some cookies...\n"

	#declare Cookie1=
	object {
		union {
			difference {
				superellipsoid {
					<.95,.25>				// Cylinder with rounded edges
					rotate x*90				// Stand upright
					scale <.075,.03,.075>			// Scale to approx. <.15,.06,.15>
				}
				cylinder {<0,-.015,0>,<0,.015,0>,.1}		// Cut slice from middle
				pigment {color DarkBrown}
			}
			cylinder {
				<0,-.016,0>,<0,.016,0>,.07			// Put in filling
				pigment {color White}
				finish {ambient .35}
			}
			translate <0,.03,0>					// Move so origin is on bottom
		}
	}

	#declare Cookie2=
	object {
		intersection {
				superellipsoid {
					<.95,.25>				// Cylinder with rounded edges
					rotate x*90				// Stand upright
					scale <.075,.03,.075>			// Scale to approx. <.15,.06,.15>
				}
				cylinder {<0,0,0>,<0,.04,0>,.1}			// Take top half of shape
				texture {ChocChipCookie}
		}
	}

	#declare Plate=
	object {
		lathe {
			cubic_spline
			9,
			<-.1,0>
			<0,0>
			<.5,0>
			<.5,.015>
			<.75,.1>
			<.725,.1>
			<.5,.025>
			<0,.025>
			<-.1,.025>
		}
		scale <.75,.75,.75>
		pigment {
			image_map {
				gif "plate.gif"
			}
			rotate x*90
			translate <-.5,0,-.5>
		}
		finish {
			ambient .25
		}
	}

	#declare Cookies=
	union {
		object {Plate}
		object {Cookie1	translate <-.1,.025,.2>}
		object {Cookie1 translate <-.15,.025,0>}
		object {Cookie1	translate <.1,.025,.1>}
		object {Cookie1	translate <-.125,.085,.1>}
	}

	#declare CookieStack=
	union {
		object {
			box {<-.15,0,-.25>,<.15,.02,.25>}				// Napkin
			rotate y*-5
			pigment {color White}
			normal {
				wrinkles .3
				scale <.1,.1,.1>
			}
			finish {ambient .2}
		}
		object {Cookie2	translate <0,0,0>}					// Choc. Chip Cookies
		object {Cookie2	translate <.025,.03,-.03>}
		object {Cookie2	translate <.05,.06,.01>}
		object {Cookie2	translate <0,.09,.05>}
		object {Cookie2	translate <-.025,.12,0>}
	}
#end

#if (I_Pizza=True)
	#debug "     Throwing together a pizza\n"

	#declare BoxSide=
	object {
		box {<0,0,0>,<1,.2,-.001>}						// Printing on side of carton
		pigment {
			image_map {
				gif "pizza1.gif"
			}
			scale <1,.2,1>
		}
		finish {ambient .2}
	}

	#declare PizzaBox1=
	object {
		union {
			difference {
				box {<0,0,0>,<1,.2,1>}					// Basic Carton
				box {<.05,0.025,0.05>,<.95,.3,.975>}
			}
			union {
				box {<.05,-.025,-.975>,<.95,0,0>}			// Lid
				box {<.05,-.175,-.975>,<.95,0,-.95>}
				rotate x*85
				translate <0,.2,1>
			}
			object {BoxSide}						// Printing on Sides
			object {BoxSide	rotate y*90	translate <0,0,1>}
			object {BoxSide	rotate y*180	translate <1,0,1>}
			object {BoxSide	rotate y*-90	translate <1,0,0>}
			object {
				box {<0,0,0>,<1,1,-.01>}				// Printing on Lid
				pigment {
					image_map {
						gif "pizza2.gif"
					}
				}
				finish {ambient .2}
				rotate x*85
				translate <0,0,-1>
				rotate x*100
				translate <0,.2,1>
			}
			pigment {color NewTan}
		}
	}

	#declare PizzaBox2=
	object {
		union {
			difference {
				box {<0,0,0>,<1,.2,1>}					// Basic Carton
				box {<.05,0.025,0.05>,<.95,.3,.975>}
			}
			union {
				box {<.05,-.025,-.975>,<.95,0,0>}			// Lid
				box {<.05,-.175,-.975>,<.95,0,-.95>}
				rotate x*30
				translate <0,.2,1>
			}
			object {BoxSide}						// Printing on Sides
			object {BoxSide	rotate y*90	translate <0,0,1>}
			object {BoxSide	rotate y*180	translate <1,0,1>}
			object {BoxSide	rotate y*-90	translate <1,0,0>}
			object {
				box {<0,0,0>,<1,1,-.01>}				// Printing on Lid
				pigment {
					image_map {
						gif "pizza2.gif"
					}
				}
				rotate x*90
				translate <0,0,-1>
				rotate x*30
				translate <0,.2,1>
			}
			pigment {color NewTan}
		}
	}

	#declare PizzaBox3=
	object {
		union {
			difference {
				box {<0,0,0>,<1,.2,1>}					// Basic Carton
				box {<.05,0.025,0.05>,<.95,.3,.975>}
			}
			union {
				box {<.05,-.025,-.975>,<.95,0,0>}			// Lid
				box {<.05,-.175,-.975>,<.95,0,-.95>}
				translate <0,.2,1>
			}
			object {BoxSide}						// Printing on Sides
			object {BoxSide	rotate y*90	translate <0,0,1>}
			object {BoxSide	rotate y*180	translate <1,0,1>}
			object {BoxSide	rotate y*-90	translate <1,0,0>}
			object {
				box {<0,0,0>,<1,1,-.01>}				// Printing on Lid
				pigment {
					image_map {
						gif "pizza2.gif"
					}
				}
				rotate x*90
				translate <0,0,-1>
				translate <0,.2,1>
			}
			pigment {color NewTan}
		}
		translate <-.5,0,-.5>
	}

	#declare StackBoxes=
	union {
		#declare LoopY=1
		#declare SDP=seed(97)
		#while (LoopY<=11)
			object {
				PizzaBox3
				rotate y*(rand(SDP)*360)
				translate <(rand(SDP)*.2)-.1,(LoopY-1)*.2,(rand(SDP)*.2)-.1>
			}
			#declare LoopY=LoopY+1
		#end
	}
#end

#if (I_Candles=True)
	#debug "     Creating some *darling* candles...\n"

	#declare Taper=
	object {
		union {
			difference {
				union {
					cylinder {<0,0,0>,<0,.5,0>,.05}				// Candle
					sphere {
						<0,0,0>,.05
						scale <1,10,1>
						translate <0,.5,0>
					}
				}
				box {<-.1,.85,-.1>,<.1,1.1,.1>}
				sphere {<0,.75,0>,.03}
				texture {Beeswax}
			}
			sphere {								// Flame
				<0,0,0>, 1
				pigment {color rgbt <1,1,1,1>}
				hollow
				halo {
					emitting
					spherical_mapping
					linear
					turbulence .5
					color_map {
						[ 0.0 color rgbt <1,0,0,1>]
						[ 0.5 color rgbt <1,1,0,-1>]
						[ 1.0 color rgbt <1,0,0,1>]
					}
					frequency 2
					omega 3
					samples 20
					scale <.35,.75,.35>
				}
				translate <0,1,0>
			}
			#if (UseLights=True)
				light_source {
					<0,1,0>,
					color Goldenrod*.5
					fade_distance .25
					fade_power 2
				}
			#end
		}
	}

	#declare Candle=
	object {
		union {
			superellipsoid {					// Candle Holder
				<.55,.5>					// Rounded cube/cylinder
				rotate x*90					// Stand upright
				scale <.1,.075,.1>				// Scale to approx. <.2,.15,.2>
				translate <0,.04,0>
				texture {T_Gold_5D}
			}
			object {Taper}
		}
	}
#end

#debug "Putting out stuff...\n"
#declare Stuff=
union {
	#if (I_Popcans=True)
		#debug "     - Placing popcans\n"
		object {Popcan1			translate <-6.75,2.55,7.5>}
		object {Popcan2	rotate y*95	translate <-6.6,2.55,8>}
		object {Popcan1	rotate y*170	translate <-6,4.55,17.75>}
		object {Popcan2 rotate y*284	translate <4.25,4.55,8.25>}
	#end

	#if (I_Cookies=True)
		#debug "     - Placing cookies\n"
		object {Cookies		rotate y*50	translate <-9.6,2.6,9>}
		object {CookieStack	translate <-.5,2.56,8>}
	#end

	#if (I_Pizza=True)
		#debug "     - Mmmmmm...pizza!\n"
		object {PizzaBox1	translate <-.45,2.55,8.5>}
		object {PizzaBox2	rotate y*-37	translate <3.25,1.85,5.5>}
		object {StackBoxes	translate <0,0,7>}
	#end

	#if (I_Candles=True)
		#debug "     - Heretic by Candlelight\n"

		object {Candle				translate <8.75,2.56,7.5>}
		object {Candle		rotate y*120	translate <6.75,2.56,7.5>}
	#end
}
