
////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// zeltar-7.pov
//
// Created by Paul T. Dawson <ptdawson@voicenet.com>
//
// March 1, 1997 to April 30, 1997
//
// No copyright - have fun with it!
//
////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// WARNING #1 --- This file might *NOT* work in POV-Ray for MS-DOS,
//            --- it causes some strange memory errors.
//            ---
//            --- It does work in POV-Ray for Windows!
//
// WARNING #2 --- This code is really sloppy! 8-)
//
// WARNING #3 --- Run "hf-1.pov" first, to make a 320x200 TGA file.
//
////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// Scene switches.


        #declare fake = 2
        
        #declare Show_Creatures = on
        #declare Show_Fence     = on
        #declare Show_Floor     = on
        #declare Show_Mountains = on
        #declare Show_School    = on
        #declare Show_Sign      = on
        #declare Show_Sky       = on
        #declare Show_Tracks    = on

        // Note: The "fake" variable is used to substitute a simple
        //       shape for the actual final object. For example, the
        //       spirals on the fence (with 12,000 triangles each) are
        //       replaced with a single cone. This speeds up testing!
        //
        //       In this scene, "fake" works for Show_Creatures,
        //       Show_Fence, Show_Mountains, and Show_Tracks.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// All the usual stuff.


        #include "colors.inc"
        #include "textures.inc"
        #include "golds.inc"
        #include "skies.inc"
        #include "stars.inc"

        #default { finish { Shiny } }

        #declare R = seed(0)

        light_source{< 10, 15, -10 > color rgb 1 }
        light_source{< -100, 100 , 0 > color rgb 1 }
        
        background { White }


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// Set up the camera.


        // Wide view.
        //camera{location<50 ,100 ,-120 > look_at <50, 30 ,50> }
        
        // Final.
        camera{location<10 ,15 ,-10 > look_at <50, 0 ,50> }


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The strange creatures.


#if ( Show_Creatures = fake )

        #declare Creature = union {
                cylinder{<0,-1,0><0,2,0>,1 pigment{Gray70}}
                cone{<0,2,0>,0.75<0,5,0>,1.5 pigment{Gray40}}
                cone{<0,5,0>,1.5<0,6,0>,1.0 pigment{Gray10}}
                } // End of union.

#end // End of if block.


#if ( Show_Creatures = on )

        #declare Half_Cone_1 = difference {

                union {
                cone { <0,0,0>,1.5 <0,0,-0.5>,1 }
                cylinder{<0,0,0><0,0,0.5>,1.5 }
                } // End of union.

                cone { <0,0,-0.501>,1 <0,0,-0.25>,0.8 }

                box { < -2, -2, 0.6 > < 2, 0, -0.6 > }

                } // End of difference.

        #declare Half_Cone_2 = difference {

                union {
                cone { <0,0,0>,1.1 <0,0,-0.5>,0.75 }
                cylinder{<0,0,0><0,0,0.5>,1.1}
                } // End of union.

                cone { <0,0,-0.501>,0.75 <0,0,-0.25>,0.6 }

                box { < -2, 2, 0.6 > < 2, 0, -0.6 > }
                
                } // End of difference.

        // Twelve points for connecting triangles.
                #declare VEC_1 = < -1.5, 4.5, 0 >
                #declare VEC_2 = < -1.0, 4.5, -0.5  >
                #declare VEC_3 = < -0.8, 4.5, -0.25 >
                #declare VEC_4 = <  0.8, 4.5, -0.25 >
                #declare VEC_5 = <  1.0, 4.5, -0.5  >
                #declare VEC_6 = <  1.5, 4.5, 0 >

                #declare VEC_7  = < -1.1, 2.75, 0 >
                #declare VEC_8  = < -0.75, 2.75, -0.5 >
                #declare VEC_9  = < -0.6, 2.75, -0.25 >
                #declare VEC_10 = <  0.6, 2.75, -0.25 >
                #declare VEC_11 = <  0.75, 2.75, -0.5 >
                #declare VEC_12 = <  1.1, 2.75, 0 >

                #declare VEC_B1 = < -1.5, 4.5, 0.5 >
                #declare VEC_B2 = < 1.5, 4.5, 0.5 >
                #declare VEC_B3 = < -1.1, 2.75, 0.5 >
                #declare VEC_B4 = < 1.1, 2.75, 0.5 >

        #declare One_Arm = union {
                
                #declare TEMP = 0 #while ( TEMP <=5 )

                        sphere { 0,0.1 pigment { Gray30 }
                        translate < TEMP*0.2, (sin(TEMP)/2),0 > }

                #declare TEMP = TEMP + 0.1 #end
                        
                // The hand.
                sphere { 0,0.2 pigment{Gray10}
                translate < TEMP*0.2, (sin(TEMP)/2),0 > }

                } // End of union.

        #declare Base = union {
        
                // Main body.
                cylinder { <0,0,0><0,2,0>, 0.75 pigment{Gray50} }
                
                // Lid.
                cylinder { <0,1.8,0><0,2,0>, 0.8 pigment{Gray30} }

                // Neck.
                cone { <0,2,0>,0.4 <0,3,0>,0.1 pigment {Gray10} }

                // Vertical ribs.
                #declare TEMP = 0 #while ( TEMP < 360 )
                        sphere{0,0.75 scale <0.1,1,0.1> translate <0.75,1,0>
                        rotate y*TEMP pigment{Gray20} }
                #declare TEMP = TEMP + 36 #end
                
                // Wheels.
                #declare TEMP = 0 #while ( TEMP < 360 )
                        
                        union {
                                sphere{0,0.2 pigment{Black} }
                                
                                cylinder { <0,0,0> <-0.3,0.8,0>, 0.1
                                pigment{Gray30}}
                                
                                translate <0.55,-0.8,0>
                                rotate y*TEMP
                                
                                } // End of union.

                #declare TEMP = TEMP + (360/5) #end
                
                } // End of union.

        #declare One_Eye = union {
                
                sphere { 0, 0.4
                scale < 1, 0.6, 0.4 > pigment{White}}
                
                sphere { 0,0.15 translate <0,0,-0.1> pigment{OrangeRed}}

                } // End of union.
        
        #declare The_Nose = difference {
                
                sphere { 0,0.8 scale <0.3,1,0.3 >}
                box{<-1,-0.2,-1><1,-1,1>}

                } // End of difference.

        #declare The_Mouth = union {
        
                difference {
                        sphere { 0,1 scale < 1, 0.7, 0.5 > }
                        box { <-2,-0.2,-2><2,0.2,2> }
                        } // End of difference.
                
                cylinder { <0,-0.2,0><0,0.2,0>,0.7
                        scale < 1, 1, 0.5 >
                        pigment{checker White,Gray70 scale < 0.1, 11, 11> } }
                
                } // End of union.

        // Put it all together.
        
        #declare Creature = union {
        
        object{Half_Cone_1 translate y*4.5  }
        
        object{Half_Cone_2 translate y*2.75  }

        object { One_Eye translate < -0.5, 4.5, -0.25 > }
        object { One_Eye translate <  0.5, 4.5, -0.25 > }

        object { Base translate y *-0.5 }

        object { One_Arm rotate x*50 translate < 0.75, 1.6, 0 >
                translate y *-0.5 }
        object { One_Arm rotate y*180 rotate x*50
                translate < -0.75, 1.6, 0 > translate y *-0.5 }

        object { The_Nose translate <0,3.8,-0.25> }

        object { The_Mouth translate < 0, 2.8, -0.1 > }

        // Back side fan shaped boxes.
        #declare TEMP = -15 #while ( TEMP <= 15 )

                union { box { < -0.02, 1, 0.5 > < 0.02, 4, 0.7 > }
                        cylinder { <-0.02,4,0.5><0.02,4,0.5>,0.2 }
                        rotate z * TEMP
                        translate < 0, 1.1, 0 >
                        pigment { Gray50 }
                        } // End of union.

        #declare TEMP = TEMP + 5 #end

        // Connect the two differenced cone halves.
        triangle { VEC_1, VEC_2, VEC_7 }
        triangle { VEC_2, VEC_7, VEC_8 }
        triangle { VEC_2, VEC_3, VEC_8 }
        triangle { VEC_3, VEC_8, VEC_9 }
        triangle { VEC_3, VEC_4, VEC_9 }
        triangle { VEC_4, VEC_9, VEC_10 }
        triangle { VEC_4, VEC_5, VEC_10 }
        triangle { VEC_5, VEC_10, VEC_11 }
        triangle { VEC_5, VEC_6, VEC_11 }
        triangle { VEC_6, VEC_11, VEC_12 }

        // Connect the two cylinders.
        triangle { VEC_1,  VEC_B1, VEC_7  }
        triangle { VEC_B1, VEC_B3, VEC_7  }
        triangle { VEC_6,  VEC_B2, VEC_12 }
        triangle { VEC_B2, VEC_B4, VEC_12 }

        // Fill in back opening.
        triangle { VEC_B1, VEC_B2, VEC_B3 }
        triangle { VEC_B2, VEC_B3, VEC_B4  }

        pigment { Gray70 }
        normal { crackle 0.3 scale 0.1 }

        translate y * 0.5 

        } // End of union.

#end // End of if block.


#ifdef ( Creature )

        // Left side - facing camera.
        object{Creature translate<21, 2, 54 >}
        object{Creature translate<21, 2, 34 >}
        object{Creature translate<21, 2, 12+3 >}
        
        // Left side - facing away from camera.
        object{Creature rotate y*180 translate<25, 2, 3 >}

        // Left to right road - facing negative x.
        object{Creature rotate y*90 translate<41, 2, 21 >}
        object{Creature rotate y*90 translate<66, 2, 21 >}
        
        // Left to right road - facing positive x.
        object{Creature rotate y*-90 translate<13, 2, 17 >}
        object{Creature rotate y*-90 translate<49, 2, 17 >}
        
        // Driving out of school.
        object{Creature translate<52, 2, 26 >}

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The fence around the school.


#if ( Show_Fence = on )


// Make the spiral things.

        #declare COUNT = 0
        
        #declare Half_Spiral_Thing = mesh {

                #declare A = 0 #while ( A <= 10 )

                        #declare YROT = A * 360
                        #declare X1 = 1.01 - ( A/10 )
                        
                        // First triangle.
                        #declare V1=vrotate ( <X1,A,0>,<0,YROT,0> )
                        #declare V2=vrotate ( <X1+0.1,A+0.1,0>,<0,YROT,0> )
                        #declare V3=vrotate ( <X1+0.2,A,0>,<0,YROT,0> )
                        triangle{ V1,V2,V3 }
                        #declare COUNT=COUNT+1
                        
                        // Second triangle.
                        #declare V1=vrotate ( <X1,A,0>,<0,YROT,0> )
                        #declare V2=vrotate ( <X1+0.1,A+0.1,0>,<0,YROT,0> )
                        #declare V3=vrotate ( <X1+0.1,A,0.1>,<0,YROT,0> )
                        triangle{ V1,V2,V3 }
                        #declare COUNT=COUNT+1
                        
                        // Third triangle.
                        #declare V1=vrotate ( <X1+0.2,A,0>,<0,YROT,0> )
                        #declare V2=vrotate ( <X1+0.1,A+0.1,0>,<0,YROT,0> )
                        #declare V3=vrotate ( <X1+0.1,A,0.1>,<0,YROT,0> )
                        triangle{ V1,V2,V3 }
                        #declare COUNT=COUNT+1

                #declare A = A + 0.005 #end

                pigment { color rgb < 0.4, 0, 0 > }
                finish { F_MetalA }
                
        } // End of mesh.

        #declare Spiral_Thing = union {

                object { Half_Spiral_Thing }
                object { Half_Spiral_Thing rotate y*180 }

                scale < 0.4, 0.6, 0.4 >

                } // End of union.

        #declare COUNT = COUNT * 2
        #debug "There are "
        #debug str ( COUNT, 0, 0 )
        #debug " triangles in one spiral thing!\n"
        
        #declare Fence_Section = union {
        box { <-0.5,-10,-0.5><0.5,1,0.5>
                pigment { color rgb < 1.0, 0.8, 0.8 > }
                normal { crackle 0.1 scale < 0.1, 0.1, 100 > } }
        object { Spiral_Thing translate < 0, 0.75, 0 > }
        } // End of union.

#end // End of if block.

#if ( Show_Fence = fake )
        
        #declare Fence_Section = union {
        box { <-0.5,-10,-0.5><0.5,1,0.5>
                pigment { color rgb < 1.0, 0.8, 0.8 > } }
        cone { <0,1,0>,0.5 <0,6,0>,0 pigment { Yellow } }
        } // End of union.

#end // End of if block.


#ifdef ( Fence_Section )

        #declare COUNT2 = 0
        
        #declare X=20 #while (X<=40)
                object{Fence_Section rotate y*(int(rand(R)*4)*90)
                        translate <X+10,0,20+10>}
                object{Fence_Section rotate y*(int(rand(R)*4)*90)
                        translate <X+10,0,60+10>}
                #declare COUNT2 = COUNT2 + 2
        #declare X=X+1 #end

        #declare X=50 #while (X<=70)
                object{Fence_Section rotate y*(int(rand(R)*4)*90)
                        translate <X+10,0,20+10>}
                object{Fence_Section rotate y*(int(rand(R)*4)*90)
                        translate <X+10,0,60+10>}
                #declare COUNT2 = COUNT2 + 2
        #declare X=X+1 #end

        #declare Z = 21 #while(Z<=59)
                object{Fence_Section rotate y*(int(rand(R)*4)*90)
                        translate <20+10,0,Z+10>}
                object{Fence_Section rotate y*(int(rand(R)*4)*90)
                        translate <70+10,0,Z+10>}
                #declare COUNT2 = COUNT2 + 2
        #declare Z=Z+1 #end

        #if ( Show_Fence = on )
                #declare GRANDTOTAL = COUNT * COUNT2
                #debug "Grand total of fence triangles is "
                #debug str ( GRANDTOTAL, 0, 0 )
                #debug ".\n"
        #end // End of if block.

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The floor (?), created by "HF-1.POV" (320x200 TGA).


#if ( Show_Floor = on )

        height_field { tga "hf-1.tga"

                scale < 100, 9, 100 >
                pigment { color rgb < 0.6, 0.1, 0.1 > }
                normal { crackle 0.5 scale 0.1 }
                smooth
                translate y * -10

                } // End of height_field.

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// Mountains in background.


#if ( Show_Mountains = fake )

        box{<-100,-1,110><150,25,111>pigment{Brown}}
        box{< 110,-1,-10><111,25,150>pigment{Brown}}

#end // End of if block.

#if ( Show_Mountains = on )

        #declare Far_Away = height_field { gif "hf-2.gif"
                scale < 100, 24, 100 >
                pigment { color rgb < 0.6, 0.1, 0.1 > }
                normal { crackle 0.5 scale 0.1 }
                smooth
                translate y * -10
                } // End of height_field.

        #declare Far_Away2 = object { Far_Away
                rotate y * 180 translate < 100, 0, 100 > }
        
        // First row - behind camera.
        object { Far_Away  scale <1,3,1> translate < -100, 0, -100 > }
        object { Far_Away2 scale <1,3,1> translate <    0, 0, -100 > }
        object { Far_Away  scale <1,3,1> translate <  100, 0, -100 > }
        object { Far_Away2 scale <1,3,1> translate <  200, 0, -100 > }
        object { Far_Away  scale <1,3,1> translate <  300, 0, -100 > }

        // Second row - aligned with floor piece.
        object { Far_Away2 scale <1,3,1> translate < -100, 0,   0 > }
        object { Far_Away                translate <  100, 0,   0 > }
        object { Far_Away  scale <1,3,1> translate <  200, 0,   0 > }

        // Third row - behind floor.
        object { Far_Away2 scale <1,3,1> translate < -100, 0, 100 > }
        object { Far_Away                translate <    0, 0, 100 > }
        object { Far_Away2               translate <  100, 0, 100 > }
        object { Far_Away  scale <1,3,1> translate <  200, 0, 100 > }
        object { Far_Away2 scale <1,3,1> translate <  300, 0, 100 > }

        // Fourth row.
        object { Far_Away  scale <1,3,1> translate < -100, 0, 200 > }
        object { Far_Away2 scale <1,3,1> translate <    0, 0, 200 > }
        object { Far_Away  scale <1,3,1> translate <  100, 0, 200 > }
        object { Far_Away2 scale <1,3,1> translate <  200, 0, 200 > }
        object { Far_Away  scale <1,3,1> translate <  300, 0, 200 > }

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The school.


#if ( Show_School = on )

        // Make the "brick".

        #declare Goofy_Brick = height_field { gif "hf-3.gif"
                scale < 2, 0.3, 2 >
                texture { T_Gold_1A }
                normal { crackle 0.1 scale < 0.2, 10, 0.2 > }
                smooth
                rotate x * -90
                } // End of height_field.

        #declare Big_Brick = union {
                object { Goofy_Brick translate <2,0,0>}
                object { Goofy_Brick rotate z * 90 translate <2,0,0>}
                object { Goofy_Brick translate <0,2,0> }
                object { Goofy_Brick rotate z*90 translate <4,2,0>}
                } // End of union.

        // Front of school.
        #declare Y = -12 #while ( Y <= 16 )
        #declare X = 40 #while ( X <= 68 )

                object { Big_Brick translate < X, Y, 40 > }
        
        #declare X = X + 4 #end
        #declare Y = Y + 4 #end

        // Side of school.
        #declare Y = -12 #while ( Y <= 16 )
        #declare Z = 40 #while ( Z <= 56 )

                object { Big_Brick
                        translate x * -4
                        rotate y * 90
                        translate < 40, Y, Z > }
        
        #declare Z = Z + 4 #end
        #declare Y = Y + 4 #end

        // Roof panels.
        mesh {
                #declare ZZZ = 0 #while (ZZZ<=20)
                triangle{<0,20,ZZZ><32,20,ZZZ><16,30,ZZZ>}
                #declare ZZZ=ZZZ+0.25 #end

                translate < 40, 0, 40 >

                texture { T_Gold_1A }

                normal { crackle 0.1 scale < 0.2, 10, 0.2 > }

                } // End of mesh.

        // Use some "trees" for antennas on the roof.
        // The section uses the "ptd_tree.inc" nested loop trees!

        #declare TREE_RAND = seed(0)
        #declare Wiggle_Flag = off
        #declare Branches_On_End_Flag = on
        #declare Number_Of_Large_Branches = 7
        #declare Number_Of_Medium_Branches = 2
        #declare Number_Of_Small_Branches = 2
        #declare Large_Branch_Minimum_Angle = 90
        #declare Large_Branch_Maximum_Angle = 90
        #declare Medium_Branch_Minimum_Angle = 80
        #declare Medium_Branch_Maximum_Angle = 80
        #declare Small_Branch_Minimum_Angle = 90
        #declare Small_Branch_Maximum_Angle = 90
        #declare Tree_Trunk_Size = 14
        #declare Large_Branch_Size_Min = 2.5
        #declare Large_Branch_Size_Max = 2.5
        #declare Medium_Branch_Size_Min = 5
        #declare Medium_Branch_Size_Max = 5
        #declare Small_Branch_Size_Min = 0.5
        #declare Small_Branch_Size_Max = 0.5

        // Use a negative number for the leaf style,
        // then define a custom leaf type.
        #declare Leaf_Type = -1
        #declare TEMP_TEX = texture {
                checker texture{T_Gold_1A}, texture{T_Gold_5E} }
        #declare One_Leaf = union {
                torus { 1, 0.15 texture { TEMP_TEX scale 10 } }
                cylinder { < -1, 0,  0 > < 1, 0, 0 >, 0.05
                        pigment { Gray30 } }
                cylinder { <  0, 0, -1 > < 0, 0, 1 >, 0.05
                        pigment { Gray30 } }
                } // End of union.

        #declare TREE_MESH_SIZE = 300
        #declare Leaf_Texture = texture { pigment { White } }
        #declare Bark_Texture = texture { T_Gold_5E }
        #include "ptd_tree.inc"

        // Left side antennas.
        object { Complete_Tree scale 0.5 translate < 41, 19, 41 > }
        object { Complete_Tree scale 0.5 translate < 41, 19, 50 > }
        object { Complete_Tree scale 0.5 translate < 41, 19, 59 > }
        
        // Right side antennas.
        object { Complete_Tree scale 0.5 translate < 71, 19, 41 > }
        object { Complete_Tree scale 0.5 translate < 71, 19, 50 > }
        object { Complete_Tree scale 0.5 translate < 71, 19, 59 > }

        // Front door.
        box { < 49,-3,39.00><63,11,41> pigment { Gray20}
        normal { crackle 0.2 scale 0.1 } finish { F_MetalA}}

        box { < 50,-2,38.99><55.9,10,39>
                pigment { White } finish { Mirror reflection 0.6 } }
        box { < 56.1,-2,38.99><62,10,39>
                pigment { White } finish { Mirror reflection 0.6 } }

        // Sign over front door.

                box { < 47, 12, 39.5><65,16,41>
                        normal { crackle 0.2 scale 0.1 }
                        pigment { Gray20 }
                        finish { F_MetalA }
                        } // End of box.

                height_field { gif "sign-2.gif"
                        scale < 16, 0.5, 3 >
                        rotate x * -90
                        pigment {image_map { gif "sign-2.gif"
                                interpolate 2 once } scale <16,3,1>}
                        smooth
                        translate < 48, 12.5, 39.5 >
                        } // End of height_field.

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The sign.

#if ( Show_Sign = on )

        #declare The_Sign = union {
        
        // The words.
        box{ <0,0,0><1,1,0.1>
                pigment{image_map { gif "sign-1.gif"
                        interpolate 2 once } }
                scale < 8, 3, 1 >
                } // End of box.

        // Outer frame.
        difference {
                box { < -0.1, -0.1, -0.1 > < 8.1, 3.1, 1.0 > }
                box { <  0,    0,   -0.2 > < 8.0, 3.0, 0.2 > }
                pigment { Gray30 }
                finish { F_MetalA }
                } // End of difference.

        // Posts.
        #declare TEMP = 1 #while ( TEMP <= 7 )

                cylinder { < TEMP, -0.1, 0.5 > < TEMP, -20, 0.5 >, 0.2
                        pigment { Red }
                        finish { F_MetalE } }

                #declare TEMP2 = -0.5 #while ( TEMP2 > -20 )

                        torus { 0.4, 0.03
                                texture { T_Gold_5E }
                                translate < TEMP, TEMP2, 0.5 > }

                #declare TEMP2 = TEMP2 - 0.25 #end

        #declare TEMP = TEMP + 2 #end

        } // End of union.

        object { The_Sign scale 1.4 translate < 32-2, 2, 26 > }

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The sky.


#if ( Show_Sky = on )

        sphere{ < 0, -4000, 0 >, 5000
                texture { Starfield2 }
                finish { Luminous }
                hollow }

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// The tracks that the creatures travel on.


#if ( Show_Tracks = fake )

        #declare Track_1 = union {
                box{<0,0.5,0><2,1,2> pigment{Maroon}}
                cylinder{<1,-10,1><1,0.5,1>,0.1 texture{T_Gold_1A}} }
        
        #declare Track_2 = union {
                box{<0,0.5,0><2,1,2> pigment{Gray30}}
                cylinder{<1,-10,1><1,0.5,1>,0.1 texture{T_Gold_1A}} }

        #declare Track_3 = union {
                box{<0,0.5,0><2,1,2> pigment{Cyan}}
                cylinder{<1,-10,1><1,0.5,1>,0.1 texture{T_Gold_1A}} }

#end // End of if block.


#if ( Show_Tracks = on )

        #declare TEMP_TEX_1 = texture {
                pigment{color rgb<0.6,0.2,0.2> } finish{F_MetalA}}

        #declare TEMP_TEX_2 = texture {
                pigment{color rgb<0.8,0.4,0.4> } finish{F_MetalA}}

        // This is the "straight line" track.

        #declare Track_1 = mesh {

                #declare Y = 0.3 #while ( Y <= 0.9 )
                
                // Sides of box.        
                        triangle { <0,Y,0><2,Y,0><2,Y+0.1,0>
                        texture { T_Gold_1A} }
                        triangle { <0,Y,0><0,Y+0.1,0><2,Y+0.1,0>
                        texture { T_Gold_1A} }
                
                        triangle { <0,Y,2><2,Y,2><2,Y+0.1,2>
                        texture { T_Gold_1A} }
                        triangle { <0,Y,2><0,Y+0.1,2><2,Y+0.1,2>
                        texture { T_Gold_1A} }
                
                // Flat top of box.
                        triangle { <0,Y+0.1,0><2,Y+0.1,0><2,Y+0.1,2>
                        texture { T_Gold_1A} }
                        triangle { <0,Y+0.1,0><0,Y+0.1,2><2,Y+0.1,2>
                        texture { T_Gold_1A} }
                
                #declare Y = Y + 0.3 #end

                // Rails.
                #declare X = 0 #while ( X <= 2 )
                        triangle { <X,1.2,0><X,1,0.2><X,1,0>
                                texture{TEMP_TEX_1} }
                        triangle { <X,1.2,2><X,1,1.8><X,1,2>
                                texture{TEMP_TEX_1} }
                #declare X = X + 0.01 #end

                // Post.
                #declare Y = -10 #while ( Y <= 0.3 )
                
                #declare V1 = vrotate(< 0.4,Y, 0.0>,<0,Y*100,0>)
                #declare V2 = vrotate(< 0.0,Y, 0.2>,<0,Y*100,0>)
                #declare V3 = vrotate(<-0.2,Y, 0.0>,<0,Y*100,0>)
                #declare V4 = vrotate(< 0.0,Y,-0.2>,<0,Y*100,0>)
                #declare V5 = < 0, Y-0.1, 0 >

                #declare V1 = V1 + <1,0,1>
                #declare V2 = V2 + <1,0,1>
                #declare V3 = V3 + <1,0,1>
                #declare V4 = V4 + <1,0,1>
                #declare V5 = V5 + <1,0,1>

                triangle { V1, V2, V5 texture { T_Gold_1A } }
                triangle { V2, V3, V5 texture { T_Gold_1A } }
                triangle { V3, V4, V5 texture { T_Gold_1A } }
                triangle { V4, V1, V5 texture { T_Gold_1A } }

                #declare Y = Y + 0.1 #end

        } // End of mesh.

        // Sideways track.
        
        #declare Track_2 = object { Track_1
                
                translate < -1, 0, -1 >
                rotate y * 90
                translate < 1, 0, 1 >
                
                } // End of object.

        // Four way intersection track (computer controlled).
        
        #declare Track_3 = union {
                
                #declare TEMP = 0.3 #while ( TEMP <= 0.9 )
                        cylinder{<1, TEMP, 1><1,TEMP+0.1, 1>,1.5+0.5
                                texture{T_Gold_1A} }
                #declare TEMP = TEMP + 0.3 #end
                
                #declare Y = -10 #while ( Y <= 0.3 )
                
                #declare V1 = vrotate(< 0.4,Y, 0.0>,<0,Y*100,0>)
                #declare V2 = vrotate(< 0.0,Y, 0.2>,<0,Y*100,0>)
                #declare V3 = vrotate(<-0.2,Y, 0.0>,<0,Y*100,0>)
                #declare V4 = vrotate(< 0.0,Y,-0.2>,<0,Y*100,0>)
                #declare V5 = < 0, Y-0.1, 0 >

                #declare V1 = V1 + <1,0,1>
                #declare V2 = V2 + <1,0,1>
                #declare V3 = V3 + <1,0,1>
                #declare V4 = V4 + <1,0,1>
                #declare V5 = V5 + <1,0,1>

                triangle { V1, V2, V5 texture { T_Gold_1A } }
                triangle { V2, V3, V5 texture { T_Gold_1A } }
                triangle { V3, V4, V5 texture { T_Gold_1A } }
                triangle { V4, V1, V5 texture { T_Gold_1A } }

                #declare Y = Y + 0.1 #end
                
                // Bunch of corner posts.
                cylinder{<0-0.2,1,0-0.2><0-0.2,2,0-0.2>,0.08 texture{T_Gold_5E}}
                cylinder{<2+0.2,1,0-0.2><2+0.2,2,0-0.2>,0.08 texture{T_Gold_5E}}
                cylinder{<2+0.2,1,2+0.2><2+0.2,2,2+0.2>,0.08 texture{T_Gold_5E}}
                cylinder{<0-0.2,1,2+0.2><0-0.2,2,2+0.2>,0.08 texture{T_Gold_5E}}
                
                cone{<0-0.2,2,0-0.2>,0.08<0-0.2,2.3,0-0.2>,0 texture{T_Gold_1A}}
                cone{<2+0.2,2,0-0.2>,0.08<2+0.2,2.3,0-0.2>,0 texture{T_Gold_1A}}
                cone{<2+0.2,2,2+0.2>,0.08<2+0.2,2.3,2+0.2>,0 texture{T_Gold_1A}}
                cone{<0-0.2,2,2+0.2>,0.08<0-0.2,2.3,2+0.2>,0 texture{T_Gold_1A}}
                
                } // End of union.

#end // End of if block.


#if ( Show_Tracks != off )

        // Start the big loop.

        #declare A=1 #while (A<=50)
        
        #declare ZZ=""

        #if(A= 1) #declare ZZ=".................................................." #end
        #if(A= 2) #declare ZZ=".................................................." #end
        #if(A= 3) #declare ZZ=".................................................." #end
        #if(A= 4) #declare ZZ=".................................................." #end
        #if(A= 5) #declare ZZ="..........+-+--------------------................." #end
        #if(A= 6) #declare ZZ="..........I.I....................................." #end
        #if(A= 7) #declare ZZ="..........+-+--------------------................." #end
        #if(A= 8) #declare ZZ="..........I.I....................................." #end
        #if(A= 9) #declare ZZ="..........I.I....................................." #end
        #if(A=10) #declare ZZ="----------+-+....................................." #end
        #if(A=11) #declare ZZ="..........I.I....................................." #end
        #if(A=12) #declare ZZ="----------+-+.............................I.I....." #end
        #if(A=13) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=14) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=15) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=16) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=17) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=18) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=19) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=20) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=21) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=22) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=23) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=24) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=25) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=26) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=27) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=28) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=29) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=30) #declare ZZ="..........I.I.............................I.I....." #end
        #if(A=31) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=32) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=33) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=34) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=35) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=36) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=37) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=38) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=39) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=40) #declare ZZ="----------+-+-------------+-+-------------+-+-----" #end
        #if(A=41) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=42) #declare ZZ="----------+-+-------------+-+-------------+-+-----" #end
        #if(A=43) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=44) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=45) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=46) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=47) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=48) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=49) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        #if(A=50) #declare ZZ="..........I.I.............I.I.............I.I....." #end
        
        // Now do something with that string.

        #declare X=1 #while(X<=50)
        
                #declare TTTT = substr(ZZ,X,1)
                
                // Left to right.
                #declare MATCH1 = strcmp( TTTT, "-" )
                #if (MATCH1=0) object{Track_1
                        translate<(X-1)*2,0,100-(A*2)>} #end

                // Front to back..
                #declare MATCH2 = strcmp( TTTT, "I" )
                #if (MATCH2=0) object{Track_2
                        translate<(X-1)*2,0,100-(A*2)>} #end

                // Crossover.
                #declare MATCH3 = strcmp( TTTT, "+" )
                #if (MATCH3=0) object{Track_3
                        translate<(X-1)*2,0,100-(A*2)>} #end

        #declare X=X+1 #end

#declare A=A+1 #end

#end // End of if block.


////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//
// Bye!

