//-----------------------------------------------------------
// Cube de Dirk Huizer
//-----------------------------------------------------------

#declare lng = 7
#declare lar = lng/10

#declare textu = texture {
  T_Wood10
  scale 3
  rotate <0, 30, 0>
}

#declare face_bas = box {
  <-lng/2, -lng/2, -lng/2>, <lng/2, -lng/2+lar, lng/2>
}

#declare face_droite = union {
  box {
    <lng/2-lar, -lng/2, -lng/2>, <lng/2, 0, lng/2>
  }
  box {
    <lng/2-lar, 0, -lng/2>, <lng/2, lng/2, -lng/2+lar>
  }
  difference {
    box {
      <lng/2-lar, lng/2, -lng/2>, <lng/2, lng-lar, -lng/2+lar>
    }
    box {
      <-3*lar, 0, -3*lar>, <3*lar, 3*lar, 3*lar>
      rotate <45, 0, 0>
      translate <lng/2-lar/2, lng-3*lar/2, -lng/2+lar/2>
    }
    no_shadow
  }
}

#declare bloc = union {
  object {
    face_bas
  }
  object {
    face_droite
  }
}

#declare huizer = union {
  object {
    bloc
  }
  object {
    bloc
    rotate <0, 90, -90>
  }
  object {
    bloc
    rotate <-90, 0, 90>
  }
  texture {
    textu
  }
  finish {
    ambient 0.65
  }
  translate <0, lng/2, 0>
}

