/*
3D Sierpinski Gasket in case

(c) 1997 Mario Becroft
*/

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "skies.inc"
#include "woods.inc"
#include "metals.inc"

/*** Settings ***/

/* Scene definition */


/* Options */

#declare iterations = 260000
#declare use_blobs = false

/*** Variables ***/


/*** Atmosphere ***/

sky_sphere {
//      S_Cloud1        // Good general sky
	S_Cloud3        // Good night-time sky
//      S_Cloud4        // Stormy night sky
	rotate x*10
}

fog {
	fog_type 2
	color rgbt<0.7,0.7,0.7,0.0>
	distance 40
	fog_offset -7
	fog_alt 1.7
}

/*** Camera ***/

//#declare Cam_pos = <0.00001,6,0.00001>
#declare Cam_pos = <1.2,0.8,-4.5>
#declare Cam_lookat = <0,0.5,0>
camera {
	location Cam_pos
	look_at Cam_lookat
	
	angle 30
}


/*** Lights ***/

light_source {  <15,1,-10>*5 color Gray85 }
light_source {  <-8,20,-10>*5 color White }


/*** Misc. texture definitions ***/


/*** Object definitions ***/

/* The gasket */

#if (!use_blobs)
#declare GasketObject = object {
	sphere { <0,0,0>,0.01 }
}
#end

#declare Corner0 = < 0, 0, 0.5>
#declare Corner1 = vrotate(Corner0,y*(360/3))
#declare Corner2 = vrotate(Corner0,y*(360/3*2))
#declare Corner3 = < 0, 0.75, 0>

#declare R1 = seed(0)
#switch (rand(R1)*4)
	#range (0.0,1.0)
		#declare Corner = Corner0
		#break
	#range (1.0,2.0)
		#declare Corner = Corner1
		#break
	#range (2.0,3.0)
		#declare Corner = Corner2
		#break
	#range (3.0,4.0)
		#declare Corner = Corner3
		#break
#end
#declare Px = Corner.x
#declare Py = Corner.y
#declare Pz = Corner.z
#declare itercount = 0
#if (use_blobs)
#declare Gasket = blob {
	threshold 0.6
#else
#declare Gasket = union {
#end
	#while (itercount < iterations)
		#switch (rand(R1)*4)
			#range (0.0,1.0)
				#declare Corner = Corner0
				#break
			#range (1.0,2.0)
				#declare Corner = Corner1
				#break
			#range (2.0,3.0)
				#declare Corner = Corner2
				#break
			#range (3.0,4.0)
				#declare Corner = Corner3
				#break
		#end
		#declare Px = Px + (Corner.x-Px)/2
		#declare Py = Py + (Corner.y-Py)/2
		#declare Pz = Pz + (Corner.z-Pz)/2
#if (use_blobs)
		sphere { <Px,Py,Pz>,0.02,0.07 }
#else
		object { GasketObject translate <Px,Py,Pz> }
#end
		#declare itercount = itercount + 1
	#end
	
	texture {
		pigment { color Gray90+<0,0,0.03> }
		finish { ambient 0.2 phong 1.0 phong_size 45 metallic }
	}
}

//#declare GasketGlobe = union {
union { // No definition to save memory
	/* The gasket */
	object { Gasket translate y*-(0.25+0.03) scale 0.95
		rotate y*60 rotate x*-10 
	}
	
	/* The globe */
	intersection {
		sphere { <0,0,0>,0.8 }
		box { <-1,1,-1>,<1,-0.5,1> }
		texture { T_Glass3
			finish {
				fade_power 1.2
				fade_distance 4
				caustics 1
			}
		}
	}
	
	/* The metal ring at base of globe */
	#declare Rtop = -0.42
	#declare Rrad = 0.81
	#declare Rmrad = 0.01
	#declare Rinrad = Rrad - Rmrad
//      #declare Rtopangle = (1-(1+Rtop))*90
//      #declare Rtopvec = vrotate(<Rinrad,0,0>,z*Rtopangle).x
//      #declare Rtoprad = Rtopvec.x
	#declare Rtoprad = 0.68
	union {
		intersection {
			sphere { <0,0,0>,Rrad }
			box { <-1,Rtop,-1>,<1,-0.5,1> }
		}
		torus { Rtoprad , Rmrad translate y*Rtop }
		texture { T_Chrome_1C
			normal {
				bozo
				bump_size 0.04
				scale 0.05
			}
		}
	}
	translate y*0.5
}

#declare Tripyramid = mesh {
	triangle { Corner0,Corner1,Corner2 }
	triangle { Corner1,Corner0,Corner3 }
	triangle { Corner2,Corner1,Corner3 }
	triangle { Corner0,Corner2,Corner3 }
	
	texture { T_Glass3
		finish {
			fade_power 1.2
			fade_distance 4
			caustics 1
		}
	}

	scale <1,1.3,1>
	scale 0.37
	rotate y*15
	translate <0.9,0.0001,-0.7>
}

#declare Ssize = 0.9
#declare Sthick = 0.3
#declare Sbottom = -1
#declare Surface = union {
	box { <-Ssize,0,-Ssize>,<Ssize,-Sthick,Ssize> }
	box { <-(Ssize+Sthick/2),0-Sthick/2,-Ssize>,<Ssize+Sthick/2,Sbottom,Ssize> }
	box { <-Ssize,0-Sthick/2,-(Ssize+Sthick/2)>,<Ssize,Sbottom,Ssize+Sthick/2> }
	cylinder { <-Ssize,-Sthick/2,+Ssize>,<+Ssize,-Sthick/2,+Ssize>,Sthick/2 }
	cylinder { <+Ssize,-Sthick/2,+Ssize>,<+Ssize,-Sthick/2,-Ssize>,Sthick/2 }
	cylinder { <+Ssize,-Sthick/2,-Ssize>,<-Ssize,-Sthick/2,-Ssize>,Sthick/2 }
	cylinder { <-Ssize,-Sthick/2,-Ssize>,<-Ssize,-Sthick/2,+Ssize>,Sthick/2 }
	cylinder { <+Ssize,-Sthick/2,+Ssize>,<+Ssize,Sbottom,+Ssize>,Sthick/2 }
	cylinder { <+Ssize,-Sthick/2,-Ssize>,<+Ssize,Sbottom,-Ssize>,Sthick/2 }
	cylinder { <-Ssize,-Sthick/2,-Ssize>,<-Ssize,Sbottom,-Ssize>,Sthick/2 }
	cylinder { <-Ssize,-Sthick/2,+Ssize>,<-Ssize,Sbottom,+Ssize>,Sthick/2 }
	sphere { <+Ssize,-Sthick/2,+Ssize>,Sthick/2 }
	sphere { <+Ssize,-Sthick/2,-Ssize>,Sthick/2 }
	sphere { <-Ssize,-Sthick/2,-Ssize>,Sthick/2 }
	sphere { <-Ssize,-Sthick/2,+Ssize>,Sthick/2 }
	
	scale <1,0.6,1>
	texture { T_Wood1
		finish {
			specular 0.25
			roughness 0.015
			reflection 0.2
			ambient 0.15
			diffuse 0.7
		}

		rotate x*10
		rotate y*20
	}
	translate x*0.165
}

#declare Ground_tex = texture {
	pigment {
		bozo
		color_map {
			[0 ForestGreen]
			[1 ForestGreen*0.6]
		}
		scale 10
	}
}

#declare Ground = union {
	plane { y,-10 }
	height_field { tga "sgmhf.tga" smooth
		translate <-0.5,0,-0.5>
		scale < 1, 0.2, 1 >
		scale 130
		translate z*130
		translate y*-10
		rotate y*-20
	}
	texture { Ground_tex }
}

/*** Put down objects ***/

//object { GasketGlobe }

object { Tripyramid }

object { Surface }

object { Ground }

/*** Lens flare(s) ***/

#declare cam_loc = Cam_pos
#declare lookat = Cam_lookat
#declare sky_vect = <0,0,1>

/* R.H. highlight on globe */
#declare flare_type = "Sparkle1"
#declare flare_scale_factor = 0.5
#declare light_loc = <0.315,0.49,0>
#include "lnsflare.inc"

/* L.H. highlight on globe */
#declare flare_type = "Sparkle1"
#declare flare_scale_factor = 0.4
#declare light_loc = <-0.23,0.93,0>
#include "lnsflare.inc"

/* Highlight on "Tripyramid" */
#declare flare_type = "Sparkle1"
#declare flare_scale_factor = 0.32
#declare flare_amount = 0.6
#declare light_loc = <0.85,0.2,0>
#include "lnsflare.inc"
