
// Persistence of Vision Ray Tracer Scene Description File
// File: questick.inc
// Vers: 3.01
// Desc: use to create a single questick 
// Date: 06/29/97
// Auth: Bob Franke

#version 3

#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "metals.inc"


#declare PineMult = 1.5
#declare Que_Yellow_Pine =
texture {
    pigment {
        wood
        turbulence 0.02
        color_map {
            [0.000, 0.222 color rgb <0.808, 0.671, 0.451>*PineMult
                          color rgb <0.808, 0.671, 0.451>*PineMult]
            [0.222, 0.342 color rgb <0.808, 0.671, 0.451>
                          color rgb <0.600, 0.349, 0.143>*PineMult]
            [0.342, 0.393 color rgb <0.600, 0.349, 0.143>*PineMult
                          color rgb <0.808, 0.671, 0.451>*PineMult]
            [0.393, 0.709 color rgb <0.808, 0.671, 0.451>*PineMult
                          color rgb <0.808, 0.671, 0.451>*PineMult]
            [0.709, 0.821 color rgb <0.808, 0.671, 0.451>*PineMult
                          color rgb <0.533, 0.298, 0.127>*PineMult]
            [0.821, 1.000 color rgb <0.533, 0.298, 0.127>*PineMult
                          color rgb <0.808, 0.671, 0.151>*PineMult]
        }
    scale 0.1
    translate <10, 0, 0>
    }
}
// light_Yellow_Pine layer 2
texture {
    pigment {
        wood
        turbulence 0.01
        color_map {
            [0.000, 0.120 color rgbf <1.000, 1.000, 1.000, 1.000>
                          color rgbf <0.702, 0.412, 0.318, 0.608>*PineMult]
            [0.120, 0.231 color rgbf <0.702, 0.412, 0.318, 0.608>*PineMult
                          color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult]
            [0.231, 0.496 color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult
                          color rgbf <1.000, 1.000, 1.000, 1.000>]
            [0.496, 0.701 color rgbf <1.000, 1.000, 1.000, 1.000>
                          color rgbf <1.000, 1.000, 1.000, 1.000>]
            [0.701, 0.829 color rgbf <1.000, 1.000, 1.000, 1.000>
                          color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult]
            [0.829, 1.000 color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult
                          color rgbf <1.000, 1.000, 1.000, 1.000>]
        }
    scale 0.5
    translate <10, 0, 0>
    }
}


#declare queStick=
union{
  difference{
    superellipsoid { <1, .75>  rotate<90,0,0> scale .25 texture{pigment{Blue*1.3}}}
    object{plane {y,.125+.03125 } }
  }
  difference{
    superellipsoid { <1, .75>  rotate<90,0,0> scale .25 texture{pigment{VeryDarkBrown }}}
    object{plane {y,.125+.03125 inverse } }

  }
  cylinder {<0,.0625,0>, <0,-.875,0>, .2501  texture{pigment{rgb<1,1,.85>} finish{Shiny}}}
  cylinder {<0,-.875,0>, <0,-15,0>, .2501  texture{Que_Yellow_Pine scale .25 rotate<87,0,0> }}
  cone {<0,-15,0>, .2501, <0,-29,0>, .5625 texture{Que_Yellow_Pine scale .25 rotate<87,0,0> }}
  cylinder {<0,-29,0>, <0,-30,0>, .57  texture{T_Brass_4C } }
  cylinder {<0,-30,0>, <0,-30.03125,0>, .57  texture{pigment{Black}} }
  cylinder {<0,-30.03125,0>, <0,-31,0>, .57  texture{T_Brass_4C } }
  cone {<0,-31,0>, .5625, <0,-58,0>, 1.00 texture{Que_Yellow_Pine scale .25 rotate<87,0,0> }}
  cylinder {<0,-58,0>, <0,-59.5,0>, 1.00  texture{Aluminum  } }
  sphere{<0,-59.5,0>,.75 pigment{Black}}

  #declare loop = 0
  #while (loop < 220)
    torus{.72+(loop*.0013),0.04  translate<0,-40-(.08*loop),0> texture{pigment{HandleColor}} finish{Shiny}}
    #declare loop = loop + 1
  #end
}
