#include "colors.inc"

camera {
   location <30, 3, 0>
   direction <-1, 0, 0>
   look_at <0, 7, 0>
   focal_point <-5, 7, 0>
   aperture .4
   blur_samples 50
}

#declare cloud1 =
pigment {
    wrinkles
    turbulence 0.2
    lambda 2.2
    omega 0.707
    color_map {
	[0.3 color Clear]
	[0.4 color Gray25]
	[0.65 color Gray15]
	[0.8 color Gray25]
	[1.0 color Black]
    }
    scale 1/150
}

#declare cloud2 =
pigment {
    wrinkles
    turbulence 0.2
    lambda 2.2
    omega 0.707
    color_map {
	[0.3 color Clear ]
	[0.4 color Black transmit 1]
    }
    scale 1/150
}

#declare cloud3 =
pigment {
    wrinkles
    turbulence 0.3
    lambda 1.5
    omega 1
    color_map {
	[0.6 color Clear ]
	[0.8 color rgb <1, .5, 0>]
	[0.9 color rgb <1, .75, .75>]
	[1.0 color rgbf <1, .75, .75, 1>]
    }
    scale <.5, .2, 1>
    scale .2
}

sphere {<0, 0, 0>, 1 inverse no_shadow
       texture {
		pigment {
		       gradient y
		       pigment_map {
				   [0.99800 color Clear]
				   [0.99925 cloud2]
				   [1.00000 cloud1]
		       }
		 }
	finish {ambient 1 diffuse 0}
	}
rotate 260*y
scale 100000
translate -99498*y
}

sphere {<0, 0, 0>, 1 inverse no_shadow
       texture {
		pigment {
		       gradient y
		       pigment_map {
				   [0.2 color Clear]
				   [0.7 cloud3]
		       }
		 }
	finish {ambient 1 diffuse 0}
	}
scale 9999
rotate 20*y
}

sphere {<0, 0, 0>, 10000 inverse no_shadow
	texture {
		pigment {
			image_map {tga "sky.tga"
				map_type 1
				interpolate 2
			}
		}
	finish {ambient 1 diffuse 0}
    rotate <90, 0, -90>
    rotate -12.5*y
	}
}

plane {y, 0 texture{
      hexagon
	    texture {pigment {color Gray70}
		    finish {reflection .15 ambient .2 specular 1 roughness .01}
	    },
	    texture {pigment {color Gray80}
		    finish {reflection .15 ambient .2 specular 1 roughness .01}
	    },
	    texture {pigment {color Gray90}
		    finish {reflection .15 ambient .2 specular 1 roughness .01}
	    }
      }
      scale 1
      rotate -15*y
}

light_source {<10000000, 2500000, 2216950> color rgb <1, .75, .5>}

height_field {gif "fract009.gif"
	texture {
		pigment {color rgb <1, .75, .5>}
		finish {ambient .2}
	}
translate <-.5, 0, -.5>
scale <2000, 125, 2000>
translate <-1250, -25, 0>
}

height_field {gif "fract009.gif"
	texture {
		pigment {color rgb <1, .75, .5>}
	}
translate <-.5, 0, -.5>
scale <-1000, 60, -1000>
translate <500, -10, 0>
}

#declare plastic = texture {
	pigment {color rgb <0.4, 0.45, 0.5>}
	finish {
		ambient 0.35
		brilliance 3
		diffuse 0.4
		metallic
		specular 0.70
		roughness 1/50
		reflection 0.25
	}
}

#declare splitter = union {
	 box {<-1, 4, -3>, <1, 10, 3> texture {
	     pigment {
		 onion
		 color_map {
			   [0 color rgbt <2, 0, 0, .25>]
			   [.2 color rgbt <.2, 0, 0, .75>]
		 }
		 rotate -90*z
		 scale 6.2
		 translate 7*y
	 }
	     finish {
		    specular 1
		    roughness 0.001
		    ambient 1
		    diffuse .1
		    refraction 1
		    reflection 0.25
		    ior 1.5
	     }
	 }hollow}
	 box {<-1, 0, -3>, <1, 4, 3> texture {plastic}}
	 cylinder {<0, 0, -3>, <0, 0, 3>, 2 texture {plastic}}
	 sphere {<0, 0, -3>, 2 texture {plastic}}
	 sphere {<0, 0, 3>, 2 texture {plastic}}
	 cylinder {<0, 0, -3>, <0, 5, -3>, 1  clipped_by {
	    box {<-2, 0, -5>, <2, 6, -3>}}
	    texture {plastic}
     }
	 cylinder {<0, 0, 3>, <0, 5, 3>, 1 clipped_by {
	    box {<-2, 0, 3>, <2, 6, 5>}}
	    texture {plastic}
     }
	 sphere {<0, 5, -3>, 1 clipped_by {
	    box {<-2, 3, -5>, <2, 7, -3>}}
	    texture {plastic}
     }
	 sphere {<0, 5, 3>, 1 clipped_by {
	    box {<-2, 3, 3>, <2, 7, 5>}}
	    texture {plastic}
     }
 }

#declare mirror = union {
	 cylinder {<-1.1, 7, 0>, <1.1, 7, 0>, 2.5 texture {
	     pigment {
		 onion
		 color_map {
			   [0 color rgb <.5, 0, 0>]
			   [.5 color rgb <0, 0, 0>]
		 }
		 rotate -90*z
		 scale 5
		 translate 7*y
	 }
	     finish {
		    specular 1
		    roughness 0.01
		    diffuse 0
		    reflection .8
	    ambient 1
	     }
	 }}
	 box {<-1, 0, -3>, <1, 7, 3> texture {plastic}}
	 cylinder {<-1, 7, 0>, <1, 7, 0>, 3 texture {plastic}}
	 cylinder {<0, 0, -3>, <0, 0, 3>, 2 texture {plastic}}
	 sphere {<0, 0, -3>, 2 texture {plastic}}
	 sphere {<0, 0, 3>, 2 texture {plastic}}
}

#declare rings = pigment {
	 onion
	 color_map {
		   [0 color rgb <1, .5, .5>]
		   [.5 color rgb <.5, .5, .5>]
		   [1 color rgb <1, .5, .5>]
	 }
	 frequency 8
}

#declare screen = union {
	 box {<-.99, 4, -2.8>, <1.01, 9.8, 2.8> texture {
	 pigment {
	    onion
	    pigment_map {
			[.4 rings]
			[1 color White]
	    }
	 rotate -90*z
	 scale 4.25
	 translate 7*y
	 }
	 }}
	 box {<-1, 0, -3>, <1, 10, 3> texture {plastic}}
	 cylinder {<0, 0, -3>, <0, 0, 3>, 2 texture {plastic}}
	 sphere {<0, 0, -3>, 2 texture {plastic}}
	 sphere {<0, 0, 3>, 2 texture {plastic}}
}

#declare lens = union {
	 sphere {<0, 0, 0>, 1 texture {
	     pigment {
			gradient x
			pigment_map {
				[.5 color rgbt <.5, 0, 0, .9>]
				[.9 color rgbt <.5, 0, 0, .8>]
				[1 color rgbt <1, 0, 0, .7>]
			}
	     }
	     finish {
		    specular 1
		    roughness 0.001
		    ambient 1
		    diffuse .1
		    refraction 1
		    reflection 0.2
		    ior 1.5
	     }
	 }
	 hollow
	 scale 1.44
	 translate y*7
	 }
	 difference {
		      cylinder {<0, 0, 0>, <0, 7, 0>, 1}
		      sphere {<0, 7, 0>, 1.45 }
	 texture {plastic}
	 }
	 sphere {<0, 0, 0>, 2 texture {plastic}}
	 light_source {<0, 7, 0> color <1, 0, 0>
		spotlight
		point_at <-28, 7, 0>
		radius 6.1155
		falloff 9
		tightness 10
	 }
}

#declare beam = texture {
    pigment { color rgbt <1, 1, 1, 1> }
	halo {
	     emitting
	     cylindrical_mapping
	     linear
	     color_map {
		     [ 0 color rgbt <1, 0, 0,  1>]
		     [.5 color rgbt <1, 0, 0, .8>]
		     [ 1 color rgbt <1, 0, 0, -.5>]
	     }
	     samples 50
      }
}

#declare beam2 = texture {
    pigment { color rgbt <1, 1, 1, 1> }
	halo {
	     emitting
	     cylindrical_mapping
	     linear
	     color_map {
		     [ 0 color rgbt <1, 0, 0,  1>]
		     [.5 color rgbt <1, 0, 0, .9>]
		     [ 1 color rgbt <1, 0, 0, .25>]
	     }
	     samples 50
      }
}

#declare beam3 = texture {
    pigment { color rgbt <1, 1, 1, 1> }
	halo {
	     emitting
	     cylindrical_mapping
	     linear
	     color_map {
		     [ 0 color rgbt <1, 0, 0,  1>]
		     [.5 color rgbt <1, 0, 0, .5>]
		     [ 1 color rgbt <1, 0, 0,  -1>]
	     }
	     samples 50
      }
}

#declare beam4 = texture {
    pigment { color rgbt <1, 1, 1, 1> }
	halo {
	     emitting
	     spherical_mapping
	     linear
	     color_map {
		     [ 0 color rgbt <1, 0, 0, 1>]
		     [.7 color rgbt <1, 0, 0, .94>]
		     [.85 color rgbt <1, 0, 0, .82>]
		     [ 1 color rgbt <1, 0, 0, .31>]
	     }
	     samples 50
      }
      scale 45
}

#declare beam5 = texture {
    pigment { color rgbt <1, 1, 1, 1> }
	halo {
	     emitting
	     spherical_mapping
	     linear
	     color_map {
		     [ 0 color rgbt <1, 0, 0, 1>]
		     [.7 color rgbt <1, 0, 0, .97>]
		     [.85 color rgbt <1, 0, 0, .88>]
		     [ 1 color rgbt <1, 0, 0, .4>]
	     }
	     samples 50
      }
      scale 45
}

object {union {
       object {splitter rotate 45*y}
       cylinder {<0, -1, 0>, <0, 100, 0>, .1 texture {beam}
		rotate <90, 90, 0> translate 7*y hollow
       }
       cylinder {<0, -60, 0>, <0, -1, 0>, .1 texture {beam2}
		rotate <90, 90, 0> translate 7*y hollow
       }
       cylinder {<0, -1, 0>, <0, 22, 0>, .1 texture {beam3}
		rotate <90, 0, 0> translate 7*y hollow
       }
       cylinder {<0, -60, 0>, <0, -1, 0>, .1 texture {beam3}
		rotate <90, 0, 0> translate 7*y hollow
       }
       object {mirror translate 60*x rotate 90*y}
       object {mirror translate -60*x}
       object {lens translate -21*x rotate 90*y}
       object {screen translate -50*x rotate 90*y}
       cone {<0, -27.9, 0>, 3, <0, -1, 0>, .1
	    texture {beam4}
	    hollow
	    translate -21*y rotate -90*x translate 7*y
       }
}
rotate -35*y
translate -9*z
}

object {union {
       object {splitter rotate 45*y}
       cylinder {<0, -1, 0>, <0, 100, 0>, .12 texture {beam3}
		rotate <90, 90, 0> translate 7*y hollow
       }
       cylinder {<0, -60, 0>, <0, -1, 0>, .12 texture {beam3}
		rotate <90, 90, 0> translate 7*y hollow
       }
       cylinder {<0, -1, 0>, <0, 22, 0>, .12 texture {beam}
		rotate <90, 0, 0> translate 7*y hollow
       }
       cylinder {<0, -60, 0>, <0, -1, 0>, .12 texture {beam}
		rotate <90, 0, 0> translate 7*y hollow
       }
       object {mirror translate 60*x rotate 90*y}
       object {mirror translate -60*x}
       object {lens translate -21*x rotate 90*y}
       object {screen translate -50*x rotate 90*y}
       cone {<0, -27.9, 0>, 3, <0, -1, 0>, .1
	    texture {beam5}
	    hollow
	    translate -21*y rotate -90*x translate 7*y
       }
}
rotate 55*y
translate <-150, 0, -25>
}

object {union {
       object {splitter rotate 45*y}
       cylinder {<0, -1, 0>, <0, 100, 0>, .14 texture {beam}
		rotate <90, 90, 0> translate 7*y hollow
       }
       cylinder {<0, -60, 0>, <0, -1, 0>, .14 texture {beam}
		rotate <90, 90, 0> translate 7*y hollow
       }
       cylinder {<0, -1, 0>, <0, 22, 0>, .14 texture {beam3}
		rotate <90, 0, 0> translate 7*y hollow
       }
       cylinder {<0, -60, 0>, <0, -1, 0>, .14 texture {beam3}
		rotate <90, 0, 0> translate 7*y hollow
       }
       object {mirror translate 60*x rotate 90*y}
       object {mirror translate -60*x}
       object {lens translate -21*x rotate 90*y}
       object {screen translate -50*x rotate 90*y}
       cone {<0, -27.9, 0>, 3, <0, -1, 0>, .1
	    texture {beam4}
	    hollow
	    translate -21*y rotate -90*x translate 7*y
       }
}
rotate 0*y
translate <-250, 0, 125>
}

fog {
    fog_type 2
    distance 800
    colour rgb <.1, 0, .2>
    fog_offset 5
    fog_alt 5
    up <0,1,0>
}

