
#ifndef (ABCDE)
#include "defaults.inc"
#end
//============================================================


#declare CeilFin = finish{  ambient .5 diffuse 0.7 phong 0.9 phong_size 20}

#declare CeilTex1 =
texture { pigment { color White * .9}
 finish { CeilFin }
}
#declare CeilTex2 =
texture { pigment { color White}
 finish { CeilFin }
}

plane { y, 10.9833  pigment { color White*.7} finish{ambient .3 diffuse 0.3} hollow}

#declare CeilTile =
  julia_fractal {
    <-0.083,0.0,0.383,-0.025>
    quaternion
    sqr
    max_iteration 35
    precision 35
    rotate < 0, 0, 90 >
    scale < 1, .2, 1 >
    scale < .25, .5, .25 >
    translate < -15, 22,  0>
  }

#declare CLCube4 =
union {
  object { CeilTile texture { CeilTex1 } }
  object { CeilTile texture { CeilTex2 } translate < .55, 0, 0 >}
  object { CeilTile texture { CeilTex2 } translate < 0, 0, -.55 >}
  object { CeilTile texture { CeilTex1 } translate < .55, 0, -.55 >}
}

#declare CLCube16 =
union {
 object { CLCube4 }
 object { CLCube4 translate < 1.1, 0, 0 >}
 object { CLCube4 translate < 0, 0, -1.1 >}
 object { CLCube4 translate < 1.1, 0, -1.1 >}
}

#declare CLRow =
union {
#declare X = 0 #while ( X <= 30 )
object {CLCube16 translate < X, 0, 0 > }
#declare X = X + 2.2 #end
}

#declare FTCeil =
union {
#declare Z = -10 #while (Z <= 30)
object {CLRow translate < 0, 0, Z > }
#declare Z = Z + 2.2 #end
}



object {FTCeil scale < 1, .5, 1 > }

