#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#declare ABCDE = 0

global_settings {
  adc_bailout 1/255
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
#ifdef (Radiosity)
 #debug "This is one line."
    radiosity {
        count 800                // Ensure that we get good, accurate samples
        error_bound 0.2          // And calculate lots of them.  (more important than count)
        gray_threshold 0.5
        distance_maximum 30       // Scene-dependant!
        low_error_factor 0.7     // force many extra samples to be calculated...
        nearest_count 9          // so we can average them together for smoothness
        minimum_reuse 0.01       // get quite tightly into corners
        brightness 3.3           // doesn't really matter.  Not used in final output.
        recursion_limit 1        // Try this = 2, but drop the count to maybe 300
   }
#end
}

#default {
  finish {  ambient .1
            diffuse 0.5
            reflection 0.01
            phong 0.9
            phong_size 200
         }
}

light_source{ <15, 10, -20> color White }
camera{ location <15.0 , 6.0 ,-10> look_at <4.0 , 2.0 , 0.0>}

