
#ifndef (ABCDE)
#include "defaults.inc"
#end
//============================================================

#declare FloorFin = finish{  ambient .5 diffuse 0.7 phong 0.8 phong_size 200}

#declare FloorTex1 =
texture { pigment { color MediumGoldenrod }
 finish { FloorFin }
}
#declare FloorTex2 =
texture { pigment { color LightBlue }
 finish { FloorFin }
}

#declare FloorTile =
  julia_fractal {
    <-0.083,0.0,0.383,-0.025>
    quaternion
    sqr
    max_iteration 35
    precision 35
    rotate < 0, 0, 90 >
    scale < 1, .2, 1 >
    scale < .25, .5, .25 >
    translate < -15, -.6,  0>
  }

#declare FTCube4 =
union {
  object { FloorTile texture { FloorTex1 } }
  object { FloorTile texture { FloorTex2 } translate < .55, 0, 0 >}
  object { FloorTile texture { FloorTex2 } translate < 0, 0, -.55 >}
  object { FloorTile texture { FloorTex1 } translate < .55, 0, -.55 >}
}

#declare FTCube16 =
union {
 object { FTCube4}
 object { FTCube4 translate < 1.1, 0, 0 >}
 object { FTCube4 translate < 0, 0, -1.1 >}
 object { FTCube4 translate < 1.1, 0, -1.1 >}
}

#declare FTRow =
union {
#declare X = 0 #while ( X <= 30 )
object {FTCube16 translate < X, 0, 0 > }
#declare X = X + 2.2 #end
}

#declare FTfloor =
union {
#declare Z = -10 #while (Z <= 30)
object {FTRow translate < 0, 0, Z > }
#declare Z = Z + 2.2 #end
}



object {FTfloor scale < 1, .5, 1 > }
plane { y, -.3 hollow pigment { color Very_Light_Purple }}

