
#ifndef (ABCDE)
#include "defaults.inc"
#include "stones2.inc"

background { color red 0.5 green 0.5 blue 0.5 }

#end
//============================================================

#declare TheFin = finish{
                         ambient .5
                         diffuse 0.6
                         reflection 0.05
                         phong 0.9
                         phong_size 200}

#declare TheMap =
    color_map {
      [0.0  color White]
      [0.1  color Yellow]
      [0.25  color Magenta]
      [0.3  color /*Medium*/Aquamarine ]
      [0.35  color Red]
      [0.5  color Yellow]
      [0.6  color Blue]
      [0.7  color Green]
      [0.8  color Cyan * 1.5]
      [0.9  color Plum ]
      [1.0  color Turquoise ]
    }
#declare TheSMap =
    color_map {
      [0.2  color Red]
      [0.4  color Yellow]
      [0.6  color Blue]
      [0.8  color Green]
      [1.0  color Plum ]
    }

#declare GingerTex = texture{ pigment{ bozo turbulence 2.5 color_map { TheMap }}
  finish { TheFin }
}
#declare SierpinskiTex = texture{ pigment { bozo turbulence 5 color_map { TheSMap }}
  finish { TheFin }
}
#declare HenonTex = texture{ pigment {gradient y color_map  {TheMap }}
  finish { TheFin }
}
#declare LorenzTex = texture{ pigment {gradient x color_map {TheMap }}
  finish { TheFin }
}
#declare RosslerTex = texture{ pigment {onion color_map {TheMap }}
  finish { TheFin }
}
#declare ButterflyTex =
texture{  pigment { mandel 10 color_map { TheMap } scale 8 translate < 3.5, 0, 0 >}
finish { TheFin }
}
#declare ForcefieldTex = texture {    pigment { gradient x color_map {TheMap } }
  finish { TheFin }
}


#declare GlassCase =
texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
    finish  {
       ambient 0.1
       diffuse 0.1
       reflection 0.01
       refraction 1
       ior 1.45
       specular 0.2
       roughness 0.03
     }
}

#declare TheBase =
  julia_fractal {
    <-0.083,0.0,-0.83,-0.025>
    quaternion
    sqr
    max_iteration 18
    precision 25
  }
/////////////////////////////////////////////////////////////////////////////////////
/*
GingerBread
*/
#declare X2 = -1
#declare Y2 = .4
#declare Loops = 0

#declare Ginger =
mesh {
#while ( Loops <= 7000 )
  #declare	Xgin = (1 - Y2 ) + abs(X2)
  #declare	Ygin = X2
    triangle { < Xgin - .2, Ygin, 0 >, < Xgin , Ygin + .3, 0 >, < Xgin + .2, Ygin + .1, 0 >  }  //h
#declare  X2 = Xgin
#declare  Y2 = Ygin
#declare Loops = Loops + 1 #end
texture {GingerTex scale 2}
scale .3
translate< -.7, -1, 0 >
}
#declare GingerBread =
union {
 box {  <-2, -2.4, -.10>   < 2,  2.2,  .10>  texture {GlassCase }}
 object {    Ginger}
 object { TheBase
          texture { T_Stone38}
          scale < 1.7, .8, .5 >
          rotate < 0, 0, 0 >
          translate < 0, -2.7, 0 >
        }
 }
/////////////////////////////////////////////////////////////////////////////////////
/*
The Sierpinski Gasket
*/

#declare Xser = 5
#declare Yser = 2
#declare R1 = seed(20)
#declare Loops = 0
#declare Sierpin =
mesh {
#while ( Loops <= 4000 )
#declare J = int (rand(R1)*3)
	#switch(J)
		#case (0)  //the first point on triangle is (6, 10, 0)
		  #declare	Yser = (Yser + 15)/2
		  #declare	Xser = (Xser + 6)/2
		#break
		#case (1)  //the second point on triangle is (0, 0, 0)
		  #declare	Yser = (Yser)/2
		  #declare	Xser = (Xser )/2
		#break
		#case (2)  //the third point on the triangle is (11, 0, 0)
		  #declare	Yser = (Yser)/2
		  #declare	Xser = (Xser + 11)/2
        #break
    #end
 triangle { < Xser - .3, Yser, 0 >, < Xser , Yser + .5, 0 >, < Xser + .3, Yser, 0 > }
 #declare Loops = Loops + 1 #end
 texture {SierpinskiTex }
 scale .25
 translate < -1.45, -1.9, .1 >
}
#declare Sierpinski =
union {
 box {  <-2, -2.4, -.20>   < 2,  2.2,  .20>  texture {GlassCase }}
 object { Sierpin }
 object { TheBase
          texture { T_Stone39}
          scale < 1.7, .8, .5 >
          rotate < 0, 0, 0 >
          translate < 0, -2.5, .3 >
 finish { TheFin }
        }
 scale .6
// translate < 0, 0, .8 >
 }
/////////////////////////////////////////////////////////////////////////////////////
/*
HENON'S ATTRACTOR
X(n+1) = (Yn+1) - (1.4X^2)
Y(n+1) = 0.3Xn
*/

#declare Xhen = 0
#declare Yhen = 0
#declare Ahen = 1.4
#declare Bhen = .3


#declare Loops = 0
#declare Hen =
mesh {
#while ( Loops <= 3000 )
		  #declare	Xhen2 = (Yhen + 1) - ( Ahen * Xhen * Xhen )
		  #declare	Yhen2 = Bhen * Xhen
triangle { < Xhen2 - .03, Yhen2, 0 >, < Xhen2, Yhen2 + .05, 0 >, < Xhen2 + .03, Yhen2, 0 >  }
#declare  Xhen = Xhen2
#declare  Yhen = Yhen2

#declare Loops = Loops + 1 #end
texture {HenonTex}
scale < 2, 3, 2 >
//translate< -1, 4, 0 >
}
#declare Henon =
union {
 box {  <-2.8, -2.0, -.10>   < 2.8,  2.0,  .10>  texture {GlassCase }}
 object { Hen }
 object { TheBase
          texture { T_Stone40}
          scale < 1.9, .75, .5 >
          translate < .6, -1.8, -.40 >
        }
 }
/////////////////////////////////////////////////////////////////////////////////////
/*
Lorenz'S ATTRACTOR
*/

#declare Xlor = 1
#declare Ylor = 1
#declare Zlor = 1
#declare Alor  = -1
#declare Blor  = 15
#declare Clor  = 5
#declare dtlor = .01

#declare Loops = 0
#declare Lor =
mesh {
#while ( Loops <= 2000 )
  #declare	Xlor2 = Xlor + ( -Alor * Xlor * dtlor) + ( Alor * Ylor * dtlor )
  #declare	Ylor2 = Ylor + ( Blor * Xlor * dtlor ) - ( Ylor * dtlor ) - ( Xlor * Zlor * dtlor )
  #declare	Zlor2 = Zlor + ( -Clor * Zlor * dtlor ) + ( Xlor * Ylor * dtlor )
    triangle { < Xlor2 - .1, Ylor2, 0 >, < Xlor2, Ylor2 + .3, 0 >, < Xlor2 + .1, Ylor2, 0 >  }
  #declare  Xlor = Xlor2
  #declare  Ylor = Ylor2
  #declare  Zlor = Ylor2
#declare Loops = Loops + 1 #end
 texture {LorenzTex scale 2 }
scale <.4, .3, .4 >
}
#declare Lorenz =
union {
 box {  <-2.2, -4.9, -.10>   < 2.2,  3.2,  .10>  texture {GlassCase }}
 object { Lor}
 object { TheBase
          rotate < 0, 100, 0 >
          texture {T_Stone41 }
          scale < 2.2, 1.2, 1 >
          translate < -.25, -4.8, -.5 >
        }
 }
/////////////////////////////////////////////////////////////////////////////////////
/*
ROSSLER'S ATTRACTOR
*/
#declare Xroz =  1
#declare Yroz =  1
#declare Zroz =  1
#declare Aroz  = .2
#declare Broz  = .2
#declare Croz  = 5.7
#declare dtroz = .04
#declare Loops = 0

#declare Ros =
mesh {
#while ( Loops <= 5000 )
  #declare	Xroz2 = Xroz - Yroz * dtroz - Zroz * dtroz
  #declare	Yroz2 = Yroz + Xroz * dtroz +  Aroz * Yroz * dtroz
  #declare	Zroz2 = Zroz + Broz * dtroz + Xroz * Zroz * dtroz - Croz * Zroz * dtroz
  triangle { < Xroz2 - .2, Yroz2, 0 >, < Xroz2 , Yroz2 + .75, 0 >, < Xroz2 + .2, Yroz2, 0 >  }
 #declare  Xroz = Xroz2
 #declare  Yroz = Yroz2
 #declare  Zroz = Zroz2
#declare Loops = Loops + 1 #end
 texture { RosslerTex }
scale .3
translate < -1.45, 2, .25 >
}
#declare Rossler =
union {
 box {  <-5.2, -2.9, -1.75>   < 2.2,  4.9,  1.75> translate < 0, 0, 0 > texture {GlassCase }}
 object { Ros}
 object { TheBase
          texture {T_Stone42 }
          scale < 3.9, .5, 3.5 >
          translate < -1, -2.8, -1 >
        }
 }
/////////////////////////////////////////////////////////////////////////////////////
/*
Forcefield
*/
#declare Loops = -15
#declare MaxLoops = 15
 #declare X = 0
 #declare Y = 0

#declare Force =
mesh {
#while ( Loops <= MaxLoops )
 #declare A = .9
 #declare X =  Loops
// #declare Y = (8 * A * A * A) / (X*X + 4 * A*A) Witch of Agnesi
#declare Y = 2 * 3.14 * ((A + cos (2 * (Y/X) )) * (A + cos (2 * (Y/X) )))
   triangle{ < X -.2, Y, 0  >, < X, Y + .7, 0 >, < X + .2, Y, 0 > }
#declare Loops = Loops + .005 #end
texture {ForcefieldTex }
scale .2
translate < -1.5, -1.5, 0 >
}
#declare Forcefield=
union {
 box {  <-5.0, -2.9, -.5>   < 2.0,  3.5,  .5> translate < 0, 0, 0 > texture {GlassCase }}
 object { Force }
 object { TheBase
          texture { T_Stone42 }
          scale < 3.5, .5, 3.0 >
          rotate < 0, 40, 0 >
          translate < -1.8, -2.8, 0 >
        }
 }
/////////////////////////////////////////////////////////////////////////////////////
/*
ButterFly
*/
#declare Loops = -8
#declare MaxLoops = 8
#declare X = 0
#declare Y = 0

#declare Butter =
mesh {
#while ( Loops <= MaxLoops )
 #declare X =  Loops
 #declare Y = X * cos ( 2 * Y -.1)
   triangle{ < X -.4, Y, 0  >, < X, Y + .5, 0 >, < X + .4, Y, 0 > }
#declare Loops = Loops + .01 #end
texture {ButterflyTex }
scale .3
translate < -1.6, 0, -.1 >
}
#declare ButterFly=
union {
 box {  <-5.0, -2.9, -.5>   < 2.0,  3.5,  .5> translate < 0, 0, 0 > texture {GlassCase }}
 object { Butter }
 object { TheBase
          texture { T_Stone43 }
          scale < 3.0, .5, 3.0 >
          rotate < 0, 40, 0 >
          translate < -1.3, -2.8, -0.2 >
        }
 }

object { Sierpinski rotate <0, -80, 0> translate< -11, 1.5, -5 >}
object { GingerBread scale .7 rotate <0, -20, 0> translate < -8.5, 2.3, 8.5>}
object { Henon scale .5 rotate <0, 0, 0> translate <-2, 1.5, 9.5 >}
object { Lorenz scale .45 rotate <0, -75, 0> translate <-9, 2.75, 1.0 >}
object { Rossler scale .25  rotate <0, -60, 0> translate <7, 1.5, -4.5 >}
object { Forcefield scale .25 rotate <0, -90, 0> translate< 7, 1.8, -6.5 >}
object { ButterFly scale .3 rotate <0, 10, 0> translate <4, 1.9, 7.5 >}









