// BLamp.inc

#declare Y1 = 0			// y coordinate of lower edge
#declare L1 = -250
#declare R1 = 250
#declare N1 = -500
#declare F1 = 500

#declare Y2 = 300		// y coordinate of upper edge
#declare L2 = L1*.8
#declare R2 = R1*.8
#declare N2 = N1*.8
#declare F2 = F1*.8

#declare Y3 = 240		// y coordinate of lamps

#declare LampCol = rgb < 1.0,0.95,0.9 >

#declare BLampBulb = light_source {
	0
	color LampCol*0.05
	looks_like {
		sphere {
			0,25
			pigment { color LampCol }
			finish {
				ambient 1.0
			}
		}
	}
}

#declare BLamp = union {
	union {
		polygon { 5, <L1,Y1,N1>, <L2,Y2,N2>, <L2,Y2,F2>, <L1,Y1,F1>, <L1,Y1,N1> }
		polygon { 5, <R1,Y1,N1>, <R2,Y2,N2>, <R2,Y2,F2>, <R1,Y1,F1>, <R1,Y1,N1> }
		polygon { 5, <L1,Y1,N1>, <R1,Y1,N1>, <R2,Y2,N2>, <L2,Y2,N2>, <L1,Y1,N1> }
		polygon { 5, <L1,Y1,F1>, <R1,Y1,F1>, <R2,Y2,F2>, <L2,Y2,F2>, <L1,Y1,F1> }
		polygon { 5, <L2,Y2,N2>, <R2,Y2,N2>, <R2,Y2,F2>, <L2,Y2,F2>, <L2,Y2,N2> }
		texture {
			pigment { color White }
			finish {
				//reflection 0.1
				metallic
				phong 1.0
				phong_size 100
			}
		}
	}
	object { BLampBulb translate <L2*.6,Y3,F2*.6> }
	object { BLampBulb translate <L2*.6,Y3,0> }
	object { BLampBulb translate <L2*.6,Y3,N2*.6> }
	object { BLampBulb translate <R1*.6,Y3,F2*.6> }
	object { BLampBulb translate <R2*.6,Y3,0> }
	object { BLampBulb translate <R2*.6,Y3,N2*.6> }
#if(do_arealight)
	light_source {
		<0,Y3,0>
		color LampCol*1.2
		spotlight
		point_at < 0,-1000,0 >
		radius 50
		falloff 70
		tightness 5
		area_light x*300,z*800,5,5
		jitter
		adaptive 1
	}
#end
}
