#declare ChalkR		= 4
#declare ChalkLen	= 35-ChalkR*2

#declare T_Chalk = texture {
	pigment { color White }
	finish {
		ambient 0.15
	}
}

#declare Chalk = intersection {
	union {
		sphere { < -ChalkLen/2, 0, 0 >, ChalkR }
		sphere { <  ChalkLen/2, 0, 0 >, ChalkR }
		cylinder { < -ChalkLen/2,0,0>,<ChalkLen/2,0,0>,ChalkR }
	}
	plane {  x,0 rotate < 10, 12,-30> translate x*ChalkLen*0.6 }
	plane {  x,0 rotate < 72,  0,-10> translate x*ChalkLen*0.6 }
	plane { -x,0 rotate <  0, -5, 22> translate x*-ChalkLen*0.55 }
	texture { T_Chalk }
	translate y*ChalkR
}

#declare r1 = seed(0)

#if(0)
#declare Grains = union {
	#declare i = 0
	#while(i<10)
		sphere { < (rand(r1)-.5)*10, 0, (rand(r1)-.5)*10>, 0.1 }
		#declare i=i+1
	#end
	texture { T_Chalk }
	translate x*(ChalkLen/2+ChalkR)
}
#else
#declare P_Grain1 = pigment {
	bozo
	color_map {
		[ 0.0 rgbf <1,1,1,1> ]
		[ 0.8 rgbf <1,1,1,1> ]
		[ 0.8 White ]
	}
	scale .1
//	turbulence 10
}

#declare P_Grain2 = pigment {
	bozo
	color_map {
		[ 0.00 rgbf <1,1,1,1> ]
		[ 0.95 rgbf <1,1,1,1> ]
		[ 0.95 White ]
	}
	scale .1
//	turbulence 10
}

#declare Grains = disc {
	<0,0,0>,y,1
	texture {
		pigment {
			wood
			ramp_wave
			pigment_map {
				[ 0.0 P_Grain1 ]
				[ 0.5 P_Grain1 ]
				[ 0.5 P_Grain2 ]
			}
			rotate x*90
		}
	}
	scale 5
	translate y*0.001
	translate x*(ChalkLen/2+ChalkR)
}
#end

#declare ChalkWithGrains = union {
	object { Chalk }
	object { Grains }
}
