/*
ChalkLine.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)

Uses the variable Clength

*/

#declare P_Chalk1 = pigment {
	bozo
	color_map {
		[ 0.0 rgbf < 1.0, 1.0, 1.0, 0.0 > ]
		[ 0.5 rgbf < 1.0, 1.0, 1.0, 0.0 > ]
		[ 0.5 rgbf < 1.0, 1.0, 1.0, 1.0 > ]
		[ 1.0 rgbf < 1.0, 1.0, 1.0, 1.0 > ]
	}
	turbulence 10
}

#declare P_Chalk2 = pigment {
	bozo
	color_map {
		[ 0.0 rgbf < 1.0, 1.0, 1.0, 0.0 > ]
		[ 0.9 rgbf < 1.0, 1.0, 1.0, 0.0 > ]
		[ 0.9 rgbf < 1.0, 1.0, 1.0, 1.0 > ]
		[ 1.0 rgbf < 1.0, 1.0, 1.0, 1.0 > ]
	}
	turbulence 10
}

#declare ChalkLine = union {
	object {
		Square
		texture {
			pigment {
				gradient y
				triangle_wave
				pigment_map {
					[ 0.0 P_Chalk1 ]
					[ 0.3 P_Chalk1 ]
					[ 0.6 P_Chalk2 ]
				}
			}
		}
		translate y*-.5
		scale < Clength, 5, 1 >
	}
	disc {
		<0,0,0>,z,1
		pigment {
			wood
			ramp_wave
			pigment_map {
				[ 0.0 P_Chalk1 ]
				[ 0.3 P_Chalk1 ]
				[ 0.6 P_Chalk2 ]
			}
		}
		scale 2.5
		clipped_by { plane { x,0 } }
	}
	disc {
		<0,0,0>,z,1
		pigment {
			wood
			ramp_wave
			pigment_map {
				[ 0.0 P_Chalk1 ]
				[ 0.3 P_Chalk1 ]
				[ 0.6 P_Chalk2 ]
			}
		}
		scale 2.5
		clipped_by { plane { -x,0 } }
		translate x*Clength
	}
	rotate x*90
}
