/*
Cue.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/


#declare CueLength = 1050

#declare T_Cue1 = texture {
	pigment { color Black }
	finish {
		specular 0.7
		roughness 0.05
	}
}

#declare T_Cue2 = texture {
	pigment { color rgb < 1.0, 1.0, 0.9 > }
	finish {
		specular 0.7
		roughness 0.05
	}
}

#declare T_Cue3 = texture {
	T_Wood1
	finish {
		specular 0.5
		roughness 0.05
	}
	rotate x*90
	scale 10/CueLength
}

#declare T_Cue4 = texture {
	pigment {
		bozo
		color_map {
			[ 0.0 Black ]
			[ 0.8 Black ]
			[ 1.0 White ]
		}
		scale 10/CueLength
	}
	finish {
		specular 0.2
		roughness 0.1
	}
}

#declare T_Cue5 = texture {
	pigment {
		color Black
	}
}

#declare Cue = sor {
	6
	<0,0>,<6,2>,<7,3>,<12,1020>,<8,1028>,<7,1030>
	sturm
	texture {
		gradient y
		texture_map {
			[ 0											T_Cue1 ]
			[     5/CueLength				T_Cue1 ]
			[     5/CueLength				T_Cue2 ]
			[    25/CueLength				T_Cue2 ]
			[    25/CueLength				T_Cue3 ]
			[   650/CueLength				T_Cue3 ]
			[   650/CueLength				T_Cue4 ]
			[  1020/CueLength				T_Cue4 ]
			[  1020/CueLength				T_Cue5 ]
		}
		scale CueLength
	}
}
