#declare PLen = 70		// height (half the width) of the protractor
#declare PLinT = 0.4		// line thickness

#declare T_Protractor = texture {
#if(1)
	pigment { color rgbf < 0.2,1.0,0.2,0.8 > }
	finish {
		reflection 0.15
		specular 0.4
		roughness 0.01
	}
	normal {
		bumps 0.3 scale 2000
	}
#else
	pigment { color White }
	finish {
		reflection 0.15
	}
#end
}

#declare T_PTLines = texture {
	pigment { color rgb < 0.0, 0.0, 0.0 > }
}

#declare Protractor = union {
	merge {
		intersection {		// half circle
			//cylinder { < 0,0,0.00 >,<0,0,1.4998>,PLen }
			plane { -y,0 }
			cone { < 0,0,0.0>, PLen*.90, <0,0,1.4998>, PLen }
		}
		box { <-PLen,-PLen*0.1,0.00>,<PLen,0.01,1.4998> }
		texture { T_Protractor }
	}
	union {
		#declare ang = 0
		#while(ang<180)
		#switch(ang)
			#case(0)
				#declare PLiS = -PLen*0.995	// horizontal line
				#break
			#case(45)
			#case(135)
				#declare PLiS = PLen * 0.25
				#break
			#case(90)
				#declare PLiS = PLen * -0.05
				#break
			#else
				#declare PLiS = PLen * (mod(ang,10)=0 ? 0.90 : 0.95)
		#end
		#declare PLiE = PLen*0.995

		polygon {
			5
			< PLiS,0    >,< PLiE,0    >,
			< PLiE,PLinT>,< PLiS,PLinT>,
			< PLiS,0    >
			rotate z*ang
			translate z*1.4999
			texture { T_PTLines }
		}
		#declare ang=ang+5
		#end
		#declare ang=10
		#while(ang<180)
		text {
			#declare txta = ((ang<90) ? ang : 180-ang)
			ttf "cour.ttf",
			str(txta,2,0),
			0.01,0
			translate x*-.53
			scale < 5,5,1 >
			rotate z*-90
			translate x*PLen*.85
			rotate z*ang
			translate z*1.4999
		}
		#declare ang=ang+10
		#end
		disc {
			< 0,0,0 >,z,PLen*0.80,PLen*0.80-PLinT
			translate z*1.4999
			clipped_by { plane { -y,0 } }
			texture { T_PTLines }
		}
	}
	translate z*-1.5
}
