// Room.inc

#declare RoomW = 6000
#declare RoomD = 6000
#declare RoomH = 2400
#declare WallT = 150
#declare WallPaneW = 400

#declare Wall = intersection {
	plane { -z, 0 }
	plane {  z, WallT }
	texture {
		pigment {
			wood
			color_map {
				[0.0 color rgb <0.88, 0.60, 0.40> ]
				[0.1 color rgb <0.88, 0.60, 0.40> ]
				[0.9 color rgb <0.60, 0.30, 0.20> ]
			}
			rotate x*90
			turbulence 0.4
			octaves 3
			scale < 100,400,100 >
			warp { repeat x*WallPaneW offset <40,33,190> }
		}
		finish {
			phong 0.5
			phong_size 60
			brilliance 4
		}
		normal {
			gradient x
			slope_map {
				[0.00 <0, 1>]
				[0.02 <1, 1>]
				[0.02 <1, 0>]
				[0.98 <1, 0>]
				[0.98 <1,-1>]
				[1.00 <0,-1>]
			}
			bump_size 5
			scale WallPaneW
		}
	}
}

#declare Floor = polygon {
	5
	<0,0,0>,
	<RoomW,0,0>,
	<RoomW,0,RoomD>,
	<0,0,RoomD>,
	<0,0,0>
	texture {
		pigment { checker color Brown,color Brown*0.6 scale 100 }
	}
}

#declare Ceiling = polygon {
	5
	<0,RoomH,0>,
	<RoomW,RoomH,0>,
	<RoomW,RoomH,RoomD>,
	<0,RoomH,RoomD>,
	<0,RoomH,0>
	texture {
		pigment {
			brick color White*0.4,color White*0.5
			brick_size < 1000,400,400 >
			mortar 20
			rotate x*90
		}
	}
}

#declare Room = intersection {
	union {
		object { Wall translate z*RoomD }
		object { Wall rotate y*90 translate x*RoomW }
		object { Wall rotate y*-90 }
		object { Wall rotate y*180 }
		object { Floor }
		object { Ceiling }
	}
	box {
		<-WallT,-WallT,-WallT>
		<RoomW+WallT,RoomH+WallT,RoomD+WallT>
	}
}
