/*
TableFrame.inc

Copyright Martin Vilcans 1997
*/

#declare T_Filt = texture {
	pigment { color rgb < 0.01, 0.50, 0.01 > }
	finish {
		//brilliance 0.3
		ambient 0.3
		diffuse 0.4
	}
}

#declare big=100000

#declare Edge_r = 2
#declare Edge_a = (90-45)
#declare Edge_h = 25
#declare Edge_w = 30
#declare Edge_w2 = 80
#declare Edge_r2 = 4
#declare Edge_o  = tan(radians(90-Edge_a))*Edge_h

#declare offsx = sin(radians(Edge_a))*Edge_r
#declare offsy = -cos(radians(Edge_a))*Edge_r

#render concat("offsx=",str(offsx,10,2))

#declare FiltFrame = union {
	cylinder {
		< 0,0,-big>, <0,0,big>, Edge_r
		translate < 0, Edge_h-Edge_r >
	}
	//< -Edge_r, Edge_h-Edge_r, -big >, < -Edge_r, Edge_h-Edge_r, big >, Edge_r }
	intersection {
		plane { -y,0
			rotate z*Edge_a
			translate y*(Edge_h-Edge_r)
			translate < offsx,offsy >
		}
		plane { y,(Edge_h-Edge_r-(Edge_r*sin(radians(Edge_a)))) }
		plane { -x,Edge_w }
		plane { -y,0 }
	}
	intersection {
		plane {  y,Edge_h }
		plane {  x,0 }
		plane { -y,-Edge_h+Edge_r*2 }
		plane { -x,Edge_w-Edge_r2 }
	}
	cylinder {
		< -Edge_w+Edge_r2, Edge_h-Edge_r2, -big >, < -Edge_w+Edge_r2, Edge_h-Edge_r2, big >, Edge_r2
	}
	texture { T_Filt }
}

#declare TreeFrame = superellipsoid {
	<0.2,0.2>
	translate x*-1
	scale < Edge_w2/2, Edge_h, big >
	translate x*-Edge_w
	texture {
		T_Wood4 scale 50
		//pigment { checker color Red, color White scale < 50,100,150 > }
		finish {
			reflection 0.2
		}
	}
}

#declare TableFrame = union {
	object { FiltFrame }
	object { TreeFrame }
}

