/*
Window.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#declare big = 100000

#declare Window_Thick = 3
#declare Window_Width = 704
#declare Window_Height=960
#declare Frame_Width = 60
#declare Thin_Width = 30
#declare Glass_Width = Window_Width - 2*Frame_Width
#declare Glass_Height = Window_Height - 2*Frame_Width

#render concat("Glass_Width = ",str(Glass_Width,5,2),"\n")
#render concat("Glass_Height= ",str(Glass_Height,5,2),"\n")


#declare T_WindowFrame =
	texture {
		pigment { color rgb <1.00,1.00,0.90> }
		finish {
			diffuse 0.4
			ambient 0.4
			reflection 0.1
			specular 0.9
			roughness 0.005
		}
		normal {
			//wood
			bumps
			bump_size 0.3
			scale < 1,10,1>
			turbulence 0.1
			/*turbulence 0.1		// copied from P_WoodGrain3B
			octaves 5
			lambda 3.25
			scale <0.15, .5, 1>
			rotate <5, 10, 5>
			translate -x*2
			scale 4
			rotate x*90*/
		}
	}

#declare WindowFrame = intersection {
	union {
		// ppningsbar del:
		box { < 0,-big,-10 > < Frame_Width-10,big,10 > }
		cylinder { < Frame_Width-10, -big, -5>, <Frame_Width-10, big,-5>, 5 }
		cylinder { < Frame_Width-5,  -big,  0>, <Frame_Width-5,  big, 0>, 5 }
		cylinder { < Frame_Width-10, -big,  5>, <Frame_Width-10, big, 5>, 5 }

		// del av vggen:
		cylinder { < -10, -big,  -10>, < -10, big, -10>, 15 }
		box { <-50,-big,-25>, < -10,big,10> }
	}
	box { < Frame_Width-10, -big, -Window_Thick/2 >, < Frame_Width+1, big, Window_Thick/2 > inverse }
	//texture { T_Wood8 rotate x*90 }
	texture { T_WindowFrame }
}

#declare ThinFrame = intersection {
	union {
		cylinder { < 0,-big,-5 >, < 0, big, -5>, 5 }
		cylinder { < 0,-big, 0 >, < 0, big,  0>, 5 scale < Thin_Width/10,1,1 > }
	}
	box { < -15, -big, -Window_Thick/2 >, < 15,big,Window_Thick/2 > inverse }	// make room for the glass
	texture { T_WindowFrame }
}

#declare Window = union {
	box {			// glass
		< 0,0,-Window_Thick/2 > < Glass_Width, Glass_Height, Window_Thick/2>
		texture {
			pigment { color rgbf < 1.0, 1.0, 1.0, 0.9 > }
			finish {
				specular 1
				roughness 0.001
				ambient 0
				diffuse 0
				//reflection 0.1
				//refraction on
		    //ior 1.5
			}
		}
		translate < Frame_Width, Frame_Width >
	}
	intersection {		// left frame
		object { WindowFrame }
		plane { -y 0 rotate z* 45 }
		plane {  y 0 rotate z*-45 translate y*Window_Height }
	}
	intersection {		// right frame
		object { WindowFrame }
		plane { -y 0 rotate z* 45 }
		plane {  y 0 rotate z*-45 translate y*Window_Height }
		scale < -1,1,1 >
		translate x*Window_Width
	}
	intersection {		// lower frame
		object { WindowFrame }
		plane { -y 0 rotate z* 45 }
		plane {  y 0 rotate z*-45 translate y*Window_Width }
		rotate z*90
		translate x*Window_Width
 	}
	intersection {		// upper frame
		object { WindowFrame }
		plane { -y 0 rotate z* 45 }
		plane {  y 0 rotate z*-45 translate y*Window_Width }
		scale < -1,1,1 >
		rotate z*90
		translate y*Window_Height
		translate x*Window_Width
	}
	intersection {		// middle vertical frame
		object { ThinFrame }
		plane {  y,Window_Height }
		plane { -y,0 }
		translate x*(Window_Width/2)
	}
	intersection {
		object { ThinFrame }
		plane {  y,Window_Width }
		plane { -y,0 }
		rotate z*-90
		translate y*(Frame_Width + (Glass_Height/3))
	}
	intersection {
		object { ThinFrame }
		plane {  y,Window_Width }
		plane { -y,0 }
		rotate z*-90
		translate y*(Frame_Width + (Glass_Height*2/3))
	}
}
