// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare sjedalo = texture {pigment {colour rgb < 0.2, 0.2, 0.2>}
finish {ambient 0.25 diffuse 0.6 specular 0.3 roughness 0.1}
normal {bumps 0.25 scale 0.02}}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<24.9285, -4.9151, -3.0763> <24.9947, -4.9160, -2.9603> <25.0243, -4.9519, -2.7230> <25.1491, -4.9181, -2.6897>
		<24.8848, -4.7865, -3.0265> <24.9509, -4.7874, -2.9105> <24.9908, -4.8263, -2.6579> <25.1156, -4.7924, -2.6247>
		<24.8339, -4.6042, -2.9760> <24.9035, -4.6051, -2.8540> <24.9351, -4.6327, -2.5924> <25.0700, -4.6080, -2.5624>
		<24.8099, -4.4625, -2.9595> <24.8795, -4.4634, -2.8375> <24.9069, -4.4903, -2.5829> <25.0419, -4.4656, -2.5528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<24.9285, -4.9151, -3.0763> <24.9751, -5.0518, -3.1292> <25.0551, -5.2122, -3.2325> <25.1086, -5.3399, -3.2995>
		<24.9947, -4.9160, -2.9603> <25.0412, -5.0527, -3.0133> <25.1052, -5.2129, -3.1447> <25.1588, -5.3406, -3.2116>
		<25.0243, -4.9519, -2.7230> <25.0619, -5.0930, -2.7961> <25.1390, -5.2417, -2.9371> <25.1812, -5.3678, -3.0319>
		<25.1491, -4.9181, -2.6897> <25.1867, -5.0592, -2.7628> <25.2335, -5.2160, -2.9119> <25.2757, -5.3421, -3.0067>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1491, -4.9181, -2.6897> <25.3485, -4.8640, -2.6366> <25.6579, -4.7582, -2.7068> <25.8009, -4.6786, -2.8438>
		<25.1156, -4.7924, -2.6247> <25.3150, -4.7384, -2.5715> <25.6694, -4.6414, -2.6548> <25.8124, -4.5618, -2.7917>
		<25.0700, -4.6080, -2.5624> <25.3167, -4.5628, -2.5075> <25.6886, -4.4698, -2.5738> <25.8720, -4.3977, -2.7385>
		<25.0419, -4.4656, -2.5528> <25.2886, -4.4204, -2.4980> <25.6735, -4.3428, -2.5620> <25.8568, -4.2708, -2.7266>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1491, -4.9181, -2.6897> <25.1867, -5.0592, -2.7628> <25.2335, -5.2160, -2.9119> <25.2757, -5.3421, -3.0067>
		<25.3485, -4.8640, -2.6366> <25.3862, -5.0051, -2.7096> <25.3846, -5.1751, -2.8716> <25.4267, -5.3012, -2.9665>
		<25.6579, -4.7582, -2.7068> <25.6429, -4.9106, -2.7747> <25.6665, -5.0715, -2.9334> <25.6604, -5.2161, -3.0176>
		<25.8009, -4.6786, -2.8438> <25.7859, -4.8310, -2.9117> <25.7754, -5.0162, -3.0392> <25.7693, -5.1608, -3.1234>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8009, -4.6786, -2.8438> <25.9663, -4.5866, -3.0021> <26.0720, -4.4512, -3.3291> <26.0701, -4.4054, -3.5716>
		<25.8124, -4.5618, -2.7917> <25.9778, -4.4698, -2.9501> <26.0869, -4.3450, -3.3091> <26.0850, -4.2991, -3.5517>
		<25.8720, -4.3977, -2.7385> <26.0531, -4.3266, -2.9010> <26.1271, -4.2010, -3.2754> <26.1252, -4.1540, -3.5245>
		<25.8568, -4.2708, -2.7266> <26.0379, -4.1997, -2.8892> <26.1037, -4.0963, -3.2554> <26.1018, -4.0492, -3.5046>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8009, -4.6786, -2.8438> <25.7859, -4.8310, -2.9117> <25.7754, -5.0162, -3.0392> <25.7693, -5.1608, -3.1234>
		<25.9663, -4.5866, -3.0021> <25.9513, -4.7389, -3.0701> <25.9003, -4.9527, -3.1604> <25.8941, -5.0974, -3.2446>
		<26.0720, -4.4512, -3.3291> <26.0473, -4.6272, -3.3622> <25.9990, -4.8481, -3.4663> <25.9715, -5.0237, -3.4993>
		<26.0701, -4.4054, -3.5716> <26.0455, -4.5814, -3.6047> <25.9976, -4.8137, -3.6483> <25.9702, -4.9893, -3.6813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<26.0701, -4.4054, -3.5716> <26.0683, -4.3595, -3.8142> <25.9576, -4.3665, -4.1664> <25.7896, -4.3948, -4.3451>
		<26.0850, -4.2991, -3.5517> <26.0832, -4.2533, -3.7942> <25.9686, -4.2387, -4.1724> <25.8007, -4.2671, -4.3511>
		<26.1252, -4.1540, -3.5245> <26.1233, -4.1069, -3.7737> <26.0436, -4.0873, -4.1669> <25.8599, -4.0947, -4.3416>
		<26.1018, -4.0492, -3.5046> <26.1000, -4.0021, -3.7537> <26.0286, -3.9648, -4.1313> <25.8449, -3.9722, -4.3060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<26.0701, -4.4054, -3.5716> <26.0455, -4.5814, -3.6047> <25.9976, -4.8137, -3.6483> <25.9702, -4.9893, -3.6813>
		<26.0683, -4.3595, -3.8142> <26.0437, -4.5355, -3.8473> <25.9962, -4.7793, -3.8302> <25.9688, -4.9549, -3.8632>
		<25.9576, -4.3665, -4.1664> <25.9432, -4.5331, -4.1586> <25.8928, -4.7653, -4.1518> <25.8875, -4.9307, -4.1261>
		<25.7896, -4.3948, -4.3451> <25.7752, -4.5615, -4.3372> <25.7661, -4.7805, -4.2860> <25.7607, -4.9459, -4.2603>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7896, -4.3948, -4.3451> <25.6444, -4.4194, -4.4995> <25.3338, -4.4930, -4.5990> <25.1350, -4.5633, -4.5664>
		<25.8007, -4.2671, -4.3511> <25.6555, -4.2916, -4.5055> <25.2997, -4.3524, -4.6133> <25.1009, -4.4227, -4.5806>
		<25.8599, -4.0947, -4.3416> <25.6740, -4.1021, -4.5185> <25.3009, -4.1656, -4.6087> <25.0550, -4.2283, -4.5706>
		<25.8449, -3.9722, -4.3060> <25.6590, -3.9797, -4.4829> <25.2730, -4.0296, -4.5653> <25.0271, -4.0924, -4.5271>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7896, -4.3948, -4.3451> <25.7752, -4.5615, -4.3372> <25.7661, -4.7805, -4.2860> <25.7607, -4.9459, -4.2603>
		<25.6444, -4.4194, -4.4995> <25.6300, -4.5860, -4.4917> <25.6555, -4.7937, -4.4031> <25.6501, -4.9591, -4.3774>
		<25.3338, -4.4930, -4.5990> <25.3721, -4.6510, -4.5831> <25.3724, -4.8684, -4.4943> <25.4155, -5.0202, -4.4526>
		<25.1350, -4.5633, -4.5664> <25.1733, -4.7213, -4.5504> <25.2218, -4.9216, -4.4696> <25.2650, -5.0735, -4.4279>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1350, -4.5633, -4.5664> <25.0106, -4.6073, -4.5460> <24.9846, -4.6606, -4.3115> <24.9201, -4.7023, -4.2023>
		<25.1009, -4.4227, -4.5806> <24.9765, -4.4667, -4.5602> <24.9404, -4.5228, -4.3103> <24.8759, -4.5645, -4.2011>
		<25.0550, -4.2283, -4.5706> <24.9204, -4.2627, -4.5497> <24.8927, -4.3326, -4.2957> <24.8249, -4.3764, -4.1808>
		<25.0271, -4.0924, -4.5271> <24.8925, -4.1267, -4.5062> <24.8688, -4.1947, -4.2590> <24.8010, -4.2386, -4.1441>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1350, -4.5633, -4.5664> <25.1733, -4.7213, -4.5504> <25.2218, -4.9216, -4.4696> <25.2650, -5.0735, -4.4279>
		<25.0106, -4.6073, -4.5460> <25.0489, -4.7653, -4.5300> <25.1276, -4.9549, -4.4541> <25.1708, -5.1068, -4.4124>
		<24.9846, -4.6606, -4.3115> <25.0315, -4.8070, -4.3128> <25.0969, -5.0040, -4.2498> <25.1511, -5.1471, -4.2349>
		<24.9201, -4.7023, -4.2023> <24.9670, -4.8487, -4.2035> <25.0481, -5.0356, -4.1671> <25.1022, -5.1787, -4.1522>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<24.8099, -4.4625, -2.9595> <24.8795, -4.4634, -2.8375> <24.9069, -4.4903, -2.5829> <25.0419, -4.4656, -2.5528>
		<24.7991, -4.3992, -2.9521> <24.8687, -4.4001, -2.8301> <24.8934, -4.4221, -2.5783> <25.0284, -4.3973, -2.5482>
		<24.7984, -4.3067, -2.9715> <24.8590, -4.3075, -2.8653> <24.9002, -4.3360, -2.6250> <25.0150, -4.3044, -2.5973>
		<24.8158, -4.2509, -2.9990> <24.8764, -4.2517, -2.8928> <24.9030, -4.2853, -2.6727> <25.0177, -4.2536, -2.6450>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.0419, -4.4656, -2.5528> <25.2886, -4.4204, -2.4980> <25.6735, -4.3428, -2.5620> <25.8568, -4.2708, -2.7266>
		<25.0284, -4.3973, -2.5482> <25.2751, -4.3522, -2.4934> <25.6626, -4.2518, -2.5535> <25.8459, -4.1798, -2.7181>
		<25.0150, -4.3044, -2.5973> <25.2286, -4.2454, -2.5457> <25.6091, -4.1411, -2.5909> <25.7691, -4.0625, -2.7323>
		<25.0177, -4.2536, -2.6450> <25.2313, -4.1947, -2.5934> <25.5600, -4.0801, -2.6392> <25.7199, -4.0015, -2.7806>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8568, -4.2708, -2.7266> <26.0379, -4.1997, -2.8892> <26.1037, -4.0963, -3.2554> <26.1018, -4.0492, -3.5046>
		<25.8459, -4.1798, -2.7181> <26.0270, -4.1086, -2.8807> <26.0844, -4.0096, -3.2389> <26.0825, -3.9625, -3.4880>
		<25.7691, -4.0625, -2.7323> <25.9245, -3.9861, -2.8698> <26.0145, -3.8898, -3.2487> <26.0128, -3.8487, -3.4660>
		<25.7199, -4.0015, -2.7806> <25.8753, -3.9251, -2.9181> <25.9373, -3.8436, -3.2394> <25.9357, -3.8025, -3.4567>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<26.1018, -4.0492, -3.5046> <26.1000, -4.0021, -3.7537> <26.0286, -3.9648, -4.1313> <25.8449, -3.9722, -4.3060>
		<26.0825, -3.9625, -3.4880> <26.0806, -3.9154, -3.7371> <26.0178, -3.8770, -4.1059> <25.8342, -3.8844, -4.2806>
		<26.0128, -3.8487, -3.4660> <26.0112, -3.8076, -3.6832> <25.9155, -3.7593, -4.0699> <25.7579, -3.7806, -4.2234>
		<25.9357, -3.8025, -3.4567> <25.9341, -3.7615, -3.6739> <25.8672, -3.7202, -4.0019> <25.7096, -3.7416, -4.1555>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8449, -3.9722, -4.3060> <25.6590, -3.9797, -4.4829> <25.2730, -4.0296, -4.5653> <25.0271, -4.0924, -4.5271>
		<25.8342, -3.8844, -4.2806> <25.6483, -3.8919, -4.4574> <25.2597, -3.9644, -4.5444> <25.0137, -4.0272, -4.5063>
		<25.7579, -3.7806, -4.2234> <25.5957, -3.8026, -4.3814> <25.2142, -3.8843, -4.4561> <25.0013, -3.9586, -4.4265>
		<25.7096, -3.7416, -4.1555> <25.5474, -3.7636, -4.3135> <25.2178, -3.8545, -4.3932> <25.0048, -3.9287, -4.3636>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.0271, -4.0924, -4.5271> <24.8925, -4.1267, -4.5062> <24.8688, -4.1947, -4.2590> <24.8010, -4.2386, -4.1441>
		<25.0137, -4.0272, -4.5063> <24.8791, -4.0615, -4.4854> <24.8581, -4.1331, -4.2426> <24.7903, -4.1770, -4.1277>
		<25.0013, -3.9586, -4.4265> <24.8868, -3.9985, -4.4106> <24.8491, -4.0598, -4.1759> <24.7901, -4.0979, -4.0759>
		<25.0048, -3.9287, -4.3636> <24.8904, -3.9687, -4.3477> <24.8671, -4.0178, -4.1302> <24.8080, -4.0560, -4.0301>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<24.8158, -4.2509, -2.9990> <24.8764, -4.2517, -2.8928> <24.9030, -4.2853, -2.6727> <25.0177, -4.2536, -2.6450>
		<24.8444, -4.1589, -3.0444> <24.9050, -4.1597, -2.9382> <24.9082, -4.1883, -2.7640> <25.0230, -4.1566, -2.7362>
		<24.9075, -4.0577, -3.1283> <24.9406, -4.0581, -3.0703> <24.9846, -4.0756, -2.9003> <25.0474, -4.0580, -2.8863>
		<24.9573, -3.9892, -3.1929> <24.9904, -3.9896, -3.1349> <25.0048, -4.0082, -3.0135> <25.0677, -3.9906, -2.9995>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.0177, -4.2536, -2.6450> <25.2313, -4.1947, -2.5934> <25.5600, -4.0801, -2.6392> <25.7199, -4.0015, -2.7806>
		<25.0230, -4.1566, -2.7362> <25.2366, -4.0977, -2.6846> <25.4964, -4.0012, -2.7016> <25.6564, -3.9226, -2.8430>
		<25.0474, -4.0580, -2.8863> <25.1804, -4.0209, -2.8568> <25.4810, -3.9135, -2.8971> <25.5816, -3.8646, -2.9833>
		<25.0677, -3.9906, -2.9995> <25.2006, -3.9535, -2.9699> <25.4058, -3.8846, -2.9846> <25.5064, -3.8357, -3.0708>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7199, -4.0015, -2.7806> <25.8753, -3.9251, -2.9181> <25.9373, -3.8436, -3.2394> <25.9357, -3.8025, -3.4567>
		<25.6564, -3.9226, -2.8430> <25.8118, -3.8462, -2.9805> <25.8458, -3.7888, -3.2284> <25.8442, -3.7478, -3.4456>
		<25.5816, -3.8646, -2.9833> <25.6653, -3.8240, -3.0550> <25.6923, -3.7641, -3.3281> <25.6914, -3.7423, -3.4434>
		<25.5064, -3.8357, -3.0708> <25.5900, -3.7950, -3.1424> <25.5852, -3.7613, -3.3267> <25.5843, -3.7395, -3.4421>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9357, -3.8025, -3.4567> <25.9341, -3.7615, -3.6739> <25.8672, -3.7202, -4.0019> <25.7096, -3.7416, -4.1555>
		<25.8442, -3.7478, -3.4456> <25.8426, -3.7067, -3.6629> <25.8048, -3.6697, -3.9141> <25.6472, -3.6911, -4.0677>
		<25.6914, -3.7423, -3.4434> <25.6906, -3.7205, -3.5588> <25.6595, -3.6766, -3.8345> <25.5746, -3.6885, -3.9149>
		<25.5843, -3.7395, -3.4421> <25.5834, -3.7177, -3.5575> <25.5855, -3.6818, -3.7414> <25.5007, -3.6937, -3.8218>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7096, -3.7416, -4.1555> <25.5474, -3.7636, -4.3135> <25.2178, -3.8545, -4.3932> <25.0048, -3.9287, -4.3636>
		<25.6472, -3.6911, -4.0677> <25.4850, -3.7131, -4.2257> <25.2247, -3.7974, -4.2729> <25.0117, -3.8717, -4.2433>
		<25.5746, -3.6885, -3.9149> <25.4727, -3.7029, -4.0115> <25.1712, -3.7889, -4.0839> <25.0386, -3.8347, -4.0680>
		<25.5007, -3.6937, -3.8218> <25.3988, -3.7081, -3.9184> <25.1932, -3.7674, -3.9542> <25.0606, -3.8132, -3.9383>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.0048, -3.9287, -4.3636> <24.8904, -3.9687, -4.3477> <24.8671, -4.0178, -4.1302> <24.8080, -4.0560, -4.0301>
		<25.0117, -3.8717, -4.2433> <24.8972, -3.9116, -4.2274> <24.8967, -3.9486, -4.0547> <24.8376, -3.9868, -3.9547>
		<25.0386, -3.8347, -4.0680> <24.9758, -3.8563, -4.0604> <24.9344, -3.9022, -3.8952> <24.9021, -3.9231, -3.8406>
		<25.0606, -3.8132, -3.9383> <24.9979, -3.8348, -3.9308> <24.9853, -3.8618, -3.8108> <24.9531, -3.8827, -3.7562>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1086, -5.3399, -3.2995> <25.1539, -5.4478, -3.3560> <25.2148, -5.5893, -3.4361> <25.2578, -5.7004, -3.4879>
		<25.1588, -5.3406, -3.2116> <25.2040, -5.4485, -3.2682> <25.2599, -5.5871, -3.3715> <25.3029, -5.6983, -3.4233>
		<25.1812, -5.3678, -3.0319> <25.2168, -5.4743, -3.1121> <25.2994, -5.6016, -3.2187> <25.3344, -5.7133, -3.2916>
		<25.2757, -5.3421, -3.0067> <25.3113, -5.4487, -3.0869> <25.3732, -5.5814, -3.1997> <25.4082, -5.6932, -3.2727>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.2757, -5.3421, -3.0067> <25.3113, -5.4487, -3.0869> <25.3732, -5.5814, -3.1997> <25.4082, -5.6932, -3.2727>
		<25.4267, -5.3012, -2.9665> <25.4623, -5.4077, -3.0466> <25.4822, -5.5517, -3.1717> <25.5171, -5.6635, -3.2447>
		<25.6604, -5.2161, -3.0176> <25.6552, -5.3367, -3.0878> <25.6789, -5.4789, -3.2165> <25.6852, -5.6023, -3.2814>
		<25.7693, -5.1608, -3.1234> <25.7641, -5.2814, -3.1935> <25.7568, -5.4391, -3.2932> <25.7631, -5.5625, -3.3581>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7693, -5.1608, -3.1234> <25.7641, -5.2814, -3.1935> <25.7568, -5.4391, -3.2932> <25.7631, -5.5625, -3.3581>
		<25.8941, -5.0974, -3.2446> <25.8889, -5.2180, -3.3148> <25.8473, -5.3929, -3.3823> <25.8536, -5.5163, -3.4472>
		<25.9715, -5.0237, -3.4993> <25.9506, -5.1578, -3.5245> <25.9178, -5.3272, -3.6073> <25.9098, -5.4627, -3.6328>
		<25.9702, -4.9893, -3.6813> <25.9492, -5.1234, -3.7065> <25.9168, -5.3021, -3.7400> <25.9088, -5.4376, -3.7656>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9702, -4.9893, -3.6813> <25.9492, -5.1234, -3.7065> <25.9168, -5.3021, -3.7400> <25.9088, -5.4376, -3.7656>
		<25.9688, -4.9549, -3.8632> <25.9478, -5.0890, -3.8884> <25.9158, -5.2770, -3.8728> <25.9078, -5.4125, -3.8983>
		<25.8875, -4.9307, -4.1261> <25.8830, -5.0686, -4.1047> <25.8419, -5.2562, -4.1051> <25.8488, -5.3948, -4.0898>
		<25.7607, -4.9459, -4.2603> <25.7563, -5.0837, -4.2389> <25.7500, -5.2670, -4.2036> <25.7569, -5.4056, -4.1883>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7607, -4.9459, -4.2603> <25.7563, -5.0837, -4.2389> <25.7500, -5.2670, -4.2036> <25.7569, -5.4056, -4.1883>
		<25.6501, -4.9591, -4.3774> <25.6457, -5.0970, -4.3560> <25.6709, -5.2762, -4.2884> <25.6778, -5.4148, -4.2731>
		<25.4155, -5.0202, -4.4526> <25.4520, -5.1486, -4.4175> <25.4733, -5.3282, -4.3538> <25.5090, -5.4588, -4.3272>
		<25.2650, -5.0735, -4.4279> <25.3015, -5.2018, -4.3927> <25.3647, -5.3664, -4.3370> <25.4004, -5.4970, -4.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.2650, -5.0735, -4.4279> <25.3015, -5.2018, -4.3927> <25.3647, -5.3664, -4.3370> <25.4004, -5.4970, -4.3104>
		<25.1708, -5.1068, -4.4124> <25.2073, -5.2351, -4.3773> <25.2911, -5.3923, -4.3257> <25.3268, -5.5229, -4.2990>
		<25.1511, -5.1471, -4.2349> <25.1968, -5.2681, -4.2223> <25.2538, -5.4347, -4.1775> <25.2973, -5.5570, -4.1705>
		<25.1022, -5.1787, -4.1522> <25.1480, -5.2997, -4.1396> <25.2096, -5.4604, -4.1176> <25.2531, -5.5827, -4.1105>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.2578, -5.7004, -3.4879> <25.3047, -5.8216, -3.5444> <25.3640, -5.9874, -3.6132> <25.4082, -6.1135, -3.6601>
		<25.3029, -5.6983, -3.4233> <25.3498, -5.8194, -3.4798> <25.3961, -5.9859, -3.5672> <25.4403, -6.1120, -3.6142>
		<25.3344, -5.7133, -3.2916> <25.3715, -5.8321, -3.3692> <25.4280, -5.9952, -3.4565> <25.4625, -6.1230, -3.5193>
		<25.4082, -5.6932, -3.2727> <25.4453, -5.8119, -3.3502> <25.4807, -5.9805, -3.4441> <25.5152, -6.1084, -3.5070>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.4082, -5.6932, -3.2727> <25.4453, -5.8119, -3.3502> <25.4807, -5.9805, -3.4441> <25.5152, -6.1084, -3.5070>
		<25.5171, -5.6635, -3.2447> <25.5542, -5.7822, -3.3222> <25.5712, -5.9554, -3.4229> <25.6057, -6.0833, -3.4858>
		<25.6852, -5.6023, -3.2814> <25.6918, -5.7317, -3.3495> <25.7251, -5.9009, -3.4501> <25.7440, -6.0348, -3.5062>
		<25.7631, -5.5625, -3.3581> <25.7697, -5.6919, -3.4262> <25.7933, -5.8676, -3.5094> <25.8121, -6.0015, -3.5655>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7631, -5.5625, -3.3581> <25.7697, -5.6919, -3.4262> <25.7933, -5.8676, -3.5094> <25.8121, -6.0015, -3.5655>
		<25.8536, -5.5163, -3.4472> <25.8602, -5.6457, -3.5153> <25.8613, -5.8344, -3.5686> <25.8802, -5.9683, -3.6247>
		<25.9098, -5.4627, -3.6328> <25.9014, -5.6050, -3.6596> <25.9075, -5.7882, -3.7340> <25.9165, -5.9305, -3.7610>
		<25.9088, -5.4376, -3.7656> <25.9004, -5.5799, -3.7924> <25.9068, -5.7704, -3.8285> <25.9158, -5.9126, -3.8554>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9088, -5.4376, -3.7656> <25.9004, -5.5799, -3.7924> <25.9068, -5.7704, -3.8285> <25.9158, -5.9126, -3.8554>
		<25.9078, -5.4125, -3.8983> <25.8995, -5.5548, -3.9251> <25.9061, -5.7525, -3.9229> <25.9151, -5.8948, -3.9499>
		<25.8488, -5.3948, -4.0898> <25.8560, -5.5402, -4.0738> <25.8574, -5.7352, -4.0931> <25.8767, -5.8803, -4.0900>
		<25.7569, -5.4056, -4.1883> <25.7641, -5.5509, -4.1723> <25.7884, -5.7448, -4.1593> <25.8077, -5.8899, -4.1562>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7569, -5.4056, -4.1883> <25.7641, -5.5509, -4.1723> <25.7884, -5.7448, -4.1593> <25.8077, -5.8899, -4.1562>
		<25.6778, -5.4148, -4.2731> <25.6850, -5.5602, -4.2571> <25.7193, -5.7543, -4.2257> <25.7386, -5.8994, -4.2226>
		<25.5090, -5.4588, -4.3272> <25.5469, -5.5976, -4.2989> <25.5648, -5.7956, -4.2686> <25.5999, -5.9374, -4.2573>
		<25.4004, -5.4970, -4.3104> <25.4383, -5.6358, -4.2821> <25.4745, -5.8269, -4.2567> <25.5097, -5.9688, -4.2454>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.4004, -5.4970, -4.3104> <25.4383, -5.6358, -4.2821> <25.4745, -5.8269, -4.2567> <25.5097, -5.9688, -4.2454>
		<25.3268, -5.5229, -4.2990> <25.3647, -5.6616, -4.2708> <25.4220, -5.8452, -4.2498> <25.4571, -5.9870, -4.2385>
		<25.2973, -5.5570, -4.1705> <25.3447, -5.6903, -4.1628> <25.3918, -5.8771, -4.1429> <25.4363, -6.0115, -4.1458>
		<25.2531, -5.5827, -4.1105> <25.3005, -5.7160, -4.1028> <25.3603, -5.8953, -4.1002> <25.4049, -6.0298, -4.1032>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.4082, -6.1135, -3.6601> <25.4480, -6.2270, -3.7024> <25.4979, -6.3816, -3.7530> <25.5378, -6.4983, -3.7852>
		<25.4403, -6.1120, -3.6142> <25.4801, -6.2254, -3.6565> <25.5239, -6.3801, -3.7173> <25.5638, -6.4967, -3.7495>
		<25.4625, -6.1230, -3.5193> <25.4930, -6.2356, -3.5747> <25.5472, -6.3870, -3.6362> <25.5828, -6.5048, -3.6752>
		<25.5152, -6.1084, -3.5070> <25.5457, -6.2210, -3.5624> <25.5889, -6.3753, -3.6271> <25.6245, -6.4932, -3.6661>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.5152, -6.1084, -3.5070> <25.5457, -6.2210, -3.5624> <25.5889, -6.3753, -3.6271> <25.6245, -6.4932, -3.6661>
		<25.6057, -6.0833, -3.4858> <25.6362, -6.1959, -3.5412> <25.6670, -6.3534, -3.6100> <25.7026, -6.4713, -3.6491>
		<25.7440, -6.0348, -3.5062> <25.7607, -6.1532, -3.5559> <25.7959, -6.3091, -3.6257> <25.8205, -6.4308, -3.6621>
		<25.8121, -6.0015, -3.5655> <25.8288, -6.1199, -3.6151> <25.8569, -6.2802, -3.6738> <25.8815, -6.4019, -3.7102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8121, -6.0015, -3.5655> <25.8288, -6.1199, -3.6151> <25.8569, -6.2802, -3.6738> <25.8815, -6.4019, -3.7102>
		<25.8802, -5.9683, -3.6247> <25.8969, -6.0866, -3.6743> <25.9121, -6.2541, -3.7173> <25.9367, -6.3758, -3.7537>
		<25.9165, -5.9305, -3.7610> <25.9245, -6.0568, -3.7849> <25.9461, -6.2207, -3.8375> <25.9662, -6.3457, -3.8613>
		<25.9158, -5.9126, -3.8554> <25.9238, -6.0390, -3.8794> <25.9455, -6.2067, -3.9112> <25.9656, -6.3318, -3.9350>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9158, -5.9126, -3.8554> <25.9238, -6.0390, -3.8794> <25.9455, -6.2067, -3.9112> <25.9656, -6.3318, -3.9350>
		<25.9151, -5.8948, -3.9499> <25.9231, -6.0211, -3.9738> <25.9450, -6.1928, -3.9850> <25.9651, -6.3178, -4.0087>
		<25.8767, -5.8803, -4.0900> <25.8938, -6.0086, -4.0872> <25.9092, -6.1801, -4.1085> <25.9340, -6.3066, -4.1195>
		<25.8077, -5.8899, -4.1562> <25.8248, -6.0181, -4.1535> <25.8533, -6.1887, -4.1578> <25.8781, -6.3152, -4.1687>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8077, -5.8899, -4.1562> <25.8248, -6.0181, -4.1535> <25.8533, -6.1887, -4.1578> <25.8781, -6.3152, -4.1687>
		<25.7386, -5.8994, -4.2226> <25.7557, -6.0276, -4.2198> <25.7915, -6.1982, -4.2122> <25.8163, -6.3247, -4.2231>
		<25.5999, -5.9374, -4.2573> <25.6309, -6.0624, -4.2473> <25.6622, -6.2341, -4.2411> <25.6981, -6.3580, -4.2483>
		<25.5097, -5.9688, -4.2454> <25.5406, -6.0938, -4.2354> <25.5843, -6.2609, -4.2321> <25.6202, -6.3848, -4.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.5097, -5.9688, -4.2454> <25.5406, -6.0938, -4.2354> <25.5843, -6.2609, -4.2321> <25.6202, -6.3848, -4.2393>
		<25.4571, -5.9870, -4.2385> <25.4881, -6.1120, -4.2284> <25.5428, -6.2752, -4.2273> <25.5786, -6.3991, -4.2345>
		<25.4363, -6.0115, -4.1458> <25.4764, -6.1324, -4.1485> <25.5206, -6.2985, -4.1489> <25.5607, -6.4187, -4.1621>
		<25.4049, -6.0298, -4.1032> <25.4450, -6.1507, -4.1058> <25.4952, -6.3130, -4.1159> <25.5352, -6.4333, -4.1291>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.5378, -6.4983, -3.7852> <25.5876, -6.6440, -3.8254> <25.6453, -6.8478, -3.8568> <25.7071, -6.9876, -3.9012>
		<25.5638, -6.4967, -3.7495> <25.6136, -6.6425, -3.7896> <25.6671, -6.8467, -3.8256> <25.7289, -6.9865, -3.8700>
		<25.5828, -6.5048, -3.6752> <25.6268, -6.6503, -3.7234> <25.6914, -6.8543, -3.7494> <25.7440, -6.9941, -3.8052>
		<25.6245, -6.4932, -3.6661> <25.6684, -6.6386, -3.7143> <25.7272, -6.8443, -3.7413> <25.7798, -6.9841, -3.7971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.6245, -6.4932, -3.6661> <25.6684, -6.6386, -3.7143> <25.7272, -6.8443, -3.7413> <25.7798, -6.9841, -3.7971>
		<25.7026, -6.4713, -3.6491> <25.7465, -6.6167, -3.6973> <25.7928, -6.8260, -3.7266> <25.8453, -6.9658, -3.7823>
		<25.8205, -6.4308, -3.6621> <25.8509, -6.5812, -3.7070> <25.9188, -6.7823, -3.7431> <25.9449, -6.9314, -3.7946>
		<25.8815, -6.4019, -3.7102> <25.9119, -6.5523, -3.7551> <25.9692, -6.7581, -3.7846> <25.9952, -6.9072, -3.8362>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8815, -6.4019, -3.7102> <25.9119, -6.5523, -3.7551> <25.9692, -6.7581, -3.7846> <25.9952, -6.9072, -3.8362>
		<25.9367, -6.3758, -3.7537> <25.9672, -6.5262, -3.7987> <26.0164, -6.7354, -3.8236> <26.0425, -6.8845, -3.8752>
		<25.9662, -6.3457, -3.8613> <25.9911, -6.5011, -3.8909> <26.0487, -6.7026, -3.9393> <26.0661, -6.8589, -3.9690>
		<25.9656, -6.3318, -3.9350> <25.9905, -6.4872, -3.9646> <26.0482, -6.6904, -4.0034> <26.0657, -6.8468, -4.0331>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9656, -6.3318, -3.9350> <25.9905, -6.4872, -3.9646> <26.0482, -6.6904, -4.0034> <26.0657, -6.8468, -4.0331>
		<25.9651, -6.3178, -4.0087> <25.9900, -6.4732, -4.0383> <26.0478, -6.6783, -4.0676> <26.0652, -6.8347, -4.0973>
		<25.9340, -6.3066, -4.1195> <25.9646, -6.4630, -4.1330> <26.0137, -6.6668, -4.1868> <26.0401, -6.8243, -4.1936>
		<25.8781, -6.3152, -4.1687> <25.9087, -6.4716, -4.1822> <25.9658, -6.6738, -4.2307> <25.9922, -6.8313, -4.2375>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8781, -6.3152, -4.1687> <25.9087, -6.4716, -4.1822> <25.9658, -6.6738, -4.2307> <25.9922, -6.8313, -4.2375>
		<25.8163, -6.3247, -4.2231> <25.8469, -6.4811, -4.2366> <25.9148, -6.6812, -4.2775> <25.9412, -6.8388, -4.2843>
		<25.6981, -6.3580, -4.2483> <25.7423, -6.5108, -4.2572> <25.7884, -6.7163, -4.3070> <25.8414, -6.8666, -4.3068>
		<25.6202, -6.3848, -4.2393> <25.6644, -6.5377, -4.2482> <25.7231, -6.7389, -4.2989> <25.7761, -6.8892, -4.2988>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.6202, -6.3848, -4.2393> <25.6644, -6.5377, -4.2482> <25.7231, -6.7389, -4.2989> <25.7761, -6.8892, -4.2988>
		<25.5786, -6.3991, -4.2345> <25.6229, -6.5520, -4.2434> <25.6873, -6.7513, -4.2945> <25.7403, -6.9016, -4.2944>
		<25.5607, -6.4187, -4.1621> <25.6107, -6.5689, -4.1787> <25.6641, -6.7721, -4.2205> <25.7262, -6.9182, -4.2311>
		<25.5352, -6.4333, -4.1291> <25.5852, -6.5835, -4.1456> <25.6428, -6.7845, -4.1915> <25.7049, -6.9307, -4.2022>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7071, -6.9876, -3.9012> <25.7275, -7.0336, -3.9158> <25.7731, -7.0794, -3.9510> <25.8074, -7.1079, -3.9786>
		<25.7289, -6.9865, -3.8700> <25.7493, -7.0326, -3.8846> <25.7874, -7.0788, -3.9306> <25.8217, -7.1072, -3.9582>
		<25.7440, -6.9941, -3.8052> <25.7620, -7.0421, -3.8244> <25.8083, -7.0842, -3.8750> <25.8315, -7.1122, -3.9159>
		<25.7798, -6.9841, -3.7971> <25.7979, -7.0321, -3.8163> <25.8317, -7.0776, -3.8697> <25.8549, -7.1056, -3.9106>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7798, -6.9841, -3.7971> <25.7979, -7.0321, -3.8163> <25.8317, -7.0776, -3.8697> <25.8549, -7.1056, -3.9106>
		<25.8453, -6.9658, -3.7823> <25.8634, -7.0138, -3.8015> <25.8746, -7.0657, -3.8600> <25.8978, -7.0937, -3.9009>
		<25.9449, -6.9314, -3.7946> <25.9536, -6.9814, -3.8119> <25.9692, -7.0321, -3.8728> <25.9629, -7.0712, -3.9090>
		<25.9952, -6.9072, -3.8362> <26.0040, -6.9572, -3.8535> <26.0021, -7.0163, -3.9000> <25.9958, -7.0554, -3.9361>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9952, -6.9072, -3.8362> <26.0040, -6.9572, -3.8535> <26.0021, -7.0163, -3.9000> <25.9958, -7.0554, -3.9361>
		<26.0425, -6.8845, -3.8752> <26.0512, -6.9345, -3.8925> <26.0330, -7.0014, -3.9255> <26.0267, -7.0405, -3.9616>
		<26.0661, -6.8589, -3.9690> <26.0718, -6.9098, -3.9786> <26.0586, -6.9752, -4.0139> <26.0421, -7.0238, -4.0230>
		<26.0657, -6.8468, -4.0331> <26.0713, -6.8977, -4.0428> <26.0583, -6.9673, -4.0559> <26.0418, -7.0159, -4.0649>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<26.0657, -6.8468, -4.0331> <26.0713, -6.8977, -4.0428> <26.0583, -6.9673, -4.0559> <26.0418, -7.0159, -4.0649>
		<26.0652, -6.8347, -4.0973> <26.0708, -6.8856, -4.1070> <26.0580, -6.9593, -4.0978> <26.0415, -7.0079, -4.1069>
		<26.0401, -6.8243, -4.1936> <26.0489, -6.8772, -4.1959> <26.0310, -6.9516, -4.1893> <26.0251, -7.0012, -4.1698>
		<25.9922, -6.8313, -4.2375> <26.0011, -6.8842, -4.2398> <25.9997, -6.9562, -4.2180> <25.9938, -7.0058, -4.1985>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9922, -6.8313, -4.2375> <26.0011, -6.8842, -4.2398> <25.9997, -6.9562, -4.2180> <25.9938, -7.0058, -4.1985>
		<25.9412, -6.8388, -4.2843> <25.9501, -6.8916, -4.2866> <25.9664, -6.9610, -4.2486> <25.9605, -7.0106, -4.2291>
		<25.8414, -6.8666, -4.3068> <25.8596, -6.9183, -4.3068> <25.8715, -6.9879, -4.2714> <25.8952, -7.0288, -4.2439>
		<25.7761, -6.8892, -4.2988> <25.7943, -6.9409, -4.2987> <25.8288, -7.0027, -4.2662> <25.8525, -7.0436, -4.2386>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.7761, -6.8892, -4.2988> <25.7943, -6.9409, -4.2987> <25.8288, -7.0027, -4.2662> <25.8525, -7.0436, -4.2386>
		<25.7403, -6.9016, -4.2944> <25.7585, -6.9532, -4.2943> <25.8054, -7.0108, -4.2633> <25.8291, -7.0517, -4.2357>
		<25.7262, -6.9182, -4.2311> <25.7467, -6.9664, -4.2346> <25.7853, -7.0261, -4.2092> <25.8199, -7.0626, -4.1944>
		<25.7049, -6.9307, -4.2022> <25.7253, -6.9788, -4.2057> <25.7713, -7.0342, -4.1903> <25.8059, -7.0707, -4.1754>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.8882, -7.1380, -4.0473> <25.8938, -7.1378, -4.0394> <25.8976, -7.1397, -4.0230> <25.9067, -7.1371, -4.0210>
		<25.8640, -7.1290, -4.0267> <25.8695, -7.1287, -4.0188> <25.8821, -7.1302, -3.9899> <25.8911, -7.1277, -3.9878>
		<25.8290, -7.1259, -3.9961> <25.8433, -7.1252, -3.9757> <25.8475, -7.1315, -3.9441> <25.8709, -7.1249, -3.9388>
		<25.8074, -7.1079, -3.9786> <25.8217, -7.1072, -3.9582> <25.8315, -7.1122, -3.9159> <25.8549, -7.1056, -3.9106>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9067, -7.1371, -4.0210> <25.9233, -7.1325, -4.0172> <25.9485, -7.1238, -4.0203> <25.9613, -7.1176, -4.0309>
		<25.8911, -7.1277, -3.9878> <25.9078, -7.1230, -3.9841> <25.9589, -7.1051, -3.9919> <25.9716, -7.0990, -4.0024>
		<25.8709, -7.1249, -3.9388> <25.9138, -7.1130, -3.9292> <25.9587, -7.0971, -3.9329> <25.9916, -7.0813, -3.9601>
		<25.8549, -7.1056, -3.9106> <25.8978, -7.0937, -3.9009> <25.9629, -7.0712, -3.9090> <25.9958, -7.0554, -3.9361>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9613, -7.1176, -4.0309> <25.9733, -7.1119, -4.0407> <25.9793, -7.1054, -4.0645> <25.9791, -7.1023, -4.0808>
		<25.9716, -7.0990, -4.0024> <25.9836, -7.0932, -4.0123> <25.9981, -7.0795, -4.0598> <25.9979, -7.0764, -4.0760>
		<25.9916, -7.0813, -3.9601> <26.0225, -7.0664, -3.9856> <26.0319, -7.0540, -4.0286> <26.0316, -7.0461, -4.0705>
		<25.9958, -7.0554, -3.9361> <26.0267, -7.0405, -3.9616> <26.0421, -7.0238, -4.0230> <26.0418, -7.0159, -4.0649>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9791, -7.1023, -4.0808> <25.9790, -7.0993, -4.0971> <25.9727, -7.0966, -4.1215> <25.9605, -7.0984, -4.1326>
		<25.9979, -7.0764, -4.0760> <25.9978, -7.0733, -4.0923> <25.9826, -7.0688, -4.1413> <25.9705, -7.0706, -4.1524>
		<26.0316, -7.0461, -4.0705> <26.0313, -7.0382, -4.1125> <26.0212, -7.0341, -4.1569> <25.9899, -7.0386, -4.1856>
		<26.0418, -7.0159, -4.0649> <26.0415, -7.0079, -4.1069> <26.0251, -7.0012, -4.1698> <25.9938, -7.0058, -4.1985>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9605, -7.0984, -4.1326> <25.9476, -7.1003, -4.1445> <25.9223, -7.1074, -4.1502> <25.9057, -7.1131, -4.1481>
		<25.9705, -7.0706, -4.1524> <25.9576, -7.0725, -4.1642> <25.9063, -7.0865, -4.1773> <25.8897, -7.0922, -4.1753>
		<25.9899, -7.0386, -4.1856> <25.9566, -7.0435, -4.2162> <25.9116, -7.0571, -4.2249> <25.8688, -7.0719, -4.2196>
		<25.9938, -7.0058, -4.1985> <25.9605, -7.0106, -4.2291> <25.8952, -7.0288, -4.2439> <25.8525, -7.0436, -4.2386>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.9057, -7.1131, -4.1481> <25.8966, -7.1162, -4.1470> <25.8931, -7.1204, -4.1310> <25.8877, -7.1236, -4.1236>
		<25.8897, -7.0922, -4.1753> <25.8807, -7.0954, -4.1742> <25.8686, -7.1046, -4.1465> <25.8631, -7.1077, -4.1392>
		<25.8688, -7.0719, -4.2196> <25.8454, -7.0799, -4.2167> <25.8417, -7.0856, -4.1850> <25.8277, -7.0937, -4.1661>
		<25.8525, -7.0436, -4.2386> <25.8291, -7.0517, -4.2357> <25.8199, -7.0626, -4.1944> <25.8059, -7.0707, -4.1754>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1202, -3.8323, -3.3934> <25.0714, -3.8793, -3.3333> <24.9998, -3.9308, -3.2479> <24.9573, -3.9892, -3.1929>
		<25.1274, -3.8324, -3.3810> <25.0785, -3.8794, -3.3208> <25.0329, -3.9313, -3.1898> <24.9904, -3.9896, -3.1349>
		<25.1305, -3.8362, -3.3555> <25.1076, -3.8836, -3.2497> <25.0227, -3.9485, -3.1138> <25.0048, -4.0082, -3.0135>
		<25.1440, -3.8326, -3.3519> <25.1211, -3.8800, -3.2462> <25.0856, -3.9309, -3.0998> <25.0677, -3.9906, -2.9995>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1440, -3.8326, -3.3519> <25.1211, -3.8800, -3.2462> <25.0856, -3.9309, -3.0998> <25.0677, -3.9906, -2.9995>
		<25.1654, -3.8268, -3.3462> <25.1425, -3.8742, -3.2405> <25.2185, -3.8937, -3.0702> <25.2006, -3.9535, -2.9699>
		<25.1991, -3.8146, -3.3529> <25.2868, -3.8233, -3.2636> <25.3264, -3.8540, -3.0768> <25.4058, -3.8846, -2.9846>
		<25.2141, -3.8068, -3.3684> <25.3018, -3.8155, -3.2791> <25.4270, -3.8051, -3.1630> <25.5064, -3.8357, -3.0708>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.2141, -3.8068, -3.3684> <25.3018, -3.8155, -3.2791> <25.4270, -3.8051, -3.1630> <25.5064, -3.8357, -3.0708>
		<25.2309, -3.7981, -3.3858> <25.3186, -3.8067, -3.2965> <25.5107, -3.7645, -3.2347> <25.5900, -3.7950, -3.1424>
		<25.2370, -3.7890, -3.4227> <25.3413, -3.7756, -3.4209> <25.4801, -3.7585, -3.3254> <25.5852, -3.7613, -3.3267>
		<25.2369, -3.7843, -3.4480> <25.3411, -3.7708, -3.4462> <25.4792, -3.7367, -3.4408> <25.5843, -3.7395, -3.4421>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.2369, -3.7843, -3.4480> <25.3411, -3.7708, -3.4462> <25.4792, -3.7367, -3.4408> <25.5843, -3.7395, -3.4421>
		<25.2367, -3.7795, -3.4732> <25.3409, -3.7660, -3.4715> <25.4784, -3.7149, -3.5562> <25.5834, -3.7177, -3.5575>
		<25.2299, -3.7745, -3.5108> <25.3163, -3.7497, -3.5983> <25.5076, -3.6872, -3.6433> <25.5855, -3.6818, -3.7414>
		<25.2128, -3.7763, -3.5299> <25.2992, -3.7515, -3.6175> <25.4228, -3.6992, -3.7236> <25.5007, -3.6937, -3.8218>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.2128, -3.7763, -3.5299> <25.2992, -3.7515, -3.6175> <25.4228, -3.6992, -3.7236> <25.5007, -3.6937, -3.8218>
		<25.1976, -3.7779, -3.5470> <25.2840, -3.7532, -3.6345> <25.3208, -3.7135, -3.8202> <25.3988, -3.7081, -3.9184>
		<25.1638, -3.7869, -3.5572> <25.1393, -3.7925, -3.6726> <25.2128, -3.7484, -3.8393> <25.1932, -3.7674, -3.9542>
		<25.1424, -3.7944, -3.5537> <25.1179, -3.8000, -3.6691> <25.0801, -3.7941, -3.8234> <25.0606, -3.8132, -3.9383>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.1424, -3.7944, -3.5537> <25.1179, -3.8000, -3.6691> <25.0801, -3.7941, -3.8234> <25.0606, -3.8132, -3.9383>
		<25.1291, -3.7992, -3.5515> <25.1045, -3.8048, -3.6669> <25.0174, -3.8158, -3.8159> <24.9979, -3.8348, -3.9308>
		<25.1263, -3.8049, -3.5263> <25.0764, -3.8269, -3.5988> <25.0287, -3.8275, -3.7389> <24.9853, -3.8618, -3.8108>
		<25.1193, -3.8094, -3.5145> <25.0695, -3.8314, -3.5870> <24.9965, -3.8483, -3.6843> <24.9531, -3.8827, -3.7562>
	}
	texture {sjedalo}
}
