
// Persistence of Vision Ray Tracer Scene Description File
// File: cigs.inc
// Vers: 1.00
// Desc: An ashtray containing some cigarette butts and with a lit cigarette
//       on top. (Dunhill deluxe!) created for the May-June round of the IRTC.
// Date: 19-05-97.
// Auth: Chris Hernandez


#declare Clear = color rgbft <1,1,1,0,1>

#declare CigSmoke_BasicHalo = halo {
   attenuating
   spherical_mapping
   poly
      exponent 1.25
      max_value 1.0
   colour_map {
      [ 0.0 rgbt <1.0, 1.0, 1.0,  1.0> ]
      [ 0.3 rgbt <1.0, 1.0, 1.0,  0.2> ]
      [ 0.8 rgbt <0.7, 0.7, 0.7, -1.0> ]
      [ 1.0 rgbt <1.0, 1.0, 1.0, -1.0> ]
   }
   turbulence <1.25,2.5,1.25>
      octaves 6
      omega 0.7
      lambda 3.5
   frequency 1
   samples 5
      aa_level 8
      aa_threshold 0.3
      jitter 0.2
}

#declare Cigarette_Smoke = cone {
   1*y,  0.175, 0*y, 0.05
   open
   hollow
   texture {
      pigment { color rgbft <1,1,1,0,1> }
      finish  { ambient 0 diffuse 0 }
      halo { CigSmoke_BasicHalo scale 0.5 }
      halo { CigSmoke_BasicHalo scale <0.1, 0.55, 0.075> }
      halo { CigSmoke_BasicHalo scale <0.1,0.65,0.2> }
   }
   scale <1.5,4,1.5>
   /*
   matrix < 1.0, 0.0, 0.0,    // ---- shear smoke in the +ve x direction.
            0.2, 1.0, 0.0,
            0.0, 0.0, 1.0,
            0.0, 0.0, 0.0  >
   */
}


#declare Butt_Texture = texture {
    pigment {
        granite
        color_map {
           [ 0.00 color rgb <0.70, 0.50, 0.20> ]
           [ 0.60 color rgb <0.70, 0.50, 0.20> ]
           [ 0.61 color rgb <0.73, 0.53, 0.23> ]
           [ 0.97 color rgb <0.73, 0.53, 0.23> ]
           [ 1.00 color rgb <0.80, 0.60, 0.30> ]
        }
    }
    finish { ambient 0.5 diffuse 0.5 crand 0.03 }
    scale 0.35
}


#declare Cigarette_Butt = object {
   cylinder {
      0*x, 0.75*x, 0.1
      texture { Butt_Texture }
   }
}

#declare Lit_Cigarette = object {
   union {
      object { Cigarette_Smoke scale 1 translate <0, -0.05, 0> }
      cylinder {
         0*x, 1.5*x, 0.1
         texture {
            pigment {
               gradient x
               color_map {
                  [ 0.00 color rgb 0.80 ]
                  [ 0.40 color rgb 0.80 ]
                  [ 0.41 color rgb 0.77 ]
                  [ 0.60 color rgb 0.77 ]
                  [ 0.61 color rgb 0.80 ]
                  [ 1.00 color rgb 0.80 ]
               }
            }
            finish  { ambient 0.55 diffuse 0.4 crand 0.03 }
            scale 0.07
         }
         texture {
            pigment {
               image_map {
                  gif "cigburn.gif"
                  map_type 0
                  interpolate 2
                  once
                  transmit 155, 1.0
               }
            }
            finish  { ambient 0.5 diffuse 0.4 }
            translate <-0.5,-0.5,0>
            rotate z*90
            scale 0.4
            translate x*0.175
         }
         texture {
            pigment {
               image_map {
                  gif "ciglabel.gif"
                  map_type 0
                  interpolate 2
                  once
                  transmit 9, 1.0
               }
            }
            finish  { ambient 0.5 diffuse 0.4 }
            translate <-0.5,-0.5,0>
            rotate -z*90
            scale 0.3
            translate x*1.4
         }
         rotate x*30
      }
      object { Cigarette_Butt translate x*1.5 }
   }
}

#declare Ashtray = object {
   difference {
      union {
         difference {
            cylinder { 0*y, 0.6*y, 1.5 }
            cylinder { 0.1*y, 1*y, 1.0 }
         }
         torus { 1.25, 0.25 scale <1,0.3,1> translate y*0.6 }
      }
      cylinder { -2*x, 2*x, 0.25 translate 0.75*y }
      cylinder { -2*z, 2*z, 0.25 translate 0.75*y }
   }
   texture {
      pigment { color rgb 0.5 }
      finish {
        ambient 0.4
        diffuse 0.4
        specular 0.20
        roughness 0.01
        reflection 0.03
      }
   }
}

// -----------------------------------------------------------------------------------------
//                                    Main Ashtray Object
// -----------------------------------------------------------------------------------------

#declare Ashtray_Filled = object {
   union{
      object { Lit_Cigarette translate<0, 0.6, 0> }
      object { Cigarette_Butt rotate z*97 translate <-0.4, 0, 0.4> }
      object { Cigarette_Butt rotate y*110 translate <0.1, 0.15, 0.2> }
      object { Cigarette_Butt rotate -y*65 translate <-0.2, 0.15, 0.3> }
      object { Cigarette_Butt rotate y*180 rotate z*15 translate <0, 0.35, -0.15> }
      object { Ashtray }
   }
}
