// Persistence of Vision Ray Tracer Scene Description File

// File: lamp.pov
// Vers: 1.00
// Desc: Blue desk lamp. Created as part of a scene for May-June round of IRTC.
// Date: May 1997
// Auth: Chris Hernandez


/*
#declare Lamp_BlueMetal = texture {
    pigment { color rgb < 0.6, 0.6, 0.7 > }
    finish {
       ambient 0.6
       diffuse 0.4
       specular 0.45
       roughness 0.04
       reflection 0.025
    }
}*/

#declare Lamp_BlueMetal = texture {
    pigment { color rgb < 0.6, 0.6, 0.7 > }
    finish {
       ambient 0.45 //0.35
       diffuse 0.6
       specular 0.65 roughness 0.0225
       phong 0.65 phong_size 110
       reflection 0.05 //0.04
       metallic
    }
}


#declare Lamp_WhitePlastic = texture {
    pigment { color rgb 0.9 }
    finish {
       ambient 0.5
       diffuse 0.4
       specular 0.25
       roughness 0.075
       crand 0.04
    }
}



/* ------------------------------------ Lamp base -------------------------------------- */

#declare Lamp_Base = object {
   union {
      difference {
         sphere { <0, -2.5, 0> 3.5 }
         plane { y, 0 }
         plane { -x, 0 }
         scale <1.5,1,1>
      }
      difference {
         sphere { <0, -2.5, 0> 3.5 }
         plane { y, 0 }
         plane { x, 0 }
      }
      union{
         cylinder { 0*y,  0.1*y,  0.2 }
         cylinder { 0.1*y,  0.25*y,  0.1 }
         rotate z*20
         texture { Lamp_WhitePlastic }
         translate <-2.25, 0.65, 0>
      }
      cylinder { 0.9*y,  1.2*y,  0.4 texture {Lamp_WhitePlastic} }
      texture {
         pigment { color rgb < 0.4, 0.4, 0.43 > }
         finish {
            ambient 0.5
            diffuse 0.4
            specular 0.3
            roughness 0.1
            crand 0.05
            reflection 0.01
         }
      }
   }
}


/* ------------------------------------ Misc Parts -------------------------------------- */

// -------------------------- Bolts

#declare LampBolt_PlaneDist = 0.08

#declare Lamp_Bolt = object {
   union {
      difference {
         cylinder { 0*z, -0.06*z, 0.1}
         plane { y, -LampBolt_PlaneDist rotate z*000 }
         plane { y, -LampBolt_PlaneDist rotate z*045 }
         plane { y, -LampBolt_PlaneDist rotate z*090 }
         plane { y, -LampBolt_PlaneDist rotate z*135 }
         plane { y, -LampBolt_PlaneDist rotate z*180 }
         plane { y, -LampBolt_PlaneDist rotate z*225 }
         plane { y, -LampBolt_PlaneDist rotate z*270 }
         plane { y, -LampBolt_PlaneDist rotate z*315 }
      }
      cylinder { -0.02*z, -0.07*z, 0.04}
      torus { 0.03, 0.01 rotate x*90 translate -z*0.07 }
      cylinder { -0.02*z, -0.075*z, 0.03}
      texture {
         pigment { color rgb 0.6 }
         finish {
            ambient 0.6
            diffuse 0.4
            specular 0.4
            roughness 0.065
            reflection 0.02
         }
      }
      scale <0.6, 0.6, 1.2>
   }
}


// -------------------------- Knob

#declare LampKnob_CylDist = 0.8

#declare LampKnob_CutAway = object {
   cylinder { <0, LampKnob_CylDist, -5 > <0, LampKnob_CylDist, 5 > 0.4 }
}

#declare Lamp_Knob = object {
   union {
      difference {
         union {
            cylinder { -0.15*z,  0.15*z,  0.4 }
            torus { 0.4, 0.15 rotate x*90 }
            sphere { <0, 0, -0.15> 0.55 clipped_by {plane { z, 0 }} scale <1,1,0.5> }
         }
         object { LampKnob_CutAway  rotate z*000 }
         object { LampKnob_CutAway  rotate z*060 }
         object { LampKnob_CutAway  rotate z*120 }
         object { LampKnob_CutAway  rotate z*180 }
         object { LampKnob_CutAway  rotate z*240 }
         object { LampKnob_CutAway  rotate z*300 }
      }
      cylinder { 0*z,  0.35*z,  0.15 }
      texture {
         pigment { color rgb 0.65 }
         finish {
            ambient 0.6
            diffuse 0.4
            specular 0.35
            roughness 0.075
         }
      }
      translate -0.35*z
   }
}

// -------------------------- Lamp Supports

#declare LS_BoxRad = 0.125

#declare Lamp_Support1 = object {
   union {
      box { < -LS_BoxRad, 0, -LS_BoxRad> < LS_BoxRad, 7, LS_BoxRad> translate -x*0.275 }
      box { < -LS_BoxRad, 0, -LS_BoxRad> < LS_BoxRad, 7, LS_BoxRad> translate  x*0.275 }
   }
   texture {Lamp_BlueMetal}
}

#declare Lamp_Support2 = object {
   union {
      box { < -LS_BoxRad, 0, -LS_BoxRad> < LS_BoxRad, 10, LS_BoxRad> translate -x*0.275 }
      box { < -LS_BoxRad, 0, -LS_BoxRad> < LS_BoxRad, 10, LS_BoxRad> translate  x*0.275 }
   }
   texture {Lamp_BlueMetal}
}


// -------------------------- Springs

#declare Lamp_Spring = object {
   union {
      cylinder {
         -2*y, 2*y, 0.15
         texture {
            pigment {
               gradient y
               color_map {
                  [ 0.00 color rgb  0.5]
                  [ 0.25 color rgb  0.5]
                  [ 0.26 color rgbt 1.0]
                  [ 0.75 color rgbt 1.0]
                  [ 0.76 color rgb  0.5]
                  [ 1.00 color rgb  0.5]
               }
            }
            finish { ambient 0.7 diffuse 0.5 specular 0.3 roughness 0.01}
            scale 0.05
         }
      }
      cylinder { 0.35*z, -0.15*z, 0.1 translate  y*2.2 texture {Lamp_WhitePlastic} }
      cylinder { 0.35*z, -0.15*z, 0.1 translate -y*2.2 texture {Lamp_WhitePlastic} }
      torus { 0.145, 0.025 rotate x*90 translate  y*2.145 }
      torus { 0.145, 0.025 rotate x*90 translate -y*2.145 }
      texture {
         pigment { color rgb 0.5 }
         finish { ambient 0.7 diffuse 0.5 specular 0.3 roughness 0.01}
      }
   }
   translate <0,2.3,-0.35>
}

#declare Lamp_Springs = object {
   union {
      object { Lamp_Spring translate -z*LS_BoxRad}
      object { Lamp_Spring rotate y*180 translate z*LS_BoxRad}
   }
}

// -------------------------- Cord

#declare LampCord_Lower = torus { 0.3, 0.075 rotate x*90 clipped_by {plane { y,0}} }
#declare LampCord_Upper = torus { 0.3, 0.075 rotate x*90 clipped_by {plane {-y,0}} }

#declare Lamp_Cord = object {
   union {
      object { LampCord_Lower translate -x*0.6 }
      object { LampCord_Upper scale <1,1.2,1>}
      object { LampCord_Lower translate  x*0.6 }
   }
   clipped_by { plane { x, 0.6 } plane { -x, 0.6 } }
   texture { Lamp_WhitePlastic }
}


/* --------------------------------------- Joints --------------------------------------- */

#declare LJ_HalfWidth = 0.16

#declare Lamp_TopJoint = object {
   difference {
      union {
         difference {
            union {
               box { < -0.2, -0.2, -LJ_HalfWidth> < 0.2, 0.2, LJ_HalfWidth> }
               cylinder { <-0.1,  0.2, -LJ_HalfWidth > <-0.1,  0.2, LJ_HalfWidth > 0.1 }
               cylinder { < 0.2, -0.1, -LJ_HalfWidth > < 0.2, -0.1, LJ_HalfWidth > 0.1 }
            }
            cylinder { < 0.2, 0.2, -1 > < 0.2, 0.2, 1 > 0.2 }
            box { < -0.21, -0.21, -1> < -0.1, -0.1, 1 > }
         }
         cylinder { <-0.1, -0.1, -LJ_HalfWidth > <-0.1, -0.1, LJ_HalfWidth > 0.1 }
         object { Lamp_Bolt translate < -0.1,  0.2, -LJ_HalfWidth> }
         object { Lamp_Bolt translate <  0.2, -0.1, -LJ_HalfWidth> }
         object { Lamp_Bolt translate < -0.1, -0.1, -LJ_HalfWidth> }
         object { Lamp_Bolt rotate x*180 translate < -0.1,  0.2, LJ_HalfWidth> }
         object { Lamp_Bolt rotate x*180 translate <  0.2, -0.1, LJ_HalfWidth> }
         object { Lamp_Bolt rotate x*180 translate < -0.1, -0.1, LJ_HalfWidth> }
      }
      box { < -1, -1, -LS_BoxRad > < 1, 1, LS_BoxRad > }
      texture { Lamp_WhitePlastic }
      bounded_by { box {<-0.3, -0.3, -0.4> <0.3, 0.3, 0.4>} }
      scale 1.5
      rotate -z*45
   }
}

#declare Lamp_BottomJoint = object {
   difference {
      union {
         difference {
            box { < -0.2, -0.2, -LJ_HalfWidth> < 0.2, 0.25, LJ_HalfWidth> }
            plane { -y, 0 rotate -z*25 translate <-0.2, 0.25, 0> }
         }
         cylinder {
            -LJ_HalfWidth*z, LJ_HalfWidth*z, 0.215
            clipped_by { plane {-y, 0} }
            scale <1,0.25,1>
            rotate -z*25
            translate <0, 0.155, 0>
         }
         cylinder { -0.2*y,  -0.45*y,  0.10 }
         object { Lamp_Bolt translate < -0.13, 0.180, -LJ_HalfWidth> }
         object { Lamp_Bolt translate <  0.13, 0.065, -LJ_HalfWidth> }
         object { Lamp_Bolt rotate x*180 translate < -0.13, 0.180, LJ_HalfWidth> }
         object { Lamp_Bolt rotate x*180 translate <  0.13, 0.065, LJ_HalfWidth> }
      }
      box { < -1, -0.15, -LS_BoxRad > < 1, 1, LS_BoxRad > }
      translate 0.35*y
      scale <2.2, 2.2, 1.1>
      texture { Lamp_WhitePlastic }
   }
}

#declare Lamp_MiddleJoint = object {
   union {
      object{ Lamp_BottomJoint clipped_by{plane{-y, -0.45}} rotate y*180 translate -y*0.45 }
      object{ Lamp_BottomJoint clipped_by{plane{-y, -0.45}} translate -y*0.45 rotate -z*180 }
      object{ Lamp_Knob translate <0, -0.1, -LJ_HalfWidth*2.2> }
   }
}



/* -------------------------------------- Lamp Head --------------------------------------- */

#declare Lamp_Head = object {
   union {
      // ----------------------- Main lamp head shape
      cylinder { -0.25*y, 0*y, 2 open hollow }
      cone { 0*y, 2, 1.25*y, 1.0 open hollow }
      cone { 1.25*y, 1, 3.3*y, 0.75 open hollow }
      
      // ----------------------- Endpiece at top of lamp (ie crosspiece/cutout at thin end)
      union {
         difference {
            torus { 0.65, 0.1 clipped_by { cylinder{ -y, y, 0.65 inverse } } }
            plane { y, 0 }
         }
         difference {
            union {
               box { <-0.1,-0.01,-0.65> <0.1,0,0.65> }
               box { <-0.65,-0.01,-0.1> <0.65,0,0.1> }
               cylinder { -0.01*y, 0*y, 0.325 }
            }
            cylinder { y, -y, 0.2 }
            translate y*0.1
         }
         texture { Lamp_BlueMetal }
         translate y*3.3
      }
      
      // ----------------------- Lamp cord and other attachments
      union{
         cylinder { 0*x,  0.15*x,  0.3 }
         cylinder { 0.15*x,  0.6*x,  0.15 }
         cylinder { < 0.85, 0, -LS_BoxRad> ,  < 0.85, 0, LS_BoxRad> ,  0.25 }
         object { Lamp_Cord rotate -z*12 translate <0.7,0.65,0.0> }
         cylinder { -0.1*x, 0.1*x, 0.12 translate y*0.5 }
         texture {Lamp_WhitePlastic}
         translate <0.85, 2, 0>
      }
      
      // ----------------------- Light source
      light_source {
         <0,0.45,0>
         color rgb 0.85 //0.85
         area_light <1,0,0>, <0,0,1>, 3, 3
         adaptive 0
         jitter //0.1
         fade_distance 8.5 //9
         fade_power 1.4 //1.5
         looks_like {
            sphere {
               <0,0.25,0> 0.65
               texture { pigment { color rgb 1.0 } finish { ambient 1 diffuse 0 } }
            }
         }
      }
   }
   texture { Lamp_BlueMetal }
}



// ==========================================================================================

#declare Lamp = object {
   union {
      object { Lamp_Base }
      object { Lamp_BottomJoint translate <0, 1.1, 0> }
      object { Lamp_Support1 rotate -z*45 translate <0, 2.1, 0> }
      object { Lamp_MiddleJoint translate <4.8, 7.5, 0> }
      object { Lamp_Support2 rotate z*80 translate <5.2, 7.9, 0> }
      object { Lamp_TopJoint rotate -z*20 translate <-4.6, 9.65, 0> }
      object { Lamp_Head rotate -z*5 translate <-6.65, 7.85, 0> }
      object { Lamp_Springs rotate -z*41 translate <-0.15, 1.95, 0> }
      object { Lamp_Springs rotate  z*85 translate < 4.9, 8.05, 0> }
   }
}

