// Persistence of Vision Ray Tracer Scene Description File

// File: math.pov
// Vers: 1.00
// Desc: Main scene file - "Cram Chowder". Scene of a desktop with a pencil, pen,
//       calculator, lamp, ashtray and some books. This is what Math and Physics
//       means to me... staying inside on beautiful days cramming for exams.
//       Created for May-June round of the internet raytracing comp.
// Date: May 1997
// Auth: Chris Hernandez


#debug "\n"
#debug "------**> Cram Chowder - (c) 1997 by Chris Hernandez <**------ \n"
#debug "\n"
#debug "     SURGEON GENERALS WARNING: \n"
#debug "     Excessive raytracing may lead to cancer of the rectum \n"
#debug "     and may cause addiction to heavily salted snack foods. \n"
#debug "\n"


global_settings {
   assumed_gamma 3.0
   max_intersections 100
   max_trace_level 6
}


#include "colors.inc"
#include "mug.inc"
#include "pencil.inc"
#include "pen.inc"
#include "lamp.inc"
#include "paper.inc"
#include "cigs.inc"
#include "books.inc"
#include "calc1.inc"
#include "penholdr.inc"
#include "mathmisc.inc"
#include "clock.inc"


background { color rgb 0.2 }



// -----------------------------------------------------------------------------------------
//                                       Desk Texture
// -----------------------------------------------------------------------------------------

#declare DeskTexture = texture {
   pigment {
      image_map {
        gif "woodtxt3.gif"
        map_type 0
        interpolate 2
      }
   }
   normal {
      bump_map {
        gif "woodtxt3.gif"
        map_type 0
        interpolate 2
        bump_size 0.125
      }
   }
   finish {
      ambient 0.25
      diffuse 0.2
      specular 0.65
      roughness 0.075
      reflection 0.045
      crand 0.01
   }
   translate <-0.5, -0.5, 0>
   rotate 90*x
   rotate 90*y
   scale <1, 1, 1.5>   // <--------- Set relative scaling
   scale 6             // <--------- Set absolute scaling
}



// -----------------------------------------------------------------------------------------
//                        Background elements: tree line, sky sphere
// -----------------------------------------------------------------------------------------

#declare day   = 1
#declare night = 2

#declare SkyType = day

#declare FBM_Clouds = pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color Clear]
        [0.5, 1.001 color Clear color Clear]
    }
    scale <6, 1, 6>
}

#declare CBH_Clouds = pigment {    // White clouds with transparency for layering.
   bozo                            // Slightly modified version of FBM_Clouds.
   turbulence 0.65
   octaves 6
   omega 0.7
   lambda 2
   color_map {
      [0.0, 0.1   color red 0.88 green 0.88 blue 0.88
                  color red 0.90 green 0.90 blue 0.90]
      [0.1, 0.5   color red 0.89 green 0.89 blue 0.89
                  color Clear ]
      [0.5, 1.001 color Clear color Clear]
   }
   scale <6, 1, 6>
}


//---------------------------- Background Sky

sky_sphere {

   #if ( SkyType = night )
      pigment {
        granite
        color_map {
            [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
            [ 0.72  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.75  0.78 color Gray40 color Gray60 ] // Very Faint Stars
            [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.81  0.85 color Gray80 color Gray95 ] // Medium White Stars
            [ 0.85  0.91 color Gray95 color White  ] // White Stars
            [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
        }
      scale .015
      }
      pigment { FBM_Clouds scale 0.075 }
      #debug "  Sky Type.............. Night\n"
   #else
      pigment { SkyBlue }
      pigment { CBH_Clouds scale 0.045 }
      pigment { CBH_Clouds translate -0.15*y rotate y*5 scale 0.045 }
      #debug "  Sky Type.............. Day\n"
   #end
}


//---------------------------- Tree Line

plane {
   z, 16 hollow
   texture {
      pigment {
         image_map {
            gif "treeline.gif"
            map_type 0
            interpolate 2
            once
            transmit 244, 1.0
         }
      }
      #if ( SkyType = night )
         finish { ambient 0.4 diffuse 0.0 }
      #else
         finish { ambient 0.8 diffuse 0.0 }
      #end
      translate <-0.5, 0, 0>
      scale < 34, 19, 1 >
      scale 0.8
   }
}


// -----------------------------------------------------------------------------------------
//                          Rear Wall: window, window frame and ledge
// -----------------------------------------------------------------------------------------

#declare TempTexture = texture {
    pigment { color rgb < 0.5, 0.5, 0.7 > }
    finish {
       ambient 0.4
       diffuse 0.3
       specular 0.35
       roughness 0.05
    }
}

#declare Window_FrameTexture = texture {
    pigment { color rgb 0.9 }
    finish {
       ambient 0.4
       diffuse 0.3
       specular 0.35
       roughness 0.05
    }
}

#declare Ledge_Texture =  // ------ Declare 2-layer wood texture for window ledge
texture {
   pigment {
   wood
   turbulence 0.04
   octaves 3
   scale <0.05, .05, 1>
   color_map {
      [0.0, 0.1 color rgb <0.68, 0.60, 0.40>
                color rgb <0.68, 0.60, 0.40>]
      [0.1, 0.9 color rgb <0.68, 0.60, 0.40>
                color rgb <0.35, 0.30, 0.20>]
      [0.9, 1.0 color rgb <0.35, 0.30, 0.20>
                color rgb <0.35, 0.30, 0.20>] }
   }
}
texture {
   pigment {
      wood
      turbulence <0.1, 0.5, 1>
      octaves 5
      lambda 3.25
      scale <0.15, .5, 1>
      rotate <5, 10, 5>
      translate -x*2
      color_map {
         [0.0, 0.1 color rgbf <0.35, 0.32, 0.20, 0.100>
                   color rgbf <0.35, 0.32, 0.20, 0.500>]
         [0.1, 0.2 color rgbf <0.35, 0.35, 0.20, 0.650>
                   color rgbf <0.63, 0.60, 0.40, 0.975>]
         [0.2, 0.3 color rgbf <0.63, 0.60, 0.40, 0.975>
                   color rgbf <0.35, 0.30, 0.20, 1.000>]
         [0.3, 0.4 color rgbf <0.35, 0.30, 0.20, 0.100>
                   color rgbf <0.35, 0.30, 0.20, 0.500>]
         [0.4, 0.9 color rgbf <0.35, 0.30, 0.20, 0.650>
                   color rgbf <0.63, 0.60, 0.40, 0.975>]
         [0.9, 1.0 color rgbf <0.63, 0.60, 0.40, 0.975>
                   color rgbf <0.40, 0.32, 0.20, 1.000>]
      }
   }
}

#declare Window_Glass = texture {
   pigment { color rgbf <0.95, 0.95, 0.95, 0.9> }
   finish {
      ambient 0.4
      diffuse 0.175
      reflection 0.20
      refraction on
      ior 1.45
      specular 0.8
      roughness 0.003
    }
}

#declare WallPaper =  texture {
   pigment {
      image_map {
         gif "wgrey10.gif"
         map_type 0
         interpolate 2
      }
   }
   normal {
      bump_map {
         gif "wgrey10.gif"
         map_type 0
         interpolate 2
         bump_size 2.0
      }
   }
   finish { ambient 0.25 diffuse 0.4 }
   scale <4, 5, 4>
}


//---------------------------- Main wall and hollow for window frame

difference {
   box { < -50, 0, 0> < 50, 50, 6> texture { WallPaper } }
   box { < -10, 3, -0.1> < 10, 24, 6.1> texture { WallPaper rotate y*90 } }
   clipped_by { plane { z, 3 hollow } }
}

difference {
   box { < -50, 0, 0> < 50, 50, 6> }
   box { < -10, 3, -0.1> < 10, 24, 6.1> }
   clipped_by { plane { -z, -3 hollow } }
   texture {
      pigment {
         brick color rgb 0.4, color rgb < 0.95, 0.35, 0.35 >
         brick_size <2,1,1>
         mortar 0.2
      }
      normal {
         brick 2.0
         brick_size <2,1,1>
         mortar 0.2
      }
      finish  { ambient 0.7 diffuse 0.35 specular 0.1 roughness 0.25 }
   }
}


//---------------------------- Window sill/ledge
union {
   box { < -10, 0.25, 0> < 10, 0.25, 4> }
   cylinder { -10*x, 10*x, 0.25 scale <1,1,0.5> }
   translate < 0, 3.25, 0 >
   texture {
      Ledge_Texture
      finish { ambient 0.75 diffuse 0.4 specular 0.3 roughness 0.1 }
      rotate y*89
   }
}

//---------------------------- Window and crossbars

#declare WindowOpen = 0.3   // Amount that window is open. 0=closed, 1=fully open.

union {

   // ---------------------------- Window one, left side
   union {
      difference {
         box { <  -10,  -12, -0.4> < 0.3, 12, 0> }
         box { < -9.25, -11, -1> < -0.3, 11.25, 1> }
         texture { Window_FrameTexture }
      }
      box { <-9.9,-11.9,-0.25> <0.0,11.9,-0.15> hollow texture { Window_Glass } }
      translate x*10*WindowOpen
   }

   // ---------------------------- Window two, right side
   difference {
      box { <  10,  -12,  0.4> < -0.3, 12, 0> }
      box { < 9.25, -11, -1> < 0.3, 11.25, 1> }
      texture { Window_FrameTexture }
   }
   box { < 9.9, -11.9, 0.25> <0.0, 11.9, 0.15> hollow texture { Window_Glass }}

   // ---------------------------- Window frame
   difference {
      box { <  -10,  -12, -0.6> < 10, 12, 0.6> }
      box { < -9.5, -11.25, -1> < 9.5, 11.25, 1> }
      box { <  -9.9,  -11.9, -0.4> < 9.9, 11.9, 0.4> }
      texture { Window_FrameTexture pigment { color rgb 0.85 } }
   }
   translate < 0, (12+3.25), 3 >
}


//---------------------------- Room Shell

difference {
   box { <-55,-55,-55> <55,55,0> }
   box { <-54,-54,-54> <54,54,1> }
   texture { pigment { color rgb 0.25 } }
}




// -----------------------------------------------------------------------------------------
//                                     Lighting Setup
// -----------------------------------------------------------------------------------------

#if ( SkyType = night )
   global_settings { ambient_light rgb 0.6 }
   #declare Dimmer = 0.1
#else
   global_settings { ambient_light rgb 0.75 }
   #declare Dimmer = 0.3
#end

#declare LightFading = on

#declare BasicLight = light_source {
   0*x
   color rgb 0.65*Dimmer
   shadowless
   fade_distance 40
   fade_power 1
}

light_source { 0*x color rgb 0.95 translate < -10, 40, 40> shadowless }

#if ( LightFading = off )

light_source { 0*x  color rgb 0.65*Dimmer translate <-20, 40, -20> shadowless }
light_source { 0*x  color rgb 0.75*Dimmer translate < 20, 40, -20> shadowless }
light_source { 0*x  color rgb 0.65*Dimmer translate <-20,-40, -20> shadowless }
light_source { 0*x  color rgb 0.65*Dimmer translate <  0,  0, -20> shadowless }
light_source { 0*x  color rgb 0.20*Dimmer translate <  0, 20,  20> shadowless }
#debug "  Light Fading.......... Off\n"

#else

light_source { <-20, 40, -20> color rgb 0.65*Dimmer shadowless fade_distance 40 fade_power 1.5 }
light_source { < 20, 40, -20> color rgb 0.75*Dimmer shadowless fade_distance 40 fade_power 1.5 }
light_source { <-20,-40, -20> color rgb 0.65*Dimmer shadowless fade_distance 40 fade_power 1.5 }
light_source { <  0,  0, -20> color rgb 0.65*Dimmer shadowless fade_distance 19 fade_power 1.5 }
light_source { <  0, 20,  20> color rgb 0.20*Dimmer shadowless fade_distance 20 fade_power 1.5 }
#debug "  Light Fading.......... On\n"

#end


// -----------------------------------------------------------------------------------------
//                                       Main Scene
// -----------------------------------------------------------------------------------------

#declare FocalBlur = on

camera {

  location <0,20,-50> look_at   <0.0 , 1.0 , 0.0>
  //location <0,15,30> look_at   <0.0 , 2.0 , 0.0> angle 58  // <--- OUTSIDE
  //location <0,50,-5>  look_at   <0.0 , 1.0 , 0.0>  angle 50  // <--- ABOVE
  //location <0,0.3,-50>  look_at <0.0 , 0.3 , 0.0>  // <--- IN FRONT

  #if ( FocalBlur=on )
     focal_point <0, 1, -12>
     blur_samples 35 //15
     aperture 0.45
     #debug "  Focal Blur............ On\n"
  #else
     #debug "  Focal Blur............ Off\n"
  #end

  angle 36

}


object { UNSW_Mug scale <1.1,1.2,1.1> rotate y*35 translate < 6, 0, -12 >}
object { Pencil rotate x*90 rotate y*2 translate <-3.5, PencilBody_PlaneDist, -19>}
object { Pen rotate x*90  rotate -z*90 rotate -y*75 translate <2.5, Pen_OuterRadius+0.5, -16> }
object { Lamp scale 1 rotate -y*30 translate <10, 0, -5> }
object { PadOfPaper scale <1.1,1,1> rotate x*90 rotate -y*30 translate <2,0,-16> }
object { Ashtray_Filled rotate y*50 translate <9,0,-14> }
object { Book2 rotate y*180 translate <-10, 1.3, -3.5> }
object { Book1 rotate -y*20 translate <-0.5, 1.0, -7.5> }
object { Calculator scale 1.5 rotate y*75 translate <-7, 0, -17> }
object { AE_Poster scale 0.7 translate < 17.5, 12, -0.01 > }
object { PenHolder_Filled scale 0.8 rotate -y*35 translate < 6, 0, -4> }
object { BookSet scale 0.9 translate <14.75, 0, -0.2> }
object { Post_Its scale 0.9 translate <-12.65, 8, 0> }
object { Clock scale 1.5 rotate -y*12 translate <-5.5, 3.5, 0.4> }

plane  {
   y, 0
   clipped_by { plane { z, 0 } }
   clipped_by { plane {-z, 25 } }
   texture { DeskTexture }
}

