
// Persistence of Vision Ray Tracer Scene Description File
// File: penholdr.pov
// Vers: 1.00
// Desc: A rectangular-prism pen holder with a few pens and pencils in it.
//       Created for the May-June 1997 round of the IRTC.
// Date: June 16th, 1997.
// Auth: Chris Hernandez


// ---------------------------------------------------------------------------------------
//                            Quick 'n dirty pens & pencils
// ---------------------------------------------------------------------------------------

// **** NOTE ****
// These pens and pencils are "quick and dirty" because only the top parts
// (ie the parts sticking out of the pen holder) are detailed. Also, the
// code is pretty much bare bones with minimal comments. Good Luck!

#declare PencilTexture = texture {
   pigment { color red 0.55 green 0.15 blue 0.15 }
   finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 crand 0.05 }
}

#declare PH_Pencil1 = object {  /* --- Red Pencil w/ rounded end --- */
   difference {
	  union {
		 cylinder { // ---------------------- Pencil Body
			6*y,  0*y,  0.178 hollow
			texture {
			   pigment { color rgb 0.05 }
			   finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 }
			}
		 }
		 sphere {  // ----------------------- Pencil Top
			<0, 0, 0> 0.178
			scale <1,0.7,1>
			translate y*6
			texture {
			   pigment { color red 0.55 green 0.15 blue 0.15 }
			   finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 crand 0.05 }
			}
		 }
	  }
	  union {      // ----------------------- Pencil Sides
		 plane { z, -0.16875 rotate y*000 }
		 plane { z, -0.16875 rotate y*045 }
		 plane { z, -0.16875 rotate y*090 }
		 plane { z, -0.16875 rotate y*135 }
		 plane { z, -0.16875 rotate y*180 }
		 plane { z, -0.16875 rotate y*225 }
		 plane { z, -0.16875 rotate y*270 }
		 plane { z, -0.16875 rotate y*315 }
		 texture {
			pigment { color red 0.55 green 0.15 blue 0.15 }
			finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 crand 0.05 }
		 } 
	  }
   }
}


#declare PH_Pencil2 = object {  /* --- Yellow Pencil w/ eraser on the end --- */
   union {
	  difference {
		 cylinder { // ---------------------- Pencil Body
			6*y,  0*y,  0.178 hollow
			texture {
			   pigment { color rgb 0.05 }
			   finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 }
			}
		 }
		 union {      // ----------------------- Pencil Sides
			plane { z, -0.16875 rotate y*000 }
			plane { z, -0.16875 rotate y*045 }
			plane { z, -0.16875 rotate y*090 }
			plane { z, -0.16875 rotate y*135 }
			plane { z, -0.16875 rotate y*180 }
			plane { z, -0.16875 rotate y*225 }
			plane { z, -0.16875 rotate y*270 }
			plane { z, -0.16875 rotate y*315 }
			texture {
			   pigment { color red 0.80 green 0.80 blue 0.15 }
			   finish  { ambient 0.5 diffuse 0.45 specular 0.2 roughness 0.04 crand 0.05 }
			}  
		 }
	  }
	  union {
		 difference {   // ----------------------- Pencil Top
			cylinder { 0*y, 0.5*y, 0.182 }

			torus { 0.182, 0.015 translate y*(0.15+0*0.05) }
			torus { 0.182, 0.015 translate y*(0.15+1*0.05) }
			torus { 0.182, 0.015 translate y*(0.15+2*0.05) }
			torus { 0.182, 0.015 translate y*(0.15+3*0.05) }
			torus { 0.182, 0.015 translate y*(0.15+4*0.05) }
			
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*000 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*045 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*090 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*135 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*180 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*225 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*270 }
			sphere { <0.182, 0.05, 0>, 0.03 rotate y*315 }
			
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*000 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*045 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*090 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*135 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*180 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*225 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*270 }
			sphere { <0.182, 0.45, 0>, 0.03 rotate y*315 }
		 }
		 union {
			cylinder { 0.65*y, 0.5*y, 0.178 }
			sphere { <0, 0.65, 0> 0.178 scale <1,0.9,1> }
			texture {
			   pigment { color rgb 0.85 }
			   finish  { ambient 0.45 diffuse 0.35 specular 0.15 roughness 0.1 crand 0.1 }
			}
		 }
		 torus { 0.173, 0.009 }
		 torus { 0.173, 0.009 translate y*0.5 }
		 texture {
			pigment { color rgb <0.85, 0.65, 0.50> }
			finish  {
				ambient 0.55 brilliance 4 diffuse 0.5 metallic
				specular 0.45 roughness 1/70 reflection 0.05 crand 0.05
			}   
		 }
		 translate y*6
	  }
   }
}


#declare PH_Pen1a = object {  /* --- Plain Blue Pen --- */
   difference {
	  union {
		 cylinder { // ---------------------- Pen Body
			6.25*y,  0*y,  0.178 hollow
		 }
		 sphere {  // ----------------------- Pen Top
			<0, 0, 0> 0.178
			scale <1,0.7,1>
			translate y*6.25
		 }
	  }
	  union {      // ----------------------- Pen Sides
		 plane { z, -0.16875 rotate y*000 }
		 plane { z, -0.16875 rotate y*045 }
		 plane { z, -0.16875 rotate y*090 }
		 plane { z, -0.16875 rotate y*135 }
		 plane { z, -0.16875 rotate y*180 }
		 plane { z, -0.16875 rotate y*225 }
		 plane { z, -0.16875 rotate y*270 }
		 plane { z, -0.16875 rotate y*315 }
	  }
	  texture {
		 pigment { color red 0.3 green 0.3 blue 0.8 }
		 finish  { ambient 0.5 diffuse 0.4 specular 0.2 roughness 0.04 crand 0.05 }
	  } 
   }
}

#declare PH_Pen1b = object {  /* --- Plain Purple Pen --- */
   difference {
	  union {
		 cylinder { // ---------------------- Pen Body
			6.25*y,  0*y,  0.178 hollow
		 }
		 sphere {  // ----------------------- Pen Top
			<0, 0, 0> 0.178
			scale <1,0.7,1>
			translate y*6.25
		 }
	  }
	  union {      // ----------------------- Pen Sides
		 plane { z, -0.16875 rotate y*000 }
		 plane { z, -0.16875 rotate y*045 }
		 plane { z, -0.16875 rotate y*090 }
		 plane { z, -0.16875 rotate y*135 }
		 plane { z, -0.16875 rotate y*180 }
		 plane { z, -0.16875 rotate y*225 }
		 plane { z, -0.16875 rotate y*270 }
		 plane { z, -0.16875 rotate y*315 }
	  }
	  texture {
		 pigment { color red 0.6 green 0.3 blue 0.6 }
		 finish  { ambient 0.5 diffuse 0.4 specular 0.2 roughness 0.04 crand 0.05 }
	  } 
   }
}

#declare PH_Pen2a = object {  /* --- Black pen w/ lid --- */
   union {
	  difference {
		 cylinder { // ---------------------- Pen Body
			5.5*y,  0*y,  0.178 hollow
		 }
		 union {      // ----------------------- Pen Sides
			plane { z, -0.16875 rotate y*000 }
			plane { z, -0.16875 rotate y*045 }
			plane { z, -0.16875 rotate y*090 }
			plane { z, -0.16875 rotate y*135 }
			plane { z, -0.16875 rotate y*180 }
			plane { z, -0.16875 rotate y*225 }
			plane { z, -0.16875 rotate y*270 }
			plane { z, -0.16875 rotate y*315 }
		 }
	  }
	  union {  // ----------------------- Pen Top
		 sphere {
			<0, 0, 0> 0.185
			scale <1.2,9,1.2>
			clipped_by { plane { -y, 0 } }
		 }
		 sphere {
			<0, 0, 0> 0.1
			scale <1,7,1.1>
			clipped_by {
			   plane { -y, 0 }
			   //plane { -x, 0 }
			}
			translate -x*0.185
		 }
		 sphere {
			<0, 0, 0> 0.1
			scale <1,10,1.1>
			clipped_by {
			   plane { y, 0 }
			   plane { x, 0 }
			}
			translate -x*0.185
		 }
		 torus { 0.183, 0.05 scale <1,0.7,1> }
		 translate y*5.5
	  }
	  texture {
		 pigment { color rgb 0.15 }
		 finish  { ambient 0.5 diffuse 0.4 specular 0.2 roughness 0.04 crand 0.05 }
	  } 
   }
}


#declare PH_Pen2b = object {  /* --- Red pen w/ lid --- */
   union {
	  difference {
		 cylinder { // ---------------------- Pen Body
			5.5*y,  0*y,  0.178 hollow
		 }
		 union {      // ----------------------- Pen Sides
			plane { z, -0.16875 rotate y*000 }
			plane { z, -0.16875 rotate y*045 }
			plane { z, -0.16875 rotate y*090 }
			plane { z, -0.16875 rotate y*135 }
			plane { z, -0.16875 rotate y*180 }
			plane { z, -0.16875 rotate y*225 }
			plane { z, -0.16875 rotate y*270 }
			plane { z, -0.16875 rotate y*315 }
		 }
	  }
	  union {  // ----------------------- Pen Top
		 sphere {
			<0, 0, 0> 0.185
			scale <1.2,9,1.2>
			clipped_by { plane { -y, 0 } }
		 }
		 sphere {
			<0, 0, 0> 0.1
			scale <1,7,1.1>
			clipped_by {
			   plane { -y, 0 }
			   //plane { -x, 0 }
			}
			translate -x*0.185
		 }
		 sphere {
			<0, 0, 0> 0.1
			scale <1,10,1.1>
			clipped_by {
			   plane { y, 0 }
			   plane { x, 0 }
			}
			translate -x*0.185
		 }
		 torus { 0.183, 0.05 scale <1,0.7,1> }
		 translate y*5.5
	  }
	  texture {
		 pigment { color rgb <0.65, 0.15, 0.15> }
		 finish  { ambient 0.5 diffuse 0.4 specular 0.2 roughness 0.04 crand 0.05 }
	  } 
   }
}

// ---------------------------------------------------------------------------------------
//                                   Pen Holder
// ---------------------------------------------------------------------------------------

#declare PenHolder = object {
   difference {
	  superellipsoid { <0.4, 0.4> }
	  plane { -y, -0.4 }
	  superellipsoid { <0.4, 0.4> scale 0.9 translate y*0.1 }
	  translate y
   }
   texture {
	  pigment { color rgb < 0.3, 0.45, 0.3 > }
	  finish {
		 ambient 0.35
		 diffuse 0.45
		 specular 0.45 roughness 0.005
		 //phong 0.35 phong_size 190
		 //reflection 0.05
		 crand 0.03
	  }
   }
   scale <1.3, 3.3, 1.3>
}


// ---------------------------------------------------------------------------------------
//                               Main Pen Holder Object
// ---------------------------------------------------------------------------------------

#declare PenHolder_Filled = object {
   union {
	  object { PenHolder }
	  object { PH_Pen1a translate <0,0,-0.3> rotate -x*9 rotate -z*2}
	  object { PH_Pen1b translate <-0.4,0, 0.4> rotate x*2 rotate -z*2}
	  object { PH_Pen2a rotate -z*12 }
	  object { PH_Pen2b translate <0,0,-0.2> rotate x*11 rotate -z*5 }
	  object { PH_Pencil1 translate <-0.2,0,0.1> rotate -x*11 rotate z*3 }
	  object { PH_Pencil2 rotate z*11 rotate x*11 }
   }
}
