// Definition of a ping pong ball centered at the origin
// The units are in centimeters
// The logo on the ball faces the -z direction. To randomize the
// orientation, call "transform BallRandomize" after declaring the ball

#ifndef (StaticBallParts)

#declare BallRadius = 1.85

#declare BallLogo = texture {
   pigment {
      image_map {
         gif "balllogo.gif"
         once
         map_type 0
         transmit 0, 1.0
         interpolate 2
      }
      translate <-0.5, -0.5, 0.0>
      scale <1.6, 0.8, 1>
   }
   finish {
      diffuse 0.3
      ambient 0.7
   }
}

#declare BallBaseTexture = texture {
   pigment {
      rgb<1.0, 0.843, 0.0>
   }
   finish {
      diffuse 0.3
      ambient 0.7
   }
}

// Notice the band, which represents the glue joint of the ball, is slightly
// lighter than the rest of the ball, but has a lower ambient value in the
// finish. This is to duplicate the way the joint actually appears on a real
// ball. On the side towards the light, the joint appears lighter (presumably
// because the thicker material there reflects more light), while on the shaded
// side of the ball, the joint appears darker (probably some light is passing
// through the ball).
#declare BallBandTexture = texture {
   pigment {
      gradient z
      scale BallRadius
      color_map {
         [0.02 rgbt<1.0, 0.875, 0.161, 0.0>]
         [0.05 rgbt<1.0, 0.843, 0.0, 1.0>]
      }
   }
   finish {
      diffuse 0.35
      ambient 0.65
   }
}

#declare BallSeed = seed(3245)
#declare StaticBallParts = version
#end   // #ifndef (StaticBallParts)

#declare BandTransform = transform {
   rotate degrees(acos(2*rand(BallSeed) - 1)) * x
   rotate rand(BallSeed) * 360 * z
}

#declare BallRandomize = transform {
   rotate rand(BallSeed) * 360 * z
   rotate degrees(acos(2*rand(BallSeed) - 1)) * x
   rotate rand(BallSeed) * 360 * z
}

// We create the ball in two parts so the image only maps to one side
// Make sure the BallBaseTexture is transformed the same for both
// halves of the ball!
#declare PingPongBall = union {
   intersection {
      sphere {<0, 0, 0>, BallRadius}
      plane {z, 0.1}
      texture {
         BallBaseTexture
      }
      texture {
         BallBandTexture
         transform BandTransform
      }
      texture {
         BallLogo
      }
   }
   intersection {
      sphere {<0, 0, 0> BallRadius}
      plane {-z, 0.1}
      texture {
         BallBaseTexture
      }
      texture {
         BallBandTexture
         transform BandTransform
      }
   }
}
