// Persistence of Vision Ray Tracer Scene Description File
// File: dabomb.pov
// Vers: 3.01 Watcom Win32
// Desc: DaBomb - A Family Portrait
// Date: June 27, 1997
// Auth: Sonya Roberts
// Note: Salvage from an image-in-progress I gave up on in screaming frustration

// ==== Standard Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"
#include "attic.inc"

#declare BaseCamera=
camera {
	location	<0,1.5,-3.5>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,1.25,0>
}

//==== Setup needed variables ====
#declare True=1
#declare False=0
#declare RSD=seed (29)

//==== Decide what to include in scene ====
#declare Use_Camera=1		// 1=BaseCamera
#declare FastLighting=True
#declare TopQuality=True

#declare I_Stuff=True
#if (I_Stuff)
	#declare I_Radium=True
	#declare I_Atomic=True
	#declare I_EinOpp=True
	#declare I_Curie=True
	#declare I_FamTree=True
	#declare I_Photo=True
	#include "stuff.pov"
#end

//==== Set up the selected scene ====
#switch (Use_Camera)
	#case (1)	camera {BaseCamera}	#break
	#else		#debug "Unable to locate specified camera"	camera {Base_Camera}	#break
#end

object {
	plane {
		<0,1,0>,0
		texture {T_Stone5}
	}
}

object {
	plane {
		<0,0,1>,2
		hollow
		texture {
			checker
			texture {
				pigment {color SeaGreen}
			}
			texture {
				pigment {color SeaGreen*1.05}
				finish {reflection .2}
			}
			scale <.25,10,.25>
		}
	}
}

#if (FastLighting)
	light_source {
		<10,5,-15>
		color Gray70
	}
     #else
	light_source {
		<10,5,-15>
		color Gray40
		area_light <5,0,0>,<0,5,0>,4,4
		adaptive 1
	}
	light_source {
		<-5,10,-20>
		color Gray40
		area_light <5,0,0>,<0,5,0>,4,4
		adaptive 1
	}
#end
