// Persistence of Vision Ray Tracer Scene Description File
// File: miscjunk.pov
// Vers: 3.01 Watcom Win32
// Desc: Miscellaneous Bits and Pieces of stuff
// Date: June 27, 1997
// Auth: Sonya Roberts
// Note: Salvaged Items

#if (I_Radium)
	#declare Radium=
	object {
		union {
			difference {
				sphere {<0,.5,0>,.55}
				sphere {<0,0,0>,.525	scale <1,.9,1>	translate <0,.5,0>}
				box {<-.6,.2,-.6>,<.6,1.1,.6>}
				texture {PorcelainWhite}
			}
			sphere {
				<0,0,0>,.5
				hollow
				pigment {color Clear}
				halo {
					emitting
					spherical_mapping
					linear
					color_map {
						[0 rgbt <.5,.91.60,.5>]
						[1 rgbt <.51,.98.63,1>]
					}
					samples 10
					scale .01
				}
				scale <.5,.25,.5>
				translate <0,.1,0>
			}
			light_source {
				<0,.05,0>
				color MediumAquamarine
				fade_distance .35
				fade_power 1
			}
		}
	}
#end

#if (I_Atomic=True)
	#declare BellJar=
	object {
		union {
			difference {
				merge {
					cylinder {<0,0,0>,<0,1.25,0>,.5}
					sphere {<0,1.25,0>,.5}
					sphere {<0,1.8,0>,.125}
				}
				merge {
					cylinder {<0,-.1,0>,<0,1.25,0>,.475}
					sphere {<0,1.25,0>,.475}
				}
				texture {T_Glass3}
			}
			union {
				cylinder {<0,0,0>,<0,.1,0>,.55}
				torus {.55,.075}
				texture {T_Wood2}
			}
		}
	}

	#declare Explosion=
	object {
		#declare ASD=seed(15)
		union {
			union {
				#declare CNT=1
				#if (TopQuality)
					#declare NUM=200
				     #else
					#declare NUM=75
				#end
				#while (CNT < NUM)
					sphere {
						<0,0,0>,(rand(ASD)*.25)
						pigment {color rgbt <1,1,1,.7+(rand(ASD)*.2)>}
						finish {
							ambient .5+(rand(ASD)*.5)
							reflection .2
						}
						scale <rand(ASD)*.15,rand(ASD)*1.5,rand(ASD)*.15>
						translate <0,rand(ASD),.05+(rand(ASD)*.1)>
						rotate y*(rand(ASD)*360)
					}
					#declare CNT=CNT+1
				#end
			}
			union {
				#declare CNT=1
				#if (TopQuality)
					#declare NUM=350
				     #else
					#declare NUM=50
				#end
				#while (CNT < NUM)
					sphere {
						<0,0,0>,rand(ASD)*.05
						pigment {color rgbt <1,1,1,.55+(rand(ASD)*.2)>}
						finish {
							ambient .5+(rand(ASD)*.5)
							reflection .2
						}
						#declare SC=rand(ASD)
						scale <SC,SC,SC>
						translate <0,.6+(rand(ASD)*.2),.175+rand(ASD)*.125>
						rotate y*(rand(ASD)*360)
					}
					#declare CNT=CNT+1
				#end
			}
			union {
				#declare CNT=1
				#if (TopQuality)
					#declare NUM=600
				     #else
					#declare NUM=100
				#end
				#while (CNT < NUM)
					sphere {
						<0,0,0>,rand(ASD)*.075
						pigment {color rgbt <1,1,1,.6+(rand(ASD)*.2)>}
						finish {
							ambient .5+(rand(ASD)*.5)
							reflection .2
						}
						#declare SC=rand(ASD)
						scale <SC,SC,SC>
						translate <0,0,.2+rand(ASD)*.2>
						rotate <rand(ASD)*360,rand(ASD)*360,rand(ASD)*360>
						translate <0,1.25,0>
					}
					#declare CNT=CNT+1
				#end
			}
		}
	}

	#declare Atomic=
	object {
		union {
			object {BellJar}
			object {Explosion}
			light_source {
				<0,.25,0>
				color Red
				fade_distance .2
				fade_power 1
			}
			#if (TopQuality)
				light_source {
					<0,.5,0>
					color OrangeRed
					fade_distance .225
					fade_power 1
				}
				light_source {
					<0,.75,0>
					color Orange
					fade_distance .25
					fade_power 1
				}
				light_source {
					<0,1,0>
					color Gold
					fade_distance .275
					fade_power 1
				}
			#end
			light_source {
				<0,1.25,0>
				color Gold
				fade_distance .3
				fade_power 1
			}
		}
	}
#end

#if (I_EinOpp)
	#declare Shape1=
	object {
		difference {
			box {<-.075,0,-.05>,<.075,1,0>}
			cylinder {<-.04,-.01,-.05>,<-.04,1.01,-.05>,.005}
			cylinder {<-.02,-.01,-.05>,<-.02,1.01,-.05>,.005}
			cylinder {<0,-.01,-.05>,<0,1.01,-.05>,.005}
			cylinder {<.02,-.01,-.05>,<.02,1.01,-.05>,.005}
			cylinder {<.04,-.01,-.05>,<.04,1.01,-.05>,.005}
		}
	}

	#declare Shape2=
	object {
		union {
			difference {
				box {<-.1,-.1,-.075>,<.1,.1,0>}
				torus {.05,.025	rotate x*90	scale <1,1,.5>	translate <0,0,-.075>}
			}
			sphere {<0,0,0>,.025	scale <1,1,.5>	translate <0,0,-.075>}
		}
	}

	#declare Frame1=
	object {
		union {
			object {Shape1			translate <-.75,0,0>}
			object {Shape1			translate <.75,0,0>}
			object {Shape1	scale <1,1.5,1>	rotate z*90	translate <.75,-.075,0>}
			object {Shape1	scale <1,1.5,1>	rotate z*90	translate <.75,1,0>}
			object {Shape2			translate <-.75,0,0>}
			object {Shape2			translate <.75,0,0>}
			object {Shape2			translate <-.75,1,0>}
			object {Shape2			translate <.75,1,0>}
			texture {T_Wood23	scale <.15,.15,.15>}
		}
	}

	#declare EinOpp=
	object {
		union {
			object {Frame1}
			object {
				box {<0,0,-.025>,<1,1,0>}
				pigment {
					image_map {
						gif "einopp.gif"
					}
				}
				finish {ambient .3}
				scale <1.5,1,1>
				translate <-.75,-.1,0>
			}
			translate <0,.1,0>
			rotate x*10
		}
	}
#end

#if (I_Curie)
	#declare Curie=
	object {
		union {
			union {
				torus {.5,.05	rotate x*90}
				sphere {<0,.525,-.025>,.075}
				sphere {<0,.6,-.025>,.035}
				difference {
					union {
						torus {.15,.025	rotate x*90	translate <-.15,.4,-.025>}
						torus {.15,.025	rotate x*90	translate <.15,.4,-.025>}
						torus {.15,.025	rotate x*90	translate <-.45,0,-.025>}
						torus {.15,.025	rotate x*90	translate <.45,0,-.025>}
					}
					cylinder {<0,0,-.2>,<0,0,0>,.5}
				}
				texture {T_Wood8	scale <.2,.2,.2>}
			}
			cylinder {
				<0,0,-.01>,<0,0,0>,.5
				pigment {
					image_map {
						gif "curie.gif"
					}
					translate <-.5,-.5,0>
				}
				finish {ambient .3}
			}
			scale <2,3,2>
		}
	}
#end

#if (I_FamTree)
	#declare FamTree=
	object {
		union {
			object {
				#include "famtree.pov"
				pigment {
					image_map {
						gif "famtree.gif"
						once
					}
					translate <-.5,-.5,0>
					scale <2,1.5,1>
				}	
				finish {ambient .2}
			}
		}
	}
#end

#if (I_Photo)
	#declare Photo=
	object {
		union {
			box {<-.025,-.025,-.005>,<1.025,.625,0>	pigment {color White}}
			box {
				<0,0,-.0051>,<1,1,-.005>
				pigment {
					image_map {
						gif "peace.gif"
					}
				}
				finish {ambient .2}
				scale <1,.6,1>
				translate <.025,.025,0>
			}
		}
		rotate x*90
		rotate y*-30
	}
#end

// ---- Position Items ----

#if (I_Radium)		object {Radium				translate <1,-.025,-.5>}	#end
#if (I_Atomic)		object {Atomic				translate <-.25,0,0>}		#end
#if (I_EinOpp)		object {EinOpp	scale <1.5,1.5,1.5>	translate <1.25,0,1.5>}		#end
#if (I_Curie)		object {Curie				translate <-2,1.75,2>}		#end
#if (I_FamTree)		object {FamTree				translate <1.4,2.6,1.975>}	#end
#if (I_Photo)		object {Photo				translate <-1.75,0,-.5>}	#end
