// N should be a value from 0 to 1.  It is used to determined features.

#declare Features = int(N*65535.99)
#declare MountType = mod(Features,16)
#declare LightsRing = (mod(Features,17)<=2)
#declare LightsRingColoured = (mod(Features,5)=0)
#declare Antenae = (mod(Features,73)<3)
#declare AntenaeLength = (pow(mod(Features,64)/40,2)+1)
#declare AntenaeDish = (mod(Features,4)=0)

#declare DysonObject =

#if ( VERYSIMPLE )
    sphere { 0, 1 }
#else

#if ( !SimpleFront | Antenae )
    union {
#end
	difference {
	    #if (LightsRing & !SimpleBack)
		union {
		    sphere { <0,0,0>,1 }
		    #declare L=0
		    #declare NL=13
		    #while (L<NL)
			sphere {
			    <0.7,0.7,0>,0.06 rotate x*360*L/NL
			    #if (LightsRingColoured)
				pigment {
				    color rgb<sin(L*3.1415/NL),
					    1-sin(L*3.1415/NL),0>
				    rotate x*360*N
				}
			    #else
				pigment { color White }
			    #end
			    finish { Luminous }
			    no_shadow
			}
			#declare L=L+1
		    #end
		}
	    #else
		sphere { <0,0,0>,1 }
	    #end
	    sphere { <-0.3,0,0>,1.1 }
	    translate <-1,0,0>
	    scale <0.7,1,1>
	}
    #if (!SimpleFront)
	sphere { <0,0,0>,0.1 }
	#declare R=0
	#while (R<3)
	    cylinder { <-1.4,0,0> <-0.5,0.9,0> 0.04 rotate x*360/3*R }
	    #declare R=R+1
	#end
	#switch (MountType)
	 #range (0..2)
	    box { <-1,-1,-1>/7 <1,1,1>/7 translate <-1.5,0,0> }
	 #break
	 #range (2..8)
	    cone { <-1.6,0,0>,0 <-1.3,0,0>,0.2 }
	 #break
	 #range (8..15)
	    object { Tetrahedron rotate z*90 rotate x*-90 scale 0.08 translate <-1.4,0,0> }
	 #break
	#end
    #end
    #if (!SimpleBack)
	#if (Antenae)
	    cone { <0,0,0>,0.1 <AntenaeLength,0,0>,0.02 }
	    sphere { <AntenaeLength,0,0>,0.06 }
	    #if (AntenaeDish)
		difference {
		    sphere {
			<0,0,0>,1
			scale <0.1,0.4,0.4>*AntenaeLength
			translate<0.10,0,0>*AntenaeLength
		    }
		    sphere {
			<0,0,0>,0.95
			scale <0.1,0.4,0.4>*AntenaeLength
			translate<0.15,0,0>*AntenaeLength
		    }
		}
	    #end
	#end
    #end
#if ( !SimpleFront | Antenae )
    }
#end

#end
