//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 16 textures and 82 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 06/17/1997    (17.06.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 4    // Rayleigh
  distance     100.0
  color <0.7,0.7,1.0,0.0,0.0>
  scattering   0.3
  samples      40
  jitter       0.1
  aa_threshold 1.0
  aa_level     3.0
}

camera {  //  Camera Camera01
  location  <0.000, -8.000, 1.600>
  direction <0.0,     0.0,  2.2037>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 1.200>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <0.000, 0.400, 1.350> // Attached to SpotL001
  direction <0.0,     0.0,  1.3741>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, -0.548, 1.033> // Following SpotL001
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight SpotL001
  <0.000, 0.400, 1.350>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.000, -0.548, 1.033>
    falloff   20.0  // outer radius (in deg)
      radius    15.0  // inner radius
}

light_source {   // Light2
  <-1.700, 0.000, 1.850>
  color rgb <1.000, 1.000, 1.000>
  atmosphere off
}

light_source {   // Light001
  <0.000, 0.000, 1.350>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  2.0
  fade_power 1.0
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "science.inc"



// ********  REFERENCED OBJECTS  *******

#declare MastBaseInt = intersection {
  box { // KaChunk
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.6, 0.5>
  }
  box { // KaChunk1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.6, 0.25>
    rotate -45.0*y
  }
  sphere { // RightMastKachun
    <0,0,0>,1
    scale 0.5
  }
  texture {
    MastBaseChumkcolor
  }
}
#declare MastBaseCsg = union {
  sphere { // RightMastBase
    <0,0,0>,1
    texture {
      MastBaseColor
    }
    scale 0.45
  }
  object { MastBaseInt }
  object { // MastBaseInt1->MastBaseInt
    MastBaseInt
    rotate -60.0*z
  }
  object { // MastBaseInt2->MastBaseInt
    MastBaseInt
    rotate -120.0*z
  }
  translate  2.0*x
}
#declare OneRightMast = union {
  cylinder { // RightPipe
    <0,0,1>, <0,0,0>, 1 
    texture {
      MastColor
    }
    scale <0.2, 0.2, 2.0>
    rotate 90.0*y
  }
  cylinder { // MastLower
    <0,0,1>, <0,0,0>, 1 
    texture {
      MastColor
    }
    scale <0.2, 0.2, 1.0>
    translate  2.0*x
  }
  object { // MastBaseCsg1->MastBaseCsg
    MastBaseCsg
    scale 0.8
    translate  <0.4, 0.0, 1.0>
  }
  object { MastBaseCsg }
}
#declare KnuckleCsgint = intersection {
  torus { // ClawFinger
    1.0, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // KnuckleCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.5>
    translate  0.5*z
  }
  texture {
    FingerColor
  }
}
#declare KnuckleCsgint1 = intersection {
  torus { // ClawFinger1
    1.0, 0.05  rotate -x*90
    scale <1.0, 0.8, 1.0>
    rotate -90.0*x
  }
  box { // KnuckleCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.5>
    translate  -0.5*z
  }
  texture {
    FingerTipColor
  }
}
#declare OneSetOfFingers = union {
  object { KnuckleCsgint }
  object { KnuckleCsgint1 }
  torus { // KnucleTor
    0.05, 0.05  rotate -x*90
    texture {
      KnuckleColor
    }
    translate  -1.0*x
  }
  torus { // KnucleTor1
    0.05, 0.05  rotate -x*90
    texture {
      KnuckleColor
    }
    translate  1.0*x
  }
}
#declare ClawWrist2 = lathe {
  cubic_spline
  8  // control points
  <0.348704, -1.354305>,
  <0.697408, -0.979354>,
  <0.650775, -0.828322>,
  <0.599296, -0.316014>,
  <0.457432, 0.273184>,
  <0.286925, 0.456685>,
  <0.238895, 0.50521>,
  <0.01524, 0.505015>
  rotate <90,0,90>
  scale 0.7
  translate  2.9*z
}
#declare ClawWrist3 = lathe {
  cubic_spline
  8  // control points
  <0.348704, -1.354305>,
  <0.697408, -0.979354>,
  <0.650775, -0.828322>,
  <0.599296, -0.316014>,
  <0.457432, 0.273184>,
  <0.286925, 0.456685>,
  <0.238895, 0.50521>,
  <0.01524, 0.505015>
  rotate <90,0,90>
  scale <0.65, 0.65, 0.7>
  translate  2.89*z
}
#declare BellCutCSg = difference {
  object { ClawWrist2 }
  object { ClawWrist3 }
  translate  -1.35*z
}
#declare wristBonesegment = intersection {
  cylinder { // WristBones2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.9, 0.5>
    rotate -90.0*x
    translate  0.9*z
  }
  object { BellCutCSg }
  texture {
    WristColor
  }
  translate  0.1*y
}




// ********  OBJECTS  *******

box { // BackDrop
  <-1, -1, -1>, <1, 1, 1>
  texture {
    ManColor
  }
  scale <4.0, 1.0, 3.0>
  translate  <0.0, 4.75, 0.75>
}


#include "C:\MORAY\POVSCN\spark.inc"

object {
  spark
  texture {
    SparkColor
  }
  no_shadow
  scale 0.54
  rotate -70.0*y
  translate  <-0.9, 0.0, 1.65>
}


sphere { // Halo
  <0,0,0>,1
  texture {
    HaloColor
  }
  no_shadow
  hollow
  translate  <-1.7, 0.0, 1.85>
}


prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  174  // control points
  <-0.709757, -0.160047>,
  <-0.654127, -0.247012>,
  <-0.647915, -0.323244>,
  <-0.566139, -0.463684>,
  <-0.522151, -0.466219>,
  <-0.539226, -0.347741>,
  <-0.370014, -0.287548>,
  <-0.24944, -0.388831>,
  <-0.267464, -0.523201>,
  <-0.209416, -0.589168>,
  <-0.154493, -0.567966>,
  <-0.149956, -0.574839>,
  <-0.140548, -0.595949>,
  <-0.104177, -0.586274>,
  <-0.104361, -0.516546>,
  <-0.091433, -0.460894>,
  <-0.009973, -0.461041>,
  <0.012947, -0.491894>,
  <-0.004911, -0.562744>,
  <-0.018433, -0.582466>,
  <-0.015142, -0.609057>,
  <0.001292, -0.628405>,
  <0.027323, -0.64304>,
  <0.059458, -0.634945>,
  <0.091113, -0.620545>,
  <0.104155, -0.594045>,
  <0.10983, -0.55984>,
  <0.088163, -0.54334>,
  <0.059859, -0.555885>,
  <0.090617, -0.513323>,
  <0.160318, -0.529098>,
  <0.270167, -0.532667>,
  <0.316447, -0.490435>,
  <0.272209, -0.421008>,
  <0.327413, -0.392187>,
  <0.467143, -0.434936>,
  <0.559684, -0.375133>,
  <0.407484, -0.277519>,
  <0.381658, -0.251973>,
  <0.465245, -0.231291>,
  <0.510048, -0.268142>,
  <0.551765, -0.268495>,
  <0.510591, -0.137576>,
  <0.437638, -0.087873>,
  <0.310437, -0.085619>,
  <0.168689, 0.047181>,
  <0.100664, 0.351249>,
  <0.166464, 0.369327>,
  <0.267137, 0.374855>,
  <0.346078, 0.40204>,
  <0.387991, 0.417121>,
  <0.363575, 0.423355>,
  <0.376583, 0.441796>,
  <0.415762, 0.43703>,
  <0.44211, 0.411627>,
  <0.446535, 0.439622>,
  <0.423743, 0.458112>,
  <0.458499, 0.473903>,
  <0.483086, 0.496831>,
  <0.495429, 0.526283>,
  <0.485296, 0.529132>,
  <0.46572, 0.503708>,
  <0.459282, 0.501596>,
  <0.468007, 0.512292>,
  <0.475067, 0.545958>,
  <0.465049, 0.544838>,
  <0.46028, 0.536577>,
  <0.452363, 0.519427>,
  <0.439925, 0.508075>,
  <0.4324, 0.508906>,
  <0.435428, 0.528958>,
  <0.436607, 0.541533>,
  <0.432484, 0.560625>,
  <0.422489, 0.554269>,
  <0.421035, 0.541569>,
  <0.418714, 0.531793>,
  <0.416551, 0.518211>,
  <0.411331, 0.506763>,
  <0.402711, 0.508975>,
  <0.4014, 0.522625>,
  <0.404058, 0.541441>,
  <0.401344, 0.552385>,
  <0.39421, 0.552823>,
  <0.389709, 0.544684>,
  <0.387807, 0.529529>,
  <0.383194, 0.508947>,
  <0.37474, 0.50527>,
  <0.356538, 0.501969>,
  <0.342841, 0.489584>,
  <0.319046, 0.484435>,
  <0.30857, 0.497003>,
  <0.231872, 0.478838>,
  <0.183833, 0.467521>,
  <0.120502, 0.511446>,
  <0.04088, 0.516824>,
  <0.012005, 0.535394>,
  <0.010836, 0.606887>,
  <-0.051601, 0.545749>,
  <-0.089304, 0.586985>,
  <-0.053504, 0.671027>,
  <-0.074293, 0.73185>,
  <-0.141424, 0.753246>,
  <-0.189758, 0.733615>,
  <-0.205864, 0.704695>,
  <-0.206318, 0.698924>,
  <-0.210108, 0.688732>,
  <-0.215572, 0.682975>,
  <-0.22974, 0.65007>,
  <-0.224452, 0.640792>,
  <-0.224779, 0.631103>,
  <-0.215782, 0.630152>,
  <-0.2159, 0.61014>,
  <-0.222697, 0.597574>,
  <-0.218483, 0.571702>,
  <-0.186078, 0.574545>,
  <-0.188103, 0.547806>,
  <-0.213909, 0.537054>,
  <-0.278539, 0.579915>,
  <-0.277891, 0.554614>,
  <-0.281203, 0.520644>,
  <-0.374406, 0.502798>,
  <-0.431748, 0.491025>,
  <-0.461159, 0.497428>,
  <-0.495514, 0.5488>,
  <-0.526414, 0.589958>,
  <-0.548992, 0.622309>,
  <-0.56587, 0.597892>,
  <-0.580893, 0.631871>,
  <-0.583472, 0.662103>,
  <-0.58795, 0.679298>,
  <-0.582035, 0.696701>,
  <-0.580976, 0.710253>,
  <-0.588745, 0.716567>,
  <-0.596112, 0.712408>,
  <-0.594762, 0.704878>,
  <-0.594802, 0.70221>,
  <-0.599576, 0.692708>,
  <-0.60343, 0.682738>,
  <-0.610189, 0.702462>,
  <-0.611638, 0.72483>,
  <-0.625774, 0.727829>,
  <-0.629605, 0.720392>,
  <-0.62734, 0.714505>,
  <-0.62694, 0.711116>,
  <-0.630339, 0.683516>,
  <-0.642022, 0.691372>,
  <-0.646343, 0.710564>,
  <-0.642297, 0.735483>,
  <-0.654592, 0.743723>,
  <-0.665103, 0.717929>,
  <-0.668912, 0.689324>,
  <-0.682557, 0.706312>,
  <-0.683166, 0.731789>,
  <-0.693266, 0.737786>,
  <-0.705646, 0.70461>,
  <-0.677599, 0.653536>,
  <-0.712296, 0.636617>,
  <-0.719177, 0.604699>,
  <-0.684202, 0.620072>,
  <-0.647337, 0.604297>,
  <-0.631159, 0.567965>,
  <-0.657, 0.565985>,
  <-0.57376, 0.435017>,
  <-0.470475, 0.356797>,
  <-0.347377, 0.349758>,
  <-0.306528, 0.35003>,
  <-0.290639, 0.25354>,
  <-0.308404, 0.189772>,
  <-0.427209, 0.064702>,
  <-0.635255, -0.017766>,
  <-0.794221, -0.166954>,
  <-0.709757, -0.160047>,
  <-0.654127, -0.247012>,
  <-0.647915, -0.323244>
  rotate -x*90
  texture {
    ManColor
  }
  scale <0.9, 0.9, 0.009>
  rotate 90.0*x
  translate  <0.1, -1.45, 0.5>
}






#declare LeftBase = lathe {
  cubic_spline
  9  // control points
  <0.101854, -0.190123>,
  <0.245416, 0.000195>,
  <0.27642, 0.498656>,
  <0.181976, 1.046301>,
  <0.189777, 1.28662>,
  <0.15415, 1.482548>,
  <0.176783, 1.552986>,
  <0.218341, 1.618305>,
  <0.140624, 1.828911>
  rotate <90,0,90>
  translate  -1.5*x
}
#declare LeftOrbCutCsg = difference {
  object { LeftBase }
  sphere { // LeftOrb
    <0,0,0>,1
    scale 0.3
    translate  <-1.5, 0.0, 1.825>
  }
  texture {
    LeftBaseColor
  }
  translate  -0.2*x
}
#declare LeftBitCsg = union {
  cylinder { // LeftSideLinkRim
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 1.2>
    rotate 90.0*y
    translate  <-1.6, 0.0, 0.8>
  }
  box { // LeftSideLink
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.15, 0.4>
    translate  <-1.0, 0.0, 0.4>
  }
}
#declare PocketCsg = difference {
  object { LeftBitCsg }
  superellipsoid { // LeftSidePocket
    <0.2, 0.2>
    scale <0.2, 0.1, 0.2>
    translate  <-1.0, -0.15, 0.45>
  }
  sphere { // MainOrb1
    <0,0,0>,1
    translate  1.35*z
  }
  texture {
    LeftLinkColor
  }
}
#declare LeftSideCsg = union {
  object { LeftOrbCutCsg }
  sphere { // LeftOrb1
    <0,0,0>,1
    texture {
      OrbColor
    }
    hollow
    scale 0.3
    translate  <-1.7, 0.0, 1.825>
  }
  object { PocketCsg }
  cylinder { // Pipe
    <0,0,1>, <0,0,0>, 1 
    texture {
      PipeColor
    }
    scale <0.05, 0.05, 0.5>
    rotate -90.0*y
    translate  <-0.75, -0.1, 0.65>
  }
  cylinder { // Pipe1
    <0,0,1>, <0,0,0>, 1 
    texture {
      PipeColor
    }
    scale <0.05, 0.05, 0.5>
    rotate -90.0*y
    translate  <-0.75, -0.1, 0.55>
  }
  cylinder { // Pipe2
    <0,0,1>, <0,0,0>, 1 
    texture {
      PipeColor
    }
    scale <0.05, 0.05, 0.5>
    rotate -90.0*y
    translate  <-0.75, -0.1, 0.45>
  }
  cylinder { // Pipe3
    <0,0,1>, <0,0,0>, 1 
    texture {
      PipeColor
    }
    scale <0.05, 0.05, 0.5>
    rotate -90.0*y
    translate  <-0.75, -0.1, 0.35>
  }
  cylinder { // Pipe4
    <0,0,1>, <0,0,0>, 1 
    texture {
      PipeColor
    }
    scale <0.05, 0.05, 0.5>
    rotate -90.0*y
    translate  <-0.75, -0.1, 0.25>
  }
  torus { // LeftRimming
    0.2, 0.05  rotate -x*90
    texture {
      RimmerColor
    }
    translate  <-1.75, 0.0, 0.1>
  }
  torus { // LeftRimming1
    0.2, 0.05  rotate -x*90
    texture {
      RimmerColor
    }
    scale <1.05, 1.05, 1.0>
    translate  <-1.75, 0.0, 0.2>
  }
  torus { // LeftRimming2
    0.2, 0.05  rotate -x*90
    texture {
      RimmerColor
    }
    scale <1.08, 1.08, 1.0>
    translate  <-1.75, 0.0, 0.3>
  }
  torus { // LeftRimming3
    0.2, 0.05  rotate -x*90
    texture {
      RimmerColor
    }
    scale <1.07, 1.07, 1.0>
    translate  <-1.75, 0.0, 0.4>
  }
  torus { // LeftRimming4
    0.2, 0.05  rotate -x*90
    texture {
      RimmerColor
    }
    scale <1.05, 1.05, 1.0>
    translate  <-1.75, 0.0, 0.5>
  }
}
#declare Base3 = lathe {
  cubic_spline
  4  // control points
  <1.218835, -0.056923>,
  <0.989188, -0.005015>,
  <0.504604, 0.57144>,
  <0.973948, 0.906213>
  rotate <90,0,90>
}
#declare BaseIntCsg3 = difference {
  object { Base3 }
  sphere { // BaseCut2
    <0,0,0>,1
    translate  1.35*z
  }
}
#declare Base2 = lathe {
  cubic_spline
  4  // control points
  <1.218835, -0.056923>,
  <0.989188, -0.005015>,
  <0.631673, 0.552104>,
  <0.973948, 0.906213>
  rotate <90,0,90>
}
#declare BaseIntCsg2 = difference {
  object { Base2 }
  sphere { // BaseCut1
    <0,0,0>,1
    scale <2.0, 2.0, 1.0>
    translate  <0.2, 0.0, 1.3>
  }
}
#declare Base1 = lathe {
  cubic_spline
  4  // control points
  <1.218835, -0.056923>,
  <0.989188, -0.005015>,
  <0.73388, 0.552104>,
  <0.973948, 0.906213>
  rotate <90,0,90>
}
#declare BaseIntCsg1 = difference {
  object { Base1 }
  sphere { // BaseCut
    <0,0,0>,1
    scale <2.0, 2.0, 1.0>
    translate  <-0.1, 0.0, 1.1>
  }
}
#declare BaseCsg = union {
  object { BaseIntCsg3 }
  object { BaseIntCsg2 }
  object { BaseIntCsg1 }
  texture {
    BaseColor
  }
}
#declare AllFingers = union {
  object { OneSetOfFingers }
  object { // OneSetOfFinge1->OneSetOfFingers
    OneSetOfFingers
    rotate -30.0*z
  }
  object { // OneSetOfFinge2->OneSetOfFingers
    OneSetOfFingers
    rotate -60.0*z
  }
  object { // OneSetOfFinge3->OneSetOfFingers
    OneSetOfFingers
    rotate -90.0*z
  }
  object { // OneSetOfFinge4->OneSetOfFingers
    OneSetOfFingers
    rotate -120.0*z
  }
  object { // OneSetOfFinge5->OneSetOfFingers
    OneSetOfFingers
    rotate -150.0*z
  }
}
#declare CutFingers = difference {
  object { AllFingers }
  sphere { // MainOrb3
    <0,0,0>,1
    texture {
      OrbColor
    }
    scale 1.002
  }
}
#declare ClawWrist = lathe {
  cubic_spline
  8  // control points
  <0.348704, -1.354305>,
  <0.697408, -0.979354>,
  <0.650775, -0.828322>,
  <0.599296, -0.316014>,
  <0.457432, 0.273184>,
  <0.286925, 0.456685>,
  <0.238895, 0.50521>,
  <0.01524, 0.505015>
  rotate <90,0,90>
  scale 0.7
  translate  1.55*z
}
#declare ClawWrist1 = lathe {
  cubic_spline
  8  // control points
  <0.348704, -1.354305>,
  <0.697408, -0.979354>,
  <0.650775, -0.828322>,
  <0.599296, -0.316014>,
  <0.457432, 0.273184>,
  <0.286925, 0.456685>,
  <0.238895, 0.50521>,
  <0.01524, 0.505015>
  rotate <90,0,90>
  scale <0.65, 0.65, 0.7>
  translate  1.54*z
}
#declare WristMissingBon = difference {
  object { ClawWrist }
  cylinder { // WristBones
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.9, 1.0>
    rotate -90.0*x
    translate  <0.0, -0.5, 0.9>
  }
  cylinder { // WristBones1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.9, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.5, 0.0, 0.9>
  }
  sphere { // MainOrb2
    <0,0,0>,1
    texture {
      OrbColor
    }
  }
  object { ClawWrist1 }
  texture {
    WristColor
  }
}
#declare WholeDamnClaw = union {
  object { CutFingers }
  object { WristMissingBon }
  object { wristBonesegment }
  object { // wristBonesegm1->wristBonesegment
    wristBonesegment
    rotate -90.0*z
  }
  object { // wristBonesegm2->wristBonesegment
    wristBonesegment
    rotate 180.0*z
  }
  object { // wristBonesegm3->wristBonesegment
    wristBonesegment
    rotate 90.0*z
    translate  0.0*y
  }
  rotate <0.0, 60.0, 45.0>
  translate  1.35*z
}
#declare UpperMastCsg5 = union {
  cylinder { // MastUpper5
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.7>
  }
  sphere { // MastElbowTop11
    <0,0,0>,1
    scale 0.15
    translate  0.7*z
  }
  texture {
    MastColor
  }
  scale <0.75, 0.75, 1.9>
  rotate <-70.629242, 57.131802, -108.603485>
  translate  <-0.004561, 2.181004, 2.050565>
}
#declare UpperMastCsg4 = union {
  cylinder { // MastUpper4
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.7>
  }
  sphere { // MastElbowTop9
    <0,0,0>,1
    scale 0.15
    translate  0.7*z
  }
  texture {
    MastColor
  }
  scale 0.75
  rotate <-64.075394, 27.791168, 147.814087>
  translate  <1.541846, 1.543507, 2.07375>
}
#declare UpperMastCsg3 = union {
  cylinder { // MastUpper3
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.7>
  }
  sphere { // MastElbowTop7
    <0,0,0>,1
    scale 0.15
    translate  0.7*z
  }
  texture {
    MastColor
  }
  scale <0.75, 0.75, 1.9>
  rotate <-76.284431, 34.614948, 42.962467>
  translate  <2.172656, -0.006553, 2.013924>
}
#declare UpperMastCsg2 = union {
  cylinder { // MastUpper2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.7>
  }
  sphere { // MastElbowTop4
    <0,0,0>,1
    scale 0.15
  }
  sphere { // MastElbowTop5
    <0,0,0>,1
    scale 0.15
    translate  0.7*z
  }
  texture {
    MastColor
  }
  rotate <0.0, 15.0, 90.0>
  translate  <0.0, 2.0, 1.35>
}
#declare UpperMastCsg1 = union {
  cylinder { // MastUpper1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.7>
  }
  sphere { // MastElbowTop2
    <0,0,0>,1
    scale 0.15
  }
  sphere { // MastElbowTop3
    <0,0,0>,1
    scale 0.15
    translate  0.7*z
  }
  texture {
    MastColor
  }
  rotate <0.0, 15.0, 45.0>
  translate  <1.413123, 1.413814, 1.35>
}
#declare UpperMastCsg = union {
  cylinder { // MastUpper
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.7>
  }
  sphere { // MastElbowTop
    <0,0,0>,1
    scale 0.15
  }
  sphere { // MastElbowTop1
    <0,0,0>,1
    scale 0.15
    translate  0.7*z
  }
  texture {
    MastColor
  }
  rotate 15.0*y
  translate  <2.0, 0.0, 1.35>
}
#declare ScienceCsg = union {
  object { LeftSideCsg }
  object { BaseCsg }
  sphere { // MainOrb
    <0,0,0>,1
    texture {
      OrbColor
    }
    hollow
    translate  1.35*z
  }
  object { OneRightMast }
  object { // OneRightMast1->OneRightMast
    OneRightMast
    rotate 45.0*z
  }
  object { // OneRightMast2->OneRightMast
    OneRightMast
    rotate 90.0*z
  }
  object { WholeDamnClaw }
  object { UpperMastCsg5 }
  object { UpperMastCsg4 }
  object { UpperMastCsg3 }
  sphere { // WristEnd
    <0,0,0>,1
    texture {
      MastColor
    }
    scale 0.15
    translate  <1.165954, 1.1678, 2.302651>
  }
  object { UpperMastCsg2 }
  object { UpperMastCsg1 }
  object { UpperMastCsg }
}
difference { // CutGRoundWay
  object { ScienceCsg }
  plane { // CutGround
    z,0
    texture {
      BaseColor
    }
  }
}




