// Persistence of Vision Ray Tracer Scene Description File
// File: shatter.pov
// Vers: 
// Desc: the end of the world formula (submission to IRC May/June 97 - subject: math & physics)
// Date: June 1997
// Auth: Uwe Post (up@ct.heise.de)
//




#version 3

#declare calcformula=1
#declare calcplane=1
#declare calceaters=1
#declare calcfog=1

global_settings
{
  assumed_gamma 1.0
}

// -------------- camera and so on --------------------------
camera
{
  location  5*y-6*z // left "it" which uses the saw: -1.9,1.5,-2.0
  direction 1.5*z
  right     4/3*x
  look_at   z // left "it" which uses the saw: -2.1,0.0,-0.75
}

sky_sphere
{
  pigment
  {
    color rgb 0
  }
}

light_source
{
  0
  color 1
  translate 30*(y-x-z)
}


#if (calcplane)
//--------------- the plane ------------------
union
{
height_field
{
  tga        "shatten.tga"
//  smooth
  translate -x*0.5-z*0.5
  rotate x*180
  rotate y*180
}
box { <-10,-0.01,-10>,<-.5,0,10> }
box { <0.5,-0.01,-10>,<10,0,10> }
box { <-0.5,-0.01,.45>,<.5,0,10> }
box { <-0.5,-0.01,-10>,<.5,0,-0.45> }
scale 4
pigment { color 0.01       }
normal { crackle 0.4  scale 0.07
}
finish { specular 1 ambient 0.2}
translate 3*z-2*x
rotate y*45
scale 2
}
#end

#declare metfin=
finish {
    ambient 0.25
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
}

#declare metalpig = pigment {
granite turbulence 0.1
  color_map
  { [0,0.1 color rgb <0.5, 0.5, 0.5> color rgb <0.5, 0.5, 0.5>]
    [0.1,0.6 color rgb <0.85, 0.85, 0.85> color rgb <0.85, 0.85, 0.85>]
    [0.6,0.8 color rgb <0.6, 0.6, 0.6> color rgb <0.6, 0.6, 0.6>]
    [0.8,1 color rgb <0.77, 0.77, 0.77> color rgb <0.77, 0.77, 0.77>]
  }
  scale 0.3
}

#declare whitepig = pigment {
granite turbulence 0.5
  color_map
  { [0 color rgb <0.5, 0.5, 0.5> ]
    [0.1 color rgb <0.85, 0.85, 0.85> ]
    [0.6 color rgb <0.7, 0.67, 0.6> ]
    [1 color rgb 1]
  }
  scale 0.3
}

#declare rustpig=
     pigment {
        granite turbulence 0.9
        color_map {
            [0.0, 0.2 color rgb <0.20, 0.91, 0.20>
                      color rgb <0.50, 0.73, 0.00>]
            [0.2, 0.5 color rgb <0.10, 0.13, 0.00>
                      color rgb <0.49, 0.11, 0.08>]
            [0.5, 0.6 color rgb <0.49, 0.11, 0.08>
                      color rgb <0.59, 0.31, 0.28>]
            [0.6, 1.0 color rgb <0.59, 0.31, 0.28>
                      color rgb <0.69, 0.21, 0.28>]
        }
    }

#declare rustnorm=
     normal {   crackle 1 turbulence 0.5}

#declare metaltex= texture {
 spotted turbulence 0.7
 texture_map {
             [0    pigment{rustpig} normal{rustnorm}]
             [0.2  pigment{rustpig} normal{rustnorm}]
             [0.201 pigment{whitepig} ] // pigment {metalpig} finish {metfin}
             [1     pigment{whitepig} ] // pigment {metalpig} finish {metfin}
 }

 scale 2
}

#declare sawtex= texture {
             pigment{color rgb 0.9 } finish{metfin}
 }



#declare saw=
union
{
polygon
{
  15, // number of points
  <0,0>,<1,-1>,<2,0>,<3,-1>,<4,0>,<5,-1>,<6,0>,<7,-1>,<8,0>,<9,-1>,<10,0>,<11,-1>,<11,2>,
  <0,1>,<0,0>
   texture { sawtex }
  rotate -5*z
translate -6*x
  scale 0.1
}
polygon
{
  15, // number of points
  <0,0>,<1,1>,<2,0>,<3,1>,<4,0>,<5,1>,<6,0>,<7,1>,<8,0>,<9,1>,<10,0>,<11,1>,<11,-2>,
  <0,-1>,<0,0>
   texture { sawtex }
  rotate 5*z
  translate y*2-6*x
  scale 0.1
}
torus
{
  0.4,
  0.1
  rotate 90*x
  pigment { color rgb <.8,.6,.5>  }
  scale 0.4*x+0.6*y+0.4*z
  translate x*0.66+y*0.1
}
scale 0.3
}



//------------- Die Formel -------------------

#declare font_texture = texture { metaltex scale 0.05}


#declare formel_scale = 2

#if (calcformula)
union{
text
{
  ttf        "symbol.ttf",    "",
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0,0,0>, <1,0.3,1> } }
  clipped_by { bounded_by }
  scale formel_scale
  rotate -90*x
  rotate 170*y
  translate formel_scale*(-x-2*z)
}

text
{
  ttf        "symbol.ttf",    "",
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0,0.3,0>, <1,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale
  rotate -90*x
  rotate 180*y
  translate formel_scale*(-x-2*z)

}

text
{
  ttf          // font type (only TrueType format for now)
  "symbol.ttf",  // Microsoft Windows-format TrueType font file name
  "Y",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0,0,0>, <0.6,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale
  rotate -90*x
  rotate 190*y
  translate -2*z*formel_scale
}

text
{
  ttf          // font type (only TrueType format for now)
  "symbol.ttf",  // Microsoft Windows-format TrueType font file name
  "Y",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0.6,0,0>, <1,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale
  rotate -90*x
  rotate 170*y
  translate -2*z*formel_scale
}


text
{
  ttf          // font type (only TrueType format for now)
  "symbol.ttf",  // Microsoft Windows-format TrueType font file name
  "-",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  scale formel_scale
  rotate -90*x
  rotate 180*y
  translate (x-2*z)*formel_scale
}

// dieses Stck liegt auf dem Wagen rechts
text
{
  ttf          // font type (only TrueType format for now)
  "symbol.ttf",  // Microsoft Windows-format TrueType font file name
  "-",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0,0,0>, <.2,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale
  rotate -90*x
  rotate 185*y
  translate (1.2*x-2.2*z)*formel_scale
  translate z*1.5+y*0.05+x*0.3
}

// dieses Stck liegt auf dem Wagen fast am Loch
text
{
  ttf          // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "n",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0,0,0>, <.16,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale*0.5
  rotate -90*x
  rotate 185*y
  translate (1.2*x-2.2*z)*formel_scale
  translate 4.8*z-1.2*x+0.05*y
}


text
{
  ttf          // font type (only TrueType format for now)
  "symbol.ttf",  // Microsoft Windows-format TrueType font file name
  "-",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0.2,0,0>, <.4,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale
  rotate -90*x
  rotate 200*y
  translate (x-2.2*z)*formel_scale
  translate 0.6*x-0.2*z
}

text
{
  ttf          // font type (only TrueType format for now)
  "symbol.ttf",  // Microsoft Windows-format TrueType font file name
  "-",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  bounded_by { box { <0.4,0,0>, <1,1,1> } }
  clipped_by { bounded_by }
  scale formel_scale
//  rotate -90*x
  rotate 170*y
  translate (x-2.2*z)*formel_scale-y*0.2
}
translate z*3
}


text
{
  ttf          // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "2",   // the string to create
  0.2,           // the extrusion depth
  0            // offset
  texture { font_texture }
  scale formel_scale*0.5
  rotate -90*x
  rotate 95*y
  translate (-0.2*x+1.2*z)*formel_scale
  translate -1.3*x-0.4*z+0.05*y
}
#end


//---------------- the three wheels --------------
#declare radtex = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

#declare threewheel=
union
{
torus { // rad3
  1.5, 0.5  rotate -x*90
  texture {
    radtex
  }
  scale <0.13, 0.123957, 0.601708>
  rotate <-90.0, -90.0, -90.0>
  translate  <-0.041857, -0.748849, -0.190548>
}


torus { // rad2
  1.5, 0.5  rotate -x*90
  texture {
    radtex
  }
  scale <0.13, 0.123957, 0.601708>
  rotate <-90.0, -90.0, -90.0>
  translate  <-1.052863, 1.619035, -0.190548>
}


torus { // rad1
  1.5, 0.5  rotate -x*90
  texture {
    radtex
  }
  scale <0.13, 0.123957, 0.601708>
  rotate <-90.0, -90.0, -90.0>
  translate  <0.995755, 1.619035, -0.190548>
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  texture {
    pigment {
    wood
    turbulence 0.05
    octaves 4
    scale <0.05, .05, 1>
    color_map {
        [0 color rgb <0.5, 0.37, 0.26>]
        [0.1 color rgb <0.5, 0.37, 0.26>]
        [0.9 color rgb <0.4, 0.25, 0.15>]
        [1.0 color rgb <0.4, 0.25, 0.15>]
    }
   }  scale 0.3
  }
  scale <1.026605, 1.341362, 0.174785>
  translate  <-0.026605, 0.63853, 0.0>
}

scale 0.25
rotate -90*x
rotate y*90


}



//------------------ "them" ------------

// we don't need this definition because they all are defined differently
#declare eater =
union
{
// Krper

julia_fractal {
        <-.745,0,.113,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <0.6,0,0> ]
            [0.5 colour rgb <0.7, 0.65, 0.85> ]
            [1.00 colour rgb <0.6, 0.2, 0.2> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,0.1>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,0.1>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
cone {         <-2,1.5,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-4.2,0.5,0.1>,0.01,<-2,1.5,0.1>,0.05}
cone {         <-2,-1.5,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-4.2,-0.5,0.1>,0.01,<-2,-1.5,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <0.6,0,0> ]
            [0.5 colour rgb <0.7, 0.65, 0.85> ]
            [1.00 colour rgb <0.6, 0.2, 0.2> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union


#if (calceaters)
//---------------- positioning the eaters ------------------

// "it" 1
// einer an einem liegenden Trmmerstck des =
object {
union
{
// Krper

julia_fractal {
        <-.75,0,.113,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <0.2,0,0> ]
            [0.5 colour rgb <0.3, 0.1, 0.1> ]
            [1.00 colour rgb <0.2, 0.15, 0.15> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.55*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,-0.5>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,-0.5>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
union{
cone {         <-1.7,1.9,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-3.9,0.8,0.1>,0.01,<-1.7,1.9,0.1>,0.05}}
cone {         <-2,-1,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-3.8,0.4,-0.4>,0.01,<-2,-1,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <0.2,0,0> ]
            [0.5 colour rgb <0.3, 0.1, 0.1> ]
            [1.00 colour rgb <0.2, 0.15, 0.15> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate y*230
scale 0.15
translate 0.1*y-0.8*z+0.8*x
}

// "it" 2
// noch einer an einem liegenden Trmmerstck des =, weiter vorn
object {
union
{
// Krper

julia_fractal {
        <-.743,0,.13,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0,0> ]
            [0.5 colour rgb <0.7, 0.65, 0.85> ]
            [1.00 colour rgb <0.6, 0.6, 0.8> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,0.1>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,0.1>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
cone {         <-2,1.5,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-4.2,0.5,0.1>,0.01,<-2,1.5,0.1>,0.05}
cone {         <-2,-1.5,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-4.2,-0.5,0.1>,0.01,<-2,-1.5,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0,0> ]
            [0.5 colour rgb <0.7, 0.65, 0.85> ]
            [1.00 colour rgb <0.6, 0.6, 0.8> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate -20*z
rotate y*30
scale 0.15
translate 0.1*y-2.1*z+1.8*x
}
// der kriegt noch nen Wagen - wo das Stck draufgeladen werden soll
object {threewheel
rotate y*205
translate -1.4*z+0.8*x
}

// "it" 3
// noch einer an einem liegenden Trmmerstck des =, weiter rechts
object {
union
{
// Krper
julia_fractal {
        <-.74,0,.10,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0.5,0> ]
            [0.5 colour rgb <0.5, 0.65, 0.85> ]
            [1.00 colour rgb <0.2, 0.6, 0.8> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,0.1>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,0.1>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
cone {         <-1.6,1.7,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-3,0.5,0.1>,0.01,<-1.6,1.7,0.1>,0.05}
cone {         <-1.6,-1.7,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-3,-0.5,0.1>,0.01,<-1.6,-1.7,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0.5,0> ]
            [0.5 colour rgb <0.5, 0.65, 0.85> ]
            [1.00 colour rgb <0.2, 0.6, 0.8> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union
rotate 90*x
rotate y*70
scale 0.15
translate 0.1*y-0.01*z+2.8*x
}
// der kriegt noch nen Wagen (rechts)
object {threewheel
rotate y*245
translate 0.9*z+2.5*x
}

// ein alleinstehender Wage mit einer 2 (s.o.) drauf
object {threewheel
rotate y*165
translate 1.8*z-2.2*x
}

// "it" 4
// einer weiter hinten
object {
union
{
// Krper

julia_fractal {
        <-.745,0,.113,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.7 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <0.7,0,0.3> ]
            [0.5 colour rgb <0.75, 0.65, 0.85> ]
            [1.00 colour rgb <0.8, 0.6, 0.8> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,0.1>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,0.1>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
cone {         <-1.6,2,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-3.6,1.5,0.1>,0.01,<-1.6,2,0.1>,0.05}
cone {         <-1.6,-2,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-3.6,-1.5,0.1>,0.01,<-1.6,-2,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <0.7,0,0.3> ]
            [0.5 colour rgb <0.75, 0.65, 0.85> ]
            [1.00 colour rgb <0.8, 0.6, 0.8> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate y*270
scale 0.15
translate 0.1*y+2.3*z+0.2*x
}
// der kriegt noch nen Wagen (4)
union {object {threewheel
rotate y*90}
// auf diesen Wagen Saegen
object{saw rotate 90*x translate 0.1*z+0.12*y}
object{saw rotate 90*x rotate 185*y translate -0.1*z+0.12*y-0.1*x}
translate 1.4*z+0.2*x
}





// "it" 5
// einer fast am Loch
object {
union
{
// Krper

julia_fractal {
        <-.72,0,.11,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0,0.5> ]
            [0.5 colour rgb <0.9, 0.65, 0.35> ]
            [1.00 colour rgb <0.8, 0.6, 0.3> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.8,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.5,0.1>,0.01,<-2,0.8,0.1>,0.05}

cone {         <-2,-0.8,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.5,0.1>,0.01,<-2,-0.8,0.1>,0.05}
// ueres Armpaar
cone {         <-2,1.5,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-4.2,0.5,0.1>,0.01,<-2,1.5,0.1>,0.05}
cone {         <-2,-1.5,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-4.2,-0.5,0.1>,0.01,<-2,-1.5,0.1>,0.05}
         texture {
         normal { quilted 0.5 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0,0.5> ]
            [0.5 colour rgb <0.9, 0.65, 0.35> ]
            [1.00 colour rgb <0.8, 0.6, 0.3> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate y*260
scale 0.15
translate 0.1*y+3.2*z+0.4*x
}

// "it" 6
// einer fast am Loch, weggewandt
object {
union
{
// Krper

julia_fractal {
        <-.72,0,.09,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <0.3,0,0.3> ]
            [0.5 colour rgb <0.4, 0.25, 0.5> ]
            [1.00 colour rgb <0.3, 0.1, 0.4> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,0.1>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,0.1>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
cone {         <-1.6,1.7,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-3,0.5,0.1>,0.01,<-1.6,1.7,0.1>,0.05}
cone {         <-1.6,-1.7,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-3,-0.5,0.1>,0.01,<-1.6,-1.7,0.1>,0.05}
         texture {
         normal { quilted 0.5 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <0.3,0,0.3> ]
            [0.5 colour rgb <0.4, 0.25, 0.5> ]
            [1.00 colour rgb <0.3, 0.1, 0.4> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.04
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate y*80
scale 0.15
translate 0.1*y+2.75*z+1.4*x
}
// der kriegt nen Wagen und da mu noch was drauf
object {threewheel
rotate y*255
translate 3.8*z+1.2*x
}

// "it" 7
// einer am psi
object {
union
{
// Krper

julia_fractal {
        <-.745,0,.113,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <1,1,0> ]
            [0.5 colour rgb <0.9, 0.65, 0.85> ]
            [1.00 colour rgb <0.4, 0.6, 0.8> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,0.1>,0.01,<-2,0.5,0.1>,0.05}
cone {         <-2,-0.5,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,0.1>,0.01,<-2,-0.5,0.1>,0.05}
// ueres Armpaar
cone {         <-2,1.5,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-4.2,0.5,0.1>,0.01,<-2,1.5,0.1>,0.05}
cone {         <-2,-1.5,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-4.2,-0.5,0.1>,0.01,<-2,-1.5,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <1,1,0> ]
            [0.5 colour rgb <0.9, 0.65, 0.85> ]
            [1.00 colour rgb <0.4, 0.6, 0.8> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate y*80
scale 0.15
translate 0.1*y-1.1*z-1.2*x
}

// "it" 8
// einer am nabla
object {
union
{
// Krper

julia_fractal {
        <-.745,0,.113,.05>
        max_iteration 6
        precision 20
        hypercomplex
        texture {
        normal { quilted 0.6 }
        pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0,1> ]
            [0.5 colour rgb <0.9, 0.65, 0.1> ]
            [1.00 colour rgb <0.8, 0.4, 0.8> ]
           }
        }
        finish { phong 0.7 phong_size 100 }
        scale 0.05
        }
        scale 0.1*x+0.5*y
        rotate y*90
        scale 2
}
// Arme
union
{
cone {      <-2,0.4,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{        <-3,0.2,1.8>,0.01,<-2,0.4,0.1>,0.05}
cone {         <-2,-0.4,0.1>,0.05,<-0.9,0,0.1>,0.1}
cone{         <-3,-0.2,1.8>,0.01,<-2,-0.4,0.1>,0.05}
// ueres Armpaar
cone {         <-2.4,1.1,0.1>,0.05,<0.3,0.2,0.1>,0.1}
cone{         <-4.8,0.05,0.1>,0.01,<-2.4,1.1,0.1>,0.05}
cone {         <-2.4,-1.1,0.1>,0.05,<0.3,-0.2,0.1>,0.1}
cone{         <-4.8,-0.05,0.1>,0.01,<-2.4,-1.1,0.1>,0.05}
         texture {
         normal { quilted 0.6 }
         pigment {
            ripples
            colour_map {
            [0 colour rgb <1,0,1> ]
            [0.5 colour rgb <0.9, 0.65, 0.1> ]
            [1.00 colour rgb <0.8, 0.4, 0.8> ]
           }
         }
         finish { phong 0.7 phong_size 100 }
         scale 0.05
         }
} // union arme
//Augen
sphere {<-1.1,0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
sphere {<-1.1,-0.3,-0.1>,0.1 pigment {color 0} finish {specular 1}}
} // union

rotate 90*x
rotate -25*z
rotate y*35
scale 0.15
translate 0.1*y-1.0*z-1.8*x
}

// it has a saw
object { saw
rotate -20*z
rotate y*35
translate -2.51*x+0.45*y-0.48*z
}

// another saw lying around
object { saw
rotate x*90
translate -1.7*x+0.02*y-1.3*z
}

// another saw lying around, broken
object { saw
  bounded_by { box { <-1,-1,-1>, <0,1,1> } }
  clipped_by { bounded_by }
rotate x*90
rotate y*74
translate 1.7*x+0.02*y-1.4*z
}

object { saw
  bounded_by { box { <0,-1,-1>, <1,1,1> } }
  clipped_by { bounded_by }
rotate x*90
rotate y*80
translate 1.78*x+0.02*y-1.4*z
}



#end



#if (calcfog)

fog
{
  fog_type   2
  distance   24 // was: 4
  color      rgb 0.8
  fog_offset -0.1
  fog_alt    0.2
  turbulence 1
}


#end

