// Persistence of Vision Raytracer
// Lutrin

/******************************************************************************
   A faire:
******************************************************************************/

#declare INC_LUTRIN=1
#include "common.inc"

/******************************************************************************

        textures

******************************************************************************/

#declare Lutrin_TBois1=
   texture { pigment { P_WoodGrain1A color_map { M_Wood18A }}}
   texture { pigment { P_WoodGrain1B color_map { M_Wood18B }}}
   
#declare Lutrin_TBois2=
   texture { pigment { P_WoodGrain2A color_map { M_Wood14A }}}
   texture { pigment { P_WoodGrain2B color_map { M_Wood14B }}}

/******************************************************************************

        objets

******************************************************************************/

#declare Lutrin_S1=union{
   difference{
      intersection{
         cylinder {-2*z, 2*z, 15}
         box {<0, 0, -3><20, 20, 3>}
         }
      cylinder {-3*z, 3*z, 1 scale <5, 7, 1> translate 12*x rotate 45*z}
      }
   box {<0, -2, -2><10, 2, 2> rotate 45*z}
   }

#declare Lutrin1=object{
   union{
      difference{
         union{
            cylinder {-30*x, 30*x, 1 scale <1, 15, 20>}
            cylinder {-30*x, 30*x, 1 scale <1, 3, 3> translate <0, 3, 20>}
            cylinder {-30*x, 30*x, 1 scale <1, 3, 3> translate <0, 3, -20>}
            }
         cylinder {-40*x, 40*x, 1 scale <1, 10, 15>}
         box {<-25, -1, -25> <25, 25, 25>}
         box {<-40, -40, -40> <40, 0, 40>}
         }
      object {Lutrin_S1 translate <3, 15, 0>}
      object {Lutrin_S1 rotate 180*y translate <-3, 15, 0>}
      box {<-26, 10, -2><26, 15, 2>}
      box {<-3, 15, -2> <3, 130, 2>}
      //box {<-30, 100, -20> <30, 150, 20>}
      }
   texture{Lutrin_TBois1 scale 10 rotate 87*x}
   }

#declare Lutrin2=object{
   union{
      difference{
         box {<-30, 0, -20> <30, 2, 20>}
         cylinder {-1*y, 3*y, 1 scale <20, 1, 5> translate <-30, 0, 20>}
         cylinder {-1*y, 3*y, 1 scale <20, 1, 5> translate < 30, 0, 20>}
         }
      cylinder {<-5, 0, 20> <-5, 2, 20> 5}
      cylinder {< 5, 0, 20> < 5, 2, 20> 5}
      difference{
         box {<-30, 0, -20> <30, 7, -18>}
         cylinder {-17*z, -21*z, 1 scale <23/2, 3, 1> translate <-5-23/2, 7, 0>}
         cylinder {-17*z, -21*z, 1 scale <23/2, 3, 1> translate < 5+23/2, 7, 0>}
         }
      cylinder {< -28, 7, -20> < -28, 7, -18> 2}
      cylinder {<  28, 7, -20> <  28, 7, -18> 2}
      cylinder {<-2.5, 7, -20> <-2.5, 7, -18> 2.5}
      cylinder {< 2.5, 7, -20> < 2.5, 7, -18> 2.5}
      }
   texture{Lutrin_TBois1 scale 10 rotate 2*x}
   }

#declare Lutrin3=object{
   union{
      difference{
         box {<-25, 0, 0> <25, 7, 35>}
         cylinder {-z, 36*z, 1 scale <15, .5, 1> translate <-25, 7, 0>}
         cylinder {-z, 36*z, 1 scale <15, .5, 1> translate < 25, 7, 0>}
         }
      cylinder {0, 35*z, 1 scale <5, .5, 1> translate <-5, 7, 0>}
      cylinder {0, 35*z, 1 scale <5, .5, 1> translate < 5, 7, 0>}
      }
   texture{
      pigment{
         image_map {
            png "map.png"
            map_type 0
            interpolate 2
            once
            }
         rotate 90*x scale <51, 1, 36> translate <-25.5, 0, -0.5>
         }
      }
   }
   
#declare Lutrin5=object{
   box {<-26, 0, -1> <26, .5, 36>}
   texture {
      pigment {Tan *.8}
      normal {crackle 0.5 turbulence 0.5 bump_size /*3.0*/10}
      }
   }
  
#declare Lutrin4=union{
   object {Lutrin2}
   object {Lutrin3 translate <0, 2.5, -17>}
   object {Lutrin5 translate <0, 2, -18>}
   }

#declare Lutrin=union{
   object {Lutrin1}
   object {Lutrin4 rotate 180*y rotate 50*x translate 131*y}
   }

#ifndef (INC_MAIN)
   #include "Tycho.pov"
#end
