
// Persistence of Vision Ray Tracer Scene Description File
// File: foucault.pov
// Vers: 3
// Desc: A foucault pendulum
// Date: 06/06/97
// Auth: Jared Saxton
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"
#include "metals.inc"
#include "glass.inc"

global_settings{assumed_gamma 1.5} //1.5 for focal blur, 1.0 for no focal blur

// -------------CONTROLS-------------------
#declare area_lght=1
#declare textures=1
#declare foucault=1
#declare walls_and_floor=1
#declare room_details=1
#declare foc_blur=1
#declare pegs=1
// ----------------------------------------

// -------------CAMERA----------------------
#if(foc_blur=1)
 camera{
  location<-6.75,6.5,-9.5>
  look_at<0.85,1,0>
  aperture 0.2 focal_point<-6,2,0> blur_samples 100
 }
#else
 camera{
  location<-6.75,6.5,-9.5>
  look_at<0.85,1,0>
//  look_at<0.85,10,0>
 }
#end

// ----------------------------------------

// ------------LIGHTS----------------------
#if(area_lght=1)
 light_source{0*x color red 1.0 green 1.0 blue 0.9 area_light
   <8, 0, 0> <0, 0, 8>
   4, 4
   adaptive 0
   jitter
   translate <-130, 100, 10>
 }
 light_source{0*x color red 1.0 green 1.0 blue 0.9 area_light
   <8, 0, 0> <0, 0, 8>
   4, 4
   adaptive 0
   jitter
   translate <130, 100, -10>
 }
#else
 light_source{
  0*x
  color red 1.0  green 1.0  blue 0.9
  translate <-130, 100, 10>
 }
 light_source{
  0*x
  color red 1.0  green 1.0  blue 0.9
  translate <130, 100, -10>
 }
#end

// ----------------------------------------

//-----------TEST TEXTURES----
#declare Dark_Stone =
texture{pigment{color red 0.22 green 0.07 blue 0.06}}
texture{T_Grnt15 scale <1, 2, 2> rotate <0, 0, 40>}
texture{T_Crack4 scale <1, 1, 1> rotate <10, 0, -40>
        finish{phong 1.0 phong_size 90 reflection 0.15}
}

#declare Light_Stone =
texture{pigment{color red 0.82 green 0.67 blue 0.66}}
texture{T_Grnt23 scale <1, 1, 1> rotate <10, 0, -40>}
texture{T_Grnt23a scale <1, 1, 1> rotate <10, 0, -40>}
texture{T_Crack2 scale <1, 1, 1> rotate <10, 0, -40>
        finish{phong 1.0 phong_size 90 reflection 0.15}
}

// --------TEXTURE DECLARATIONS------------

#if(textures=1)
 #declare glass_panel_tex=texture{T_Glass2}
 #declare outside_ring_tex=texture{pigment{Black} finish{reflection 0.15}}
 #declare inside_ring_tex=texture{T_Stone17 finish{reflection 0.15}}
 #declare main_floor_tex=texture{tiles{texture{Dark_Stone} tile2 texture{pigment{Black} finish{reflection 0.05}}} scale 3}
 #declare pri_star_tex=texture{T_Stone21 finish{reflection 0.15}}
 #declare sec_star_tex=texture{T_Stone17 finish{reflection 0.15}}
 #declare mid_cyl_tex=texture{T_Stone17 finish{reflection 0.15}}
 #declare pole_tex=texture{T_Brass_1A}
 #declare bob_tex=texture{Polished_Brass}
 #declare arch_tex=texture{T_Stone17 scale 3}
 #declare wall_tex=texture{T_Stone17 scale 3}
 #declare contain_tex=texture{Dark_Stone finish{reflection 0.15}}
 #declare peg_tex=texture{T_Stone17 scale 3}
 #declare floor_bracket_tex=texture{T_Brass_1A}
 #declare axel_tex=texture{Polished_Chrome}
 #declare border_tex=texture{pigment{Black} finish{reflection 0.15}}
#else
 #declare glass_panel_tex=pigment{Yellow}
 #declare outside_ring_tex=pigment{NewTan}
 #declare inside_ring_tex=pigment{Scarlet}
 #declare main_floor_tex=pigment{DarkTan}
 #declare pri_star_tex=pigment{Red}
 #declare sec_star_tex=pigment{Blue}
 #declare mid_cyl_tex=pigment{Yellow}
 #declare pole_tex=pigment{Blue}
 #declare bob_tex=pigment{CoolCopper}
 #declare arch_tex=pigment{NeonBlue}
 #declare wall_tex=pigment{NewMidnightBlue}
 #declare contain_tex=pigment{SpicyPink}
 #declare peg_tex=pigment{Red}
 #declare floor_bracket_tex=texture{T_Brass_1A}
 #declare axel_tex=pigment{Yellow}
 #declare border_tex=pigment{MidnightBlue}
#end
// ----------------------------------------

// ---------OBJECT DECLARATIONS------------
#declare column=object{
 union{
  cone{<0,5,0>,0.875,<0,16,0>,0.75}
  intersection{
   cone{<0,16,0>,0.75,<0,18,0>,1}
   box{<-0.85,16,-0.85>,<0.85,18,0.85>}
  }
  torus{0.75,0.125 translate<0,16,0>}
  torus{0.875,0.125 translate<0,5.125,0>}
  box{<-1,0,-1>,<1,5,1>}
 }
}

#declare col_set=object{
 union{
  box{<-1.5,23,-1.5>,<11.5,24,1.5>}
  union{
   object{column}
   object{column translate<10,0,0>}
   difference{
    box{<-1,18,-1>,<11,23,1>}
    cylinder{<5,18,100>,<5,18,-100>,4}
   }
  }
  union{
   difference{
    box{<0,0,-0.5>,<10,4.5,0.5>}
    #declare chunk_trans=2.5
    #while(chunk_trans<=7.5)
     cylinder{<chunk_trans,3,100>,<chunk_trans,3,-100>,1}
     box{<chunk_trans-1,3,100>,<chunk_trans+1,-10,-100>}
     #declare chunk_trans=chunk_trans+2.5
    #end
   }
  }
 }
}

#declare pri_tri=object{
 difference{
  box{<0,-1,2>,<9.5,0,-2>}
  box{<-100,-100,0>,<100,100,-100> rotate y*-12 translate z*-2}
  box{<-100,-100,0>,<100,100,100> rotate y*12 translate z*2}
 }
}

#declare pri_star=object{
 union{
  #declare tri_rot=0
  #while(tri_rot<=360)
   object{pri_tri rotate y*tri_rot}
   #declare tri_rot=tri_rot+30
  #end
 }
}

#declare sec_tri=object{
 intersection{
  object{pri_tri translate y*0.5}
  object{pri_tri rotate y*30}
 }
}

#declare sec_star=object{
 union{
  #declare tri_rot=0
  #while(tri_rot<=360)
   object{sec_tri rotate y*tri_rot}
   #declare tri_rot=tri_rot+30
  #end
 }
}

#declare pole=object{
 union{
  cylinder{<9.5,0,0>,<9.5,3.25,0>,0.2}
  sphere{<9.5,3.25,0>,0.35}
  difference{
   cylinder{<9.5,0,0>,<9.5,0.15,0>,0.35}
   torus{0.35,0.15 translate<9.5,0.15,0>}
   box{<100,0.15,100>,<-100,100,-100>}
  }
  difference{
   cylinder{<9.5,0.35,0>,<9.5,0.5,0>,0.35}
   torus{0.35,0.15 translate<9.5,0.35,0>}
   box{<100,0.35,100>,<-100,-100,-100>}
  }
  difference{
   cylinder{<9.5,1,0>,<9.5,1.15,0>,0.35}
   torus{0.35,0.15 translate<9.5,1.15,0>}
   box{<100,1.15,100>,<-100,100,-100>}
  }
  difference{
   cylinder{<9.5,1.85,0>,<9.5,2,0>,0.35}
   torus{0.35,0.15 translate<9.5,1.85,0>}
   box{<100,1.85,100>,<-100,-100,-100>}
  }
  difference{
   cylinder{<9.5,2.5,0>,<9.5,2.65,0>,0.35}
   torus{0.35,0.15 translate<9.5,2.65,0>}
   box{<100,2.65,100>,<-100,100,-100>}
  }
  difference{
   cylinder{<9.5,2.85,0>,<9.5,3,0>,0.35}
   torus{0.35,0.15 translate<9.5,2.85,0>}
   box{<100,2.85,100>,<-100,-100,-100>}
  }
  cylinder{<9.5,3,0>,<9.5,3.25,0>,0.35}
  cylinder{<9.5,2,0>,<9.5,2.5,0>,0.35}
  cylinder{<9.5,0.5,0>,<9.5,1,0>,0.35}
 }
}

#declare poles=object{
 union{
  #declare pole_rot=0
  #while(pole_rot<=360)
   object{pole rotate y*pole_rot}
   #declare pole_rot=pole_rot+30
  #end
 }
}

#declare bob=object{
 union{
  cylinder{<0,0,0>,<0,-30,0>,0.025}
  sphere{<0,-30,0>,0.75}
  sphere{<0,-29.25,0>,0.1}
  torus{0.65,0.15 translate<0,-29.9,0>}
  torus{0.65,0.15 translate<0,-30.1,0>}
  cylinder{<0,-29.9,0>,<0,-30.1,0>,0.8}
  cone{<0,-30,0>,0.25,<0,-31,0>,0.05}
  sphere{<0,-31,0>,0.05}
  rotate<0,0,-9>
  translate y*30.9
 }
}

#declare outside_ring=object{
 intersection{
  difference{
   cylinder{<0,-10,0>,<0,10,0>,6.5}
   cylinder{<0,-15,0>,<0,15,0>,6}
  }
  object{pri_star}
 }
}

#declare inside_ring=object{
 difference{
  cylinder{<0,-1,0>,<0,0,0>,6.5}
  cylinder{<0,-15,0>,<0,15,0>,6}
 }
}

#declare glass_panels=object{
 union{
  #declare glass_rot=0
  #while(glass_rot<=360)
   union{
    box{<0.125,0.25,0.4>,<-0.125,2.75,4.6>}
    difference{
     union{
      difference{
       box{<0.175,2,0>,<-0.175,2.5,0.75>}
       box{<-10,2.333,0.5625>,<10,10,10>}
       box{<-10,-10,0.5625>,<10,2.166,10>}
      }
      cylinder{<0.175,2.333,0.5625>,<-0.175,2.333,0.5625>,0.166}
      cylinder{<0.175,2.166,0.5625>,<-0.175,2.166,0.5625>,0.166}

      difference{
       box{<0.175,1,0>,<-0.175,0.5,0.75>}
       box{<-10,0.833,0.5625>,<10,10,10>}
       box{<-10,-10,0.5625>,<10,0.666,10>}
      }
      cylinder{<0.175,0.833,0.5625>,<-0.175,0.833,0.5625>,0.166}
      cylinder{<0.175,0.666,0.5625>,<-0.175,0.666,0.5625>,0.166}

      difference{
       box{<0.175,2,5>,<-0.175,2.5,4.25>}
       box{<-10,2.333,-10>,<10,10,4.4375>}
       box{<-10,-10,-10>,<10,2.166,4.4375>}
      }
      cylinder{<0.175,2.333,4.4375>,<-0.175,2.333,4.4375>,0.166}
      cylinder{<0.175,2.166,4.4375>,<-0.175,2.166,4.4375>,0.166}

      difference{
       box{<0.175,1,5>,<-0.175,0.5,4.25>}
       box{<-10,0.833,4.4375>,<10,10,-10>}
       box{<-10,-10,4.4375>,<10,0.666,-10>}
      }
      cylinder{<0.175,0.833,4.4375>,<-0.175,0.833,4.4375>,0.166}
      cylinder{<0.175,0.666,4.4375>,<-0.175,0.666,4.4375>,0.166}
      union{
       sphere{<0.15,2.166,0.5625>,0.075}
       sphere{<-0.15,2.166,0.5625>,0.075}
       sphere{<0.15,2.333,0.5625>,0.075}
       sphere{<-0.15,2.333,0.5625>,0.075}

       sphere{<0.15,0.833,0.5625>,0.075}
       sphere{<-0.15,0.833,0.5625>,0.075}
       sphere{<0.15,0.666,0.5625>,0.075}
       sphere{<-0.15,0.666,0.5625>,0.075}

       sphere{<0.15,2.166,4.4375>,0.075}
       sphere{<-0.15,2.166,4.4375>,0.075}
       sphere{<0.15,2.333,4.4375>,0.075}
       sphere{<-0.15,2.333,4.4375>,0.075}

       sphere{<0.15,0.833,4.4375>,0.075}
       sphere{<-0.15,0.833,4.4375>,0.075}
       sphere{<0.15,0.666,4.4375>,0.075}
       sphere{<-0.15,0.666,4.4375>,0.075}
       texture{Polished_Chrome}
      }
     }
     box{<0.125,0,0>,<-0.125,3,5>}
     texture{pole_tex}
    }
    rotate y*15 translate x*-9.5 rotate y*glass_rot
   }
   #declare glass_rot=glass_rot+30
  #end
 }
}

#declare contain=object{
 difference{
  cylinder{<0,-5,0>,<0,0,0>,9.5}
  #declare cont_rot=0
  #while(cont_rot<=360)
   box{<0.125,-10,0>,<-10,10,5> rotate y*15 translate x*-9.5 rotate y*cont_rot}
   #declare cont_rot=cont_rot+30
  #end
 }
}

#declare railings=object{
 union{
  #declare rail_rot=0
  #while(rail_rot<=360)
// box{<0.25,3,-0.125>,<-0.25,3.25,5.125> rotate y*15 translate x*-9.5 rotate y*rail_rot}
   torus{0.15,0.1 rotate x*90 translate<0,3.25,1> rotate y*15 translate x*-9.5 rotate y*rail_rot}
   torus{0.15,0.1 rotate x*90 translate<0,3.25,4> rotate y*15 translate x*-9.5 rotate y*rail_rot}

//   torus{0.2,0.05 rotate x*90 translate<0,3.25,1.05> rotate y*15 translate x*-9.5 rotate y*rail_rot}
//   torus{0.2,0.05 rotate x*90 translate<0,3.25,3.95> rotate y*15 translate x*-9.5 rotate y*rail_rot}


   cone{<0,3.25,1>,0.25,<0,3.25,1.5>,0.175 rotate y*15 translate x*-9.5 rotate y*rail_rot}
   cone{<0,3.25,3.5>,0.175,<0,3.25,4>,0.25 rotate y*15 translate x*-9.5 rotate y*rail_rot}
   cylinder{<0,3.25,-0.125>,<0,3.25,5.125>,0.175 rotate y*15 translate x*-9.5 rotate y*rail_rot}
   #declare rail_rot=rail_rot+30
  #end
 }
}

#declare border=object{
 union{
  #declare alt=0
  #declare bord_rot=0
  #while(bord_rot<=360)
   box{<0.35,-5,0>,<-0.35,0,5> rotate y*15 translate x*-9.5 rotate y*bord_rot
    #if(mod(alt,2)=1) texture{pigment{Black} finish{reflection 0.15}} #else texture{T_Stone17 finish{reflection 0.15}} #end}
   #declare alt=alt+1
   #declare bord_rot=bord_rot+30
  #end
 }
}

#declare arch_stone=object{
difference{
  cylinder{<0,0,-2>,<0,0,2>,7}
  cylinder{<0,0,-10>,<0,0,10>,5}
  box{<-10,0,-10>,<10,10,10> rotate z*(180/14)}
  box{<10,0,10>,<-10,-10,-10>}
  box{<-10,-10,-10>,<10,10,0> rotate y*18}
  box{<-10,-10,10>,<10,10,0> rotate y*-18}
 }
}

#declare arch=object{
 union{
  #declare arch_rot=0
  #declare stone_count=1
  #while(stone_count<=13)
   object{arch_stone rotate z*arch_rot}
   #declare arch_rot=arch_rot+(180/13)
   #declare stone_count=stone_count+1
  #end
 }
}

#declare R1=seed(34837)
#declare block=object{
 difference{
  box{<0,0,-2>,<6,3,2>}
  cylinder{<-10,3,-2>,<10,3,-2>,0.125}
  cylinder{<-10,3,2>,<10,3,2>,0.125}
  cylinder{<-10,0,-2>,<10,0,-2>,0.125}
  cylinder{<-10,0,2>,<10,0,2>,0.125}
  cylinder{<0,-10,-2>,<0,10,-2>,0.125}
  cylinder{<0,-10,2>,<0,10,2>,0.125}
  cylinder{<6,-10,-2>,<6,10,-2>,0.125}
  cylinder{<6,-10,2>,<6,10,2>,0.125}
  cylinder{<0,3,-10>,<0,3,10>,0.125}
  cylinder{<6,3,-10>,<6,3,10>,0.125}
  cylinder{<0,0,-10>,<0,0,10>,0.125}
  cylinder{<6,0,-10>,<6,0,10>,0.125}
 }
}

#declare short_block=object{
 difference{
  box{<0,0,-2>,<3,3,2>}
  cylinder{<-10,3,-2>,<10,3,-2>,0.125}
  cylinder{<-10,3,2>,<10,3,2>,0.125}
  cylinder{<-10,0,-2>,<10,0,-2>,0.125}
  cylinder{<-10,0,2>,<10,0,2>,0.125}
  cylinder{<0,-10,-2>,<0,10,-2>,0.125}
  cylinder{<0,-10,2>,<0,10,2>,0.125}
  cylinder{<3,-10,-2>,<3,10,-2>,0.125}
  cylinder{<3,-10,2>,<3,10,2>,0.125}
  cylinder{<0,3,-10>,<0,3,10>,0.125}
  cylinder{<3,3,-10>,<3,3,10>,0.125}
  cylinder{<0,0,-10>,<0,0,10>,0.125}
  cylinder{<3,0,-10>,<3,0,10>,0.125}
 }
}

#declare wall=object{
 union{
  #declare block_y_trans=2
  #while(block_y_trans<15)
   #declare block_x_trans=0
   #while(block_x_trans<200)
    object{block translate<block_x_trans,block_y_trans,0> texture{wall_tex rotate z*((rand(R1)*90)-45) translate<rand(R1)*100,rand(R1)*100,rand(R1)*100>}}
    #declare block_x_trans=block_x_trans+6
   #end
   #declare block_y_trans=block_y_trans+6
  #end

  #declare block_y_trans=5
  #while(block_y_trans<15)
   #declare block_x_trans=3
   #while(block_x_trans<200)
    object{block translate<block_x_trans,block_y_trans,0> texture{wall_tex rotate z*((rand(R1)*90)-45) translate<rand(R1)*100,rand(R1)*100,rand(R1)*100>}}
    #declare block_x_trans=block_x_trans+6
   #end
   #declare block_y_trans=block_y_trans+6
  #end

  #declare block_y_trans=5
  #while(block_y_trans<15)
   object{short_block translate<0,block_y_trans,0> texture{wall_tex rotate z*((rand(R1)*90)-45) translate<rand(R1)*100,rand(R1)*100,rand(R1)*100>}}
   #declare block_y_trans=block_y_trans+6
  #end

  difference{
   box{<-1,0,-3>,<500,2,3>}
   cylinder{<-10,2,-3>,<500,2,-3>,0.5}
   cylinder{<-10,2,3>,<500,2,3>,0.5}
   cylinder{<-1,2,-10>,<-1,2,10>,0.5}
   texture{wall_tex}
  }
  object{col_set translate<-50,15,0> texture{wall_tex}}
  object{col_set translate<-40,15,0> texture{wall_tex}}
  object{col_set translate<-30,15,0> texture{wall_tex}}
  object{col_set translate<-20,15,0> texture{wall_tex}}
  object{col_set translate<-10,15,0> texture{wall_tex}}
  object{col_set translate<0,15,0> texture{wall_tex}}
  object{col_set translate<10,15,0> texture{wall_tex}}
  object{col_set translate<20,15,0> texture{wall_tex}}
  object{col_set translate<30,15,0> texture{wall_tex}}
  object{col_set translate<40,15,0> texture{wall_tex}}
  object{col_set translate<50,15,0> texture{wall_tex}}
 }
}

#declare new_arch=object{
 difference{
  box{<-5,10,-2>,<5,17,2>}
  cylinder{<0,10,-100>,<0,10,100>,5}
  texture{wall_tex}
 }
}

#declare full_wall=object{
 union{
  object{wall translate x*5}
  object{wall rotate y*180 translate x*-5}
  object{new_arch}
//  object{arch translate y*15 texture{arch_tex}}
  object{col_set translate<-50,15,0> texture{wall_tex}}
  object{col_set translate<-40,15,0> texture{wall_tex}}
  object{col_set translate<-30,15,0> texture{wall_tex}}
  object{col_set translate<-20,15,0> texture{wall_tex}}
  object{col_set translate<-10,15,0> texture{wall_tex}}
  object{col_set translate<0,15,0> texture{wall_tex}}
  object{col_set translate<10,15,0> texture{wall_tex}}
  object{col_set translate<20,15,0> texture{wall_tex}}
  object{col_set translate<30,15,0> texture{wall_tex}}
  object{col_set translate<40,15,0> texture{wall_tex}}
  object{col_set translate<50,15,0> texture{wall_tex}}
 }
}

#declare peg=object{
 union{
  union{
   torus{0.04, 0.025 translate y*0.35}
   cylinder{<0,0,0>,<0,0.365,0>,0.04}
   cylinder{<0,-0.025,0>,<0,0.35,0>,0.065}
   rotate z*20
   translate<6.25,0.15,0>
   texture{peg_tex}
  }
  union{
   cylinder{<6.25,0.15,0.125>,<6.25,0.15,0.09>,0.05}
   cylinder{<6.25,0.15,-0.125>,<6.25,0.15,-0.09>,0.05}
   box{<6.3,0,0.125>,<6.2,0.15,0.09>}
   box{<6.3,0,-0.125>,<6.2,0.15,-0.09>}
   box{<6.125,0,0.125>,<6.325,0.01,-0.125>}
   texture{floor_bracket_tex}
  }
  cylinder{<6.25,0.15,0.135>,<6.25,0.15,-0.135>,0.0135 texture{axel_tex}}
 }
}

#declare fallen_peg=object{
 union{
  union{
   torus{0.04, 0.025 translate y*0.35}
   cylinder{<0,0,0>,<0,0.365,0>,0.04}
   cylinder{<0,-0.025,0>,<0,0.35,0>,0.065}
   rotate z*-105
   translate<6.25,0.15,0>
   texture{peg_tex}
  }
  union{
   cylinder{<6.25,0.15,0.125>,<6.25,0.15,0.09>,0.05}
   cylinder{<6.25,0.15,-0.125>,<6.25,0.15,-0.09>,0.05}
   box{<6.3,0,0.125>,<6.2,0.15,0.09>}
   box{<6.3,0,-0.125>,<6.2,0.15,-0.09>}
   box{<6.125,0,0.125>,<6.325,0.01,-0.125>}
   texture{floor_bracket_tex}
  }
  cylinder{<6.25,0.15,0.135>,<6.25,0.15,-0.135>,0.0135 texture{axel_tex}}
 }
}


#declare pegs_1=object{
 union{
  #declare peg_rot=5
  #while(peg_rot<=150)
   object{peg rotate y*peg_rot}
   #declare peg_rot=peg_rot+5
  #end
 }
}

#declare pegs_2=object{
 union{
  #declare peg_rot=155
  #while(peg_rot<=180)
   object{fallen_peg rotate y*peg_rot}
   #declare peg_rot=peg_rot+5
  #end
 }
}

#declare pegs_3=object{
 union{
  #declare peg_rot=185
  #while(peg_rot<=330)
   object{peg rotate y*peg_rot}
   #declare peg_rot=peg_rot+5
  #end
 }
}

#declare pegs_4=object{
 union{
  #declare peg_rot=335
  #while(peg_rot<=360)
   object{fallen_peg rotate y*peg_rot}
   #declare peg_rot=peg_rot+5
  #end
 }
}


// ----------------------------------------

// -------------MAIN-----------------------
#if(foucault=1)
 object{bob texture{bob_tex}}
 object{poles texture{pole_tex}}
 object{contain translate y*0.001 texture{contain_tex}}
 object{border translate y*0.002} //texture{border_tex}
 object{inside_ring translate y*0.003 texture{inside_ring_tex}}
 object{pri_star translate y*0.004 texture{pri_star_tex}}

 object{sec_star scale 1.0 translate y*0.005 texture{sec_star_tex}}
 object{sec_star scale 0.8 translate y*0.006 texture{pri_star_tex}}

 cylinder{<0,-1,0>,<0,0,0>,1.75 translate y*0.009 texture{mid_cyl_tex}}
 cylinder{<0,-1,0>,<0,0,0>,1.75*0.9 translate y*0.010 texture{mid_cyl_tex}}

 object{outside_ring translate y*0.011 texture{outside_ring_tex}}

 object{glass_panels texture{glass_panel_tex}}
 object{railings texture{pole_tex}}
#end

#if(walls_and_floor=1)
 plane{y,0 texture{main_floor_tex}}
 object{full_wall translate<-20,0,75>}
 object{full_wall translate<0,0,25>}
 object{full_wall translate<0,0,-25>}
 object{wall rotate y*90 translate<50,0,23>}
#end

#if(pegs=1)
 object{pegs_1}
 object{pegs_2}
 object{pegs_3}
 object{pegs_4}
#end
// ----------------------------------------
