// File: .pov
// Vers: 3
// Desc: Geometry, the Queen of Mathematics
// Date: 22-June-97
// Auth: SjG libelle@webbwerks.com
// incredibly simple(minded), actually.

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare StdCam = camera
	{
	location  <0.0, 0, -6.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.0,  0.0>
	}

#declare ZoomCam = camera
	{
	location  <3.0, 0, -4.0>
	direction 2.0*z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.0,  0.0>
	}

#declare mainLight = light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.0
  translate <-100,80,-80>
  atmosphere off
  shadowless
}

#declare secondLight = light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.0
  translate <0,0,100>
  atmosphere off
  shadowless
}

#declare flareLight = light_source {
    0*x
	color rgb <1, 1, 1>
	spotlight
	translate <0,1,80>
	point_at <0,60,20>
	radius 80
	tightness 5
	falloff 89.5
  }

#declare theDarkness = atmosphere {
    type 1
    samples 60
    distance 120
    scattering 0.005
    aa_level 8
    aa_threshold 0.207
    jitter 0.051
}

#declare GeoEarth = height_field
{
  tga "HillBump.tga" smooth
  texture
  {
  finish
	{
	roughness 0.8
	}
   pigment
    {
      image_map { gif "GeoGrid.gif" map_type 0 interpolate 2 once }
      rotate x*90
    }
  }
  translate <-0.5, 0, -0.5>
}

#declare GeoWhizzy = height_field
		{
  		tga "moor47small2.tga" 
  		water_level 0.04
  		texture
  			{
			finish
	 			{
	 			ambient 0.9 //.82
	 			}
    		pigment
    			{
      			image_map { tga "ColorFlare.tga" map_type 0 interpolate 2 once }
      			rotate x*90 
    			}
  			}
  		translate <-0.5, 0, -0.5>
  		scale <1,0.04,1>
		}

// Actual scene gets put together here...
camera{StdCam translate <0,10,-50>}
object{mainLight}
object{secondLight}
object{flareLight}
atmosphere{theDarkness}

object{GeoWhizzy scale <100,10,100> rotate<-75,0,0> translate <0,35,80>}
object{GeoEarth scale <400,60,400> rotate <-10,0,0> translate <0,-60,120>}


