
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3
#include "colors.inc"
#include "\povwin3\myfiles\sun.inc"
#include "\povwin3\myfiles\venus.inc"
#include "\povwin3\myfiles\mercury.inc"
#include "\povwin3\myfiles\mars.inc"
#include "\povwin3\myfiles\earth.inc"
#include "\povwin3\myfiles\space.inc"
#include "stars.inc"

global_settings
{
  assumed_gamma 1.0
}

sky_sphere
{
pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .5
    }
    }

/*
object {sun
       scale .5
       translate .5*y
       }
*/
object {venus
       scale .3
       translate <.4,.35,2.25>
       }

object {mercury
       scale .2
       translate <-1.5,.35,.8>
       }
object {mars
       scale .35
       rotate 90*y
       translate <4.25,.35,.85>
       }
object {earth
       scale .35
       translate <1.35,.35,-2>}
object {space
       rotate 30*y}
// ----------------------------------------
camera
{
  location  <0.0, 4, -6.0>
  look_at   <0.0, 0.0,  0.0>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate 1*y
  looks_like {sun}
  scale .51
}



/*
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
  shadowless
}
*/

