#include "colors.inc"
#include "textures.inc"

#declare r1=seed(1000)
#declare r2=seed(101)

#declare NVn=<-20,20,0>
#declare NVu=<-20,20,20>
#declare NOn=<40,20,0>
#declare NOu=<40,20,20>
#declare SVn=<-20,-40,0>
#declare SVu=<-20,-40,20>
#declare SOn=<40,-40,0>
#declare SOu=<40,-40,20>

//background{color rgb<.7,.7,.9>}
plane{y,10000 pigment{color White}finish{ambient 1 diffuse 0}}

#declare TubWood=
texture {  /* Bottom wood-grain layer */
    pigment {
        wood
        turbulence 0.05
        //octaves rand(r1)*8
        translate y*rand(r1)*10-5
        colour_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]
        }
       warp
        {black_hole <0,0,0>,.5
         falloff 2
         strength 4
         repeat<1.1,1.1,1.1>
        }
    }
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0 //0.2
        phong_size 0 //10
    }
    normal { bumps 0.05 }
}
texture {     /* top layer, adds small dark spots */
    pigment {
        bozo
        turbulence rand(r1)*.1
        //translate y*rand(r2)*10
        translate y*rand(r1)*10-5
        color_map {
            [0.0 0.8 color rgbf <1.00, 1.00, 1.00, 1.00>
                     color rgbf <1.00, 0.90, 0.80, 0.80>]
            [0.8 1.0 color rgbf <1.00, 0.90, 0.80, 0.80>
                     color rgbf <0.30, 0.20, 0.10, 0.40>]
        }
    scale 0.25
    }
}
/*  normal {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    slope_map {
        /*[0.0, 0.1 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.888, 0.600, 0.3>]
        [0.1, 0.9 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.600, 0.400, 0.2>]
        [0.9, 1.0 color rgb <0.600, 0.400, 0.2>
                  color rgb <0.600, 0.400, 0.2>]*/
        [0  <(.888+.6+.3)/3,.5>]
        [.1 <(.888+.6+.3)/3,.5>]
        [.9 <(.6+.4+.2)/3,.5>]
    }

}*/

//}

camera
 {up y
  right<-1.333,0,0>
  location<0,-20,8>
  look_at<0,0,4>}
camera {  //  Camera StdCam
  location  <-2, -25, 2>//<-5,0,14>//
  //direction <0.0,     0.0,  8.7329>
  direction<0,0,1.6>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <3,0,7>//<-5,30,14>//4
}


/*light_source
 {<3,-5,3>*2 color White}
light_source
 {<-3,-5,7> color White}*/

light_source // p norrsidan
 {<0,30,20>*100 color White}
light_source //i taket
 {<10,-10,19> color Gray40 shadowless}
/*light_source // p vstersidan
 {<-30,-5,10> color White}
*/

#declare varv=0
#while (varv<36)
 box
 {<-.49,0,0>,<.49,.2,6>
  //pigment{color White}
  //texture{DMFWood4}
  texture {  /* Bottom wood-grain layer */
    pigment {
        wood
        turbulence 0.05
        //octaves rand(r1)*8
        translate y*rand(r1)*10-5
        colour_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]
        }
       warp
        {black_hole <0,0,0>,.5
         falloff 2
         strength 4
         repeat<1.1,1.1,1.1>
        }
    }
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0 //0.2
        phong_size 0 //10
    }
    normal { bumps 0.05 }
}
texture {     /* top layer, adds small dark spots */
    pigment {
        bozo
        turbulence rand(r1)*.1
        //translate y*rand(r2)*10
        translate y*rand(r1)*10-5
        color_map {
            [0.0 0.8 color rgbf <1.00, 1.00, 1.00, 1.00>
                     color rgbf <1.00, 0.90, 0.80, 0.80>]
            [0.8 1.0 color rgbf <1.00, 0.90, 0.80, 0.80>
                     color rgbf <0.30, 0.20, 0.10, 0.40>]
        }
    scale 0.25
    }
}
//texture{TubWood}
  normal {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    slope_map {
        /*[0.0, 0.1 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.888, 0.600, 0.3>]
        [0.1, 0.9 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.600, 0.400, 0.2>]
        [0.9, 1.0 color rgb <0.600, 0.400, 0.2>
                  color rgb <0.600, 0.400, 0.2>]*/
        [0  <(.888+.6+.3)/3,.5>]
        [.1 <(.888+.6+.3)/3,.5>]
        [.9 <(.6+.4+.2)/3,.5>]
    }

}
 rotate x*(5.25+rand(r1)*1.5)
 translate <0,-5.3,0>
 rotate z*360*(varv/36)
 //translate <0,10,0> //
 }
#declare varv=varv+1
#end

torus
 {5.75,.11
  rotate x*90
  //texture{TubWood rotate y*90}
  texture{DMFWood4}
  translate z*4
  //translate <0,10,0> //
 }
torus
 {5.5,.11
  rotate x*90
  //texture{TubWood rotate y*90}
  texture{DMFWood4}
  translate z*2
  //translate <0,10,0> //
 }


intersection            // BORTRE VGGEN
 {box
   {NVn,NOu+y*5
   }
  box       //fnster1
   {<-10,19,7>,<0,26,13>
    inverse
   }
  cylinder  //fnster1
   {<-5,19,13>,<-5,26,13>,5
    inverse
   }
  box       //fnster2
   {<-10,19,7>,<0,26,13>
    translate x*20
    inverse
   }
  cylinder  //fnster2
   {<-5,19,13>,<-5,26,13>,5
    translate x*20
    inverse
   }
  pigment{color rgb<.8,.8,.7>}
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }

/*box             //SLAFS
 {<-10,20.1,0>,<0,19.9999,7>
  translate x*20
  texture
  {
  pigment
   {bozo
    color_map
     {[0 color ForestGreen filter 1]
      [1 color rgbf<.8,.8,.7,1>]
     }
    scale <.15,.15,10>
   }
  } //(slut p texture)
  texture
  {
  pigment
   {onion
    color_map
     {[0 color rgbf<.8,.8,.7,0>]
      //[0 color rgbf<.8,.8,.7,0>]
      [1 color rgbf<.8,.8,.7,.6>]
     }
     scale <15,10,18>//<10,10,18>
     translate <15,20,0>
   }
  } //(slut p texture)
  /*texture
  {
  pigment
   {onion
    color_map
     {[0 color rgbf<1,1,1,1>]
      [.5 color rgbf<1,1,1,1>]
      [1 color rgbf<.8,.8,.7,0>]
     }
     scale <10,10,18>
     translate <15,20,10>
   }
  } //(slut p texture)*/
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }*/


#declare varv=0              //GALLRET 1
#while (varv<10)
 cylinder
  {0,<0,0,14>,.1
   pigment{color Black}
   rotate -y*20
   translate<-9+varv*1.3,23,6.8>
  }
 cylinder
  {0,<0,0,14>,.1
   pigment{color Black}
   rotate y*20
   translate<-9-1.3*3+varv*1.3,23,6.8> //14
  }
 #declare varv=varv+1
#end
cylinder
 {<-10,23,7>,<0,23,7>,.2
  pigment{color Black}
 }
cylinder
 {<-10,23,7>,<-10,23,17>,.2
  pigment{color Black}
 }
cylinder
 {<0,23,7>,<0,23,17>,.2
  pigment{color Black}
 }
intersection
 {torus
   {5,.2
    translate<-5,23,13>
   }
  plane
   {z,13
    inverse
   }
  pigment{color Black}
 }

#declare varv=0
#declare vurv=0
#while (vurv<7)
#while (varv<9)
intersection
 {box
   {<-1,-0.01,0>,<1,0.01,3.5>}
  plane
   {x,0
    rotate y*20
   }
  plane
   {x,0
    rotate -y*20
    inverse
   }
  plane
   {x,0
    rotate y*20
    translate -x*1.3
    inverse
   }
  plane
   {x,0
    rotate -y*20
    translate x*1.3
   }
  translate <-10.28+varv*1.3,23,-1.7+7+vurv*1.7>
  #if (mod(vurv,2) = 0)
   translate x*.65
  #end
  pigment{color rgbf<1,rand(r1)/3+.7,0.2/*rand(r2)/6+.3*/,.7>}
  normal{bumps 2 scale .5}
 }
 #declare varv=varv+1
#end //varv
#declare varv=0
#declare vurv=vurv+1
#end //vurv

union{
#declare varv=0              //GALLRET 2
#while (varv<10)
 cylinder
  {0,<0,0,14>,.1
   pigment{color Black}
   rotate -y*20
   translate<-9+varv*1.3,23,6.8>
  }
 cylinder
  {0,<0,0,14>,.1
   pigment{color Black}
   rotate y*20
   translate<-9-1.3*3+varv*1.3,23,6.8> //14
  }
 #declare varv=varv+1
#end
cylinder
 {<-10,23,7>,<0,23,7>,.2
  pigment{color Black}
 }
cylinder
 {<-10,23,7>,<-10,23,17>,.2
  pigment{color Black}
 }
cylinder
 {<0,23,7>,<0,23,17>,.2
  pigment{color Black}
 }
intersection
 {torus
   {5,.2
    translate<-5,23,13>
   }
  plane
   {z,13
    inverse
   }
  pigment{color Black}
 }

#declare varv=0
#declare vurv=0
#while (vurv<7)
#while (varv<9)
intersection
 {box
   {<-1,-0.01,0>,<1,0.01,3.5>}
  plane
   {x,0
    rotate y*20
   }
  plane
   {x,0
    rotate -y*20
    inverse
   }
  plane
   {x,0
    rotate y*20
    translate -x*1.3
    inverse
   }
  plane
   {x,0
    rotate -y*20
    translate x*1.3
   }
  translate <-10.28+varv*1.3,23,-1.7+7+vurv*1.7>
  #if (mod(vurv,2) = 0)
   translate x*.65
  #end
  pigment{color rgbf<1,rand(r1)/3+.7,0.2/*rand(r2)/6+.3*/,.7>}
  normal{bumps 2 scale .5}
 }
 #declare varv=varv+1
#end //varv
#declare varv=0
#declare vurv=vurv+1
#end //vurv

translate x*20
    }


box                    // GOLVET
 {NVn,SOn
  pigment{color rgb<.8,.8,.7>}
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }

box                   // HGERVGGEN
 {NOn,SOu
  pigment{color rgb<.8,.8,.7>}
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }

intersection
 {box                   // VNSTERVGGEN
   {NVn-x*5,SVu
   }
  box       //fnster1
   {<-19,0,7>,<-26,-19,13>
    inverse
   }
  cylinder  //fnster1
   {<-19,-5,13>,<-26,-5,13>,5
    inverse
   }
  pigment{color rgb<.8,.8,.7>}
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }

box                 // BAKOMVGGEN
 {SVn,SOu
  pigment{color rgb<.8,.8,.7>}
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }

box                 // TAKET
 {NVu+y*1,SOu+z*5
  pigment{color rgb<.8,.8,.7>}
  finish{ambient .4 diffuse .4}
  normal{bumps .3 scale .2}
 }



#include "..\..\blob\vatten.pov"
object
 {Vatten
  rotate x*90
  scale <4,4,.5>
  translate <6,-4,0>
  //pigment{color rgbt<1,1,1,.7>
  texture{Glass}
 }

/*plane
 {y,23
  pigment
   {checker
    color_map
     {[0 color Black]
      [1 color White]
     }
   }
 }*/
