////////////////////////////////////////////////////////////////////////////
//
//  COLOR CIRCLE ...
//  
//  The rgb values go through the color circle like this: 
//  
//  1 -- .RRRRRR.GGGGGGGGGGGGG.BBBBBBBBBBBBB.RRRRRR.
//             G R           B G           R B      
//            G   R         B   G         R   B     
//           G     R       B     G       R     B    
//          G       R     B       G     R       B   
//         G         R   B         G   R         B  
//        G           R B           G R           B 
//  0 -- .BBBBBBBBBBBBB.RRRRRRRRRRRRR.GGGGGGGGGGGGG.
//                                                  
//       |      |      |      |      |      |      |
//      000    060    120    180    240    300    360                
// 
//  These functions can be expressed using the max, min and abs
//  functions as shown below (valid for degrees A with 0 <= A <= 360):
// 
//  R = min (1, max(0, abs(A/60-3) - 1))
//  G = min (1, max(0, 2 - abs(A/60-2)))
//  B = min (1, max(0, 2 - abs(A/60-4)))
//
//  Optionally the 0 value can be shifted, giving the colors a higher
//  lightness (I'm not sure if I used the proper terminology here!!)

//
// GLOBAL VARIABLES:
// IN:  Hue        in interval 0 .. 360
//      Saturation in interval 0 .. 1 (0 is grey)
//      Value      in interval 0 .. 1 (0 is black)
// OUT: Color  in RGB 
//
////////////////////////////////////////////////////////////////////////////


#declare __h = Hue/60
#declare __s = Saturation
#declare __v = Value

#declare __i = int(__h);
#declare __f = __h - __i
#if(mod(__i,2) = 0)
  #declare __f = 1 - __f // if i is even
#end
#declare __m = __v * (1 - __s)
#declare __n = __v * (1 - __s * __f)
#switch (__i)
     #case (6)
     #case (0) 
       #declare __Cr = __v #declare __Cg = __n #declare __Cb = __m
     #break
     #case (1) 
       #declare __Cr = __n #declare __Cg = __v #declare __Cb = __m
     #break
     #case (2) 
       #declare __Cr = __m #declare __Cg = __v #declare __Cb = __n
     #break
     #case (3) 
       #declare __Cr = __m #declare __Cg = __n #declare __Cb = __v
     #break
     #case (4) 
       #declare __Cr = __n #declare __Cg = __m #declare __Cb = __v
     #break
     #case (5) 
       #declare __Cr = __v #declare __Cg = __m #declare __Cb = __n
     #break
#end

#declare Color = color <__Cr, __Cg, __Cb>
