#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "stones.inc"
#include "skies.inc"

// in camera: location <p,p,p> is essential!
  camera {
    orthographic
    up <1,0,0>*48
    right <4/3,0,0>*48
    location <100,100,100>
    look_at <0,0,0>
  }

// in light: x > y > z is essential!
light_source
  { <800,650,500> color White*2 }


#declare R = 1.5

#declare Ring =  torus { 4.5, R }

#declare Stick1 = 
// cylinder { <0,0,0>, <3,0,0>, R }
// prevent top of stick to be visible, so not a real cylinder, but:
 difference {
    cylinder { <0,0,0>, <3,0,0>, R  }
    plane { <0,1,1>, 0 }
    sphere { <3,0,0>, R }
}

#declare Stick2 = 
  cylinder { <3,0,0>, <18,0,0>, R }

#declare Thing1 = 
  merge {
    object { Ring }    
    object { Stick1 translate <5,0,0> }
  }

#declare Thing2 = 
  merge {
    object { Stick2 translate <5,0,0> }
    object { Ring translate <28,0,0> }
  }


#declare Thing = 
  merge { 
    object { Thing1 }
    object { Thing2 }
  }

#declare BasicTex = 
  texture { 
    finish { phong .9  phong_size 100 ambient 0.3 }
    normal { granite .2 scale 1.5 }
  }

#declare Pigment = 
  pigment { 
    bozo turbulence .4 omega .7 scale .1
    translate <3,10,5>
  }

#declare ColorBands = 5
#declare ColorStep = 2
#declare Saturation = .8
#declare Value = .7

#declare HueMin = 75
#declare HueMax = 300
#include "imposcol.inc"
#declare T1 = texture { ColorTex }

#declare HueMin = HueMin+120
#declare HueMax = HueMax+120
#include "imposcol.inc"
#declare T2 = texture { ColorTex }

#declare HueMin = HueMin+120
#declare HueMax = HueMax+120
#include "imposcol.inc"
#declare T3 = texture { ColorTex }

#declare System =
  union { 
    object { Thing
      texture { T1 } 
    }
    object { Thing
       rotate x*-90 rotate y*-90 translate <14,0,0> 
       texture { T2 }
    }
    // here's where 3D is faked!!:
    merge {
      object { Thing1  
	rotate x*90 rotate z*90 translate <14,0,14> texture { T3 }
      }
      object { Thing2  
	rotate x*90 rotate z*90 translate <14,0,14> texture { T3 }
	translate <-14,-14,-14> 
      }
    }
  }

object { System translate <-5,0,0> }



#declare BasicTex = 
  texture { 
    finish { ambient 0.4 }
  }

#declare Pigment = 
  pigment {
    marble turbulence .4 omega .7 scale 25
//    translate <10,15,7> rotate <13,23,34> 
  }

#declare ColorBands = 41
#declare ColorStep  = 20
#declare Saturation = .35
#declare Value = .5
#declare HueMin = 0
#declare HueMax = 360
#include "imposcol.inc"


#declare Sky = 
  sphere { <0,0,0>, 10000 hollow
    texture { ColorTex scale .1 }
  }

object { Sky }

