// viewpoint
camera {
  location <2,8,-9>
  direction <0,0,1>
  up <0,1,0>
  right <1.33,0,0>
  look_at <0,0,0>
}

// lights
light_source { <10,10,-10> color rgb<0.7,0.7,0.7> }
light_source { <0,500,0> color rgb<0.4,0.4,0.4> }

// atmosphere
fog { distance 40 color rgb<0.8,0.9,1> }

// mountains
height_field {
  tga "1.tga"
  translate <-0.5,-0.5,-0.5>
  scale <32,6,32>
  translate -0.5*y
  pigment {
    marble color_map {
      [0 color rgb<0.3,0.15,0.12>]
      [1 color rgb<0.5,0.3,0.1>]
    }
    turbulence 2
  }
}

// trees & shrubbery
height_field {
  tga "2.tga"
  translate <-0.5,-0.5,-0.5>
  scale <32,6,32>
  pigment { rgb<0.1,0.2,0.05> }
}

// the beach
height_field {
  tga "3.tga"
  translate <-0.5,-0.5,-0.5>
  scale <32,4,32>
  pigment { rgb<1,0.9,0.7> }
  translate 0.07*y
}

// the sea
difference {
  plane { <0,1,0>, 0 }
  cylinder { <-3,-10,1>, <-3,10,1>, 5 }
  pigment { rgb<0,0,0.36> }
  normal { ripples 0.5 scale 1000 frequency 16000 }
  finish { phong 0.9 reflection 0.5 diffuse 0.5 ambient 0 }
  translate -0.32*y
}

// a little cloud covering
plane { <0,1,0>, 0
  pigment {
    bozo color_map {
      [0 color rgbt<0.8,0.9,1,0>]
      [0.8 color rgbt<0.8,0.9,1,1>]
    }
    turbulence 1
    scale <2,3,3>
  }
  finish { ambient 0.3 diffuse 0.7 }
  translate 7.999*y
  hollow
}
/*
// lightning include files
#include "bolt1.inc"
#include "bolt2.inc"
#include "bolt3.inc"
#include "bolt4.inc"

// up front lightning bolt
object {
  Bolt1 
  matrix <1, 0, 0,
          0.3,1,-0.6,
          0, 0, 1,
          0, 0, 0>
  scale <7,8,6>
  translate <0.75,0.2,-4>
  pigment { rgb<0.96,0.84,1> } 
  finish { ambient 1.2 diffuse 0.25 } 
  no_shadow
}

// lightning on distant island to the right
object {
  Bolt2
  scale <9,12,10>
  translate <2.5,0,15>
  pigment { rgb<0.96,0.84,1> }
  finish { ambient 1.1 diffuse 0.25 }
  no_shadow
}

// middle lightning bolt
object {
  Bolt3
  scale 10
  rotate -8*y
  translate <-5.8,0.2,0>
  pigment { rgb<0.96,0.84,1> }
  finish { ambient 1.1 diffuse 0.25 }
  no_shadow
}

// bolt in the mountains
object {
  Bolt4
  rotate 30*y
  matrix <1, 0, 0,
          -0.3, 1, 0.2,
          0, 0, 1,
          0, 0, 0>
  scale 8
  translate <-6,0.6,6>
  pigment { rgb<0.96,0.84,1> }
  finish { ambient 1.1 diffuse 0.25 }
  no_shadow
}
*/
// scarf & arms include files
#include "scarf.inc"
#include "branch1.inc"
#include "branch2.inc"

// snowy toy
union {
  // glass shell
  difference {
    sphere { <0,0,0>, 1 }
    sphere { <0,0,0>, 0.96 }
    plane { <0,1,0>, 0 }
    pigment { rgbt<1,1,1,1> }
    finish { refraction 1 ior 1.25 reflection 0.1 phong 0.6 phong_size 150 }
    scale <1,1,0.8>
  }
  // metal base
  cylinder { <0,0,0>, <0,-0.15,0>, 1.05
    pigment { rgb<0.2,0.5,0.6> }
    finish { reflection 0.2 phong 0.6 }
    scale <1,1,0.8>
  }
  // snowman
  union {
    // three big snowballs
    union {
      difference {
        sphere { <0,0.1,0>, 0.2 }
        plane { <0,1,0>, 0 }
      }
      sphere { <0,0.3,0>, 0.13 }
      sphere { <0,0.5,0>, 0.08 }
      pigment { rgb<1,1,1> }
      normal { bumps 0.3 scale 0.03 }
    }
    // coals for eyes and mouth
    union {
      sphere { <0,0,-0.08>, 0.01 rotate 25*x rotate 18*y translate 0.5*y }
      sphere { <0,0,-0.08>, 0.01 rotate 25*x rotate -18*y translate 0.5*y }
      #declare Count = 0
      #while (Count < 6)
        intersection {
          sphere { <0,0.5,0>, 0.084 }
          cylinder { <0,-0.06,-0.1>, <0,-0.06,0>, 0.008 rotate (50-Count*20)*z translate 0.515*y }
        }
        #declare Count = Count + 1
      #end
      pigment { rgb<0.1,0.04,0.01> }
    }
    // carrot nose
    cone { <0,0.5,-0.06>, 0.025, <0,0.5,-0.18>, 0.001
      pigment {
        marble color_map {
          [0 color rgb<1,0.6,0.1>]
          [1 color rgb<0.8,0.5,0.1>]
        }
        rotate 90*y
        scale 0.002
      }
    }
    // top hat
    union {
      cylinder { <0,0,0>, <0,0.01,0>, 0.12 }
      cone { <0,0,0>, 0.07, <0,0.1,0>, 0.08 }
      rotate 15*x rotate 5*z translate 0.54*y
      pigment { rgb<0,0,0> } 
      finish { specular 0.8 } 
    }
    // scarf
    object { Scarf scale <1,1,-1> }
    // arms
    union {
      object { Branch1 translate -y scale 0.25 translate -0.12*y rotate -15*x rotate 115*z translate 0.3*y }
      object { Branch2 translate -y scale 0.25 translate -0.12*y rotate -10*x rotate -125*z translate 0.3*y }
      pigment { rgb<0.5,0.25,0.1> }
      normal { bumps 0.5 scale 0.01 }
    }
    // wooden pipe
    union {
      cylinder { <0,0,0>, <0,0,-0.15>, 0.006 }
      cylinder { <0,-0.006,-0.15>, <0,0.018,-0.15>, 0.012 }
      pigment { rgb<0.4,0.2,0.1> }
      finish { specular 0.8 }
      rotate <-20,-22,0>
      translate 0.5*y
    }
    // broom
    union {
      // broomstick
      union {
        cylinder { <0,0,0>, <0,-0.5,0>, 0.01 }
        sphere { <0,0,0>, 0.01 }
        pigment { rgb<1,0.7,0.5> }
      }      
      // broom end
      union {
        sphere { <0,0.08,0>, 0.05 }
        cylinder { <0,0.08,0>, <0,0,0>, 0.05 }
        texture {
          pigment { rgb<1,0.85,0.5> }
          normal {
            marble slope_map {
              [0 <0.5,0.866>]
              [1 <0.866,0.5>]
            }
            scale 0.003
          }
        }
        texture {
          pigment {
            gradient y color_map {
              [0 color rgbt<1,1,1,1>]
              [0.92 color rgbt<1,1,1,1>]
              [0.92 color rgbt<0.5,0.4,0.3>]
            }
            scale 0.03
          }
        }
        scale <1,1,0.22>
        translate -0.5*y
      }
      rotate 5*x
      translate <-0.28,cos(5*3.1415928/180)*0.5,0.02>
    }
    scale 1.25
  }
  // lots of snowballs
  intersection {
    union {
      #declare Count = 0
      #declare R = seed(0)
      #while (Count < 2400)
        sphere { <0.96 - rand(R)*0.96*2,rand(R)*0.96,0.96*0.8 - rand(R)*0.96*1.6>, 0.01 }
        #declare Count = Count + 1 
      #end
    }
    sphere { <0,0,0>, 0.96 scale <1,1,0.8> }
    pigment { rgb<1,1,1> }
    finish { ambient 0.2 }
    bounded_by { sphere { <0,0,0>, 1 } }
    no_shadow
  }
  rotate <10,-60,8>
  scale 0.012
  translate <1.99,7.96,-8.955>
  translate <0.005,0.012,0>
}

// texture definitions for a texture_map
#declare Clear =
texture {
  pigment { rgbt<1,1,1,1> }
}
#declare Ember =
texture {
  pigment { rgb<1,0.8,0.4> }
  finish { ambient 1 diffuse 0 }
}
#declare Ash =
texture {
  pigment { rgb<0.12,0.12,0.12> }
  normal { bumps 0.2 scale 0.001 }
}
#declare Paper =
texture {
  pigment {
    bozo color_map {
      [0 color rgb<0.5,0.5,0.5>]
      [1 color rgb<0.5,0.4,0.3>]
    }
    turbulence 1
    scale 0.08
  }
}

// debris floating in the air
plane { <0,1,0>, 0
  texture {
    crackle texture_map {
      [0 Clear]
      [0.62 Clear]
      [0.62 Ember]
      [0.65 Ash]
      [0.72 Paper]
    }
    turbulence 0.5
    scale 0.3
  }
  translate 6*y
  hollow
}

// rain drops in the sky
union{
  #declare Count = 0
  #declare R = seed(69)
  #while (Count < 16000)
    sphere { <0,0,0>, 0.012 scale <1,1.6,1> translate <10 - rand(R)*22, rand(R)*5 + 2, 10 - rand(R)*18> }
    #declare Count = Count+1
  #end
  pigment { rgbt<1,1,1,0.8> }
  finish { reflection 0.1 specular 0.3 refraction 1 ior 1.333 }
}

// torn out page from grad-level algebra text
bicubic_patch {
  type 0
  flatness 0
  u_steps 4
  v_steps 4
  <-1,1,-0.2>,  <-0.33,1,0.4>,     <0.33,1,0.3>,     <1,1,-0.3>,
  <-1,0.33,0>,  <-0.33,0.33,0.5>,  <0.33,0.33,0.5>,  <1,0.33,0>,
  <-1,-0.33,0>, <-0.33,-0.33,0.5>, <0.33,-0.33,0.3>, <1,-0.33,-0.3>,
  <-1,-1,-0.2>, <-0.33,-1,0.4>,    <0.33,-1,-0.2>,   <1,-1,-0.8>
  pigment {
    image_map {
      tga "algbpage.tga"
      interpolate 2
      transmit 255, 1
    }
    translate <-0.5,-0.5,0>
    scale 2
  }
  scale <1,1.375,0.8>
  scale 0.07
  rotate 60*x rotate -50*y
  translate <1.88,7.76,-8.86>
  hollow
  no_shadow
}

// grad-level algebra text
union {
  // spine
  intersection {
    box { <-1.03,0,-8>, <1.03,1,8> }
    difference {
      cylinder { <0,-2,-6>, <0,-2,6>, 2.5 }
      intersection {
        box { <-0.97,-1,-8>, <0.97,1,8> } 
        cylinder { <0,-1.62,-8>, <0,-1.62,8>, 2 }
      }
    }
    pigment {
      image_map {
        tga "algbspin.tga"
        interpolate 2
      }
      translate <-0.5,-0.5,0>
      scale 2*<1.03,6,1>
      rotate 90*x
    }
  }
  // back cover
  box { <-0.12,0,-6>, <0,-9.6,6>
    rotate -24*z translate -0.97*x
    pigment { rgb<15/255,24/255,51/255> }
  }
  // front cover
  box { <0.12,0,-6>, <0,-9.6,6>
    pigment {
      image_map {
        tga "algbcovr.tga"
        interpolate 2
      }
      translate <-0.5,-0.5,0>
      scale 2*<4.8,6,1>
      rotate -90*y rotate 90*x
      translate -4.8*y
    }
    rotate 24*z translate 0.97*x
  }
  // pages
  union {
    #include "pages.inc"
    scale <1,-1,1>
  }
  scale 0.0146
  rotate -8*z rotate 8*y rotate -12*x
  translate <1.66,7.79,-8.55>
}

// fundamentals of physics text
union {
  // spine
  intersection {
    box { <-1.4,0,-10>, <1.4,1,10> }
    difference {
      cylinder { <0,-4.6,-9>, <0,-4.6,9>, 5 }
      box { <-1.32,-1,-10>, <1.32,0.22,10> } 
    }
    pigment { rgb<0,0,0> }
    finish { phong 0.4 specular 0.6 }
  }
  // back cover
  box { <-0.12,0,-9>, <0,-14,9>
    pigment {
      gradient y color_map {
        [0 color rgb<0,0,0>]
        [0.05 color rgb<0,0,0>]
        [0.05 color rgb<0.24,0,0.24>]
      }
      scale 13.8
    }
    finish { phong 0.4 specular 0.6 }
    rotate -72*z translate -1.32*x
  }
  // front cover
  box { <0.12,0,-9>, <0,-14,9>
    pigment {
      gradient y color_map {
        [0 color rgb<0,0,0>]
        [0.05 color rgb<0,0,0>]
        [0.05 color rgb<0.24,0,0.24>]
      }
      scale 13.8
    }
    finish { phong 0.4 specular 0.6 }
    rotate 72*z translate 1.32*x
  }
  // mass of pages (smoothly connected cylindrical tubes)
  union {
    // right half
    union {
      // part one
      union {
        intersection {
          difference {
            cylinder { <0,0,-8.7>, <0,0,8.7>, 3.75131884044 }
            cylinder { <0,0,-9>, <0,0,9>, 2.43131884044 }
            box { <-5,0,-9>, <5,-5,9> rotate -18*z }
            translate <1.68,-0.75131884044,0>
          }
          box { <1.68,5,-9>, <-3,0,9> }
        }
        box { <-3.75131884044,-0.22,-8.7>, <-2.43131884044,0,8.7>
          rotate -18*z
          translate <1.68,-0.75131884044,0>
        }
        pigment {
          wood color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
          translate <1.68,-0.75131884044,0>
        }
        finish { ambient 0.2 diffuse 0.8 }
      }
      // part two
      intersection {
        difference {
          cylinder { <0,0,-8.7>, <0,0,8.7>, 13.7935714286 }
          cylinder { <0,0,-9>, <0,0,9>, 12.4735714286 }
          box { <0,26,-9>, <-26,-26,9> }
        }
        box { <0,26,-9>, <-26,-26,9> rotate -21.1470468371*z }
        pigment {
          wood color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
        }
        finish { ambient 0.2 diffuse 0.8 }
        translate <1.68,-10.7935714286,0>
      }
      // part three
      intersection {
        difference {
          cylinder { <0,0,-8.7>, <0,0,8.7>, 12.4735714286 }
          cylinder { <0,0,-9>, <0,0,9>, 11.1535714286  }
          box { <0,26,-9>, <26,-26,9> }
        }
        box { <0,26,-9>, <26,-26,9> rotate -21.1470468371*z }
        pigment {
          wood color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
        }
        finish { ambient 0.2 diffuse 0.8 }
        translate <10.68,12.4735714286,0>
      }
      // part four
      intersection {
        box { <10.68,0,-8.7>, <13,1.32,8.7> }
        cylinder { <0,-12.5,9>, <0,-12.5,-9>, 17.6776695297 }
        pigment {
          marble color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
          rotate 90*z
        }
        finish { ambient 0.2 diffuse 0.8 }
      }
      scale <1,-1,1>
      translate 0.632321626392*x
      rotate -18*z
      translate <1.32,-0.01,0>
    }
    // left half
    union {
      // part one
      union {
        intersection {
          difference {
            cylinder { <0,0,-8.7>, <0,0,8.7>, 3.75131884044 }
            cylinder { <0,0,-9>, <0,0,9>, 2.43131884044 }
            box { <-5,0,-9>, <5,-5,9> rotate -18*z }
            translate <1.68,-0.75131884044,0>
          }
          box { <1.68,5,-9>, <-3,0,9> }
        }
        box { <-3.75131884044,-0.22,-8.7>, <-2.43131884044,0,8.7>
          rotate -18*z
          translate <1.68,-0.75131884044,0>
        }
        pigment {
          wood color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
          translate <1.68,-0.75131884044,0>
        }
        finish { ambient 0.2 diffuse 0.8 }
      }
      // part two
      intersection {
        difference {
          cylinder { <0,0,-8.7>, <0,0,8.7>, 13.7935714286 }
          cylinder { <0,0,-9>, <0,0,9>, 12.4735714286 }
          box { <0,26,-9>, <-26,-26,9> }
        }
        box { <0,26,-9>, <-26,-26,9> rotate -21.1470468371*z }
        pigment {
          wood color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
        }
        finish { ambient 0.2 diffuse 0.8 }
        translate <1.68,-10.7935714286,0>
      }
      // part three
      intersection {
        difference {
          cylinder { <0,0,-8.7>, <0,0,8.7>, 12.4735714286 }
          cylinder { <0,0,-9>, <0,0,9>, 11.1535714286  }
          box { <0,26,-9>, <26,-26,9> }
        }
        box { <0,26,-9>, <26,-26,9> rotate -21.1470468371*z }
        pigment {
          wood color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
        }
        finish { ambient 0.2 diffuse 0.8 }
        translate <10.68,12.4735714286,0>
      }
      // part four
      intersection {
        box { <10.68,0,-8.7>, <13,1.32,8.7> }
        cylinder { <0,-12.5,9>, <0,-12.5,-9>, 17.6776695297 }
        pigment {
          marble color_map {
            [0 color rgb<1,1,1>]
            [0.4 color rgb<1,1,1>]
            [1 color rgb<0.7,0.7,0.7>]
          }
          scale 0.0946635847644
          rotate 90*z
        }
        finish { ambient 0.2 diffuse 0.8 }
      }
      scale <1,-1,1>
      translate 0.632321626392*x
      rotate -18*z
      translate <1.32,-0.01,0>
      scale <-1,1,1>
    }
  }
  // several loose pages
  union {
    // right-hand side
    union { 
      // page one
      bicubic_patch {
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        #declare Z = 8.7
        #while (Z >= -8.7)
          <0,0,Z>,<0,-6,Z>, <8,-4,Z>, <11.25,-6.5,Z>
          #declare Z = Z - 5.8
        #end
      }
      // page two (visible)
      bicubic_patch {
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        #declare Z = 8.7
        #while (Z >= -8.7)
          <0,0,Z>,<0,-8,Z>, <8,-6,Z>, <10.2,-7.8,Z>
          #declare Z = Z - 5.8
        #end
      }
      pigment {
        image_map {
          tga "physpg2.TGA"
          interpolate 2
        }
        translate -0.5*y
        scale <12.841,17.4,1>
        rotate 90*x
        rotate -37.41*z
      }
      finish { ambient 0.2 diffuse 0.8 }
    }
    // left-hand side
    union {
      // page three
      bicubic_patch {
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        #declare Z = 8.7
        #while (Z >= -8.7)
          <0,0,Z>,<0,-8,Z>, <-6,-4,Z>, <-11.5,-5.5,Z>
          #declare Z = Z - 5.8
        #end
      }
      // page four (visible)
      bicubic_patch {
        type 1
        flatness 0.01
        u_steps 3
        v_steps 3
        #declare Z = 8.7
        #while (Z >= -8.7)
          <0,0,Z>,<0,-8,Z>, <-6,-4,Z>, <-9,-8,Z>
          #declare Z = Z - 5.8
        #end
      }
      pigment {
        image_map {
          tga "physpg1.TGA"
          interpolate 2
        }
        translate <-1,-0.5,0>
        scale <12.042,17.4,1>
        rotate 90*x
        rotate 41.63*z
      }
      finish { ambient 0.2 diffuse 0.8 }
    }
  }
  scale <1,-1,1>
  scale 0.014
  rotate 15*x rotate 24*y rotate 8*z
  translate <2.14,7.3,-8.5>
}
