#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

void writelightning (int depth, int num, double height, double _x, double _z);
void sort (double *a, int num);

void main (void) {
  srandom (time(NULL));
  printf ("#declare Lightning =\nunion {\n");
  writelightning (1,20,1.0,0.0,0.0);
  printf ("}\n");
  return;
}

void writelightning (int depth, int num, double height, double _x, double _z) {
  double y[22], theta, r, oldtheta, oldr, d, X, oldX, Z, oldZ;
  int    i;

  if (num > 20) num = 20;
  if (depth > 10)
    return; 
  y[0] = height;
  y[num+1] = 0.0;
  oldtheta = oldr = 0.0;
  oldX = _x, oldZ = _z;
  for (i = 0; i < num; i++) y[i+1] = height*random()*1.0/RAND_MAX;
  sort (y, num+2);
  for (i = 0; i < num + 1; i++) {
    d = y[i+1] - y[i];
    theta = oldtheta + (random() - RAND_MAX/16)*M_PI*d/RAND_MAX;
    r = oldr + (random() - RAND_MAX/8)*16*d/RAND_MAX;
    X = r*sin(theta) + _x;
    Z = r*cos(theta) + _z;
    if ((int)rint(y[i]*1000000) != (int)rint(y[i+1]*1000000))
      printf ("  cylinder { <%f,%f,%f>, <%f,%f,%f>, 0.0025 }\n", oldX, y[i], oldZ, X, y[i+1], Z);
    oldr = r, oldtheta = theta, oldX = X, oldZ = Z;
    if (random() < RAND_MAX/5)
      writelightning (depth + 1, num - i, y[i+1], oldX, oldZ);
  }
  return;
}

void sort (double *a, int num) {
  double d[22], *b;
  int    i, A, B, _a, _b;

  if (num > 1) {
    _a = num/2;
    sort (a, _a);
    b = a + num/2;
    _b = num - num/2;
    sort (b, _b);
    for (i = A = B = 0; i < num; i++) {
      if (A < _a && B < _b)
        if (a[A] > b[B])
          d[i] = a[A++];
        else
          d[i] = b[B++];
      else if (A < _a)
        d[i] = a[A++];
      else
        d[i] = b[B++];
    }
    for (i = 0; i < num; i++) a[i] = d[i];
  }
  else
    return;
}
