// Persistence of Vision Ray Tracer Scene Description File
// File: Sun.inc
// Vers: 3
// Desc: A G-type yellow sun, complete with sunspots, corona, and flares
// Date: 6/7/1997
// Auth: Steve Sloan II

#version 3

#include "colors.inc"
#include "textures.inc"

#declare star_texture =
    pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
        turbulence 1
        sine_wave
        scale .5
    }
    
#declare sunspots =
pigment {
    dents
    frequency 5            // <- add this line
    color_map {
      [0.00 color Black]
      [0.01 color Black]
      [0.01 color Yellow]
      [1.00 color Yellow]
    }
    scale 0.05
}

#declare sun_texture = 
pigment {
    dents
    frequency 5
    pigment_map {
      [0.00 sunspots]
      [0.02 sunspots]
      [0.02 color Yellow]
      [1.00 color Yellow]
    }
}

/* Sun */
#declare sun_body =
    light_source {
        sun_position
        color rgb <1, 1, 1>
        looks_like {
            sphere {
                sun_position, 1
            }
            texture {
                pigment { sun_texture }
                finish { ambient 1 }      // Magic word 1
            }
            no_shadow                   // Magic word 2
        }
        atmosphere off
    }
    
# declare sun_corona = 
sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
        emitting
        spherical_mapping
        linear
        color_map {
            [ 0 color rgbt <1, 1, 0,  1> ]
            [ 1 color rgbt <1, 0, 0, -1> ]
        }
        samples 10
    }
    hollow
    scale 1.25
}

#declare sun_flares = 
sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
        emitting
        spherical_mapping
        linear
        turbulence 1.5
        color_map {
            [ 0.0 color rgbt <1, 0, 0,  1> ]
            [ 0.5 color rgbt <1, 1, 0, -1> ]
            [ 1.0 color rgbt <1, 0, 0,  1> ]
        }
        frequency 2
        samples 20
        scale 0.5
    }
    hollow
    scale 2
}

#declare sun = 
union {
    object { sun_body }
    #if (use_halo = 1)
        object { sun_corona }
        object { sun_flares }
    #end
    scale sun_radius
}

