
// The Texture Include-File for Microscp.pov
// created with Moray 2.5

// uses 2 images...
//     - "mdmap.gif" for the sheet of paper
//     - "ribbon.gif" for the ring-bumpmaps




// *******  T E X T U R E S  *******


//  $MRY$: 'WoodTexture'
#declare WoodTexture =    texture { // WoodTextureL1
     pigment {
       wood
       color_map {
         [ 0.000  color rgb<0.357, 0.172, 0.162> ]
         [ 1.000  color rgb<0.596, 0.325, 0.138> ]
       }
       turbulence 0.320
       octaves 10
       omega 0.250
       lambda 5.000
       frequency 2.000
       phase 0.410
       scale     <0.2000, 3.0000, 0.2000>
     }
     normal {
       dents 0.5000
       turbulence 0.200
       octaves 10
       omega 2.000
       lambda 5.000
       scale     <0.0500, 0.5000, 0.0500>
     }
     finish {
       diffuse 0.700
       ambient 0.200
       reflection 0.200
       specular 0.400
       roughness 0.0100
     }

   }

   texture { // WoodTextureL2
     pigment {
       wood
       color_map {
         [ 0.000  color rgb<0.202, 0.172, 0.162> ]
         [ 0.129  color rgbf<0.202, 0.000, 0.000, 0.796> ]
         [ 0.234  color rgbf<0.504, 0.327, 0.144, 0.796> ]
         [ 0.655  color rgbf<0.574, 0.356, 0.141, 0.797> ]
         [ 1.000  color rgbf<0.203, 0.150, 0.138, 0.797> ]
       }
       turbulence 0.500
       octaves 5
       phase 0.325
       scale     <0.2000, 3.5000, 0.2000>
     }
     finish {
       diffuse 0.590
       ambient 0.200
       specular 0.400
       roughness 0.0100
     }

   }



//  $MRY$: 'BaseTexture'
#declare BaseTexture = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   normal {
     bumps 0.2500
     octaves 4
     lambda 0.500
     scale     0.0750
   }
   finish {
     diffuse 0.350
     phong 0.200
     phong_size 5.400
     specular 0.300
     roughness 0.0500
   }

}



//  $MRY$: 'MetalTexture'
#declare MetalTexture = texture {
   pigment {
     color rgb<0.574, 0.636, 0.634>
   }
   finish {
     diffuse 0.350
     ambient 0.250
     phong 1.000
     phong_size 100.000
     reflection 0.400
     specular 0.250
     roughness 0.0050
     brilliance 0.999
     metallic
   }

}



//  $MRY$: 'BlackPlastic'
#declare BlackPlastic = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   finish {
     diffuse 0.400
     ambient 0.150
     phong 0.650
     phong_size 50.500
     specular 0.200
     roughness 0.0100
   }

}



//  $MRY$: 'Glass'
#declare Glass = texture {
   pigment {
     color rgbf<1.000, 1.000, 1.000, 0.700>
   }
   finish {
     diffuse 0.000
     ambient 0.000
     reflection 0.100
     refraction 1
     ior 1.500
     specular 1.000
     roughness 0.0010
   }

}



//  $MRY$: 'WallTexture'
#declare WallTexture = texture {
   pigment {
     color rgb<0.200, 0.000, 0.124>
   }
   finish {
     diffuse 0.500
     ambient 0.050
     specular 0.150
     roughness 0.0600
     crand 0.150
   }

}



//  $MRY$: 'WGlass'
#declare WGlass = texture {
   pigment {
     color rgbf<1.000, 1.000, 1.000, 0.847>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     phong 0.250
     phong_size 1.000
     reflection 0.100
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'MbTexture'
#declare MbTexture = texture {
   pigment {
     gradient z
     color_map {
       [ 0.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
       [ 0.335  color rgbf<0.726, 0.000, 0.000, 0.546> ]
       [ 0.750  color rgbf<0.409, 0.000, 0.000, 0.250> ]
       [ 1.000  color rgb<0.000, 0.000, 0.000> ]
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'BPlasticRibs'
#declare BPlasticRibs = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   normal {
     bump_map {
       gif "ribbon.gif"
       bump_size 1.000
       use_color
       map_type 2  // Cylindrical
       interpolate 2  // Bilinear (2)
     }
     omega 2.000
     lambda 0.500
     scale <-1,1,1> rotate 90*x // align properly along +Z
   }
   finish {
     diffuse 0.400
     ambient 0.150
     phong 0.750
     phong_size 50.500
     specular 0.200
     roughness 0.0100
   }

}



//  $MRY$: 'MetalRibs'
#declare MetalRibs = texture {
   pigment {
     color rgb<0.574, 0.636, 0.634>
   }
   normal {
     bump_map {
       gif "ribbon.gif"
       bump_size 1.000
       use_color
       map_type 2  // Cylindrical
       interpolate 2  // Bilinear (2)
     }
     omega 2.000
     lambda 0.500
     scale <-1,1,1> rotate 90*x // align properly along +Z
   }
   finish {
     diffuse 0.350
     ambient 0.250
     phong 1.000
     phong_size 100.000
     reflection 0.400
     specular 0.250
     roughness 0.0050
     brilliance 0.999
     metallic
   }

}



//  $MRY$: 'LensTexture'
#declare LensTexture = texture {
   pigment {
     color rgbf<0.574, 0.636, 0.634, 1.000>
   }
   finish {
     diffuse 0.350
     ambient 0.250
     phong 1.000
     phong_size 100.000
     reflection 0.400
     specular 0.250
     roughness 0.0050
     brilliance 0.999
     metallic
   }

}



//  $MRY$: 'PaperTexture1'
#declare PaperTexture1 = texture {
   pigment {
     image_map {
       gif "mdmap.gif"
       once
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
     scale     <2.2500, 2.9000, 1.0000>
     translate <-2.0000, -2.5000, 0.0000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}

